/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.project;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.AccessibleTitledPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.Pane;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

public final class SessionCreationDialog
extends AbstractValidatingDialog {
    private JTextField nameTextField;
    private Collection sessionNames;
    private JCheckBox useServerPlatformCheckBox;
    private ComboBoxModel serverPlatformComboBoxModel;
    private String previousServerClassName;
    private JRadioButton serverRadioButton;
    private JRadioButton databaseRadioButton;
    private JRadioButton relationalRadioButton;
    private JRadioButton xmlRadioButton;
    private JRadioButton eisRadioButton;
    private PropertyValueModel databasePlatformHolder;
    private ComboBoxModel j2cAdapterComboBoxModel;

    public SessionCreationDialog(WorkbenchContext context, Collection sessionNames) {
        super(context);
        this.sessionNames = sessionNames;
    }

    protected void initialize() {
        super.initialize();
        this.getOKAction().setEnabled(false);
    }

    protected Component buildMainPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.setTitle(this.resourceRepository().getString("SESSION_CREATION_DIALOG_TITLE"));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel namePanel = this.buildSessionNamePanel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        mainPanel.add((Component)namePanel, constraints);
        this.helpManager().addTopicID(namePanel, this.helpTopicId() + ".name");
        JPanel serverPlatformPanel = this.buildServerPlatformPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.helpManager().addTopicID(serverPlatformPanel, this.helpTopicId() + ".serverPlatform");
        mainPanel.add((Component)serverPlatformPanel, constraints);
        JPanel dataSourcePanel = this.buildDataSourcePanel();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        this.helpManager().addTopicID(dataSourcePanel, this.helpTopicId() + ".datasource");
        mainPanel.add((Component)dataSourcePanel, constraints);
        JPanel sessionTypePanel = this.buildSessionTypePanelPanel();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 0, 0, 0);
        mainPanel.add((Component)sessionTypePanel, constraints);
        return mainPanel;
    }

    private JPanel buildSessionTypePanelPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel sessionTypePanel = new JPanel(new GridBagLayout());
        sessionTypePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("SESSION_TYPE_LABEL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.serverRadioButton = new JRadioButton();
        this.serverRadioButton.setSelected(true);
        this.serverRadioButton.setText(this.resourceRepository().getString("SERVER_SESSION_RADIO_BUTTON"));
        this.serverRadioButton.setMnemonic(this.resourceRepository().getMnemonic("SERVER_SESSION_RADIO_BUTTON"));
        this.serverRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("SERVER_SESSION_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        sessionTypePanel.add((Component)this.serverRadioButton, constraints);
        buttonGroup.add(this.serverRadioButton);
        this.databaseRadioButton = new JRadioButton();
        this.databaseRadioButton.setText(this.resourceRepository().getString("DATABASE_SESSION_RADIO_BUTTON"));
        this.databaseRadioButton.setMnemonic(this.resourceRepository().getMnemonic("DATABASE_SESSION_RADIO_BUTTON"));
        this.databaseRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("DATABASE_SESSION_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        sessionTypePanel.add((Component)this.databaseRadioButton, constraints);
        buttonGroup.add(this.databaseRadioButton);
        return sessionTypePanel;
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String serverClassName;
                boolean checked = ((JCheckBox)e.getSource()).isSelected();
                if (!checked) {
                    SessionCreationDialog.this.previousServerClassName = (String)SessionCreationDialog.this.serverPlatformComboBoxModel.getSelectedItem();
                    serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
                    serverClassName = ClassTools.shortNameForClassNamed((String)serverClassName);
                } else {
                    if (SessionCreationDialog.this.previousServerClassName == null) {
                        SessionCreationDialog.this.previousServerClassName = "WebLogic_10_Platform";
                    }
                    serverClassName = SessionCreationDialog.this.previousServerClassName;
                }
                SessionCreationDialog.this.serverPlatformComboBoxModel.setSelectedItem(serverClassName);
            }
        };
    }

    private JPanel buildServerPlatformPanel() {
        this.useServerPlatformCheckBox = new JCheckBox();
        this.useServerPlatformCheckBox.setText(this.resourceRepository().getString("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setMnemonic(this.resourceRepository().getMnemonic("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("USE_SERVER_PLATFORM_CHECK_BOX"));
        this.useServerPlatformCheckBox.addActionListener(this.buildServerPlatformAction());
        final JPanel subPane = this.buildServerPlatformSubPane();
        subPane.setEnabled(false);
        this.useServerPlatformCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JCheckBox checkBox = (JCheckBox)e.getSource();
                subPane.setEnabled(checkBox.isSelected());
            }
        });
        this.updateServerPlatformWidgets();
        return new GroupBox(this.useServerPlatformCheckBox, (JComponent)subPane);
    }

    private void updateServerPlatformWidgets() {
        boolean selected;
        String serverClassName = (String)this.serverPlatformComboBoxModel.getSelectedItem();
        boolean bl = selected = serverClassName != null;
        if (selected) {
            ServerPlatformAdapter noServerPlatform = NullServerPlatformAdapter.instance();
            String noServerPlatformClassName = ClassTools.shortNameForClassNamed((String)noServerPlatform.getServerClassName());
            selected = !serverClassName.equals(noServerPlatformClassName);
        }
        this.useServerPlatformCheckBox.setSelected(selected);
    }

    private JPanel buildServerPlatformSubPane() {
        GridBagConstraints constraints = new GridBagConstraints();
        Pane container = new Pane(new GridBagLayout());
        JLabel platformLabel = SwingComponentFactory.buildLabel("SERVER_PLATFORM_COMBO_BOX", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, SwingTools.checkBoxIconWidth(), 0, 0);
        container.add((Component)platformLabel, constraints);
        this.serverPlatformComboBoxModel = this.buildServerPlatformComboBoxModel();
        JComboBox serverPlatformComboBox = new JComboBox(this.serverPlatformComboBoxModel);
        serverPlatformComboBox.setRenderer(this.buildServerPlatformRenderer());
        String platformName = this.preferences().get("platform.server", null);
        if ("NoServerPlatform".equals(platformName)) {
            serverPlatformComboBox.setSelectedItem(null);
        } else {
            serverPlatformComboBox.setSelectedItem(platformName);
        }
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        container.add(serverPlatformComboBox, constraints);
        platformLabel.setLabelFor(serverPlatformComboBox);
        return container;
    }

    private ListCellRenderer buildServerPlatformRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object value) {
                if (value == null) {
                    return "";
                }
                return SessionCreationDialog.this.resourceRepository().getString((String)value);
            }
        };
    }

    private JPanel buildSessionNamePanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel namePanel = new JPanel(new GridBagLayout());
        JLabel sessionNameLabel = SwingComponentFactory.buildLabel("SESSION_NAME_LABEL", this.resourceRepository());
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        namePanel.add((Component)sessionNameLabel, constraints);
        this.nameTextField = new JTextField(20);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        namePanel.add((Component)this.nameTextField, constraints);
        sessionNameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                SessionCreationDialog.this.updateOKAction();
            }

            public void removeUpdate(DocumentEvent e) {
                SessionCreationDialog.this.updateOKAction();
            }

            public void changedUpdate(DocumentEvent e) {
                SessionCreationDialog.this.updateOKAction();
            }
        });
        return namePanel;
    }

    private JPanel buildDataSourcePanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        ButtonGroup buttonGroup = new ButtonGroup();
        int offset = SwingTools.checkBoxIconWidth();
        JPanel datasourcePanel = new JPanel(new GridBagLayout());
        datasourcePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("DATASOURCE_LABEL")), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        this.relationalRadioButton = new JRadioButton();
        this.relationalRadioButton.setText(this.resourceRepository().getString("RELATIONAL_RADIO_BUTTON"));
        this.relationalRadioButton.setMnemonic(this.resourceRepository().getMnemonic("RELATIONAL_RADIO_BUTTON"));
        this.relationalRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("RELATIONAL_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        datasourcePanel.add((Component)this.relationalRadioButton, constraints);
        buttonGroup.add(this.relationalRadioButton);
        JPanel relationalPanel = this.buildRelationalPanel();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, offset, 0, 0);
        datasourcePanel.add((Component)relationalPanel, constraints);
        this.eisRadioButton = new JRadioButton();
        this.eisRadioButton.setText(this.resourceRepository().getString("EIS_RADIO_BUTTON"));
        this.eisRadioButton.setMnemonic(this.resourceRepository().getMnemonic("EIS_RADIO_BUTTON"));
        this.eisRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("EIS_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        datasourcePanel.add((Component)this.eisRadioButton, constraints);
        buttonGroup.add(this.eisRadioButton);
        JPanel eisPanel = this.buildEisPanel();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(0, offset, 0, 0);
        datasourcePanel.add((Component)eisPanel, constraints);
        this.xmlRadioButton = new JRadioButton();
        this.xmlRadioButton.setText(this.resourceRepository().getString("XML_RADIO_BUTTON"));
        this.xmlRadioButton.setMnemonic(this.resourceRepository().getMnemonic("XML_RADIO_BUTTON"));
        this.xmlRadioButton.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("XML_RADIO_BUTTON"));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        datasourcePanel.add((Component)this.xmlRadioButton, constraints);
        buttonGroup.add(this.xmlRadioButton);
        this.xmlRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SessionCreationDialog.this.databaseRadioButton.setSelected(true);
                SessionCreationDialog.this.serverRadioButton.setEnabled(!SessionCreationDialog.this.xmlRadioButton.isSelected());
            }
        });
        return datasourcePanel;
    }

    private JPanel buildRelationalPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        AccessibleTitledPanel relationalPanel = new AccessibleTitledPanel(new GridBagLayout());
        final JLabel platformLabel = SwingComponentFactory.buildLabel("DATABASE_PLATFORM_LABEL", this.resourceRepository());
        platformLabel.setEnabled(false);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        relationalPanel.add((Component)platformLabel, constraints);
        String platformName = this.preferences().get("platform.database", "Oracle11");
        this.databasePlatformHolder = new SimplePropertyValueModel(DatabasePlatformRepository.getDefault().platformNamed(platformName));
        final JComboBox databasePlatformComboBox = PlatformComponentFactory.buildPlatformChooser(this.databasePlatformHolder);
        databasePlatformComboBox.setEnabled(false);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        relationalPanel.add((Component)databasePlatformComboBox, constraints);
        platformLabel.setLabelFor(databasePlatformComboBox);
        this.relationalRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                databasePlatformComboBox.setEnabled(SessionCreationDialog.this.relationalRadioButton.isSelected());
                platformLabel.setEnabled(SessionCreationDialog.this.relationalRadioButton.isSelected());
            }
        });
        return relationalPanel;
    }

    private JPanel buildEisPanel() {
        GridBagConstraints constraints = new GridBagConstraints();
        AccessibleTitledPanel eisPanel = new AccessibleTitledPanel(new GridBagLayout());
        final JLabel adapterLabel = new JLabel(this.resourceRepository().getString("EIS_PLATFORM_LABEL"));
        adapterLabel.setEnabled(false);
        adapterLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("EIS_PLATFORM_LABEL"));
        adapterLabel.setDisplayedMnemonicIndex(this.resourceRepository().getMnemonicIndex("EIS_PLATFORM_LABEL"));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        eisPanel.add((Component)adapterLabel, constraints);
        this.j2cAdapterComboBoxModel = this.buildJ2CAdaptersComboBoxModel();
        final JComboBox adapterComboBox = new JComboBox(this.j2cAdapterComboBoxModel);
        adapterComboBox.setRenderer(this.buildEisNameRenderer());
        adapterComboBox.setEnabled(false);
        String platformName = this.preferences().get("platform.eis", "AQPlatform");
        adapterComboBox.setSelectedItem(platformName);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 5, 0, 0);
        eisPanel.add(adapterComboBox, constraints);
        adapterLabel.setLabelFor(adapterComboBox);
        this.eisRadioButton.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                adapterComboBox.setEnabled(SessionCreationDialog.this.eisRadioButton.isSelected());
                adapterLabel.setEnabled(SessionCreationDialog.this.eisRadioButton.isSelected());
            }
        });
        return eisPanel;
    }

    private void updateOKAction() {
        String sessionName = this.nameTextField.getText().trim();
        boolean valid = sessionName.length() > 0 && !this.sessionNames.contains(sessionName);
        this.getOKAction().setEnabled(valid);
        if (valid) {
            this.clearErrorMessage();
        } else {
            this.setErrorMessageKey("SESSION_CREATION_DIALOG_INVALID_NAME");
        }
    }

    private ComboBoxModel buildJ2CAdaptersComboBoxModel() {
        return new DefaultComboBoxModel(CollectionTools.vector((Iterator)this.supportedJ2CAdapters()));
    }

    private ComboBoxModel buildServerPlatformComboBoxModel() {
        return new DefaultComboBoxModel(CollectionTools.vector((Iterator)this.serverPlatforms()));
    }

    private Iterator serverPlatforms() {
        SortedSet servers = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
        String serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
        servers.remove(ClassTools.shortNameForClassNamed((String)serverClassName));
        return servers.iterator();
    }

    private ListCellRenderer buildEisNameRenderer() {
        return new SimpleListCellRenderer(){

            protected String buildText(Object cellValue) {
                String string = (String)cellValue;
                if (string.equals("AQPlatform")) {
                    return "Oracle AQ";
                }
                if (string.equals("MQPlatform")) {
                    return "IBM MQSeries";
                }
                if (string.equals("JMSPlatform")) {
                    return "JMS";
                }
                return "XML File";
            }
        };
    }

    public SessionAdapter addNewSessionTo(TopLinkSessionsAdapter topLinkSessions) {
        ServerPlatform sp;
        String sessionName = this.nameTextField.getText().trim();
        DataSource ds = this.relationalRadioButton.isSelected() ? new DataSource((DatabasePlatform)this.databasePlatformHolder.getValue()) : (this.eisRadioButton.isSelected() ? new DataSource((String)this.j2cAdapterComboBoxModel.getSelectedItem()) : DataSource.buildXmlDataSource());
        if (this.useServerPlatformCheckBox.isSelected()) {
            sp = new ServerPlatform((String)this.serverPlatformComboBoxModel.getSelectedItem());
        } else {
            String serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
            sp = new ServerPlatform(ClassTools.shortNameForClassNamed((String)serverClassName));
        }
        DatabaseSessionAdapter session = this.serverRadioButton.isSelected() ? topLinkSessions.addServerSessionNamed(sessionName, sp, ds) : topLinkSessions.addDatabaseSessionNamed(sessionName, sp, ds);
        return session;
    }

    private Iterator supportedJ2CAdapters() {
        SortedSet platforms = CollectionTools.sortedSet((Iterator)EisPlatformManager.instance().platformDisplayNames());
        return platforms.iterator();
    }

    private String buildUniqueSessionName() {
        String sessionName = this.preferences().get("new name.session", this.resourceRepository().getString("SESSION_CREATION_DIALOG_NEW_SESSION_NAME"));
        return NameTools.uniqueNameFor((String)sessionName, (Collection)this.sessionNames);
    }

    protected String helpTopicId() {
        return "dialog.sessionCreation";
    }

    protected Component initialFocusComponent() {
        return this.nameTextField;
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.nameTextField.setText(this.buildUniqueSessionName());
        this.nameTextField.selectAll();
        String dataSourceType = this.preferences().get("data source type", "relational");
        this.relationalRadioButton.setSelected("relational".equals(dataSourceType));
        this.eisRadioButton.setSelected("eis".equals(dataSourceType));
        this.xmlRadioButton.setSelected("xml".equals(dataSourceType));
    }
}

