/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.SelectGenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.SortDirectionNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class OrderByItemNode
extends Node {
    private SortDirectionNode direction = null;
    private Node orderByItem = null;

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.orderByItem != null) {
            this.orderByItem.validate(context);
            Object type = this.orderByItem.getType();
            this.setType(type);
            if (!typeHelper.isOrderableType(type)) {
                throw JPQLException.expectedOrderableOrderByItem(context.getQueryInfo(), this.orderByItem.getLine(), this.orderByItem.getColumn(), this.orderByItem.getAsString(), typeHelper.getTypeName(type));
            }
        }
    }

    public Expression generateExpression(GenerationContext context) {
        boolean oldCheckState = context.shouldCheckSelectNodeBeforeResolving();
        ((SelectGenerationContext)context).checkSelectNodeBeforeResolving(true);
        Expression orderByExpression = this.getOrderByItem().generateExpression(context);
        orderByExpression = this.getDirection().addToExpression(orderByExpression, context);
        ((SelectGenerationContext)context).checkSelectNodeBeforeResolving(oldCheckState);
        return orderByExpression;
    }

    public SortDirectionNode getDirection() {
        if (this.direction == null) {
            this.setDirection(new SortDirectionNode());
        }
        return this.direction;
    }

    public Node getOrderByItem() {
        return this.orderByItem;
    }

    public void setDirection(SortDirectionNode direction) {
        this.direction = direction;
    }

    public void setOrderByItem(Node orderByItem) {
        this.orderByItem = orderByItem;
    }
}

