/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.sql.Connection;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.ObjectReferenceChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class ReferenceMapping
extends ObjectReferenceMapping {
    protected DatabaseField field;

    protected Vector collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.addElement(this.getField());
        return fields;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Expression getJoinCriteria(QueryKeyExpression exp) {
        return null;
    }

    public boolean hasConstraintDependency() {
        return true;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        this.setReferenceDescriptor(session.getDescriptor(this.getReferenceClass()));
        if (this.referenceDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        ObjectRelationalDatabaseField field = (ObjectRelationalDatabaseField)this.getField();
        field.setSqlType(2006);
        if (this.referenceDescriptor instanceof ObjectRelationalDataTypeDescriptor) {
            field.setSqlTypeName(((ObjectRelationalDataTypeDescriptor)this.referenceDescriptor).getStructureName());
        }
        this.setField(this.getDescriptor().buildField(this.getField()));
        this.setFields(this.collectFields());
        this.getDescriptor().setIsNativeConnectionRequired(true);
    }

    public boolean isReferenceMapping() {
        return true;
    }

    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        if (object == null) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertQuery = new InsertObjectQuery();
            insertQuery.setIsExecutionClone(true);
            insertQuery.setObject(object);
            insertQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(insertQuery);
        } else {
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objectInDatabase;
        if (!this.isAttributeValueInstantiated(query.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (objectInDatabase = this.readPrivateOwnedForObject(query)) != null) {
            query.setProperty(this, objectInDatabase);
        }
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(query.getObject(), query.getSession());
        if (object != null) {
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    public void postDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
    }

    protected void setField(DatabaseField field) {
        this.field = field;
    }

    public void setFieldName(String fieldName) {
        this.setField(new ObjectRelationalDatabaseField(fieldName));
    }

    public void setReferenceClass(Class referenceClass) {
        this.referenceClass = referenceClass;
    }

    public Object valueFromRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) throws DatabaseException {
        Struct struct;
        Ref ref = (Ref)row.get(this.getField());
        if (ref == null) {
            return null;
        }
        try {
            ((DatabaseAccessor)executionSession.getAccessor()).incrementCallCount(executionSession);
            Connection connection = ((DatabaseAccessor)executionSession.getAccessor()).getConnection();
            struct = (Struct)executionSession.getPlatform().getRefValue(ref, executionSession, connection);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception, executionSession, false);
        }
        AbstractRecord targetRow = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).buildRowFromStructure(struct);
        ((DatabaseAccessor)executionSession.getAccessor()).decrementCallCount();
        return this.getReferenceDescriptor().getObjectBuilder().buildObject(query, targetRow, joinManager);
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        Object referenceObject = this.getRealAttributeValueFromObject(object, session);
        if (referenceObject == null) {
            record.put(this.getField(), (Object)null);
            return;
        }
        Ref ref = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(referenceObject, session);
        record.put(this.getField(), (Object)ref);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        ObjectChangeSet changeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue();
        Object referenceObject = changeSet.getUnitOfWorkClone();
        if (referenceObject == null) {
            return;
        }
        Ref ref = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(referenceObject, session);
        record.put(this.getField(), (Object)ref);
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }

    public void writeInsertFieldsIntoRow(AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record.put(this.getField(), (Object)null);
    }
}

