/*******************************************************************************
 * Copyright (c) 1998, 2008 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the 
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0 
 * which accompanies this distribution. 
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at 
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation from Oracle TopLink
 *     08/27/2008-1.1 Guy Pelletier 
 *       - 211329: Add sequencing on non-id attribute(s) support to the EclipseLink-ORM.XML Schema
 *     08/28/2008-1.1 Guy Pelletier 
 *       - 245120: unidir one-to-many within embeddable fails to deploy for missing primary key field       
 ******************************************************************************/  
package org.eclipse.persistence.testing.models.jpa.complexaggregate;

import org.eclipse.persistence.tools.schemaframework.*;

public class ComplexAggregateTableCreator extends org.eclipse.persistence.tools.schemaframework.TableCreator {
    public ComplexAggregateTableCreator() {
        setName("EJB3ComplexAggregateProject");

        addTableDefinition(buildCITYSLICKERTable());
        addTableDefinition(buildCOUNTRYDWELLERTable());
        addTableDefinition(buildWORLDTable());
        
        addTableDefinition(buildHOCKEYPLAYERTable());
        addTableDefinition(buildHOCKEYTEAMTable());
        
        addTableDefinition(buildROLETable());
        addTableDefinition(buildPLAYERROLESTable());
    }

    public TableDefinition buildCITYSLICKERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_CITYSLICKER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(19);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(true);
        fieldID.setUnique(true);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);
        
        FieldDefinition fieldFNAME = new FieldDefinition();
        fieldFNAME.setName("FNAME");
        fieldFNAME.setTypeName("VARCHAR2");
        fieldFNAME.setSize(20);
        fieldFNAME.setSubSize(0);
        fieldFNAME.setIsPrimaryKey(true);
        fieldFNAME.setIsIdentity(false);
        fieldFNAME.setUnique(true);
        fieldFNAME.setShouldAllowNull(false);
        table.addField(fieldFNAME);
        
        FieldDefinition fieldLNAME = new FieldDefinition();
        fieldLNAME.setName("LNAME");
        fieldLNAME.setTypeName("VARCHAR2");
        fieldLNAME.setSize(20);
        fieldLNAME.setSubSize(0);
        fieldLNAME.setIsPrimaryKey(true);
        fieldLNAME.setIsIdentity(false);
        fieldLNAME.setUnique(true);
        fieldLNAME.setShouldAllowNull(false);
        table.addField(fieldLNAME);
        
        FieldDefinition fieldAGE = new FieldDefinition();
        fieldAGE.setName("AGE");
        fieldAGE.setTypeName("NUMBER");
        fieldAGE.setSize(15);
        fieldAGE.setSubSize(0);
        fieldAGE.setIsPrimaryKey(false);
        fieldAGE.setIsIdentity(false);
        fieldAGE.setUnique(false);
        fieldAGE.setShouldAllowNull(false);
        table.addField(fieldAGE);
        
        FieldDefinition fieldGENDER = new FieldDefinition();
        fieldGENDER.setName("GENDER");
        fieldGENDER.setTypeName("VARCHAR2");
        fieldGENDER.setSize(6);
        fieldGENDER.setSubSize(0);
        fieldGENDER.setIsPrimaryKey(false);
        fieldGENDER.setIsIdentity(false);
        fieldGENDER.setUnique(false);
        fieldGENDER.setShouldAllowNull(true);
        table.addField(fieldGENDER);

        FieldDefinition fieldWORLDID = new FieldDefinition();
        fieldWORLDID.setName("WORLD_ID");
        fieldWORLDID.setTypeName("NUMBER");
        fieldWORLDID.setSize(19);
        fieldWORLDID.setSubSize(0);
        fieldWORLDID.setIsPrimaryKey(false);
        fieldWORLDID.setIsIdentity(false);
        fieldWORLDID.setUnique(false);
        fieldWORLDID.setShouldAllowNull(true);
        fieldWORLDID.setForeignKeyFieldName("CMP3_WORLD.ID");
        table.addField(fieldWORLDID);
        
        return table;
    }
    
    public TableDefinition buildCOUNTRYDWELLERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_COUNTRY_DWELLER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(19);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(true);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);
        
        FieldDefinition fieldFNAME = new FieldDefinition();
        fieldFNAME.setName("FNAME");
        fieldFNAME.setTypeName("VARCHAR2");
        fieldFNAME.setSize(20);
        fieldFNAME.setSubSize(0);
        fieldFNAME.setIsPrimaryKey(true);
        fieldFNAME.setIsIdentity(false);
        fieldFNAME.setUnique(true);
        fieldFNAME.setShouldAllowNull(false);
        table.addField(fieldFNAME);
        
        FieldDefinition fieldLNAME = new FieldDefinition();
        fieldLNAME.setName("LNAME");
        fieldLNAME.setTypeName("VARCHAR2");
        fieldLNAME.setSize(20);
        fieldLNAME.setSubSize(0);
        fieldLNAME.setIsPrimaryKey(true);
        fieldLNAME.setIsIdentity(false);
        fieldLNAME.setUnique(true);
        fieldLNAME.setShouldAllowNull(false);
        table.addField(fieldLNAME);
        
        FieldDefinition fieldAGE = new FieldDefinition();
        fieldAGE.setName("AGE");
        fieldAGE.setTypeName("NUMBER");
        fieldAGE.setSize(15);
        fieldAGE.setSubSize(0);
        fieldAGE.setIsPrimaryKey(false);
        fieldAGE.setIsIdentity(false);
        fieldAGE.setUnique(false);
        fieldAGE.setShouldAllowNull(false);
        table.addField(fieldAGE);

        FieldDefinition fieldGENDER = new FieldDefinition();
        fieldGENDER.setName("GENDER");
        fieldGENDER.setTypeName("VARCHAR2");
        fieldGENDER.setSize(6);
        fieldGENDER.setSubSize(0);
        fieldGENDER.setIsPrimaryKey(false);
        fieldGENDER.setIsIdentity(false);
        fieldGENDER.setUnique(false);
        fieldGENDER.setShouldAllowNull(true);
        table.addField(fieldGENDER);
        
        FieldDefinition fieldWORLDID = new FieldDefinition();
        fieldWORLDID.setName("WORLD_ID");
        fieldWORLDID.setTypeName("NUMBER");
        fieldWORLDID.setSize(19);
        fieldWORLDID.setSubSize(0);
        fieldWORLDID.setIsPrimaryKey(false);
        fieldWORLDID.setIsIdentity(false);
        fieldWORLDID.setUnique(false);
        fieldWORLDID.setShouldAllowNull(true);
        fieldWORLDID.setForeignKeyFieldName("CMP3_WORLD.ID");
        table.addField(fieldWORLDID);
        
        return table;
    }
    
    public TableDefinition buildHOCKEYPLAYERTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_HOCKEY_PLAYER");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("PLAYERID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(19);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);
        
        FieldDefinition fieldFNAME = new FieldDefinition();
        fieldFNAME.setName("FNAME");
        fieldFNAME.setTypeName("VARCHAR2");
        fieldFNAME.setSize(20);
        fieldFNAME.setSubSize(0);
        fieldFNAME.setIsPrimaryKey(false);
        fieldFNAME.setIsIdentity(false);
        fieldFNAME.setUnique(false);
        fieldFNAME.setShouldAllowNull(false);
        table.addField(fieldFNAME);
        
        FieldDefinition fieldLNAME = new FieldDefinition();
        fieldLNAME.setName("LNAME");
        fieldLNAME.setTypeName("VARCHAR2");
        fieldLNAME.setSize(20);
        fieldLNAME.setSubSize(0);
        fieldLNAME.setIsPrimaryKey(false);
        fieldLNAME.setIsIdentity(false);
        fieldLNAME.setUnique(false);
        fieldLNAME.setShouldAllowNull(false);
        table.addField(fieldLNAME);
        
        FieldDefinition fieldAGE = new FieldDefinition();
        fieldAGE.setName("AGE");
        fieldAGE.setTypeName("NUMBER");
        fieldAGE.setSize(15);
        fieldAGE.setSubSize(0);
        fieldAGE.setIsPrimaryKey(false);
        fieldAGE.setIsIdentity(false);
        fieldAGE.setUnique(false);
        fieldAGE.setShouldAllowNull(true);
        table.addField(fieldAGE);
        
        FieldDefinition fieldHEIGHT = new FieldDefinition();
        fieldHEIGHT.setName("HEIGHT");
        fieldHEIGHT.setTypeName("DOUBLE PRECIS");
        fieldHEIGHT.setSize(15);
        fieldHEIGHT.setSubSize(0);
        fieldHEIGHT.setIsPrimaryKey(false);
        fieldHEIGHT.setIsIdentity(false);
        fieldHEIGHT.setUnique(false);
        fieldHEIGHT.setShouldAllowNull(true);
        table.addField(fieldHEIGHT);
        
        FieldDefinition fieldWEIGHT = new FieldDefinition();
        fieldWEIGHT.setName("WEIGHT");
        fieldWEIGHT.setTypeName("DOUBLE PRECIS");
        fieldWEIGHT.setSize(15);
        fieldWEIGHT.setSubSize(0);
        fieldWEIGHT.setIsPrimaryKey(false);
        fieldWEIGHT.setIsIdentity(false);
        fieldWEIGHT.setUnique(false);
        fieldWEIGHT.setShouldAllowNull(true);
        table.addField(fieldWEIGHT);
        
        FieldDefinition fieldJERSEYNUMBER = new FieldDefinition();
        fieldJERSEYNUMBER.setName("JERSEY_NUMBER");
        fieldJERSEYNUMBER.setTypeName("NUMBER");
        fieldJERSEYNUMBER.setSize(15);
        fieldJERSEYNUMBER.setSubSize(0);
        fieldJERSEYNUMBER.setIsPrimaryKey(false);
        fieldJERSEYNUMBER.setIsIdentity(false);
        fieldJERSEYNUMBER.setUnique(false);
        fieldJERSEYNUMBER.setShouldAllowNull(true);
        table.addField(fieldJERSEYNUMBER);
        
        FieldDefinition fieldPOSITION = new FieldDefinition();
        fieldPOSITION.setName("POSITION");
        fieldPOSITION.setTypeName("VARCHAR2");
        fieldPOSITION.setSize(20);
        fieldPOSITION.setSubSize(0);
        fieldPOSITION.setIsPrimaryKey(false);
        fieldPOSITION.setIsIdentity(false);
        fieldPOSITION.setUnique(false);
        fieldPOSITION.setShouldAllowNull(true);
        table.addField(fieldPOSITION);
        
        FieldDefinition fieldTEAMID = new FieldDefinition();
        fieldTEAMID.setName("TEAM_ID");
        fieldTEAMID.setTypeName("NUMBER");
        fieldTEAMID.setSize(19);
        fieldTEAMID.setSubSize(0);
        fieldTEAMID.setIsPrimaryKey(false);
        fieldTEAMID.setIsIdentity(false);
        fieldTEAMID.setUnique(false);
        fieldTEAMID.setShouldAllowNull(true);
        fieldTEAMID.setForeignKeyFieldName("CMP3_HOCKEY_TEAM.ID");
        table.addField(fieldTEAMID);
        
        return table;
    }
    
    public TableDefinition buildHOCKEYTEAMTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_HOCKEY_TEAM");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(19);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);
        
        FieldDefinition fieldNAME = new FieldDefinition();
        fieldNAME.setName("NAME");
        fieldNAME.setTypeName("VARCHAR2");
        fieldNAME.setSize(20);
        fieldNAME.setSubSize(0);
        fieldNAME.setIsPrimaryKey(false);
        fieldNAME.setIsIdentity(false);
        fieldNAME.setUnique(false);
        fieldNAME.setShouldAllowNull(false);
        table.addField(fieldNAME);
        
        FieldDefinition fieldLEVEL = new FieldDefinition();
        fieldLEVEL.setName("TEAM_LEVEL");
        fieldLEVEL.setTypeName("VARCHAR2");
        fieldLEVEL.setSize(20);
        fieldLEVEL.setSubSize(0);
        fieldLEVEL.setIsPrimaryKey(false);
        fieldLEVEL.setIsIdentity(false);
        fieldLEVEL.setUnique(false);
        fieldLEVEL.setShouldAllowNull(false);
        table.addField(fieldLEVEL);

        FieldDefinition fieldHOMECOLOR = new FieldDefinition();
        fieldHOMECOLOR.setName("HOME_COLOR");
        fieldHOMECOLOR.setTypeName("VARCHAR2");
        fieldHOMECOLOR.setSize(20);
        fieldHOMECOLOR.setSubSize(0);
        fieldHOMECOLOR.setIsPrimaryKey(false);
        fieldHOMECOLOR.setIsIdentity(false);
        fieldHOMECOLOR.setUnique(false);
        fieldHOMECOLOR.setShouldAllowNull(true);
        table.addField(fieldHOMECOLOR);
        
        FieldDefinition fieldAWAYCOLOR = new FieldDefinition();
        fieldAWAYCOLOR.setName("AWAY_COLOR");
        fieldAWAYCOLOR.setTypeName("VARCHAR2");
        fieldAWAYCOLOR.setSize(20);
        fieldAWAYCOLOR.setSubSize(0);
        fieldAWAYCOLOR.setIsPrimaryKey(false);
        fieldAWAYCOLOR.setIsIdentity(false);
        fieldAWAYCOLOR.setUnique(false);
        fieldAWAYCOLOR.setShouldAllowNull(true);
        table.addField(fieldAWAYCOLOR);
        
        return table;
    }
    
    public TableDefinition buildPLAYERROLESTable() {
        TableDefinition table = new TableDefinition();
        table.setName("PLAYER_ROLES");

        FieldDefinition fieldPLAYERID = new FieldDefinition();
        fieldPLAYERID.setName("PLAYER_ID");
        fieldPLAYERID.setTypeName("NUMBER");
        fieldPLAYERID.setSize(19);
        fieldPLAYERID.setSubSize(0);
        fieldPLAYERID.setIsPrimaryKey(false);
        fieldPLAYERID.setIsIdentity(false);
        fieldPLAYERID.setUnique(false);
        fieldPLAYERID.setShouldAllowNull(false);
        fieldPLAYERID.setForeignKeyFieldName("CMP3_HOCKEY_PLAYER.PLAYERID");
        table.addField(fieldPLAYERID);
        
        FieldDefinition fieldROLEID = new FieldDefinition();
        fieldROLEID.setName("ROLE_ID");
        fieldROLEID.setTypeName("NUMBER");
        fieldROLEID.setSize(19);
        fieldROLEID.setSubSize(0);
        fieldROLEID.setIsPrimaryKey(false);
        fieldROLEID.setIsIdentity(false);
        fieldROLEID.setUnique(false);
        fieldROLEID.setShouldAllowNull(false);
        fieldROLEID.setForeignKeyFieldName("CMP3_ROLE.ID");
        table.addField(fieldROLEID);
        
        return table;
    }
    
    public TableDefinition buildROLETable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_ROLE");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(19);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);
        
        FieldDefinition fieldDESCRIPTION = new FieldDefinition();
        fieldDESCRIPTION.setName("DESCRIP");
        fieldDESCRIPTION.setTypeName("VARCHAR2");
        fieldDESCRIPTION.setSize(50);
        fieldDESCRIPTION.setSubSize(0);
        fieldDESCRIPTION.setIsPrimaryKey(false);
        fieldDESCRIPTION.setIsIdentity(false);
        fieldDESCRIPTION.setUnique(false);
        fieldDESCRIPTION.setShouldAllowNull(false);
        table.addField(fieldDESCRIPTION);
        
        return table;
    }
    
    public TableDefinition buildWORLDTable() {
        TableDefinition table = new TableDefinition();
        table.setName("CMP3_WORLD");

        FieldDefinition fieldID = new FieldDefinition();
        fieldID.setName("ID");
        fieldID.setTypeName("NUMBER");
        fieldID.setSize(19);
        fieldID.setSubSize(0);
        fieldID.setIsPrimaryKey(true);
        fieldID.setIsIdentity(false);
        fieldID.setUnique(false);
        fieldID.setShouldAllowNull(false);
        table.addField(fieldID);
        
        return table;
    }
}
