/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational;

import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWError;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.StatusDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.DescriptorCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.ProjectCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.relational.TableGenerator;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

abstract class AbstractGenerateTablesFromDescriptorsAction
extends AbstractFrameworkAction {
    AbstractGenerateTablesFromDescriptorsAction(WorkbenchContext context) {
        super(context);
    }

    protected void generateTablesFromDescriptors(Collection descriptors) {
        ApplicationNode selectedNode = this.selectedNodes()[0];
        MWProject project = (MWProject)selectedNode.getProjectRoot().getValue();
        boolean projectDirty = project.isDirtyBranch();
        int result = this.notifyClassDefinitionMayChange(projectDirty);
        if (result == 2 || result == -1) {
            return;
        }
        if (!projectDirty && result == 1) {
            return;
        }
        if (result == 0 && projectDirty) {
            selectedNode.save(null, this.getWorkbenchContext());
        }
        TableGenerator generator = new TableGenerator(this.getWorkbenchContext());
        StatusDialog.Status status = generator.generateTablesFromDescriptors(descriptors);
        this.showResult(status);
    }

    private int notifyClassDefinitionMayChange(boolean projectDirty) {
        String messageKey = projectDirty ? "AUTO_GENERATING_TABLE_DEFINITIONS_STATUS_MESSAGE_SAVE" : "AUTO_GENERATING_TABLE_DEFINITIONS_STATUS_MESSAGE";
        LabelArea label = new LabelArea(this.resourceRepository().getString(messageKey));
        return JOptionPane.showConfirmDialog(this.currentWindow(), label, this.application().getShortProductName(), projectDirty ? 1 : 0, 1);
    }

    private void showResult(StatusDialog.Status status) {
        StatusDialog dialog = new StatusDialog(this.getWorkbenchContext(), Collections.singletonList(status), "AUTO_GENERATING_TABLE_DEFINITIONS_STATUS_DIALOG_TITLE"){

            protected CellRendererAdapter buildNodeRenderer(Object value) {
                if (value instanceof MWProject) {
                    return new ProjectCellRendererAdapter(this.resourceRepository());
                }
                if (value instanceof MWDescriptor) {
                    return new DescriptorCellRendererAdapter(this.resourceRepository());
                }
                if (value instanceof MWError) {
                    return new StatusDialog.MWErrorCellRendererAdapter(){

                        public Icon buildIcon(Object value) {
                            MWError error = (MWError)value;
                            if (error.getErrorId().endsWith("ASSUMPTION")) {
                                return this.resourceRepository().getIcon("ignore");
                            }
                            if (error.getErrorId().endsWith("URGENT")) {
                                return this.resourceRepository().getIcon("urgent");
                            }
                            return super.buildIcon(value);
                        }
                    };
                }
                return super.buildNodeRenderer(value);
            }
        };
        dialog.setVisible(true);
    }
}

