/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWStringQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QueryFormatSubPanel;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

final class StringQueryFormatSubPanel
extends QueryFormatSubPanel {
    StringQueryFormatSubPanel(PropertyValueModel queryHolder, PropertyValueModel queryFormatHolder, WorkbenchContextHolder contextHolder) {
        super(queryHolder, queryFormatHolder, contextHolder);
    }

    protected void initialize() {
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel queryStringLabel = this.buildLabel("QUERY_STRING_PANEL_LABEL");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)queryStringLabel, constraints);
        JTextArea queryStringTextArea = this.buildQueryStringTextArea();
        queryStringLabel.setLabelFor(queryStringTextArea);
        JScrollPane stringAreaPane = new JScrollPane(queryStringTextArea);
        stringAreaPane.setPreferredSize(new Dimension(10, 75));
        stringAreaPane.setMinimumSize(new Dimension(10, 75));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(1, 0, 0, 0);
        this.add((Component)stringAreaPane, constraints);
        new ComponentEnabler((ValueModel)this.buildEnablementHolder(), new Component[]{queryStringLabel, queryStringTextArea});
    }

    private PropertyValueModel buildEnablementHolder() {
        return new TransformationPropertyValueModel(this.buildStringQueryFormatHolder()){

            protected Object transform(Object value) {
                return value != null ? Boolean.TRUE : Boolean.FALSE;
            }
        };
    }

    private JTextArea buildQueryStringTextArea() {
        JTextArea textArea = new JTextArea(this.buildQueryStringDocument());
        textArea.setFont(UIManager.getFont("Label.font"));
        if (textArea.getFont() == null) {
            textArea.setFont(new Font("dialog", 0, 12));
        }
        return textArea;
    }

    private Document buildQueryStringDocument() {
        return new DocumentAdapter(this.buildQueryStringHolder());
    }

    private PropertyValueModel buildQueryStringHolder() {
        return new PropertyAspectAdapter(this.buildStringQueryFormatHolder(), "queryString"){

            protected Object getValueFromSubject() {
                return ((MWStringQueryFormat)this.subject).getQueryString();
            }

            protected void setValueOnSubject(Object value) {
                ((MWStringQueryFormat)this.subject).setQueryString((String)value);
            }
        };
    }

    private PropertyValueModel buildStringQueryFormatHolder() {
        return new TransformationPropertyValueModel(this.getQueryFormatHolder()){

            protected Object transform(Object value) {
                return value instanceof MWStringQueryFormat ? value : null;
            }
        };
    }
}

