/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;

public class PropertyMetadata
extends ORMetadata {
    private String m_name;
    private String m_value;
    private Class m_valueType;
    private String m_valueTypeName;

    public PropertyMetadata() {
        super("<property>");
    }

    public PropertyMetadata(Annotation property, MetadataAccessibleObject accessibleObject) {
        super(property, accessibleObject);
        this.m_name = (String)MetadataHelper.invokeMethod("name", property);
        this.m_value = (String)MetadataHelper.invokeMethod("value", property);
        this.m_valueType = (Class)MetadataHelper.invokeMethod("valueType", property);
    }

    public String getIdentifier() {
        return this.getName();
    }

    public String getName() {
        return this.m_name;
    }

    public String getValue() {
        return this.m_value;
    }

    public Class getValueType() {
        return this.m_valueType;
    }

    public String getValueTypeName() {
        return this.m_valueTypeName;
    }

    public Object getConvertedValue() {
        if (this.m_valueType.equals(Void.TYPE) || this.m_valueType.equals(String.class)) {
            return this.m_value;
        }
        return ConversionManager.getDefaultManager().convertObject(this.m_value, this.m_valueType);
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject) {
        super.initXMLObject(accessibleObject);
        this.m_valueType = this.initXMLClassName(this.m_valueTypeName);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setValue(String value) {
        this.m_value = value;
    }

    public void setValueType(Class valueType) {
        this.m_valueType = valueType;
    }

    public void setValueTypeName(String valueTypeName) {
        this.m_valueTypeName = valueTypeName;
    }
}

