/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Field;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PLSQLMap;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithFields;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.PlsqlTypeInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.RowtypeInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewCache;

public class PlsqlRecordType
extends SqlTypeWithFields {
    private FieldInfo[] m_fieldInfo;
    private RowtypeInfo[] m_rowtypeInfo;

    public PlsqlRecordType(SqlName sqlName, FieldInfo[] fieldInfo, Field[] fields, RowtypeInfo[] rowtypeInfo, boolean generateMe, SqlType parentType, SqlReflector reflector) throws SQLException {
        super(sqlName, 1992, generateMe, parentType, reflector);
        this.m_rowtypeInfo = rowtypeInfo;
        this.m_fieldInfo = fieldInfo;
        this.m_fields = fields;
    }

    @Override
    public Field[] getDeclaredFields(boolean publishedOnly) throws SQLException, PublisherException {
        int i;
        if (!publishedOnly) {
            return this.m_fields;
        }
        if (this.m_fieldsPublishedOnly != null) {
            return this.m_fieldsPublishedOnly;
        }
        ArrayList<Field> fieldsCS = new ArrayList<Field>();
        PLSQLMap map = new PLSQLMap(this.m_parentType, this.m_reflector);
        for (i = 0; i < this.m_fields.length; ++i) {
            if (map.getMemberName(this.m_fields[i].getName()) == null) continue;
            fieldsCS.add(this.m_fields[i]);
        }
        this.m_fieldsPublishedOnly = new Field[fieldsCS.size()];
        for (i = 0; i < this.m_fieldsPublishedOnly.length; ++i) {
            this.m_fieldsPublishedOnly[i] = (Field)fieldsCS.get(i);
        }
        return this.m_fieldsPublishedOnly;
    }

    @Override
    public Field[] getFields(boolean publishedOnly) throws SecurityException, SQLException, PublisherException {
        return this.getDeclaredFields(publishedOnly);
    }

    @Override
    protected FieldInfo[] getFieldInfo() {
        return this.m_fieldInfo;
    }

    static FieldInfo[] getFieldInfo(String packageName, String methodName, String methodNo, int sequence, SqlReflector reflector) throws SQLException {
        int data_level = -1;
        int next_rec_sequence = -1;
        ViewCache viewCache = reflector.getViewCache();
        Iterator iter = viewCache.getRows("ALL_ARGUMENTS", new String[0], new String[]{"PACKAGE_NAME", "OBJECT_NAME", "OVERLOAD"}, new Object[]{packageName, methodName, methodNo}, new String[]{"SEQUENCE"});
        ArrayList<UserArguments> viewRows = new ArrayList<UserArguments>();
        while (iter.hasNext()) {
            UserArguments item = (UserArguments)iter.next();
            viewRows.add(item);
        }
        PlsqlTypeInfo[] info = PlsqlTypeInfo.getPlsqlTypeInfo(viewRows);
        if (info != null) {
            for (int i = 0; i < info.length; ++i) {
                if (data_level == -1 && (sequence == -1 || sequence == info[i].sequence)) {
                    data_level = info[i].dataLevel;
                }
                if (data_level <= -1 || data_level != info[i].dataLevel || next_rec_sequence != -1 || sequence >= info[i].sequence) continue;
                next_rec_sequence = info[i].sequence;
                break;
            }
        }
        iter = viewCache.getRows("ALL_ARGUMENTS", new String[0], new String[]{"PACKAGE_NAME", "OBJECT_NAME", "OVERLOAD", "DATA_LEVEL"}, new Object[]{packageName, methodName, methodNo, new Integer(++data_level)}, new String[]{"SEQUENCE"});
        viewRows = new ArrayList();
        while (iter.hasNext()) {
            UserArguments item = (UserArguments)iter.next();
            if (sequence != -1 && item.sequence <= sequence || next_rec_sequence != -1 && item.sequence >= next_rec_sequence) continue;
            viewRows.add(item);
        }
        return FieldInfo.getFieldInfo(viewRows);
    }

    RowtypeInfo[] getRowtypeInfo() {
        return this.m_rowtypeInfo;
    }
}

