/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Method;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;

public abstract class SqlStmtMethod
extends Method {
    protected String[] m_sqlStmtParamNames;
    protected Type[] m_sqlStmtParamTypes;
    protected int[] m_sqlStmtParamModes;
    protected String m_sqlStmt;
    protected String m_sqlStmtTmp;
    protected String m_sqlStmtQuoted;
    protected SqlReflector m_reflector;

    public SqlStmtMethod(String name, int modifiers, String sqlStmt, SqlReflector reflector) throws SQLException, PublisherException {
        super(name, null, modifiers, null, null, null, null, null, -1);
        int j;
        this.m_sqlStmt = sqlStmt;
        this.m_reflector = reflector;
        this.m_keepMethodName = true;
        this.m_sqlStmtTmp = this.m_sqlStmt;
        Vector<String> sqlStmtParamNamesV = new Vector<String>();
        Vector<SqlType> sqlStmtParamTypesV = new Vector<SqlType>();
        Vector<Integer> sqlStmtParamModesV = new Vector<Integer>();
        Vector<String> uniqueParamNamesV = new Vector<String>();
        Vector<SqlType> uniqueParamTypesV = new Vector<SqlType>();
        Vector<Integer> uniqueParamModesV = new Vector<Integer>();
        Hashtable<String, String> uniqueHash = new Hashtable<String, String>();
        int idx0 = this.m_sqlStmtTmp.lastIndexOf(":{");
        int idx1 = -1;
        int jdbcParamIdx = 0;
        if (idx0 >= 0) {
            idx1 = this.m_sqlStmtTmp.indexOf(125, idx0);
        }
        while (idx0 >= 0 && idx1 >= 0) {
            ++jdbcParamIdx;
            String sqlStmtTmpTerm = this.m_sqlStmtTmp.substring(idx0 + ":{".length(), idx1);
            StringTokenizer stnz = new StringTokenizer(sqlStmtTmpTerm);
            boolean unique = true;
            if (stnz.countTokens() > 1) {
                String paramName = SqlName.sqlIdToJavaId(stnz.nextToken(), false);
                if (paramName != null) {
                    unique = uniqueHash.get(paramName) == null;
                }
                uniqueHash.put(paramName, paramName);
                sqlStmtParamNamesV.addElement(paramName);
                if (unique) {
                    uniqueParamNamesV.addElement(paramName);
                }
                try {
                    String typeName = stnz.nextToken();
                    while (stnz.hasMoreTokens()) {
                        typeName = typeName + " " + stnz.nextToken();
                    }
                    String schema = null;
                    if ((typeName = typeName.toUpperCase()).indexOf(46) > -1 && typeName.indexOf(46) < typeName.length() - 1) {
                        schema = typeName.substring(0, typeName.indexOf(46));
                        typeName = typeName.substring(typeName.indexOf(46) + 1);
                    }
                    SqlType tmpType = this.m_reflector.addSqlUserType(schema, typeName, 7, false, 0, 0, null);
                    sqlStmtParamTypesV.addElement(tmpType);
                    if (unique) {
                        uniqueParamTypesV.addElement(tmpType);
                    }
                }
                catch (PublisherException e) {
                    throw new SQLException(e.getMessage());
                }
                sqlStmtParamModesV.addElement(new Integer(1));
                if (unique) {
                    uniqueParamModesV.addElement(new Integer(1));
                }
                this.m_sqlStmtTmp = this.m_sqlStmtTmp.substring(0, idx0) + "?" + this.m_sqlStmtTmp.substring(idx1 + 1);
                this.m_sqlStmt = this.m_sqlStmt.substring(0, idx0) + ":" + jdbcParamIdx + this.m_sqlStmt.substring(idx1 + 1);
            } else {
                System.err.println("needParamNameAndType " + sqlStmtTmpTerm);
            }
            if ((idx0 = this.m_sqlStmtTmp.lastIndexOf(":{")) < 0) continue;
            idx1 = this.m_sqlStmtTmp.indexOf(125, idx0);
        }
        this.m_sqlStmtParamNames = new String[sqlStmtParamNamesV.size()];
        this.m_sqlStmtParamTypes = new Type[sqlStmtParamNamesV.size()];
        this.m_sqlStmtParamModes = new int[sqlStmtParamNamesV.size()];
        for (j = 0; j < sqlStmtParamNamesV.size(); ++j) {
            int jj = sqlStmtParamNamesV.size() - j - 1;
            this.m_sqlStmtParamNames[jj] = (String)sqlStmtParamNamesV.elementAt(j);
            this.m_sqlStmtParamTypes[jj] = (Type)sqlStmtParamTypesV.elementAt(j);
            this.m_sqlStmtParamModes[jj] = (Integer)sqlStmtParamModesV.elementAt(j);
        }
        this.m_paramNames = new String[uniqueParamNamesV.size()];
        this.m_paramTypes = new Type[uniqueParamNamesV.size()];
        this.m_paramModes = new int[uniqueParamNamesV.size()];
        for (j = 0; j < uniqueParamNamesV.size(); ++j) {
            int jj = uniqueParamNamesV.size() - j - 1;
            this.m_paramNames[jj] = (String)uniqueParamNamesV.elementAt(j);
            this.m_paramTypes[jj] = (Type)uniqueParamTypesV.elementAt(j);
            this.m_paramModes[jj] = (Integer)uniqueParamModesV.elementAt(j);
        }
    }

    public String getSqlStmt() {
        return this.m_sqlStmt;
    }

    public String getSqlStmtQuoted() {
        if (this.m_sqlStmtQuoted == null) {
            this.m_sqlStmtQuoted = Util.quote(this.m_sqlStmt);
        }
        return this.m_sqlStmtQuoted;
    }

    public String[] getSqlStmtParamNames() {
        return this.m_sqlStmtParamNames;
    }

    public Type[] getSqlStmtParamTypes() {
        return this.m_sqlStmtParamTypes;
    }
}

