/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.Util;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Method;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlCursorMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlPackageType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithFields;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.MethodInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ParamInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ResultInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;

public abstract class SqlTypeWithMethods
extends SqlTypeWithFields {
    protected Method[] m_methods;
    protected MethodFilter m_methodFilter = null;

    public SqlTypeWithMethods(SqlName sqlName, int typecode, boolean generateMe, SqlType parentType, MethodFilter signatureFilter, SqlReflector reflector) throws SQLException {
        super(sqlName, typecode, generateMe, parentType, reflector);
        this.m_methodFilter = signatureFilter;
    }

    @Override
    public Method[] getDeclaredMethods() throws SQLException, PublisherException {
        if (this.m_methods == null) {
            this.m_methods = this.reflectMethods(this.getSqlName());
        }
        return this.m_methods;
    }

    @Override
    public boolean hasMethods() throws SQLException, PublisherException {
        Method[] m = this.getDeclaredMethods();
        return m.length > 0;
    }

    private Method[] reflectMethods(SqlName sqlName) throws SQLException, PublisherException {
        String schema = sqlName.getSchemaName();
        String type = sqlName.getTypeName();
        ArrayList<PlsqlMethod> methodl = new ArrayList<PlsqlMethod>();
        MethodInfo[] minfo = this.getMethodInfo(schema, type);
        for (int minfoi = 0; minfoi < minfo.length; ++minfoi) {
            int len;
            String methodName = minfo[minfoi].methodName;
            String methodType = minfo[minfoi].methodType;
            String methodNo = minfo[minfoi].methodNo;
            int results = minfo[minfoi].results;
            int parameters = minfo[minfoi].parameters;
            boolean preApproved = true;
            if (this.m_methodFilter != null) {
                preApproved = this.m_methodFilter.acceptMethod(new Method(methodName, null, -1, null, null, null, null, null, 0), true);
            }
            if (!preApproved) continue;
            int modifiers = 1;
            if (methodType.equals("MAP")) {
                modifiers ^= Integer.MIN_VALUE;
            } else if (methodType.equals("ORDER")) {
                modifiers ^= 0x40000000;
            }
            SqlType returnType = null;
            ResultInfo resultInfo = null;
            if (results > 0 && (resultInfo = this.getResultInfo(schema, type, methodName, methodNo)) != null) {
                try {
                    String resultTypeOwner = resultInfo.resultTypeOwner;
                    String resultTypeName = resultInfo.resultTypeName;
                    String resultTypeSubname = resultInfo.resultTypeSubname;
                    String resultTypeMod = resultInfo.resultTypeMod;
                    boolean ncharFormOfUse = resultInfo.ncharFormOfUse;
                    String resultMethodName = resultInfo.methodName;
                    String resultMethodNo = resultInfo.methodNo;
                    int sequence = resultInfo.sequence;
                    returnType = this.m_reflector.addPlsqlDBType(resultTypeOwner, resultTypeName, resultTypeSubname, resultTypeMod, ncharFormOfUse, type, resultMethodName, resultMethodNo, sequence, this);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            int paramCount = parameters;
            Vector<SqlType> paramTypes_v = new Vector<SqlType>();
            Vector<String> paramNames_v = new Vector<String>();
            Vector<Integer> paramModes_v = new Vector<Integer>();
            Vector<Boolean> paramNCharFormOfUse_v = new Vector<Boolean>();
            int firstNoDefault = -1;
            boolean[] paramDefaults = new boolean[paramCount];
            if (paramCount > 0) {
                int i;
                ParamInfo[] pinfo = null;
                pinfo = this.getParamInfo(schema, type, methodName, methodNo);
                String[] paramTypeOwner = new String[paramCount];
                String[] paramName = new String[paramCount];
                String[] paramTypeName = new String[paramCount];
                String[] paramTypeSubname = new String[paramCount];
                String[] paramTypeMod = new String[paramCount];
                String[] paramMode = new String[paramCount];
                boolean[] mcharFormOfUse = new boolean[paramCount];
                String[] paramMethodName = new String[paramCount];
                String[] paramMethodNo = new String[paramCount];
                int[] sequence = new int[paramCount];
                int[] objectId = new int[paramCount];
                for (i = pinfo.length - 1; i >= 0; --i) {
                    paramTypeOwner[i] = pinfo[i].paramTypeOwner;
                    paramName[i] = pinfo[i].paramName;
                    paramTypeName[i] = pinfo[i].paramTypeName;
                    paramTypeSubname[i] = pinfo[i].paramTypeSubname;
                    paramTypeMod[i] = pinfo[i].paramTypeMod;
                    paramMode[i] = pinfo[i].paramMode;
                    mcharFormOfUse[i] = pinfo[i].ncharFormOfUse;
                    paramMethodName[i] = pinfo[i].methodName;
                    paramMethodNo[i] = pinfo[i].methodNo;
                    sequence[i] = pinfo[i].sequence;
                    objectId[i] = pinfo[i].objectId;
                }
                paramDefaults = new boolean[pinfo.length];
                for (i = pinfo.length - 1; i >= 0; --i) {
                    paramDefaults[i] = this.hasDefault(objectId[i], paramMethodName[i], sequence[i], paramMethodNo[i]);
                }
                for (i = pinfo.length - 1; i >= 0; --i) {
                    if (paramDefaults[i]) continue;
                    firstNoDefault = i;
                    break;
                }
                for (i = 0; i < paramCount && paramMethodName[i] != null; ++i) {
                    try {
                        paramNames_v.addElement(paramName[i]);
                        String mode = paramMode[i];
                        paramModes_v.addElement(new Integer(mode == null ? 3 : (mode.equals("IN") ? 1 : (mode.equals("OUT") ? 2 : 3))));
                        paramTypes_v.addElement(this.m_reflector.addPlsqlDBType(paramTypeOwner[i], paramTypeName[i], paramTypeSubname[i], paramTypeMod[i], mcharFormOfUse[i], type, paramMethodName[i], paramMethodNo[i], sequence[i], this));
                        paramNCharFormOfUse_v.addElement(new Boolean(mcharFormOfUse[i]));
                        continue;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
            if ((len = paramTypes_v.size()) != paramCount) {
                System.err.println("WARNING: incorrect parameter number for method " + methodName + ". Expect " + paramCount + " with actual " + len);
            }
            Type[] paramTypes = new Type[len];
            String[] paramNames = new String[len];
            int[] paramModes = new int[len];
            boolean[] paramNCharFormOfUse = new boolean[len];
            for (int i = 0; i < len; ++i) {
                paramTypes[i] = (Type)paramTypes_v.elementAt(i);
                paramNames[i] = (String)paramNames_v.elementAt(i);
                paramModes[i] = (Integer)paramModes_v.elementAt(i);
                paramNCharFormOfUse[i] = (Boolean)paramNCharFormOfUse_v.elementAt(i);
            }
            paramTypes = this.generateDefaultArgsHolderParamTypes(paramTypes, paramDefaults, paramNCharFormOfUse);
            Method method = null;
            for (int paramLen = firstNoDefault + 1; paramLen <= paramCount; ++paramLen) {
                method = this instanceof SqlPackageType && returnType != null && resultInfo != null && returnType.equals(SqlReflector.REF_CURSOR_TYPE) ? new PlsqlCursorMethod(type, methodName, methodNo, modifiers, resultInfo.sequence, paramTypes, paramNames, paramModes, paramDefaults, paramLen, false, this.m_reflector) : (this instanceof SqlPackageType ? new PlsqlMethod(methodName, methodNo, modifiers, returnType, paramTypes, paramNames, paramModes, paramDefaults, paramLen) : new Method(methodName, methodNo, modifiers, returnType, paramTypes, paramNames, paramModes, paramDefaults, paramLen));
                if (!this.acceptMethod(method, false)) continue;
                methodl.add((PlsqlMethod)method);
                if (returnType == null || resultInfo == null || !returnType.equals(SqlReflector.REF_CURSOR_TYPE) || ((PlsqlCursorMethod)(method = new PlsqlCursorMethod(type, methodName, methodNo, modifiers, resultInfo.sequence, paramTypes, paramNames, paramModes, paramDefaults, paramLen, true, this.m_reflector))).getReturnColCount() == 0) continue;
                methodl.add((PlsqlMethod)method);
            }
        }
        Object[] methods = new Method[methodl.size()];
        for (int i = 0; i < methods.length; ++i) {
            methods[i] = (Method)methodl.get(i);
        }
        return (Method[])Util.sort(methods);
    }

    protected abstract MethodInfo[] getMethodInfo(String var1, String var2) throws SQLException;

    protected boolean acceptMethod(Method method, boolean preApprove) {
        boolean accept = true;
        if (this.m_methodFilter != null) {
            accept = this.m_methodFilter.acceptMethod(method, preApprove);
        }
        return accept;
    }

    protected abstract ResultInfo getResultInfo(String var1, String var2, String var3, String var4) throws SQLException;

    protected abstract ParamInfo[] getParamInfo(String var1, String var2, String var3, String var4) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasDefault(int object_id, String methodName, int sequence, String overload) throws SQLException {
        int hasDefaultInt;
        block23: {
            Object conn = null;
            Statement stmt = null;
            ResultSet rs = null;
            boolean objectIdIdx = true;
            int objectNameIdx = 2;
            int seqIdx = 3;
            hasDefaultInt = 0;
            try {
                Iterator rowIter = overload == null || overload.equals("") ? this.m_viewCache.getRows("ALL_ARGUMENTS", new String[]{"DEFAULTED"}, new String[]{"OBJECT_ID", "OBJECT_NAME", "SEQUENCE", "OVERLOAD"}, new Object[]{new Integer(object_id), methodName, new Integer(sequence), null}, new String[0]) : this.m_viewCache.getRows("ALL_ARGUMENTS", new String[]{"DEFAULTED"}, new String[]{"OBJECT_ID", "OBJECT_NAME", "SEQUENCE", "OVERLOAD"}, new Object[]{new Integer(object_id), methodName, new Integer(sequence), overload}, new String[0]);
                if (rowIter.hasNext()) {
                    SingleColumnViewRow row = (SingleColumnViewRow)rowIter.next();
                    String defaulted = row.getValue();
                    hasDefaultInt = "Y".equalsIgnoreCase(defaulted) ? 1 : 0;
                    break block23;
                }
                throw new SQLException("Pre-10.2 database do not support DEFAULTED in ALL_ARGUMENTS");
            }
            catch (Exception se) {
                try {
                    SingleColumnViewRow row;
                    boolean oidIdx = true;
                    int methodNameIdx = 2;
                    int sequenceIdx = 3;
                    int overloadIdx = 4;
                    String sqljutl = "SYS.SQLJUTL.HAS_DEFAULT(" + object_id + ", " + "'" + methodName.toUpperCase() + "', " + sequence + "," + (overload == null || overload.equals("") ? "0" : overload) + ")";
                    Iterator rowIter = this.m_viewCache.getRows("DUAL", new String[]{sqljutl}, new String[0], new Object[0], new String[0]);
                    if (rowIter.hasNext() && (row = (SingleColumnViewRow)rowIter.next()).getValue() != null) {
                        hasDefaultInt = Integer.parseInt(row.getValue());
                    }
                }
                catch (Exception e8) {
                    e8.printStackTrace();
                    System.err.println("WARNING: please install SYS.SQLJUTL for appropriate treatement of PL/SQL default arguments.");
                }
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {}
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
        return hasDefaultInt == 1;
    }

    Type[] generateDefaultArgsHolderParamTypes(Type[] paramTypes, boolean[] paramDefaults, boolean[] ncharFormOfUse) throws SQLException, PublisherException {
        int i;
        Type[] defaultParamTypes = paramTypes;
        boolean hasDefault = false;
        for (i = 0; i < paramDefaults.length; ++i) {
            if (!paramDefaults[i]) continue;
            hasDefault = true;
        }
        if (hasDefault) {
            defaultParamTypes = new Type[paramTypes.length];
            for (i = 0; i < paramTypes.length; ++i) {
                defaultParamTypes[i] = paramDefaults[i] ? this.m_reflector.addDefaultArgsHolderType((SqlType)paramTypes[i], this.getSqlName().getSimpleName(), this, ncharFormOfUse[i]) : paramTypes[i];
            }
        }
        return defaultParamTypes;
    }
}

