/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWXmlDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWCollectionContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWDirectContainerMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWListContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWSetContainerPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXmlTypeConversionConverter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.xml.MWXpathedMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClassAttribute;
import org.eclipse.persistence.tools.workbench.mappingsmodel.schema.MWSchemaContextComponent;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXmlField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.MWXpathSpec;
import org.eclipse.persistence.tools.workbench.mappingsmodel.xml.SchemaChange;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWAbstractXmlDirectCollectionMapping
extends MWDirectContainerMapping
implements MWXmlMapping,
MWXpathedMapping,
MWXpathContext,
MWDirectCollectionMapping,
MWContainerMapping {
    private MWXmlField xmlField;
    private MWContainerPolicy containerPolicy;

    protected MWAbstractXmlDirectCollectionMapping() {
    }

    MWAbstractXmlDirectCollectionMapping(MWXmlDescriptor descriptor, MWClassAttribute attribute, String name) {
        super(descriptor, attribute, name);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.xmlField = new MWXmlField(this);
    }

    protected void initialize(MWClassAttribute attribute, String name) {
        super.initialize(attribute, name);
        this.containerPolicy = attribute.isAssignableToList() ? new MWListContainerPolicy(this) : (attribute.isAssignableToSet() ? new MWSetContainerPolicy(this) : (attribute.isAssignableToCollection() ? new MWCollectionContainerPolicy(this) : new MWListContainerPolicy(this)));
    }

    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        children.add(this.xmlField);
        children.add(this.containerPolicy);
    }

    public MWContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    private void setContainerPolicy(MWContainerPolicy containerPolicy) {
        MWContainerPolicy oldValue = this.containerPolicy;
        this.containerPolicy = containerPolicy;
        this.firePropertyChanged("containerPolicy", oldValue, containerPolicy);
    }

    private MWContainerPolicy getContainerPolicyForToplink() {
        return this.containerPolicy;
    }

    private void setContainerPolicyForToplink(MWContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
    }

    public MWCollectionContainerPolicy setCollectionContainerPolicy() {
        if (this.containerPolicy instanceof MWCollectionContainerPolicy) {
            return (MWCollectionContainerPolicy)this.containerPolicy;
        }
        MWCollectionContainerPolicy containerPolicy = new MWCollectionContainerPolicy(this);
        this.setContainerPolicy(containerPolicy);
        return containerPolicy;
    }

    public MWListContainerPolicy setListContainerPolicy() {
        if (this.containerPolicy instanceof MWListContainerPolicy) {
            return (MWListContainerPolicy)this.containerPolicy;
        }
        MWListContainerPolicy containerPolicy = new MWListContainerPolicy(this);
        this.setContainerPolicy(containerPolicy);
        return containerPolicy;
    }

    public MWSetContainerPolicy setSetContainerPolicy() {
        if (this.containerPolicy instanceof MWSetContainerPolicy) {
            return (MWSetContainerPolicy)this.containerPolicy;
        }
        MWSetContainerPolicy containerPolicy = new MWSetContainerPolicy(this);
        this.setContainerPolicy(containerPolicy);
        return containerPolicy;
    }

    public MWXmlField getXmlField() {
        return this.xmlField;
    }

    public MWXmlField firstMappedXmlField() {
        if (!"".equals(this.getXmlField().getXpath())) {
            return this.getXmlField();
        }
        return null;
    }

    public void addWrittenFieldsTo(Collection writtenXpaths) {
        if (!this.isReadOnly() && !"".equals(this.getXmlField().getXpath())) {
            writtenXpaths.add(this.getXmlField());
        }
    }

    public MWSchemaContextComponent schemaContext() {
        return this.xmlDescriptor().getSchemaContext();
    }

    public MWSchemaContextComponent schemaContext(MWXmlField xmlField) {
        return this.xmlDescriptor().getSchemaContext();
    }

    public MWXpathSpec xpathSpec(MWXmlField xmlField) {
        return this.buildXpathSpec();
    }

    protected MWXpathSpec buildXpathSpec() {
        return new MWXpathSpec(){

            public boolean mayUseCollectionData() {
                return true;
            }

            public boolean mayUseComplexData() {
                return false;
            }

            public boolean mayUseSimpleData() {
                return true;
            }
        };
    }

    protected MWTypeConversionConverter buildTypeConversionConverter() {
        return new MWXmlTypeConversionConverter(this);
    }

    protected MWXmlDescriptor xmlDescriptor() {
        return (MWXmlDescriptor)this.getParent();
    }

    protected void initializeFromMWXpathedMapping(MWXpathedMapping oldMapping) {
        super.initializeFromMWXpathedMapping(oldMapping);
        this.getXmlField().setXpath(oldMapping.getXmlField().getXpath());
        this.getXmlField().setTyped(oldMapping.getXmlField().isTyped());
    }

    protected void addProblemsTo(List newProblems) {
        this.addXpathNotSpecifiedProblemTo(newProblems);
        this.addXmlFieldNotDirectProblemTo(newProblems);
        super.addProblemsTo(newProblems);
    }

    private void addXpathNotSpecifiedProblemTo(List newProblems) {
        if (!this.getXmlField().isSpecified()) {
            newProblems.add(this.buildProblem("0810"));
        }
    }

    private void addXmlFieldNotDirectProblemTo(List newProblems) {
        if (this.getXmlField().isValid() && !this.getXmlField().isDirect()) {
            newProblems.add(this.buildProblem("0814", this.getXmlField().getXpath()));
        }
    }

    public void resolveXpaths() {
        this.xmlField.resolveXpaths();
    }

    public void schemaChanged(SchemaChange change) {
        this.xmlField.schemaChanged(change);
    }

    protected DatabaseMapping buildRuntimeMapping() {
        return this.xmlDescriptor().buildDefaultRuntimeDirectCollectionMapping();
    }

    public DatabaseMapping runtimeMapping() {
        AbstractCompositeDirectCollectionMapping runtimeMapping = (AbstractCompositeDirectCollectionMapping)super.runtimeMapping();
        runtimeMapping.setValueConverter(this.getConverter().runtimeConverter((DatabaseMapping)runtimeMapping));
        runtimeMapping.setField(this.getXmlField().runtimeField());
        runtimeMapping.setContainerPolicy(this.containerPolicy.runtimeContainerPolicy());
        return runtimeMapping;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWAbstractXmlDirectCollectionMapping.class);
        descriptor.getInheritancePolicy().setParentClass(MWDirectContainerMapping.class);
        XMLCompositeObjectMapping xmlFieldMapping = new XMLCompositeObjectMapping();
        xmlFieldMapping.setReferenceClass(MWXmlField.class);
        xmlFieldMapping.setAttributeName("xmlField");
        xmlFieldMapping.setGetMethodName("getXmlFieldForTopLink");
        xmlFieldMapping.setSetMethodName("setXmlFieldForTopLink");
        xmlFieldMapping.setXPath("xpath");
        descriptor.addMapping((DatabaseMapping)xmlFieldMapping);
        XMLCompositeObjectMapping containerPolicyMapping = new XMLCompositeObjectMapping();
        containerPolicyMapping.setAttributeName("containerPolicy");
        containerPolicyMapping.setReferenceClass(MWContainerPolicy.MWContainerPolicyRoot.class);
        containerPolicyMapping.setGetMethodName("getContainerPolicyForToplink");
        containerPolicyMapping.setSetMethodName("setContainerPolicyForToplink");
        containerPolicyMapping.setXPath("container-policy");
        descriptor.addMapping((DatabaseMapping)containerPolicyMapping);
        return descriptor;
    }

    private MWXmlField getXmlFieldForTopLink() {
        return this.xmlField.isSpecified() ? this.xmlField : null;
    }

    private void setXmlFieldForTopLink(MWXmlField xmlField) {
        this.xmlField = xmlField == null ? new MWXmlField(this) : xmlField;
    }
}

