/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelGeneratorProperties;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaModelGenerator {
    protected static final String SCHEMA_FILE_NAME = "schema";
    protected static final String SCHEMA_FILE_EXT = ".xsd";
    protected static final String COLON = ":";
    protected static final String EMPTY_STRING = "";

    public Map<String, Schema> generateSchemas(java.util.List<XMLDescriptor> descriptorsToProcess, SchemaModelGeneratorProperties properties) throws DescriptorException {
        HashMap<String, Schema> schemaForNamespace = new HashMap<String, Schema>();
        Schema workingSchema = null;
        if (properties == null) {
            properties = new SchemaModelGeneratorProperties();
        }
        for (XMLDescriptor desc : descriptorsToProcess) {
            String namespace;
            XMLSchemaReference schemaRef = desc.getSchemaReference();
            if (schemaRef != null) {
                namespace = schemaRef.getSchemaContextAsQName(desc.getNamespaceResolver()).getNamespaceURI();
                workingSchema = this.getSchema(namespace, desc.getNamespaceResolver(), schemaForNamespace, properties);
                this.addNamespacesToWorkingSchema(desc.getNamespaceResolver(), workingSchema);
                continue;
            }
            for (DatabaseTable table : desc.getTables()) {
                namespace = this.getDefaultRootElementAsQName(desc, table.getName()).getNamespaceURI();
                workingSchema = this.getSchema(namespace, desc.getNamespaceResolver(), schemaForNamespace, properties);
                this.addNamespacesToWorkingSchema(desc.getNamespaceResolver(), workingSchema);
            }
        }
        for (XMLDescriptor xdesc : descriptorsToProcess) {
            this.processDescriptor(xdesc, schemaForNamespace, workingSchema, properties, descriptorsToProcess);
        }
        return schemaForNamespace;
    }

    protected void processDescriptor(XMLDescriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        XMLSchemaReference schemaRef = desc.getSchemaReference();
        if (schemaRef != null) {
            if (schemaRef.getType() == 1) {
                workingSchema.addTopLevelComplexTypes(this.buildComplexType(false, desc, schemaForNamespace, workingSchema, properties, descriptors));
            } else if (schemaRef.getType() == 2) {
                workingSchema.addTopLevelSimpleTypes(this.buildSimpleType(desc, workingSchema));
            }
            for (DatabaseTable table : desc.getTables()) {
                String localName = this.getDefaultRootElementAsQName(desc, table.getName()).getLocalPart();
                Element topLevelElement = new Element();
                topLevelElement.setName(localName);
                QName qname = schemaRef.getSchemaContextAsQName(workingSchema.getNamespaceResolver());
                String elementType = qname.getLocalPart();
                String elementTypeUri = qname.getNamespaceURI();
                String elementTypePrefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(elementTypeUri);
                if (elementTypePrefix != null) {
                    elementType = elementTypePrefix + COLON + elementType;
                }
                topLevelElement.setType(elementType);
                workingSchema.addTopLevelElement(topLevelElement);
            }
        } else {
            for (DatabaseTable table : desc.getTables()) {
                String localName = this.getDefaultRootElementAsQName(desc, table.getName()).getLocalPart();
                if (workingSchema.getTopLevelElements().get(localName) != null) continue;
                Element topLevelElement = new Element();
                topLevelElement.setName(localName);
                topLevelElement.setComplexType(this.buildComplexType(true, desc, schemaForNamespace, workingSchema, properties, descriptors));
                workingSchema.addTopLevelElement(topLevelElement);
            }
        }
    }

    private Schema getSchema(String uri, NamespaceResolver nr, HashMap<String, Schema> schemaForNamespace, SchemaModelGeneratorProperties properties) {
        Schema schema = schemaForNamespace.get(uri);
        if (schema == null) {
            schema = this.buildNewSchema(uri, nr, schemaForNamespace.size(), properties);
            schemaForNamespace.put(uri, schema);
        }
        return schema;
    }

    protected SimpleType buildSimpleType(XMLDescriptor desc, Schema workingSchema) {
        SimpleType st = this.buildNewSimpleType(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
        DatabaseMapping mapping = desc.getMappings().get(0);
        QName qname = (QName)XMLConversionManager.getDefaultJavaTypes().get(mapping.getAttributeClassification());
        String baseType = qname.getLocalPart();
        if (qname.getNamespaceURI() != null) {
            String prefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(qname.getNamespaceURI());
            if (prefix == null) {
                prefix = workingSchema.getNamespaceResolver().generatePrefix();
                workingSchema.getNamespaceResolver().put(prefix, qname.getNamespaceURI());
            }
            baseType = prefix + COLON + baseType;
        }
        Restriction restriction = new Restriction();
        restriction.setBaseType(baseType);
        st.setRestriction(restriction);
        return st;
    }

    protected SimpleType buildNewSimpleType(String name) {
        SimpleType st = new SimpleType();
        st.setName(name);
        return st;
    }

    private ComplexType buildComplexType(boolean anonymous, XMLDescriptor desc, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        ComplexType ct = new ComplexType();
        if (!anonymous) {
            ct.setName(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
        }
        InheritancePolicy inheritancePolicy = desc.getInheritancePolicyOrNull();
        Extension extension = null;
        if (inheritancePolicy != null && inheritancePolicy.getParentClass() != null) {
            extension = new Extension();
            extension.setBaseType(desc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()).getLocalPart());
            ComplexContent complexContent = new ComplexContent();
            complexContent.setExtension(extension);
            ct.setComplexContent(complexContent);
        }
        Sequence seq = new Sequence();
        for (DatabaseMapping mapping : desc.getMappings()) {
            this.processMapping(mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        }
        if (extension != null) {
            extension.setSequence(seq);
        } else {
            ct.setSequence(seq);
        }
        return ct;
    }

    protected String getSchemaTypeForDirectMapping(XMLDirectMapping mapping, Schema workingSchema) {
        return this.getSchemaTypeForElement((XMLField)mapping.getField(), mapping.getAttributeClassification(), workingSchema);
    }

    protected String getSchemaTypeForElement(XMLField xmlField, Class attrClass, Schema workingSchema) {
        String schemaTypeString = null;
        QName schemaType = xmlField.getSchemaType();
        schemaTypeString = schemaType != null ? this.getSchemaTypeString(schemaType, workingSchema) : (attrClass != null && !attrClass.equals(ClassConstants.STRING) ? this.getSchemaTypeString((QName)XMLConversionManager.getDefaultJavaTypes().get(attrClass), workingSchema) : this.getSchemaTypeString(XMLConstants.STRING_QNAME, workingSchema));
        return schemaTypeString;
    }

    private XMLDescriptor getDescriptorByName(String javaClassName, java.util.List<XMLDescriptor> descriptors) {
        for (XMLDescriptor xDesc : descriptors) {
            if (!xDesc.getJavaClassName().equals(javaClassName)) continue;
            return xDesc;
        }
        return null;
    }

    private void processXMLDirectMapping(XMLDirectMapping mapping, Sequence seq, ComplexType ct, Schema workingSchema) {
        XPathFragment frag = ((XMLField)mapping.getField()).getXPathFragment();
        if (frag.isSelfFragment()) {
            return;
        }
        String schemaTypeString = this.getSchemaTypeForDirectMapping(mapping, workingSchema);
        if (frag.isAttribute()) {
            Attribute attr = this.buildAttribute(mapping, schemaTypeString);
            ct.getOrderedAttributes().add(attr);
        } else {
            Element elem = this.buildElement(frag, schemaTypeString, "0", null);
            seq.addElement(elem);
        }
    }

    private void processXMLCompositeDirectCollectionMapping(XMLCompositeDirectCollectionMapping mapping, Sequence seq, ComplexType ct, Schema workingSchema) {
        Element element;
        XMLField field = (XMLField)mapping.getField();
        String schemaTypeString = this.getSchemaTypeForElement(field, mapping.getAttributeElementClass(), workingSchema);
        if (field.usesSingleNode()) {
            SimpleType st = new SimpleType();
            List list = new List();
            if (schemaTypeString == null) {
                schemaTypeString = this.getSchemaTypeString(XMLConstants.ANY_SIMPLE_TYPE_QNAME, workingSchema);
            }
            list.setItemType(schemaTypeString);
            st.setList(list);
            element = this.buildElement(field.getXPathFragment(), null, "0", null);
            element.setSimpleType(st);
        } else {
            element = this.buildElement(field.getXPathFragment(), schemaTypeString, "0", null);
            element.setMaxOccurs("unbounded");
        }
        seq.addElement(element);
    }

    private void processXMLCompositeObjectMapping(XMLCompositeObjectMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        String refClassName = mapping.getReferenceClassName();
        XMLDescriptor refDesc = this.getDescriptorByName(refClassName, descriptors);
        if (refDesc == null) {
            throw DescriptorException.descriptorIsMissing(refClassName, mapping);
        }
        Element element = this.buildElement(((XMLField)mapping.getField()).getXPathFragment(), null, "0", null);
        ComplexType ctype = null;
        if (refDesc.getSchemaReference() == null) {
            ctype = this.buildComplexType(true, refDesc, schemaForNamespace, workingSchema, properties, descriptors);
        } else {
            element.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
        }
        XPathFragment frag = ((XMLField)mapping.getField()).getXPathFragment();
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
            String targetNS = workingSchema.getTargetNamespace();
            if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && !fragUri.equals(EMPTY_STRING)) {
                if (s.getTopLevelElements().get(frag.getShortName()) == null) {
                    Element globalElement = new Element();
                    globalElement.setName(frag.getLocalName());
                    if (ctype != null) {
                        globalElement.setComplexType(ctype);
                    } else {
                        globalElement.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
                    }
                    s.getTopLevelElements().put(frag.getShortName(), globalElement);
                }
                element = new Element();
                element.setMinOccurs("0");
                element.setRef(frag.getShortName());
            } else {
                element.setComplexType(ctype);
            }
        } else if (ctype != null) {
            element.setComplexType(ctype);
        }
        seq.addElement(element);
    }

    private void processXMLCompositeCollectionMapping(XMLCompositeCollectionMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        String refClassName = mapping.getReferenceClassName();
        XMLDescriptor refDesc = this.getDescriptorByName(refClassName, descriptors);
        if (refDesc == null) {
            throw DescriptorException.descriptorIsMissing(refClassName, mapping);
        }
        Element element = this.buildElement(((XMLField)mapping.getField()).getXPathFragment(), null, "0", "unbounded");
        ComplexType ctype = null;
        if (refDesc.getSchemaReference() == null) {
            ctype = this.buildComplexType(true, refDesc, schemaForNamespace, workingSchema, properties, descriptors);
        } else {
            element.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
        }
        XPathFragment frag = ((XMLField)mapping.getField()).getXPathFragment();
        String fragUri = frag.getNamespaceURI();
        if (fragUri != null) {
            Schema s = this.getSchema(fragUri, null, schemaForNamespace, properties);
            String targetNS = workingSchema.getTargetNamespace();
            if (s.isElementFormDefault() && !fragUri.equals(targetNS) || !s.isElementFormDefault() && !fragUri.equals(EMPTY_STRING)) {
                if (s.getTopLevelElements().get(frag.getShortName()) == null) {
                    Element globalElement = new Element();
                    globalElement.setName(frag.getLocalName());
                    if (ctype != null) {
                        globalElement.setComplexType(ctype);
                    } else {
                        globalElement.setType(this.getSchemaTypeString(refDesc.getSchemaReference().getSchemaContextAsQName(workingSchema.getNamespaceResolver()), workingSchema));
                    }
                    s.getTopLevelElements().put(frag.getShortName(), globalElement);
                }
                element = new Element();
                element.setMinOccurs("0");
                element.setMaxOccurs("unbounded");
                element.setRef(frag.getShortName());
            } else {
                element.setComplexType(ctype);
            }
        } else if (ctype != null) {
            element.setComplexType(ctype);
        }
        seq.addElement(element);
    }

    private void processMapping(DatabaseMapping mapping, Sequence seq, ComplexType ct, HashMap<String, Schema> schemaForNamespace, Schema workingSchema, SchemaModelGeneratorProperties properties, java.util.List<XMLDescriptor> descriptors) {
        if (mapping instanceof XMLDirectMapping) {
            this.processXMLDirectMapping((XMLDirectMapping)mapping, seq, ct, workingSchema);
        } else if (mapping instanceof XMLCompositeDirectCollectionMapping) {
            this.processXMLCompositeDirectCollectionMapping((XMLCompositeDirectCollectionMapping)mapping, seq, ct, workingSchema);
        } else if (mapping instanceof XMLCompositeObjectMapping) {
            this.processXMLCompositeObjectMapping((XMLCompositeObjectMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        } else if (mapping instanceof XMLCompositeCollectionMapping) {
            this.processXMLCompositeCollectionMapping((XMLCompositeCollectionMapping)mapping, seq, ct, schemaForNamespace, workingSchema, properties, descriptors);
        }
    }

    protected Attribute buildAttribute(XMLDirectMapping mapping, String schemaType) {
        XPathFragment frag = ((XMLField)mapping.getField()).getXPathFragment();
        Attribute attr = new Attribute();
        attr.setName(frag.getShortName());
        attr.setType(schemaType);
        return attr;
    }

    private Element buildElement(XPathFragment frag, String schemaType, String minOccurs, String maxOccurs) {
        Element element = new Element();
        element.setName(frag.getLocalName());
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(maxOccurs);
        if (schemaType != null) {
            element.setType(schemaType);
        }
        return element;
    }

    private Element buildElement(String name, String minOccurs, String maxOccurs) {
        Element element = new Element();
        element.setName(name);
        element.setMinOccurs(minOccurs);
        element.setMaxOccurs(maxOccurs);
        return element;
    }

    protected String getSchemaTypeString(QName schemaType, Schema workingSchema) {
        String schemaTypeString = schemaType.getLocalPart();
        String uri = schemaType.getNamespaceURI();
        String prefix = workingSchema.getNamespaceResolver().resolveNamespaceURI(uri);
        if (prefix == null && !uri.equals(workingSchema.getDefaultNamespace())) {
            prefix = uri.equals("http://www.w3.org/2001/XMLSchema") ? workingSchema.getNamespaceResolver().generatePrefix("xsd") : (uri.equals("http://www.w3.org/2001/XMLSchema-instance") ? workingSchema.getNamespaceResolver().generatePrefix("xsi") : workingSchema.getNamespaceResolver().generatePrefix());
            workingSchema.getNamespaceResolver().put(prefix, uri);
        }
        if (prefix != null) {
            schemaTypeString = prefix + COLON + schemaTypeString;
        }
        return schemaTypeString;
    }

    private void addNamespacesToWorkingSchema(NamespaceResolver nr, Schema workingSchema) {
        if (nr != null) {
            Vector descNamespaces = nr.getNamespaces();
            for (Namespace nextNamespace : descNamespaces) {
                workingSchema.getNamespaceResolver().put(nextNamespace.getPrefix(), nextNamespace.getNamespaceURI());
            }
        }
    }

    private Schema buildNewSchema(String uri, NamespaceResolver nr, int schemaCount, SchemaModelGeneratorProperties properties) {
        Properties props;
        Schema schema = new Schema();
        schema.setName(SCHEMA_FILE_NAME + schemaCount + SCHEMA_FILE_EXT);
        ++schemaCount;
        String defaultNamespace = null;
        if (nr != null && (defaultNamespace = nr.getDefaultNamespaceURI()) != null) {
            schema.setDefaultNamespace(defaultNamespace);
            schema.getNamespaceResolver().setDefaultNamespaceURI(defaultNamespace);
        }
        if (!uri.equals(EMPTY_STRING)) {
            schema.setTargetNamespace(uri);
            String prefix = null;
            if (nr != null) {
                prefix = nr.resolveNamespaceURI(uri);
            }
            if (prefix == null && !uri.equals(defaultNamespace)) {
                prefix = schema.getNamespaceResolver().generatePrefix();
                schema.getNamespaceResolver().put(prefix, uri);
            }
        }
        if ((props = properties.getProperties(uri)) != null) {
            if (props.containsKey("elementFormQualified")) {
                schema.setElementFormDefault((Boolean)props.get("elementFormQualified"));
            }
            if (props.containsKey("attributeFormQualified")) {
                schema.setAttributeFormDefault((Boolean)props.get("attributeFormQualified"));
            }
        }
        return schema;
    }

    private boolean importExists(Schema schema, String schemaName) {
        java.util.List imports = schema.getImports();
        for (Import nextImport : imports) {
            if (nextImport.getSchemaLocation() == null || !nextImport.getSchemaLocation().equals(schemaName)) continue;
            return true;
        }
        return false;
    }

    protected QName getDefaultRootElementAsQName(XMLDescriptor desc, String qualifiedTableName) {
        QName qName = null;
        NamespaceResolver nsResolver = desc.getNamespaceResolver();
        int idx = qualifiedTableName.indexOf(COLON);
        String localName = qualifiedTableName.substring(idx + 1);
        if (idx > -1) {
            String prefix = qualifiedTableName.substring(0, idx);
            String uri = nsResolver.resolveNamespacePrefix(prefix);
            qName = new QName(uri, localName);
        } else {
            qName = nsResolver.getDefaultNamespaceURI() != null ? new QName(nsResolver.getDefaultNamespaceURI(), localName) : new QName(localName);
        }
        return qName;
    }
}

