/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractValidatingDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.events.AWTChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeNotifier;
import org.eclipse.persistence.tools.workbench.utility.node.AbstractNodeModel;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class NewNameDialog
extends AbstractValidatingDialog {
    private Builder builder;
    private JLabel textFieldLabel;
    protected JTextField textField;
    private PropertyValueModel subjectHolder;

    protected NewNameDialog(WorkbenchContext context, Builder builder) {
        super(context, builder.getTitle());
        this.builder = builder;
    }

    protected void initialize() {
        super.initialize();
        this.subjectHolder = new SimplePropertyValueModel();
    }

    protected Component buildMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.textFieldLabel = new JLabel();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 0, 5, 0);
        mainPanel.add((Component)this.textFieldLabel, constraints);
        this.textField = new JTextField(25);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 0, 5, 0);
        mainPanel.add((Component)this.textField, constraints);
        this.textFieldLabel.setText(this.builder.getTextFieldDescription());
        Document document = this.buildDocument(this.builder.getOriginalName());
        document.addDocumentListener(this.buildDocumentListener());
        this.textField.setDocument(document);
        this.textField.selectAll();
        if (this.textField.getText().length() == 0) {
            this.getOKAction().setEnabled(false);
        }
        this.helpManager().addTopicID(mainPanel, this.helpTopicId());
        return mainPanel;
    }

    protected Builder getBuilder() {
        return this.builder;
    }

    protected Document buildDocument(String originalName) {
        Document document = this.buildDocument();
        try {
            document.insertString(0, originalName, null);
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
        return document;
    }

    protected Document buildDocument() {
        return this.builder.getDocumentFactory().buildDocument();
    }

    protected Document buildDocumentWithStateObject() {
        return new DocumentAdapter(this.buildNameHolder(), this.builder.getDocumentFactory().buildDocument());
    }

    protected final PropertyValueModel buildNameHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "name"){

            protected Object getValueFromSubject() {
                return ((StateObject)((Object)this.subject)).getName();
            }

            protected void setValueOnSubject(Object value) {
                ((StateObject)((Object)this.subject)).setName((String)value);
            }
        };
    }

    protected DocumentListener buildDocumentListener() {
        return new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                NewNameDialog.this.documentChanged();
            }

            public void insertUpdate(DocumentEvent e) {
                NewNameDialog.this.documentChanged();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    protected String helpTopicId() {
        return this.builder.getHelpTopicId();
    }

    protected Component initialFocusComponent() {
        return this.textField;
    }

    protected Builder builder() {
        return this.builder;
    }

    protected void documentChanged() {
        if (this.isVisible()) {
            this.editName();
        }
    }

    protected void editName() {
        String text = this.textField.getText();
        if (this.builder.emptyNameIsIllegal() && text.length() == 0) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.EMPTY_VALUE");
            return;
        }
        boolean nameIsSameAsOriginal = this.namesMatch(text, this.builder.getOriginalName());
        if (this.builder.originalNameIsIllegal() && nameIsSameAsOriginal) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ORIGINAL_VALUE");
            return;
        }
        if (this.nameIsAlreadyTaken(text, nameIsSameAsOriginal)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.DUPLICATE_VALUE");
            return;
        }
        if (this.nameIsIllegal(text)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ILLEGAL_VALUE");
            return;
        }
        this.clearErrorMessage();
    }

    protected void setErrorMessageKey(String key) {
        super.setErrorMessageKey(key);
        this.getOKAction().setEnabled(false);
    }

    protected void clearErrorMessage() {
        super.clearErrorMessage();
        this.getOKAction().setEnabled(true);
    }

    protected boolean namesMatch(String name1, String name2) {
        return this.builder.comparisonIsCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
    }

    protected boolean nameIsAlreadyTaken(String name, boolean nameIsSameAsOriginal) {
        Iterator stream = this.builder.existingNames();
        while (stream.hasNext()) {
            if (!this.namesMatch(name, (String)stream.next()) || nameIsSameAsOriginal) continue;
            return true;
        }
        return false;
    }

    protected boolean nameIsIllegal(String name) {
        Iterator stream = this.builder.illegalNames();
        while (stream.hasNext()) {
            if (!this.namesMatch(name, (String)stream.next())) continue;
            return true;
        }
        return false;
    }

    public String getNewName() {
        if (this.wasConfirmed()) {
            return this.textField.getText();
        }
        throw new IllegalStateException("dialog was not confirmed");
    }

    protected final ValueModel getSubjectHolder() {
        return this.subjectHolder;
    }

    protected StateObject buildStateObject() {
        return null;
    }

    public void show() {
        this.installSubject();
        super.show();
    }

    private void installSubject() {
        StateObject subject = this.buildStateObject();
        if (subject != null) {
            subject.setValidator(this.buildValidator());
            subject.setChangeNotifier(AWTChangeNotifier.instance());
        }
        this.subjectHolder.setValue((Object)subject);
    }

    public StateObject subject() {
        return (StateObject)((Object)this.subjectHolder.getValue());
    }

    Node.Validator buildValidator() {
        return Node.NULL_VALIDATOR;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StateObject
    extends AbstractNodeModel {
        private Builder builder;
        private ChangeNotifier changeNotifier;
        private String name;
        private Node.Validator validator;
        public static final String NAME_PROPERTY = "name";

        protected StateObject(Builder builder) {
            this.builder = builder;
            this.name = builder.getOriginalName();
            if (this.name == null) {
                this.name = "";
            }
        }

        protected void addProblemsTo(List currentProblems) {
            super.addProblemsTo(currentProblems);
            this.editName(currentProblems);
        }

        public String displayString() {
            return this.name;
        }

        protected void editName(List<Problem> currentProblems) {
            String text = this.name;
            if (StringTools.stringIsEmpty((String)text)) {
                currentProblems.add(this.buildProblem("NEW_NAME_DIALOG.EMPTY_VALUE"));
                return;
            }
            boolean nameIsSameAsOriginal = this.namesMatch(text, this.builder.getOriginalName());
            if (this.builder.originalNameIsIllegal() && nameIsSameAsOriginal) {
                currentProblems.add(this.buildProblem("NEW_NAME_DIALOG.ORIGINAL_VALUE"));
                return;
            }
            if (this.nameIsAlreadyTaken(text, nameIsSameAsOriginal)) {
                currentProblems.add(this.buildProblem("NEW_NAME_DIALOG.DUPLICATE_VALUE"));
                return;
            }
            if (this.nameIsIllegal(text)) {
                currentProblems.add(this.buildProblem("NEW_NAME_DIALOG.ILLEGAL_VALUE"));
                return;
            }
        }

        public ChangeNotifier getChangeNotifier() {
            return this.changeNotifier;
        }

        public String getName() {
            return this.name;
        }

        public Node.Validator getValidator() {
            return this.validator;
        }

        protected boolean nameIsAlreadyTaken(String name, boolean nameIsSameAsOriginal) {
            Iterator stream = this.builder.existingNames();
            while (stream.hasNext()) {
                if (!this.namesMatch(name, (String)stream.next()) || nameIsSameAsOriginal) continue;
                return true;
            }
            return false;
        }

        protected boolean nameIsIllegal(String name) {
            Iterator stream = this.builder.illegalNames();
            while (stream.hasNext()) {
                if (!this.namesMatch(name, (String)stream.next())) continue;
                return true;
            }
            return false;
        }

        protected boolean namesMatch(String name1, String name2) {
            return this.builder.comparisonIsCaseSensitive() ? name1.equals(name2) : name1.equalsIgnoreCase(name2);
        }

        public void setChangeNotifier(ChangeNotifier changeNotifier) {
            this.changeNotifier = changeNotifier;
        }

        public void setName(String name) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChanged(NAME_PROPERTY, oldName, name);
        }

        public void setValidator(Node.Validator validator) {
            this.validator = validator;
        }
    }

    public static interface DocumentFactory {
        public Document buildDocument();
    }

    public static class Builder
    implements Cloneable {
        private String title;
        private String textFieldDescription;
        private String originalName;
        private boolean emptyNameIsLegal;
        private boolean originalNameIsLegal;
        private ArrayList existingNames;
        private ArrayList illegalNames;
        private boolean comparisonIsCaseSensitive;
        private DocumentFactory documentFactory;
        private String helpTopicId;

        public Builder() {
            this.initialize();
        }

        protected void initialize() {
            this.title = null;
            this.textFieldDescription = null;
            this.originalName = null;
            this.emptyNameIsLegal = false;
            this.originalNameIsLegal = true;
            this.existingNames = new ArrayList();
            this.illegalNames = new ArrayList();
            this.comparisonIsCaseSensitive = false;
            this.documentFactory = this.buildDefaultDocumentFactory();
            this.helpTopicId = "dialog.newName";
        }

        public NewNameDialog buildDialog(WorkbenchContext context) {
            return this.buildDialog(context, (Builder)this.clone());
        }

        protected Object clone() {
            Builder clone;
            try {
                clone = (Builder)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
            clone.existingNames = (ArrayList)this.existingNames.clone();
            clone.illegalNames = (ArrayList)this.illegalNames.clone();
            return clone;
        }

        protected NewNameDialog buildDialog(WorkbenchContext context, Builder clone) {
            return new NewNameDialog(context, clone);
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTextFieldDescription(String textFieldDescription) {
            this.textFieldDescription = textFieldDescription;
        }

        public String getTextFieldDescription() {
            return this.textFieldDescription;
        }

        public void setOriginalName(String originalName) {
            this.originalName = originalName;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public void setEmptyNameIsLegal(boolean emptyNameIsLegal) {
            this.emptyNameIsLegal = emptyNameIsLegal;
        }

        public boolean emptyNameIsLegal() {
            return this.emptyNameIsLegal;
        }

        public boolean emptyNameIsIllegal() {
            return !this.emptyNameIsLegal;
        }

        public void setOriginalNameIsLegal(boolean originalNameIsLegal) {
            this.originalNameIsLegal = originalNameIsLegal;
        }

        public boolean originalNameIsLegal() {
            return this.originalNameIsLegal;
        }

        public boolean originalNameIsIllegal() {
            return !this.originalNameIsLegal;
        }

        public void setExistingNames(Collection existingNames) {
            this.setExistingNames(existingNames.iterator());
        }

        public void setExistingNames(Iterator existingNames) {
            this.existingNames.clear();
            this.addExistingNames(existingNames);
        }

        public void addExistingNames(Collection names) {
            this.addExistingNames(names.iterator());
        }

        public void addExistingNames(Iterator names) {
            while (names.hasNext()) {
                this.existingNames.add(names.next());
            }
        }

        public Iterator existingNames() {
            return this.existingNames.iterator();
        }

        public void setIllegalNames(Collection illegalNames) {
            this.setIllegalNames(illegalNames.iterator());
        }

        public void setIllegalNames(Iterator illegalNames) {
            this.illegalNames.clear();
            this.addIllegalNames(illegalNames);
        }

        public void addIllegalNames(Collection names) {
            this.addIllegalNames(names.iterator());
        }

        public void addIllegalNames(Iterator names) {
            while (names.hasNext()) {
                this.illegalNames.add(names.next());
            }
        }

        public Iterator illegalNames() {
            return this.illegalNames.iterator();
        }

        public void setComparisonIsCaseSensitive(boolean comparisonIsCaseSensitive) {
            this.comparisonIsCaseSensitive = comparisonIsCaseSensitive;
        }

        public boolean comparisonIsCaseSensitive() {
            return this.comparisonIsCaseSensitive;
        }

        public void setDocumentFactory(DocumentFactory documentFactory) {
            this.documentFactory = documentFactory;
        }

        public DocumentFactory getDocumentFactory() {
            return this.documentFactory;
        }

        protected DocumentFactory buildDefaultDocumentFactory() {
            return new DocumentFactory(){

                public Document buildDocument() {
                    return new PlainDocument();
                }
            };
        }

        public String getHelpTopicId() {
            return this.helpTopicId;
        }

        public void setHelpTopicId(String helpTopidId) {
            this.helpTopicId = helpTopidId;
        }
    }
}

