/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.border.CompoundBorder;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.app.EditorNode;
import org.eclipse.persistence.tools.workbench.framework.context.DefaultWorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.swing.LabelPanel;

public abstract class AbstractPropertiesPage
extends AbstractPanel {
    private PropertyValueModel nodeHolder;
    private PropertyValueModel selectionHolder;

    protected AbstractPropertiesPage(WorkbenchContext context) {
        this(new SimplePropertyValueModel(), (WorkbenchContextHolder)new DefaultWorkbenchContextHolder(context));
    }

    protected AbstractPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder) {
        this(nodeHolder, contextHolder, new BorderLayout());
    }

    protected AbstractPropertiesPage(PropertyValueModel nodeHolder, WorkbenchContextHolder contextHolder, LayoutManager layoutManager) {
        super(layoutManager, contextHolder);
        this.initialize(nodeHolder);
        this.initializeLayout();
    }

    protected void initialize(PropertyValueModel selectionNodeHolder) {
        if (selectionNodeHolder == null) {
            throw new NullPointerException();
        }
        this.nodeHolder = selectionNodeHolder;
        this.selectionHolder = this.buildSelectionHolder();
    }

    protected PropertyValueModel buildSelectionHolder() {
        return new TransformationPropertyValueModel(this.nodeHolder){

            protected Object transform(Object value) {
                return value == null ? null : ((ApplicationNode)value).getValue();
            }

            protected Object reverseTransform(Object value) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected abstract void initializeLayout();

    protected PropertyValueModel getNodeHolder() {
        return this.nodeHolder;
    }

    protected ApplicationNode getNode() {
        return (ApplicationNode)this.nodeHolder.getValue();
    }

    public void setNode(ApplicationNode node, WorkbenchContext context) {
        this.getDefaultWorkbenchContextHolder().setWorkbenchContext(context);
        this.nodeHolder.setValue(node);
    }

    private DefaultWorkbenchContextHolder getDefaultWorkbenchContextHolder() {
        return (DefaultWorkbenchContextHolder)this.getWorkbenchContextHolder();
    }

    protected PropertyValueModel getSelectionHolder() {
        return this.selectionHolder;
    }

    protected Object selection() {
        return this.getSelectionHolder().getValue();
    }

    protected PropertyValueModel buildPropertiesPageIconAdapter() {
        return new PropertyAspectAdapter(this.nodeHolder, "propertiesPageTitleIcon"){

            protected Object getValueFromSubject() {
                return ((EditorNode)this.subject).propertiesPageTitleIcon();
            }
        };
    }

    protected PropertyValueModel buildPropertiesPageTitleAdapter() {
        return new PropertyAspectAdapter(this.nodeHolder, "propertiesPageTitleText"){

            protected Object getValueFromSubject() {
                return ((EditorNode)this.subject).propertiesPageTitleText();
            }
        };
    }

    protected Component buildTitlePanel() {
        LabelPanel titlePanel = new LabelPanel(this.buildPropertiesPageIconAdapter(), this.buildPropertiesPageTitleAdapter());
        CompoundBorder innerBorder = new CompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        CompoundBorder outerBorder = new CompoundBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), innerBorder);
        titlePanel.setBorder(outerBorder);
        return titlePanel;
    }
}

