/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQueryManager;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public final class RelationalCustomSqlPropertiesPage
extends ScrollablePropertiesPage {
    private PropertyValueModel queryManagerHolder;

    public RelationalCustomSqlPropertiesPage(PropertyValueModel relationalDescriptorNodeHolder, WorkbenchContextHolder contextHolder) {
        super(relationalDescriptorNodeHolder, contextHolder);
    }

    protected void initialize(PropertyValueModel nodeHolder) {
        super.initialize(nodeHolder);
        this.queryManagerHolder = this.buildQueryManagerHolder();
    }

    private PropertyValueModel buildQueryManagerHolder() {
        return new PropertyAspectAdapter(this.getSelectionHolder()){

            protected Object getValueFromSubject() {
                return ((MWTableDescriptor)this.subject).getQueryManager();
            }
        };
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.customSQL";
    }

    protected Component buildPage() {
        this.setName("Queries");
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JTabbedPane sqlStringTabbedPane = new JTabbedPane();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 5, 5);
        panel.add((Component)sqlStringTabbedPane, constraints);
        JTextArea insertSQLStringTextArea = this.buildInsertSqlTextArea();
        JScrollPane insertSQLStringScrollPane = new JScrollPane(insertSQLStringTextArea);
        insertSQLStringScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), insertSQLStringScrollPane.getBorder()));
        this.addHelpTopicId(insertSQLStringScrollPane, this.helpTopicId() + ".insert");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_INSERT_TAB"), insertSQLStringScrollPane);
        JTextArea updateSQLStringTextArea = this.buildUpdateSqlTextArea();
        JScrollPane updateSQLStingScrollPane = new JScrollPane(updateSQLStringTextArea);
        updateSQLStingScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), updateSQLStingScrollPane.getBorder()));
        this.addHelpTopicId(updateSQLStingScrollPane, this.helpTopicId() + ".update");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_UPDATE_TAB"), updateSQLStingScrollPane);
        JTextArea deleteSQLStringTextArea = this.buildDeleteSqlTextArea();
        JScrollPane deleteSQLStingScrollPane = new JScrollPane(deleteSQLStringTextArea);
        deleteSQLStingScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), deleteSQLStingScrollPane.getBorder()));
        this.addHelpTopicId(deleteSQLStingScrollPane, this.helpTopicId() + ".delete");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_DELETE_TAB"), deleteSQLStingScrollPane);
        JTextArea readObjectSQLStringTextArea = this.buildReadObjectSqlTextArea();
        JScrollPane readObjectSQLStingScrollPane = new JScrollPane(readObjectSQLStringTextArea);
        readObjectSQLStingScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), readObjectSQLStingScrollPane.getBorder()));
        this.addHelpTopicId(readObjectSQLStingScrollPane, this.helpTopicId() + ".readObject");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_READ_OBJECT_TAB"), readObjectSQLStingScrollPane);
        JTextArea readAllSQLStringTextArea = this.buildReadAllSqlTextArea();
        JScrollPane readAllSQLStingScrollPane = new JScrollPane(readAllSQLStringTextArea);
        readAllSQLStingScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), readAllSQLStingScrollPane.getBorder()));
        this.addHelpTopicId(readAllSQLStingScrollPane, this.helpTopicId() + ".readAll");
        sqlStringTabbedPane.addTab(this.resourceRepository().getString("CUSTOM_SQL_READ_ALL_TAB"), readAllSQLStingScrollPane);
        this.addHelpTopicId(panel, this.helpTopicId());
        return panel;
    }

    private JTextArea buildTextArea(PropertyValueModel stringHolder) {
        JTextArea textArea = new JTextArea(new DocumentAdapter(stringHolder));
        textArea.setFont(new Font("dialog", 0, 12));
        return textArea;
    }

    private JTextArea buildInsertSqlTextArea() {
        return this.buildTextArea(this.buildInsertSqlHolder());
    }

    private PropertyValueModel buildInsertSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "insertSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getInsertSQLString();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setInsertSQLString((String)value);
            }
        };
    }

    private JTextArea buildUpdateSqlTextArea() {
        return this.buildTextArea(this.buildUpdateSqlHolder());
    }

    private PropertyValueModel buildUpdateSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "updateSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getUpdateSQLString();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setUpdateSQLString((String)value);
            }
        };
    }

    private JTextArea buildDeleteSqlTextArea() {
        return this.buildTextArea(this.buildDeleteSqlHolder());
    }

    private PropertyValueModel buildDeleteSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "deleteSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getDeleteSQLString();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setDeleteSQLString((String)value);
            }
        };
    }

    private JTextArea buildReadObjectSqlTextArea() {
        return this.buildTextArea(this.buildReadObjectSqlHolder());
    }

    private PropertyValueModel buildReadObjectSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readObjectSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadObjectSQLString();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setReadObjectSQLString((String)value);
            }
        };
    }

    private JTextArea buildReadAllSqlTextArea() {
        return this.buildTextArea(this.buildReadAllSqlHolder());
    }

    private PropertyValueModel buildReadAllSqlHolder() {
        return new PropertyAspectAdapter(this.queryManagerHolder, "readAllSQLString"){

            protected Object getValueFromSubject() {
                return ((MWRelationalQueryManager)this.subject).getReadAllSQLString();
            }

            protected void setValueOnSubject(Object value) {
                ((MWRelationalQueryManager)this.subject).setReadAllSQLString((String)value);
            }
        };
    }
}

