/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionMultipleProjectsPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.ProjectTypeEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class SessionMultipleProjectsPane
extends AbstractSessionMultipleProjectsPane {
    SessionMultipleProjectsPane(ValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    protected void addProject(ObjectListSelectionModel selectionModel) {
        DatabaseSessionAdapter session = (DatabaseSessionAdapter)this.subject();
        ProjectType projectType = new ProjectType(session, selectionModel);
        ProjectTypeEditDialog dialog = new ProjectTypeEditDialog(this.getWorkbenchContext(), this.resourceRepository().getString("PROJECT_TYPE_EDIT_DIALOG_TITLE_ADD"), session, projectType, "session.project.advanced");
        dialog.setVisible(true);
    }

    private class ProjectType
    extends AbstractModel
    implements ProjectTypeEditDialog.ProjectTypeUpdater {
        private DatabaseSessionAdapter databaseSession;
        private String projectName;
        private final ObjectListSelectionModel selectionModel;
        public static final String PROJECT_CLASS_PROPERTY = "projectClass";
        public static final String PROJECT_XML_PROPERTY = "projectXml";
        public static final String PROJECT_TYPE_XML_PROPERTY = "projectTypeXml";

        public ProjectType(DatabaseSessionAdapter databaseSession, ObjectListSelectionModel selectionModel) {
            this.selectionModel = selectionModel;
            this.databaseSession = databaseSession;
        }

        public void apply(boolean projectTypeXml, String projectName) {
            if (projectName == null) {
                ProjectAdapter project = (ProjectAdapter)((Object)this.selectionModel.getSelectedValue());
                this.databaseSession.removeProject(project);
            } else if (projectTypeXml) {
                if (CollectionTools.contains((Iterator)this.databaseSession.additionalProjectNames(), (Object)projectName)) {
                    ProjectAdapter project = this.databaseSession.projectNamed(projectName);
                    this.selectionModel.setSelectedValue((Object)project);
                } else {
                    this.databaseSession.addProjectXmlNamed(projectName);
                }
            } else {
                this.databaseSession.addProjectClassNamed(projectName);
            }
        }

        public String getProjectName() {
            return this.projectName;
        }

        public boolean isProjectXml() {
            return true;
        }
    }
}

