/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;

public class MetadataMethod
extends MetadataAnnotatedElement {
    public static final String IS_PROPERTY_METHOD_PREFIX = "is";
    public static final String GET_PROPERTY_METHOD_PREFIX = "get";
    private static final String SET_PROPERTY_METHOD_PREFIX = "set";
    private static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    private static final int POSITION_AFTER_IS_PREFIX = "is".length();
    private static final int POSITION_AFTER_GET_PREFIX = "get".length();
    protected Method m_getMethod;
    protected Method m_setMethod;

    public MetadataMethod(Method getMethod, Class declaringClass) {
        super(getMethod);
        this.init(getMethod, declaringClass);
    }

    public MetadataMethod(Method getMethod, MetadataLogger logger) {
        super((AnnotatedElement)getMethod, logger);
        this.init(getMethod, getMethod.getDeclaringClass());
    }

    public MetadataMethod(Method getMethod, Method setMethod, String attributeName, XMLEntityMappings entityMappings) {
        super((AnnotatedElement)getMethod, entityMappings);
        this.m_getMethod = getMethod;
        this.m_setMethod = setMethod;
        this.setName(getMethod.getName());
        this.setAttributeName(attributeName);
        this.setRelationType(getMethod.getGenericReturnType());
    }

    public MetadataMethod(Method getMethod, XMLEntityMappings entityMappings) {
        super((AnnotatedElement)getMethod, entityMappings);
        this.init(getMethod, getMethod.getDeclaringClass());
    }

    public static String getAttributeNameFromMethodName(String methodName) {
        String leadingChar = "";
        String restOfName = methodName;
        if (methodName.equals(GET_PROPERTY_METHOD_PREFIX) || methodName.equals(IS_PROPERTY_METHOD_PREFIX)) {
            return "";
        }
        if (methodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_GET_PREFIX, POSITION_AFTER_GET_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_GET_PREFIX + 1);
        } else if (methodName.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_IS_PREFIX, POSITION_AFTER_IS_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_IS_PREFIX + 1);
        }
        return leadingChar.toLowerCase().concat(restOfName);
    }

    protected Method getMethod() {
        return (Method)this.getAnnotatedElement();
    }

    public Method getSetMethod() {
        return this.m_setMethod;
    }

    public Method getSetMethod(Method method, Class cls) {
        String getMethodName = method.getName();
        Class[] params = new Class[]{method.getReturnType()};
        if (getMethodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            return this.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(3), cls, params);
        }
        Method setMethod = this.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        if (setMethod == null) {
            return this.getMethod(SET_IS_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        }
        return setMethod;
    }

    protected Method getMethod(String methodName, Class cls, Class[] params) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedGetMethod(cls, methodName, params, true));
                }
                catch (PrivilegedActionException exception) {
                    return null;
                }
            }
            return PrivilegedAccessHelper.getMethod(cls, methodName, params, true);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    public String getSetMethodName() {
        return this.m_setMethod.getName();
    }

    public boolean hasAttributeName() {
        return !this.getAttributeName().equals("");
    }

    public boolean hasParameters() {
        return this.m_getMethod.getParameterTypes().length > 0;
    }

    public boolean hasSetMethod() {
        return this.m_setMethod != null;
    }

    protected void init(Method getMethod, Class declaringClass) {
        this.m_getMethod = getMethod;
        this.m_setMethod = this.getSetMethod(getMethod, declaringClass);
        this.setName(getMethod.getName());
        this.setAttributeName(MetadataMethod.getAttributeNameFromMethodName(getMethod.getName()));
        this.setRelationType(getMethod.getGenericReturnType());
    }

    protected boolean isALifeCycleCallbackMethod() {
        return this.isAnnotationPresent(PostLoad.class) || this.isAnnotationPresent(PostPersist.class) || this.isAnnotationPresent(PostRemove.class) || this.isAnnotationPresent(PostUpdate.class) || this.isAnnotationPresent(PrePersist.class) || this.isAnnotationPresent(PreRemove.class) || this.isAnnotationPresent(PreUpdate.class);
    }

    protected boolean isValidPersistenceMethod() {
        return this.isValidPersistenceMethodName() && !this.hasParameters() && this.hasSetMethod();
    }

    public boolean isValidPersistenceMethod(boolean mustBeExplicit, MetadataDescriptor descriptor) {
        if (this.isValidPersistenceElement(mustBeExplicit, "PROPERTY", descriptor)) {
            return !this.isALifeCycleCallbackMethod() && this.isValidPersistenceMethod(descriptor, this.hasDeclaredAnnotations(descriptor));
        }
        return false;
    }

    public boolean isValidPersistenceMethod(MetadataDescriptor descriptor, boolean userDecorated) {
        if (!this.isValidPersistenceElement(this.getMethod().getModifiers()) || !this.isValidPersistenceMethod()) {
            if (userDecorated) {
                if (this.hasParameters()) {
                    throw ValidationException.mappingMetadataAppliedToMethodWithArguments(this.getMethod(), descriptor.getJavaClass());
                }
                if (!this.hasSetMethod()) {
                    throw ValidationException.noCorrespondingSetterMethodDefined(descriptor.getJavaClass(), this.getMethod());
                }
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapping_metadata", this, descriptor.getJavaClass());
            }
            return false;
        }
        return true;
    }

    public boolean isValidPersistenceMethodName() {
        return (this.getName().startsWith(GET_PROPERTY_METHOD_PREFIX) || this.getName().startsWith(IS_PROPERTY_METHOD_PREFIX)) && this.hasAttributeName();
    }
}

