/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.ConversionValueMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.converters.TypeConverterMetadata;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectTypeConverterMetadata
extends TypeConverterMetadata {
    private List<ConversionValueMetadata> m_conversionValues = new ArrayList<ConversionValueMetadata>();
    private String m_defaultObjectValue;

    public ObjectTypeConverterMetadata() {
        super("<object-type-converter>");
    }

    public ObjectTypeConverterMetadata(Annotation objectTypeConverter, MetadataAccessibleObject accessibleObject) {
        super(objectTypeConverter, accessibleObject);
        for (Annotation conversionValue : (Annotation[])MetadataHelper.invokeMethod("conversionValues", objectTypeConverter)) {
            this.m_conversionValues.add(new ConversionValueMetadata(conversionValue, accessibleObject));
        }
        this.m_defaultObjectValue = (String)MetadataHelper.invokeMethod("defaultObjectValue", objectTypeConverter);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ObjectTypeConverterMetadata) {
            ObjectTypeConverterMetadata objectTypeConverter = (ObjectTypeConverterMetadata)objectToCompare;
            if (!this.valuesMatch(this.getName(), objectTypeConverter.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.getDataType(), objectTypeConverter.getDataType())) {
                return false;
            }
            if (!this.valuesMatch(this.getObjectType(), objectTypeConverter.getObjectType())) {
                return false;
            }
            if (!this.valuesMatch(this.m_conversionValues, objectTypeConverter.getConversionValues())) {
                return false;
            }
            return this.valuesMatch(this.m_defaultObjectValue, objectTypeConverter.getDefaultObjectValue());
        }
        return false;
    }

    public List<ConversionValueMetadata> getConversionValues() {
        return this.m_conversionValues;
    }

    public String getDefaultObjectValue() {
        return this.m_defaultObjectValue;
    }

    public boolean hasConversionValues() {
        return !this.m_conversionValues.isEmpty();
    }

    private Object initObject(Class type, String value, DirectAccessor accessor, boolean isData) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(type, new Class[]{String.class}, false));
                return AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{value}));
            }
            catch (PrivilegedActionException exception) {
                this.throwInitObjectException(exception, type, value, isData);
            }
        } else {
            try {
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor(type, new Class[]{String.class}, false);
                return PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{value});
            }
            catch (Exception exception) {
                this.throwInitObjectException(exception, type, value, isData);
            }
        }
        return null;
    }

    @Override
    public void process(DatabaseMapping mapping, DirectAccessor accessor) {
        ObjectTypeConverter converter;
        Class dataType = this.getDataType(accessor);
        Class<String> objectType = this.getObjectType(accessor);
        if (objectType.isEnum()) {
            converter = new EnumTypeConverter(mapping, objectType.getName());
            objectType = String.class;
        } else {
            converter = new ObjectTypeConverter(mapping);
        }
        HashMap<String, String> dataToObjectValues = new HashMap<String, String>();
        HashMap<String, String> objectToDataValues = new HashMap<String, String>();
        if (this.hasConversionValues()) {
            for (ConversionValueMetadata conversionValue : this.getConversionValues()) {
                String dataValue = conversionValue.getDataValue();
                String objectValue = conversionValue.getObjectValue();
                if (dataToObjectValues.containsKey(dataValue)) {
                    throw ValidationException.multipleObjectValuesForDataValue(accessor.getJavaClass(), this.getName(), dataValue);
                }
                dataToObjectValues.put(dataValue, objectValue);
                if (objectToDataValues.containsKey(objectValue)) continue;
                objectToDataValues.put(objectValue, dataValue);
            }
        }
        for (String dataValue : dataToObjectValues.keySet()) {
            String objectValue = (String)dataToObjectValues.get(dataValue);
            Object data = this.initObject(dataType, dataValue, accessor, true);
            Object object = this.initObject(objectType, objectValue, accessor, false);
            if (objectToDataValues.containsKey(objectValue)) {
                converter.addConversionValue(data, object);
                continue;
            }
            converter.addToAttributeOnlyConversionValue(data, object);
        }
        if (this.m_defaultObjectValue != null && !this.m_defaultObjectValue.equals("")) {
            converter.setDefaultAttributeValue(this.initObject(objectType, this.m_defaultObjectValue, accessor, false));
        }
        accessor.setConverter(mapping, converter);
    }

    public void setConversionValues(List<ConversionValueMetadata> conversionValues) {
        this.m_conversionValues = conversionValues;
    }

    public void setDefaultObjectValue(String defaultObjectValue) {
        this.m_defaultObjectValue = defaultObjectValue;
    }

    protected void throwInitObjectException(Exception exception, Class type, String value, boolean isData) {
        if (isData) {
            throw ValidationException.errorInstantiatingConversionValueData(this.getName(), value, type, exception);
        }
        throw ValidationException.errorInstantiatingConversionValueObject(this.getName(), value, type, exception);
    }
}

