/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.ClassBuffer;
import org.eclipse.persistence.sdo.helper.CodeWriter;
import org.eclipse.persistence.sdo.helper.DefaultSchemaResolver;
import org.eclipse.persistence.sdo.helper.FileCodeWriter;
import org.eclipse.persistence.sdo.helper.SDOClassGeneratorListener;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOTypesGenerator;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class SDOClassGenerator {
    private String indent = "";
    private static int INDENT_TAB = 3;
    private static final String lsep = System.getProperty("line.separator");
    private static final String lsep2 = lsep + lsep;
    private static final String START_PROPERTY_INDEX = "START_PROPERTY_INDEX";
    private Map generatedBuffers;
    private boolean generateInterfaces = true;
    private CodeWriter codeWriter;
    private SDOClassGeneratorListener sdoClassGeneratorListener;
    private HelperContext aHelperContext;

    public SDOClassGenerator() {
        this(new SDOHelperContext());
    }

    public SDOClassGenerator(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.generatedBuffers = new HashMap();
    }

    public static void main(String[] args) {
        SDOClassGenerator generator = new SDOClassGenerator(new SDOHelperContext());
        String sourceDir = null;
        String sourceFile = null;
        int argsLength = args.length;
        AbstractSessionLog.getLog().setLevel(2);
        for (int i = 0; i < argsLength; ++i) {
            if (args[i].equals("-help")) {
                generator.printUsage(null);
                System.exit(0);
            }
            if (args[i].equals("-sourceFile")) {
                if (i == argsLength - 1) {
                    generator.printUsage("sdo_classgenerator_usage_missing_sourcefile_value");
                    System.exit(0);
                }
                sourceFile = args[++i];
            }
            if (args[i].equals("-targetDirectory")) {
                if (i == argsLength - 1) {
                    generator.printUsage("sdo_classgenerator_usage_missing_targetdir");
                    System.exit(0);
                }
                sourceDir = args[++i];
            }
            if (!args[i].equals("-logLevel") || i == argsLength - 1) continue;
            AbstractSessionLog.getLog().setLevel(Integer.parseInt(args[++i]));
        }
        if (null == sourceFile) {
            generator.printUsage("sdo_classgenerator_usage_missing_sourcefile");
            System.exit(0);
        }
        try {
            FileReader reader = new FileReader(sourceFile);
            FileCodeWriter fileCodeWriter = new FileCodeWriter();
            fileCodeWriter.setSourceDir(sourceDir);
            generator.generate((Reader)reader, (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(7, "sdo_classgenerator_exception", e.getClass().getName(), e.getLocalizedMessage(), generator.getClass());
            AbstractSessionLog.getLog().logThrowable(7, e);
        }
    }

    private void printUsage(String messageID) {
        if (null != messageID) {
            System.out.println(ToStringLocalization.buildMessage(messageID, new Object[]{Helper.getShortClassName(this.getClass())}));
        }
        String messageString = ToStringLocalization.buildMessage("sdo_classgenerator_usage_help_1of6", new Object[]{Helper.getShortClassName(this.getClass())});
        messageString = messageString + Helper.cr() + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage("sdo_classgenerator_usage_help_2of6");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage("sdo_classgenerator_usage_help_3of6");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage("sdo_classgenerator_usage_help_4of6");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage("sdo_classgenerator_usage_help_5of6");
        messageString = messageString + Helper.cr();
        messageString = messageString + ToStringLocalization.buildMessage("sdo_classgenerator_usage_help_6of6");
        messageString = messageString + Helper.cr();
        System.out.println(messageString);
    }

    public Map generate(Reader xsdReader) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader xsdReader, String sourceDir) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader xsdReader, String sourceDir, SchemaResolver schemaResolver) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)fileCodeWriter, schemaResolver);
    }

    public Map generate(Reader xsdReader, SchemaResolver schemaResolver) {
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)new FileCodeWriter(), schemaResolver);
    }

    public Map generate(Reader xsdReader, CodeWriter aCodeWriter) {
        return this.generate((Source)new StreamSource(xsdReader), aCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader xsdReader, CodeWriter aCodeWriter, SchemaResolver schemaResolver) {
        return this.generate(new StreamSource(xsdReader), aCodeWriter, schemaResolver, true);
    }

    public Map generate(Reader xsdReader, CodeWriter aCodeWriter, SchemaResolver schemaResolver, boolean bProcessImports) {
        return this.generate(new StreamSource(xsdReader), aCodeWriter, schemaResolver, bProcessImports);
    }

    public Map generate(Source xsdSource, String sourceDir) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate(xsdSource, (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Source xsdSource, String sourceDir, SchemaResolver schemaResolver) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate(xsdSource, (CodeWriter)fileCodeWriter, schemaResolver);
    }

    public Map generate(Source xsdSource, SchemaResolver schemaResolver) {
        return this.generate(xsdSource, (CodeWriter)new FileCodeWriter(), schemaResolver, true);
    }

    public Map generate(Source xsdSource, CodeWriter aCodeWriter) {
        return this.generate(xsdSource, aCodeWriter, (SchemaResolver)new DefaultSchemaResolver(), true);
    }

    public Map generate(Source xsdSource, CodeWriter aCodeWriter, SchemaResolver schemaResolver) {
        return this.generate(xsdSource, aCodeWriter, schemaResolver, true);
    }

    public Map generate(Source xsdSource, CodeWriter aCodeWriter, SchemaResolver schemaResolver, boolean bProcessImports) {
        SDOTypesGenerator gen = new SDOTypesGenerator(this.aHelperContext);
        List<Type> types = gen.define(xsdSource, schemaResolver, true, bProcessImports);
        return this.generate(aCodeWriter, types);
    }

    public Map generate(CodeWriter aCodeWriter, List types) {
        this.generatedBuffers = new HashMap();
        this.generateInterfaces = true;
        this.codeWriter = aCodeWriter;
        for (int i = 0; i < types.size(); ++i) {
            SDOType theType = (SDOType)types.get(i);
            if (theType.isDataType()) continue;
            ClassBuffer nextBuffer = this.buildClassForType(theType);
            String packageDir = nextBuffer.getPackageName();
            packageDir = packageDir.replace('.', '/');
            this.getCodeWriter().writeInterface(packageDir, nextBuffer.getInterfaceName() + ".java", nextBuffer.getInterfaceBuffer());
            this.getCodeWriter().writeImpl(packageDir, nextBuffer.getClassName() + ".java", nextBuffer.getClassBuffer());
        }
        return this.generatedBuffers;
    }

    private ClassBuffer buildClassForType(SDOType sdoType) {
        String upperClassName;
        ClassBuffer classBuffer = new ClassBuffer(this.sdoClassGeneratorListener);
        classBuffer.setSdoType(sdoType);
        classBuffer.setGenerateInterface(this.generateInterfaces);
        classBuffer.setSdoTypeName(sdoType.getName());
        StringBuffer currentClassBuffer = new StringBuffer();
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplPackage(currentClassBuffer);
        }
        String packageName = null;
        int lastDotIndex = sdoType.getInstanceClassName().lastIndexOf(46);
        if (lastDotIndex > -1) {
            packageName = sdoType.getInstanceClassName().substring(0, lastDotIndex);
        }
        currentClassBuffer.append(this.indent);
        currentClassBuffer.append("package ");
        if (sdoType.getURI() != null && !sdoType.getURI().equals("")) {
            classBuffer.setUri(sdoType.getURI());
        }
        currentClassBuffer.append(packageName);
        classBuffer.setPackageName(packageName);
        currentClassBuffer.append(";").append(lsep2);
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplImports(currentClassBuffer);
        }
        currentClassBuffer.append("import ").append("org.eclipse.persistence.sdo.SDODataObject").append(";").append(lsep2);
        List documentation = (List)sdoType.get(SDOConstants.DOCUMENTATION_PROPERTY);
        if (documentation != null && documentation.size() > 0) {
            currentClassBuffer.append(this.indent);
            currentClassBuffer.append(this.buildJavaDoc(documentation));
        }
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplClass(currentClassBuffer);
        }
        currentClassBuffer.append(this.indent);
        currentClassBuffer.append("public class ");
        String interfaceName = upperClassName = Helper.getShortClassName(sdoType.getInstanceClassName());
        classBuffer.setInterfaceName(interfaceName);
        String fullClassName = upperClassName + "Impl";
        currentClassBuffer.append(fullClassName + " ");
        classBuffer.setClassName(fullClassName);
        String implExtends = null;
        String interfaceExtends = null;
        if (sdoType.isSubType()) {
            SDOType baseType = (SDOType)sdoType.getBaseTypes().get(0);
            if (!baseType.isDataType()) {
                interfaceExtends = baseType.getInstanceClassName();
                implExtends = baseType.getImplClassName();
            }
        } else {
            implExtends = "SDODataObject";
        }
        currentClassBuffer.append("extends ").append(implExtends);
        if (this.generateInterfaces) {
            currentClassBuffer.append(" implements ").append(interfaceName);
        }
        classBuffer.getAttributeBuffer().append(this.buildStartAndEndPropAttribute(sdoType));
        classBuffer.getMethodBuffer().append(this.buildNoArgCtor(fullClassName));
        currentClassBuffer.append(this.indent).append(" {").append(lsep2);
        if (this.generateInterfaces) {
            StringBuffer currentInterfaceBuffer = new StringBuffer();
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfacePackage(currentInterfaceBuffer);
            }
            currentInterfaceBuffer.append(this.indent);
            currentInterfaceBuffer.append("package ");
            currentInterfaceBuffer.append(packageName);
            currentInterfaceBuffer.append(";").append(lsep2);
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfaceImports(currentInterfaceBuffer);
            }
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfaceClass(currentInterfaceBuffer);
            }
            currentInterfaceBuffer.append(this.indent);
            currentInterfaceBuffer.append("public interface ");
            currentInterfaceBuffer.append(interfaceName);
            if (interfaceExtends != null) {
                currentInterfaceBuffer.append(" extends " + interfaceExtends);
            }
            currentInterfaceBuffer.append(this.indent).append(" {").append(lsep2);
            classBuffer.setInterfaceBuffer(currentInterfaceBuffer);
        }
        classBuffer.setClassBuffer(currentClassBuffer);
        this.getGeneratedBuffers().put(new QName(sdoType.getURI(), sdoType.getName()), classBuffer);
        List props = sdoType.getDeclaredProperties();
        int propsSize = props.size();
        for (int i = 0; i < propsSize; ++i) {
            SDOProperty nextProp = (SDOProperty)props.get(i);
            this.buildGetterAndSetter(classBuffer, nextProp);
        }
        classBuffer.close();
        return classBuffer;
    }

    private void addJavaDocLinesToBuffer(StringBuffer javaDocBuffer, List documentationList, boolean getterSetter) {
        for (int i = 0; i < documentationList.size(); ++i) {
            String documentation = (String)documentationList.get(i);
            StringTokenizer stok = new StringTokenizer(documentation, lsep);
            int lineCount = 0;
            while (stok.hasMoreTokens()) {
                String nextLine = stok.nextToken().trim();
                if (nextLine.length() > 0) {
                    if (lineCount > 0 || lineCount == 0 && !getterSetter) {
                        javaDocBuffer.append(this.indent).append(" * ");
                    }
                    javaDocBuffer.append(nextLine).append(lsep);
                }
                ++lineCount;
            }
            if (i >= documentationList.size() - 1) continue;
            javaDocBuffer.append(this.indent).append(" * ");
        }
    }

    private StringBuffer buildJavaDoc(List documentation) {
        StringBuffer javaDocBuffer = new StringBuffer();
        javaDocBuffer.append("/**").append(lsep);
        this.addJavaDocLinesToBuffer(javaDocBuffer, documentation, false);
        javaDocBuffer.append(" */").append(lsep);
        return javaDocBuffer;
    }

    private StringBuffer buildGetterJavaDoc(List documentation, String name) {
        StringBuffer javaDocBuffer = new StringBuffer();
        javaDocBuffer.append(this.indent).append("/**").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("Gets ").append(name).append(".").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("return ");
        this.addJavaDocLinesToBuffer(javaDocBuffer, documentation, true);
        javaDocBuffer.append(this.indent).append(" */").append(lsep);
        return javaDocBuffer;
    }

    private StringBuffer buildSetterJavaDoc(List documentation, String name) {
        StringBuffer javaDocBuffer = new StringBuffer();
        javaDocBuffer.append(this.indent).append("/**").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("Sets ").append(name).append(".").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("param value ");
        this.addJavaDocLinesToBuffer(javaDocBuffer, documentation, true);
        javaDocBuffer.append(this.indent).append(" */").append(lsep);
        return javaDocBuffer;
    }

    private StringBuffer buildStartAndEndPropAttribute(SDOType sdoType) {
        StringBuffer attrBuffer = new StringBuffer();
        this.pushIndent();
        int declPropsSize = sdoType.getDeclaredProperties().size();
        attrBuffer.append(this.indent).append("public static final int START_PROPERTY_INDEX = ");
        if (sdoType.isSubType()) {
            String baseClassName = ((SDOType)sdoType.getBaseTypes().get(0)).getImplClassName();
            attrBuffer.append(baseClassName).append(".END_PROPERTY_INDEX");
            if (declPropsSize > 0) {
                attrBuffer.append(" + 1");
            }
            attrBuffer.append(";");
        } else if (declPropsSize > 0) {
            attrBuffer.append("0;");
        } else {
            attrBuffer.append("-1;");
        }
        attrBuffer.append(lsep2);
        int end = 0;
        end = declPropsSize > 0 ? declPropsSize - 1 : 0;
        attrBuffer.append(this.indent).append("public static final int END_PROPERTY_INDEX = START_PROPERTY_INDEX + ").append(end).append(";").append(lsep2);
        this.popIndent();
        return attrBuffer;
    }

    private StringBuffer buildNoArgCtor(String className) {
        StringBuffer ctorBuffer = new StringBuffer();
        this.pushIndent();
        ctorBuffer.append(this.indent).append("public ").append(className).append("() {}").append(lsep2);
        this.popIndent();
        return ctorBuffer;
    }

    private void buildGetterAndSetter(ClassBuffer classBuffer, SDOProperty property) {
        this.pushIndent();
        List documentation = (List)property.get(SDOConstants.DOCUMENTATION_PROPERTY);
        this.buildGetMethodBuffer(classBuffer, property, documentation);
        this.buildSetMethodBuffer(classBuffer, property, documentation);
        this.popIndent();
    }

    private void buildGetMethodBuffer(ClassBuffer classBuffer, SDOProperty property, List documentation) {
        String returnType = this.getJavaTypeForProperty(property);
        String methodName = SDOUtil.getMethodName(property.getName(), returnType);
        if (!property.getType().isChangeSummaryType() || !methodName.equals("getChangeSummary")) {
            if (documentation != null && documentation.size() > 0) {
                classBuffer.getMethodBuffer().append(this.buildGetterJavaDoc(documentation, property.getName()));
            }
            classBuffer.getMethodBuffer().append(this.indent);
            classBuffer.getMethodBuffer().append("public ");
            classBuffer.getMethodBuffer().append(returnType).append(" ");
            classBuffer.getMethodBuffer().append(methodName);
            classBuffer.getMethodBuffer().append("() {").append(lsep);
            this.pushIndent();
            classBuffer.getMethodBuffer().append(this.indent).append("return ");
            String builtIn = this.getBuiltInType(returnType);
            if (builtIn != null) {
                String wrapperCall = this.getWrapperCall(returnType);
                if (wrapperCall != null) {
                    classBuffer.getMethodBuffer().append(wrapperCall);
                }
                classBuffer.getMethodBuffer().append("get").append(builtIn).append("(");
                classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(property.getIndexInDeclaredProperties());
                classBuffer.getMethodBuffer().append(")");
                if (wrapperCall != null) {
                    classBuffer.getMethodBuffer().append(")");
                }
            } else {
                if (!returnType.equals(ClassConstants.OBJECT.getName())) {
                    classBuffer.getMethodBuffer().append("(");
                    classBuffer.getMethodBuffer().append(returnType).append(")");
                }
                classBuffer.getMethodBuffer().append("get(");
                classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(property.getIndexInDeclaredProperties());
                classBuffer.getMethodBuffer().append(")");
            }
            classBuffer.getMethodBuffer().append(";").append(lsep);
            this.popIndent();
            classBuffer.getMethodBuffer().append(this.indent).append("}").append(lsep2);
        }
        if (this.generateInterfaces) {
            classBuffer.getInterfaceBuffer().append(this.indent);
            classBuffer.getInterfaceBuffer().append("public ");
            classBuffer.getInterfaceBuffer().append(returnType).append(" ");
            classBuffer.getInterfaceBuffer().append(methodName);
            classBuffer.getInterfaceBuffer().append("();").append(lsep2);
        }
    }

    private void buildSetMethodBuffer(ClassBuffer classBuffer, SDOProperty property, List documentation) {
        if (property.getType().isChangeSummaryType()) {
            return;
        }
        if (documentation != null && documentation.size() > 0) {
            classBuffer.getMethodBuffer().append(this.buildSetterJavaDoc(documentation, property.getName()));
        }
        classBuffer.getMethodBuffer().append(this.indent);
        classBuffer.getMethodBuffer().append("public void ");
        String methodName = SDOUtil.setMethodName(property.getName());
        classBuffer.getMethodBuffer().append(methodName);
        classBuffer.getMethodBuffer().append("(");
        String paramType = this.getJavaTypeForProperty(property);
        classBuffer.getMethodBuffer().append(paramType).append(" value");
        classBuffer.getMethodBuffer().append(")").append(" {").append(lsep);
        this.pushIndent();
        classBuffer.getMethodBuffer().append(this.indent).append("set(");
        classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(property.getIndexInDeclaredProperties());
        classBuffer.getMethodBuffer().append(" , value)");
        classBuffer.getMethodBuffer().append(";").append(lsep);
        this.popIndent();
        classBuffer.getMethodBuffer().append(this.indent).append("}");
        classBuffer.getMethodBuffer().append(lsep2);
        if (this.generateInterfaces) {
            classBuffer.getInterfaceBuffer().append(this.indent);
            classBuffer.getInterfaceBuffer().append("public void ");
            classBuffer.getInterfaceBuffer().append(methodName);
            classBuffer.getInterfaceBuffer().append("(");
            classBuffer.getInterfaceBuffer().append(paramType).append(" value");
            classBuffer.getInterfaceBuffer().append(");").append(lsep2);
        }
    }

    private void pushIndent() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < INDENT_TAB; ++i) {
            buf.append(" ");
        }
        this.indent = this.indent + buf.toString();
    }

    private void popIndent() {
        StringBuffer buf = new StringBuffer();
        int size = this.indent.length() - INDENT_TAB;
        for (int i = 0; i < size; ++i) {
            buf.append(" ");
        }
        this.indent = buf.toString();
    }

    private String getBuiltInType(String typeName) {
        if (typeName.equals(ClassConstants.PBOOLEAN.getName()) || typeName.equals(ClassConstants.BOOLEAN.getName())) {
            return "Boolean";
        }
        if (typeName.equals(ClassConstants.PBYTE.getName()) || typeName.equals(ClassConstants.BYTE.getName())) {
            return "Byte";
        }
        if (typeName.equals(ClassConstants.APBYTE.getName()) || typeName.equals(ClassConstants.ABYTE.getName())) {
            return "Bytes";
        }
        if (typeName.equals(ClassConstants.PCHAR.getName()) || typeName.equals(ClassConstants.CHAR.getName())) {
            return "Char";
        }
        if (typeName.equals(ClassConstants.PDOUBLE.getName()) || typeName.equals(ClassConstants.DOUBLE.getName())) {
            return "Double";
        }
        if (typeName.equals(ClassConstants.PFLOAT.getName()) || typeName.equals(ClassConstants.FLOAT.getName())) {
            return "Float";
        }
        if (typeName.equals(ClassConstants.PLONG.getName()) || typeName.equals(ClassConstants.LONG.getName())) {
            return "Long";
        }
        if (typeName.equals(ClassConstants.PSHORT.getName()) || typeName.equals(ClassConstants.SHORT.getName())) {
            return "Short";
        }
        if (typeName.equals(ClassConstants.PINT.getName()) || typeName.equals(ClassConstants.INTEGER.getName())) {
            return "Int";
        }
        if (typeName.equals(ClassConstants.STRING.getName())) {
            return "String";
        }
        if (typeName.equals(ClassConstants.BIGINTEGER.getName())) {
            return "BigInteger";
        }
        if (typeName.equals(ClassConstants.BIGDECIMAL.getName())) {
            return "BigDecimal";
        }
        if (typeName.equals(ClassConstants.UTILDATE.getName())) {
            return "Date";
        }
        if (typeName.equals("java.util.List")) {
            return "List";
        }
        return null;
    }

    public void setGeneratedBuffers(Map generatedBuffersMap) {
        this.generatedBuffers = generatedBuffersMap;
    }

    public Map getGeneratedBuffers() {
        return this.generatedBuffers;
    }

    private String getWrapperCall(String javaType) {
        if (javaType.equals("java.lang.Integer")) {
            return "new Integer(";
        }
        if (javaType.equals("java.lang.Boolean")) {
            return "new Boolean(";
        }
        if (javaType.equals("java.lang.Short")) {
            return "new Short(";
        }
        if (javaType.equals("java.lang.Float")) {
            return "new Float(";
        }
        if (javaType.equals("java.lang.Double")) {
            return "new Double(";
        }
        if (javaType.equals("java.lang.Byte")) {
            return "new Byte(";
        }
        return null;
    }

    private String getJavaTypeForProperty(Property property) {
        if (property.isMany() || ((SDOType)property.getType()).isXsdList()) {
            return "java.util.List";
        }
        Class instanceClass = property.getType().getInstanceClass();
        if (instanceClass.equals(ClassConstants.ABYTE)) {
            return "Byte[]";
        }
        if (instanceClass.equals(ClassConstants.APBYTE)) {
            return "byte[]";
        }
        return instanceClass.getName();
    }

    public void setCodeWriter(CodeWriter theCodeWriter) {
        this.codeWriter = theCodeWriter;
    }

    public CodeWriter getCodeWriter() {
        return this.codeWriter;
    }

    public void setSDOClassGeneratorListener(SDOClassGeneratorListener listener) {
        this.sdoClassGeneratorListener = listener;
    }

    public SDOClassGeneratorListener getSDOClassGeneratorListener() {
        return this.sdoClassGeneratorListener;
    }
}

