/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWDataField;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWColumn;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWTableDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWColumnHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.CloneIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWRelationalPrimaryKeyPolicy
extends MWModel {
    protected Collection primaryKeyHandles;
    public static final String PRIMARY_KEYS_COLLECTION = "primaryKeys";
    private MWHandle.NodeReferenceScrubber primaryKeyScrubber;

    private MWRelationalPrimaryKeyPolicy() {
    }

    MWRelationalPrimaryKeyPolicy(MWRelationalTransactionalPolicy parent) {
        super(parent);
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.primaryKeyHandles = new Vector();
    }

    private Iterator primaryKeyHandles() {
        return new CloneIterator(this.primaryKeyHandles){

            protected void remove(Object current) {
                MWRelationalPrimaryKeyPolicy.this.removePrimaryKeyHandle((MWColumnHandle)current);
            }
        };
    }

    void removePrimaryKeyHandle(MWColumnHandle handle) {
        this.primaryKeyHandles.remove(handle);
        this.fireItemRemoved(PRIMARY_KEYS_COLLECTION, handle.getColumn());
    }

    public Iterator primaryKeys() {
        return new TransformationIterator(this.primaryKeyHandles()){

            protected Object transform(Object next) {
                return ((MWColumnHandle)next).getColumn();
            }
        };
    }

    public int primaryKeysSize() {
        return this.primaryKeyHandles.size();
    }

    public void addPrimaryKey(MWColumn primaryKey) {
        if (this.containsPrimaryKey(primaryKey)) {
            throw new IllegalArgumentException(primaryKey.toString());
        }
        this.primaryKeyHandles.add(new MWColumnHandle(this, primaryKey, this.primaryKeyScrubber()));
        this.fireItemAdded(PRIMARY_KEYS_COLLECTION, primaryKey);
    }

    public void removePrimaryKey(MWColumn primaryKey) {
        Iterator stream = this.primaryKeys();
        while (stream.hasNext()) {
            if (stream.next() != primaryKey) continue;
            stream.remove();
            return;
        }
        throw new IllegalArgumentException(primaryKey.toString());
    }

    public boolean containsPrimaryKey(MWColumn primaryKey) {
        return CollectionTools.contains(this.primaryKeys(), (Object)primaryKey);
    }

    public void clearPrimaryKeys() {
        Iterator stream = this.primaryKeyHandles();
        while (stream.hasNext()) {
            stream.next();
            stream.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List children) {
        super.addChildrenTo(children);
        Collection collection = this.primaryKeyHandles;
        synchronized (collection) {
            children.addAll(this.primaryKeyHandles);
        }
    }

    private MWHandle.NodeReferenceScrubber primaryKeyScrubber() {
        if (this.primaryKeyScrubber == null) {
            this.primaryKeyScrubber = this.buildPrimaryKeyScrubber();
        }
        return this.primaryKeyScrubber;
    }

    private MWHandle.NodeReferenceScrubber buildPrimaryKeyScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle handle) {
                MWRelationalPrimaryKeyPolicy.this.removePrimaryKeyHandle((MWColumnHandle)handle);
            }

            public String toString() {
                return "MWRelationalPrimaryKeyPolicy.buildPrimaryKeyScrubber()";
            }
        };
    }

    void descriptorPrimaryTableChanged(MWTable primaryTable) {
        this.clearPrimaryKeys();
        if (primaryTable == null) {
            return;
        }
        Iterator stream = primaryTable.primaryKeyColumns();
        while (stream.hasNext()) {
            this.addPrimaryKey((MWColumn)stream.next());
        }
    }

    public MWTableDescriptor getTableDescriptor() {
        return (MWTableDescriptor)((MWRelationalTransactionalPolicy)this.getParent()).getParent();
    }

    public Iterator primaryKeyChoices() {
        MWTable primaryTable = this.getTableDescriptor().getPrimaryTable();
        if (primaryTable == null) {
            return NullIterator.instance();
        }
        return new FilteringIterator(primaryTable.columns()){

            protected boolean accept(Object next) {
                return !MWRelationalPrimaryKeyPolicy.this.containsPrimaryKey((MWColumn)next);
            }
        };
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        Iterator primaryKeys = this.primaryKeys();
        while (primaryKeys.hasNext()) {
            runtimeDescriptor.addPrimaryKeyField(((MWDataField)primaryKeys.next()).runtimeField());
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalPrimaryKeyPolicy.class);
        XMLCompositeCollectionMapping primaryKeyHandlesMapping = new XMLCompositeCollectionMapping();
        primaryKeyHandlesMapping.setReferenceClass(MWColumnHandle.class);
        primaryKeyHandlesMapping.setAttributeName("primaryKeyHandles");
        primaryKeyHandlesMapping.setGetMethodName("getPrimaryKeyHandlesForTopLink");
        primaryKeyHandlesMapping.setSetMethodName("setPrimaryKeyHandlesForTopLink");
        primaryKeyHandlesMapping.setXPath("primary-key-handles/column-handle");
        descriptor.addMapping((DatabaseMapping)primaryKeyHandlesMapping);
        return descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection getPrimaryKeyHandlesForTopLink() {
        Collection collection = this.primaryKeyHandles;
        synchronized (collection) {
            return new TreeSet(this.primaryKeyHandles);
        }
    }

    private void setPrimaryKeyHandlesForTopLink(Collection handles) {
        Iterator stream = handles.iterator();
        while (stream.hasNext()) {
            ((MWColumnHandle)stream.next()).setScrubber(this.primaryKeyScrubber());
        }
        this.primaryKeyHandles = handles;
    }

    protected void legacySetPrimaryKeys(Collection handles) {
        this.setPrimaryKeyHandlesForTopLink(handles);
    }
}

