/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryManager;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadAllQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWRelationalReadObjectQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class MWRelationalQueryManager
extends MWQueryManager {
    private volatile String insertSQLString;
    public static final String INSERT_SQL_STRING_PROPERTY = "insertSQLString";
    private volatile String updateSQLString;
    public static final String UPDATE_SQL_STRING_PROPERTY = "updateSQLString";
    private volatile String deleteSQLString;
    public static final String DELETE_SQL_STRING_PROPERTY = "deleteSQLString";
    private volatile String readObjectSQLString;
    public static final String READ_OBJECT_SQL_STRING_PROPERTY = "readObjectSQLString";
    private volatile String readAllSQLString;
    public static final String READ_ALL_SQL_STRING_PROPERTY = "readAllSQLString";
    private String legacyDescriptorAlias;

    private MWRelationalQueryManager() {
    }

    public MWRelationalQueryManager(MWRelationalTransactionalPolicy descriptor) {
        super(descriptor);
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWRelationalQueryManager.class);
        descriptor.getInheritancePolicy().setParentClass(MWQueryManager.class);
        descriptor.addDirectMapping(INSERT_SQL_STRING_PROPERTY, "insert-string/text()");
        descriptor.addDirectMapping(UPDATE_SQL_STRING_PROPERTY, "update-string/text()");
        descriptor.addDirectMapping(DELETE_SQL_STRING_PROPERTY, "delete-string/text()");
        descriptor.addDirectMapping(READ_OBJECT_SQL_STRING_PROPERTY, "read-object-string/text()");
        descriptor.addDirectMapping(READ_ALL_SQL_STRING_PROPERTY, "read-all-string/text()");
        return descriptor;
    }

    public MWReportQuery addReportQuery(String queryName) {
        return (MWReportQuery)this.addQuery(new MWReportQuery(this, queryName));
    }

    public MWReadAllQuery buildReadAllQuery(String queryName) {
        return new MWRelationalReadAllQuery(this, queryName);
    }

    public MWReadObjectQuery buildReadObjectQuery(String queryName) {
        return new MWRelationalReadObjectQuery(this, queryName);
    }

    public boolean supportsReportQueries() {
        return true;
    }

    public String getDeleteSQLString() {
        return this.deleteSQLString;
    }

    public String getInsertSQLString() {
        return this.insertSQLString;
    }

    public String getReadAllSQLString() {
        return this.readAllSQLString;
    }

    public String getReadObjectSQLString() {
        return this.readObjectSQLString;
    }

    public String getUpdateSQLString() {
        return this.updateSQLString;
    }

    public void setDeleteSQLString(String deleteSQLString) {
        String oldDeleteSQLString = this.getDeleteSQLString();
        this.deleteSQLString = deleteSQLString;
        this.firePropertyChanged(DELETE_SQL_STRING_PROPERTY, oldDeleteSQLString, deleteSQLString);
    }

    public void setInsertSQLString(String insertSQLString) {
        String oldInsertSQLString = this.getInsertSQLString();
        this.insertSQLString = insertSQLString;
        this.firePropertyChanged(INSERT_SQL_STRING_PROPERTY, oldInsertSQLString, insertSQLString);
    }

    public void setReadAllSQLString(String readAllSQLString) {
        String oldReadAllSQLString = this.getReadAllSQLString();
        this.readAllSQLString = readAllSQLString;
        this.firePropertyChanged(READ_ALL_SQL_STRING_PROPERTY, oldReadAllSQLString, readAllSQLString);
    }

    public void setReadObjectSQLString(String readObjectSQLString) {
        String oldReadObjectSQLString = this.getReadObjectSQLString();
        this.readObjectSQLString = readObjectSQLString;
        this.firePropertyChanged(READ_OBJECT_SQL_STRING_PROPERTY, oldReadObjectSQLString, readObjectSQLString);
    }

    public void setUpdateSQLString(String updateSQLString) {
        String oldUpdateSQLString = this.getUpdateSQLString();
        this.updateSQLString = updateSQLString;
        this.firePropertyChanged(UPDATE_SQL_STRING_PROPERTY, oldUpdateSQLString, updateSQLString);
    }

    public void notifyExpressionsToRecalculateQueryables() {
        Iterator queries = this.queries();
        while (queries.hasNext()) {
            ((MWRelationalQuery)queries.next()).notifyExpressionsToRecalculateQueryables();
        }
    }

    public void adjustRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        super.adjustRuntimeDescriptor(runtimeDescriptor);
        DescriptorQueryManager rtQueryManager = runtimeDescriptor.getQueryManager();
        if (!StringTools.stringIsEmpty(this.getDeleteSQLString())) {
            rtQueryManager.setDeleteSQLString(this.getDeleteSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getInsertSQLString())) {
            rtQueryManager.setInsertSQLString(this.getInsertSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getUpdateSQLString())) {
            rtQueryManager.setUpdateSQLString(this.getUpdateSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getReadAllSQLString())) {
            rtQueryManager.setReadAllSQLString(this.getReadAllSQLString());
        }
        if (!StringTools.stringIsEmpty(this.getReadObjectSQLString())) {
            rtQueryManager.setReadObjectSQLString(this.getReadObjectSQLString());
        }
    }

    public void adjustFromRuntimeDescriptor(ClassDescriptor runtimeDescriptor) {
        super.adjustFromRuntime(runtimeDescriptor);
        DescriptorQueryManager rtQueryManager = runtimeDescriptor.getQueryManager();
        this.setDeleteSQLString(rtQueryManager.getDeleteSQLString());
        this.setInsertSQLString(rtQueryManager.getInsertSQLString());
        this.setUpdateSQLString(rtQueryManager.getUpdateSQLString());
        this.setReadAllSQLString(rtQueryManager.getReadAllSQLString());
        this.setReadObjectSQLString(rtQueryManager.getReadObjectSQLString());
    }
}

