/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.FileChooser;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsplugin.MappingsPlugin;
import org.eclipse.persistence.tools.workbench.uitools.CancelException;
import org.eclipse.persistence.tools.workbench.uitools.LabelArea;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class ProjectSourceGenerationCoordinator {
    private WorkbenchContext context;

    ProjectSourceGenerationCoordinator(WorkbenchContext context) {
        this.context = context;
    }

    private ResourceRepository resourceRepository() {
        return this.context.getApplicationContext().getResourceRepository();
    }

    void exportProjectSource(MWProject project) {
        try {
            this.validateProjectClassName(project);
            this.validateProjectSourceRootDirectory(project);
            this.validateProjectProblems(project);
            this.validateOverwriteProject(project);
        }
        catch (CancelException ce) {
            return;
        }
        project.exportProjectSource();
        this.showSuccessDialog(project);
    }

    private void validateProjectClassName(MWProject project) {
        String projectClassName = project.getProjectSourceClassName();
        if (!projectClassName.equals("") && !projectClassName.endsWith(".")) {
            return;
        }
        ProjectClassNameDialog dlg = new ProjectClassNameDialog(this.context, this.buildProjectClassNameHolder(projectClassName), project.getName());
        dlg.show();
        if (dlg.wasCanceled()) {
            throw new CancelException();
        }
        project.setProjectSourceClassName(dlg.getProjectClassName());
    }

    private PropertyValueModel buildProjectClassNameHolder(String name) {
        return new SimplePropertyValueModel(name);
    }

    private void validateProjectSourceRootDirectory(MWProject project) {
        if (project.getProjectSourceDirectoryName().equals("")) {
            this.promptForProjectSourceRootDirectory(project);
        }
        if (project.absoluteProjectSourceDirectory().isFile()) {
            this.promptForNonFileProjectSourceRootDirectory(project);
        }
        if (!project.absoluteProjectSourceDirectory().exists()) {
            this.promptToCreateProjectSourceRootDirectory(project);
        }
    }

    private void promptForProjectSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_NO_DIRECTORY_CHOSEN.message");
        this.promptForDirectory(project, description);
    }

    private void promptForNonFileProjectSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_A_FILE.message", new Object[]{project.absoluteProjectSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private void promptForValidProjectSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_IS_INVALID.message", new Object[]{project.absoluteProjectSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private void promptForCreatableProjectSourceRootDirectory(MWProject project) {
        String description = this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_CHOSEN_DIRECTORY_COULD_NOT_BE_CREATED.message", new Object[]{project.absoluteProjectSourceDirectory()});
        this.promptForDirectory(project, description);
    }

    private Preferences preferences() {
        return this.context.getApplicationContext().getPreferences();
    }

    private void promptForDirectory(MWProject project, String description) {
        File startDir = MappingsPlugin.buildExportDirectory(project, project.getProjectSourceDirectoryName(), this.preferences());
        FileChooser fileChooser = new FileChooser(startDir, project.getSaveDirectory());
        fileChooser.setDialogTitle(this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG.title", project.getName()));
        fileChooser.setFileSelectionMode(1);
        fileChooser.setApproveButtonText(this.resourceRepository().getString("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        fileChooser.setApproveButtonMnemonic(this.resourceRepository().getMnemonic("PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG_SELECT_BUTTON"));
        int option = fileChooser.showOpenDialog(this.context.getCurrentWindow());
        if (option == 1) {
            throw new CancelException();
        }
        File directory = ((JFileChooser)fileChooser).getSelectedFile();
        project.setProjectSourceDirectoryName(directory.getPath());
        if (directory != null && directory.isAbsolute() && !directory.equals(project.getSaveDirectory())) {
            this.preferences().put("export location", directory.getPath());
        }
    }

    private void promptToCreateProjectSourceRootDirectory(MWProject project) {
        File canonicalProjectSourceRootDirectory;
        try {
            canonicalProjectSourceRootDirectory = project.absoluteProjectSourceDirectory().getCanonicalFile();
        }
        catch (IOException ioe) {
            this.promptForValidProjectSourceRootDirectory(project);
            return;
        }
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("CREATE_PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG.message", new Object[]{canonicalProjectSourceRootDirectory}), this.resourceRepository().getString("CREATE_PROJECT_SOURCE_ROOT_DIRECTORY_DIALOG.title"), 0, 3);
        if (input != 0) {
            throw new CancelException();
        }
        if (!project.absoluteProjectSourceDirectory().mkdirs()) {
            this.promptForCreatableProjectSourceRootDirectory(project);
        }
    }

    private void validateProjectProblems(MWProject project) {
        if (!project.hasBranchProblems()) {
            return;
        }
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), new LabelArea(this.resourceRepository().getString("exportingProjectJavaSource", StringTools.CR)), this.resourceRepository().getString("exportProjectJavaSource", project.getName()), 0, 2);
        if (input != 0) {
            throw new CancelException();
        }
    }

    private void validateOverwriteProject(MWProject project) {
        File projectFile = project.projectSourceFile();
        String projectFilePath = projectFile.getAbsolutePath();
        try {
            projectFilePath = projectFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (!projectFile.exists()) {
            return;
        }
        int input = JOptionPane.showConfirmDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("PROJECT_FILE_EXISTS_DIALOG.message", projectFilePath), this.resourceRepository().getString("PROJECT_FILE_EXISTS_DIALOG.title"), 0, 3);
        if (input != 0) {
            throw new CancelException();
        }
    }

    private void showSuccessDialog(MWProject project) {
        JOptionPane.showMessageDialog(this.context.getCurrentWindow(), this.resourceRepository().getString("EXPORT_PROJECT_SOURCE_SUCCESS_DIALOG.message"), this.resourceRepository().getString("EXPORT_PROJECT_SOURCE_SUCCESS_DIALOG.title", project.getName()), 1);
    }

    private class ProjectClassNameDialog
    extends AbstractDialog {
        private JTextField projectClassNameTextField;
        private PropertyValueModel projectClassNameHolder;
        private static final long serialVersionUID = 1L;

        private ProjectClassNameDialog(WorkbenchContext context, PropertyValueModel projectClassNameHolder, String projectName) {
            super(context);
            this.projectClassNameHolder = projectClassNameHolder;
            this.initialize(projectName);
        }

        protected void initialize(String projectName) {
            super.initialize();
            this.setTitle(this.resourceRepository().getString("PROJECT_CLASS_NAME_DIALOG.title", projectName));
            this.getOKAction().setEnabled(false);
        }

        protected String helpTopicId() {
            return "dialog.projectSourceClassName";
        }

        protected Component buildMainPanel() {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel messageLabel = new JLabel();
            messageLabel.setText(this.resourceRepository().getString("PROJECT_CLASS_NAME_DIALOG.message"));
            messageLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("PROJECT_CLASS_NAME_DIALOG.message"));
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.fill = 0;
            constraints.anchor = 21;
            constraints.insets = new Insets(5, 5, 0, 5);
            mainPanel.add((Component)messageLabel, constraints);
            this.projectClassNameTextField = this.buildProjectClassNameTextField();
            this.helpManager().addTopicID(this.projectClassNameTextField, this.helpTopicId() + ".name");
            messageLabel.setLabelFor(this.projectClassNameTextField);
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            constraints.insets = new Insets(5, 5, 5, 5);
            mainPanel.add((Component)this.projectClassNameTextField, constraints);
            return mainPanel;
        }

        protected Component initialFocusComponent() {
            return this.projectClassNameTextField;
        }

        private JTextField buildProjectClassNameTextField() {
            JTextField textField = new JTextField();
            textField.setDocument(this.buildProjectClassNameDocumentAdapter());
            return textField;
        }

        private Document buildProjectClassNameDocumentAdapter() {
            DocumentAdapter adapter = new DocumentAdapter(this.projectClassNameHolder, new RegexpDocument(3));
            adapter.addDocumentListener(this.buildProjectClassNameDocumentListener());
            return adapter;
        }

        private DocumentListener buildProjectClassNameDocumentListener() {
            return new DocumentListener(){

                public void insertUpdate(DocumentEvent de) {
                    ProjectClassNameDialog.this.projectClassNameChange();
                }

                public void removeUpdate(DocumentEvent de) {
                    ProjectClassNameDialog.this.projectClassNameChange();
                }

                public void changedUpdate(DocumentEvent de) {
                    ProjectClassNameDialog.this.projectClassNameChange();
                }
            };
        }

        void projectClassNameChange() {
            String projectClassName = this.getProjectClassName();
            this.getOKAction().setEnabled(!projectClassName.equals("") && !projectClassName.endsWith("."));
        }

        String getProjectClassName() {
            return (String)this.projectClassNameHolder.getValue();
        }
    }
}

