/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Arrays;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueAspectPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

public class ValueCollectionPropertyValueModelAdapter
extends ValueAspectPropertyValueModelAdapter {
    protected final String[] collectionNames;
    protected CollectionChangeListener valueCollectionListener;

    public ValueCollectionPropertyValueModelAdapter(PropertyValueModel valueHolder, String collectionName) {
        this(valueHolder, new String[]{collectionName});
    }

    public ValueCollectionPropertyValueModelAdapter(PropertyValueModel valueHolder, String collectionName1, String collectionName2) {
        this(valueHolder, new String[]{collectionName1, collectionName2});
    }

    public ValueCollectionPropertyValueModelAdapter(PropertyValueModel valueHolder, String collectionName1, String collectionName2, String collectionName3) {
        this(valueHolder, new String[]{collectionName1, collectionName2, collectionName3});
    }

    public ValueCollectionPropertyValueModelAdapter(PropertyValueModel valueHolder, String[] collectionNames) {
        super(valueHolder);
        this.collectionNames = collectionNames;
    }

    protected void initialize() {
        super.initialize();
        this.valueCollectionListener = this.buildValueCollectionListener();
    }

    protected CollectionChangeListener buildValueCollectionListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent e) {
                ValueCollectionPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void itemsRemoved(CollectionChangeEvent e) {
                ValueCollectionPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public void collectionChanged(CollectionChangeEvent e) {
                ValueCollectionPropertyValueModelAdapter.this.valueAspectChanged();
            }

            public String toString() {
                return "value collection listener: " + Arrays.asList(ValueCollectionPropertyValueModelAdapter.this.collectionNames);
            }
        };
    }

    protected void startListeningToValue() {
        Model v = (Model)this.value;
        int i = this.collectionNames.length;
        while (i-- > 0) {
            v.addCollectionChangeListener(this.collectionNames[i], this.valueCollectionListener);
        }
    }

    protected void stopListeningToValue() {
        Model v = (Model)this.value;
        int i = this.collectionNames.length;
        while (i-- > 0) {
            v.removeCollectionChangeListener(this.collectionNames[i], this.valueCollectionListener);
        }
    }
}

