/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Tuple;
import javax.persistence.criteria.CompoundSelection;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.QueryBuilder;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.expressions.ExpressionMath;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.FunctionExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryBuilderImpl
implements QueryBuilder {
    protected Metamodel metamodel;

    public QueryBuilderImpl(Metamodel metamodel) {
        this.metamodel = metamodel;
    }

    @Override
    public CriteriaQuery<Object> createQuery() {
        return new CriteriaQueryImpl<Object>(this.metamodel, AbstractQueryImpl.ResultType.OTHER, ClassConstants.OBJECT, this);
    }

    @Override
    public <T> CriteriaQuery<T> createQuery(Class<T> resultClass) {
        if (resultClass.equals(Tuple.class)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, resultClass, this);
        }
        if (resultClass.equals(ClassConstants.AOBJECT)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        if (resultClass.isArray()) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OBJECT_ARRAY, resultClass, this);
        }
        ManagedType<T> type = this.metamodel.type(resultClass);
        if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
            return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.ENTITY, resultClass, this);
        }
        return new CriteriaQueryImpl(this.metamodel, AbstractQueryImpl.ResultType.OTHER, resultClass, this);
    }

    @Override
    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(this.metamodel, AbstractQueryImpl.ResultType.TUPLE, Tuple.class, this);
    }

    @Override
    public <Y> CompoundSelection<Y> construct(Class<Y> result, Selection<?> ... selections) {
        return new CompoundSelectionImpl(result, selections);
    }

    @Override
    public CompoundSelection<Tuple> tuple(Selection<?> ... selections) {
        return this.construct(Tuple.class, selections);
    }

    @Override
    public CompoundSelection<Object[]> array(Selection<?> ... selections) {
        return this.construct(ClassConstants.AOBJECT, selections);
    }

    @Override
    public Order asc(Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new OrderImpl(x);
    }

    @Override
    public Order desc(Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        OrderImpl order = new OrderImpl(x, false);
        return order;
    }

    @Override
    public <N extends Number> Expression<Double> avg(Expression<N> x) {
        return new FunctionExpressionImpl<Double>(this.metamodel, ClassConstants.DOUBLE, ((InternalSelection)((Object)x)).getCurrentNode().average(), this.buildList(x), "AVG");
    }

    @Override
    public <N extends Number> Expression<N> sum(Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().sum(), this.buildList(x), "SUM");
    }

    @Override
    public <N extends Number> Expression<N> max(Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().maximum(), this.buildList(x), "MAX");
    }

    @Override
    public <N extends Number> Expression<N> min(Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().minimum(), this.buildList(x), "MIN");
    }

    @Override
    public <X extends Comparable<X>> Expression<X> greatest(Expression<X> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().maximum());
    }

    @Override
    public <X extends Comparable<X>> Expression<X> least(Expression<X> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new ExpressionImpl(this.metamodel, x.getJavaType(), ((InternalSelection)((Object)x)).getCurrentNode().minimum());
    }

    @Override
    public Expression<Long> count(Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().count(), this.buildList(x), "COUNT");
    }

    @Override
    public Expression<Long> countDistinct(Expression<?> x) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        return new FunctionExpressionImpl<Long>(this.metamodel, ClassConstants.LONG, ((InternalSelection)((Object)x)).getCurrentNode().distinct().count(), this.buildList(x), "COUNT");
    }

    @Override
    public Predicate exists(Subquery<?> subquery) {
        return new CompoundExpressionImpl(this.metamodel, new ExpressionBuilder().exists(((SubQueryImpl)subquery).subQuery), this.buildList(subquery), "exists");
    }

    @Override
    public <Y> Expression<Y> all(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().all(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "all");
    }

    @Override
    public <Y> Expression<Y> some(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().some(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "some");
    }

    @Override
    public <Y> Expression<Y> any(Subquery<Y> subquery) {
        return new FunctionExpressionImpl(this.metamodel, subquery.getJavaType(), new ExpressionBuilder().any(((InternalSelection)((Object)subquery)).getCurrentNode()), this.buildList(subquery), "any");
    }

    @Override
    public Predicate and(Expression<Boolean> x, Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)((Object)y)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isPredicate() && yp.expressions.isEmpty()) {
            if (yp.isNegated()) {
                return yp;
            }
            return xp;
        }
        if (xp.isPredicate() && xp.expressions.isEmpty()) {
            if (xp.isNegated()) {
                return xp;
            }
            return yp;
        }
        return new PredicateImpl(this.metamodel, xp.getCurrentNode().and(yp.getCurrentNode()), this.buildList(xp, yp), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate or(Expression<Boolean> x, Expression<Boolean> y) {
        CompoundExpressionImpl xp = null;
        CompoundExpressionImpl yp = null;
        xp = ((InternalExpression)((Object)x)).isExpression() ? (CompoundExpressionImpl)this.isTrue(x) : (CompoundExpressionImpl)x;
        yp = ((InternalExpression)((Object)y)).isExpression() ? (CompoundExpressionImpl)this.isTrue(y) : (CompoundExpressionImpl)y;
        if (yp.isPredicate() && yp.expressions.isEmpty() && yp.isNegated()) {
            return xp;
        }
        if (xp.isPredicate() && xp.expressions.isEmpty() && xp.isNegated()) {
            return yp;
        }
        return new PredicateImpl(this.metamodel, xp.getCurrentNode().or(yp.getCurrentNode()), this.buildList(xp, yp), Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate and(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.conjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.and((Expression<Boolean>)a, (Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    @Override
    public Predicate or(Predicate ... restrictions) {
        int max = restrictions.length;
        if (max == 0) {
            return this.disjunction();
        }
        Predicate a = restrictions[0];
        for (int i = 1; i < max; ++i) {
            a = this.or((Expression<Boolean>)a, (Expression<Boolean>)restrictions[i]);
        }
        return a;
    }

    @Override
    public Predicate not(Expression<Boolean> restriction) {
        if (((InternalExpression)((Object)restriction)).isPredicate()) {
            return ((PredicateImpl)restriction).negate();
        }
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)restriction)).getCurrentNode().not(), this.buildList(restriction), "not");
    }

    @Override
    public Predicate conjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate disjunction() {
        return new PredicateImpl(this.metamodel, null, null, Predicate.BooleanOperator.OR);
    }

    @Override
    public Predicate isTrue(Expression<Boolean> x) {
        if (((InternalExpression)((Object)x)).isPredicate()) {
            if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
                return (Predicate)x;
            }
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("PREDICATE_PASSED_TO_EVALUATION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(true), list, "equals");
    }

    @Override
    public Predicate isFalse(Expression<Boolean> x) {
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(false), this.buildList(x), "equals");
    }

    @Override
    public Predicate isNull(Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().isNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate isNotNull(Expression<?> x) {
        return new PredicateImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notNull(), new ArrayList(), Predicate.BooleanOperator.AND);
    }

    @Override
    public Predicate equal(Expression<?> x, Expression<?> y) {
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(((InternalSelection)((Object)y)).getCurrentNode()), list, "equals");
    }

    @Override
    public Predicate notEqual(Expression<?> x, Expression<?> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notEqual(((InternalSelection)((Object)y)).getCurrentNode()), list, "not equal");
    }

    @Override
    public Predicate equal(Expression<?> x, Object y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().equal(y), list, "equal");
    }

    @Override
    public Predicate notEqual(Expression<?> x, Object y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().notEqual(y), list, "not equal");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().greaterThan(((InternalSelection)((Object)y)).getCurrentNode()), list, "greaterThan");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        if (((InternalSelection)((Object)x)).getCurrentNode() == null || ((InternalSelection)((Object)y)).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((InternalSelection)((Object)x)).getCurrentNode().lessThan(((InternalSelection)((Object)y)).getCurrentNode()), list, "lessThan");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate between(Expression<? extends Y> v, Expression<? extends Y> x, Expression<? extends Y> y) {
        if (((ExpressionImpl)x).getCurrentNode() == null || ((ExpressionImpl)y).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add(y);
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)y).getCurrentNode()), list, "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate greaterThan(Expression<? extends Y> x, Y y) {
        Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add((Expression<?>)((Object)y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThan");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate lessThan(Expression<? extends Y> x, Y y) {
        Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add((Expression<?>)((Object)y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThan(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThan");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add((Expression<?>)((Object)y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().greaterThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "greaterThanEqual");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        Expression<Y> expressionY = this.literal(y);
        if (((ExpressionImpl)x).getCurrentNode() == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("OPERATOR_EXPRESSION_IS_CONJUNCTION"));
        }
        ArrayList list = new ArrayList();
        list.add(x);
        list.add((Expression<?>)((Object)y));
        return new CompoundExpressionImpl(this.metamodel, ((ExpressionImpl)x).getCurrentNode().lessThanEqual(((ExpressionImpl)expressionY).getCurrentNode()), list, "lessThanEqual");
    }

    @Override
    public <Y extends Comparable<Y>> Predicate between(Expression<? extends Y> v, Y x, Y y) {
        return null;
    }

    protected List<Expression<?>> buildList(Expression<?> ... expressions) {
        ArrayList list = new ArrayList();
        for (Expression<?> exp : expressions) {
            list.add(exp);
        }
        return list;
    }

    @Override
    public Predicate gt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return null;
    }

    @Override
    public Predicate lt(Expression<? extends Number> x, Expression<? extends Number> y) {
        return null;
    }

    @Override
    public Predicate ge(Expression<? extends Number> x, Expression<? extends Number> y) {
        return null;
    }

    @Override
    public Predicate le(Expression<? extends Number> x, Expression<? extends Number> y) {
        return null;
    }

    @Override
    public Predicate gt(Expression<? extends Number> x, Number y) {
        return null;
    }

    @Override
    public Predicate lt(Expression<? extends Number> x, Number y) {
        return null;
    }

    @Override
    public Predicate ge(Expression<? extends Number> x, Number y) {
        return null;
    }

    @Override
    public Predicate le(Expression<? extends Number> x, Number y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> neg(Expression<N> x) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> abs(Expression<N> x) {
        return new FunctionExpressionImpl(this.metamodel, x.getJavaType(), ExpressionMath.abs(((InternalSelection)((Object)x)).getCurrentNode()), this.buildList(x), "ABS");
    }

    @Override
    public <N extends Number> Expression<N> sum(Expression<? extends N> x, Expression<? extends N> y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> prod(Expression<? extends N> x, Expression<? extends N> y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> diff(Expression<? extends N> x, Expression<? extends N> y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> sum(Expression<? extends N> x, N y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> prod(Expression<? extends N> x, N y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> diff(Expression<? extends N> x, N y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> sum(N x, Expression<? extends N> y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> prod(N x, Expression<? extends N> y) {
        return null;
    }

    @Override
    public <N extends Number> Expression<N> diff(N x, Expression<? extends N> y) {
        return null;
    }

    @Override
    public Expression<Number> quot(Expression<? extends Number> x, Expression<? extends Number> y) {
        return null;
    }

    @Override
    public Expression<Number> quot(Expression<? extends Number> x, Number y) {
        return null;
    }

    @Override
    public Expression<Number> quot(Number x, Expression<? extends Number> y) {
        return null;
    }

    @Override
    public Expression<Integer> mod(Expression<Integer> x, Expression<Integer> y) {
        return null;
    }

    @Override
    public Expression<Integer> mod(Expression<Integer> x, Integer y) {
        return null;
    }

    @Override
    public Expression<Integer> mod(Integer x, Expression<Integer> y) {
        return null;
    }

    @Override
    public Expression<Double> sqrt(Expression<? extends Number> x) {
        return null;
    }

    @Override
    public Expression<Long> toLong(Expression<? extends Number> number) {
        return null;
    }

    @Override
    public Expression<Integer> toInteger(Expression<? extends Number> number) {
        return null;
    }

    @Override
    public Expression<Float> toFloat(Expression<? extends Number> number) {
        return null;
    }

    @Override
    public Expression<Double> toDouble(Expression<? extends Number> number) {
        return null;
    }

    @Override
    public Expression<BigDecimal> toBigDecimal(Expression<? extends Number> number) {
        return null;
    }

    @Override
    public Expression<BigInteger> toBigInteger(Expression<? extends Number> number) {
        return null;
    }

    @Override
    public Expression<String> toString(Expression<Character> character) {
        return null;
    }

    @Override
    public <T> Expression<T> literal(T value) {
        return new ExpressionImpl(this.metamodel, value.getClass(), new ConstantExpression(value, new ExpressionBuilder()), value);
    }

    @Override
    public <T> Expression<T> nullLiteral(Class<T> resultClass) {
        return null;
    }

    @Override
    public <T> ParameterExpression<T> parameter(Class<T> paramClass) {
        return null;
    }

    @Override
    public <T> ParameterExpression<T> parameter(Class<T> paramClass, String name) {
        return new ParameterExpressionImpl<T>(this.metamodel, paramClass, name);
    }

    @Override
    public <C extends Collection<?>> Predicate isEmpty(Expression<C> collection) {
        return null;
    }

    @Override
    public <C extends Collection<?>> Predicate isNotEmpty(Expression<C> collection) {
        return null;
    }

    @Override
    public <C extends Collection<?>> Expression<Integer> size(C collection) {
        return null;
    }

    @Override
    public <C extends Collection<?>> Expression<Integer> size(Expression<C> collection) {
        return null;
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(E elem, Expression<C> collection) {
        return null;
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(E elem, Expression<C> collection) {
        return null;
    }

    @Override
    public <E, C extends Collection<E>> Predicate isMember(Expression<E> elem, Expression<C> collection) {
        return null;
    }

    @Override
    public <E, C extends Collection<E>> Predicate isNotMember(Expression<E> elem, Expression<C> collection) {
        return null;
    }

    @Override
    public <V, M extends Map<?, V>> Expression<Collection<V>> values(M map) {
        return null;
    }

    @Override
    public <K, M extends Map<K, ?>> Expression<Set<K>> keys(M map) {
        return null;
    }

    @Override
    public Predicate like(Expression<String> x, Expression<String> pattern) {
        return null;
    }

    @Override
    public Predicate like(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return null;
    }

    @Override
    public Predicate like(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return null;
    }

    @Override
    public Predicate like(Expression<String> x, String pattern) {
        return null;
    }

    @Override
    public Predicate like(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return null;
    }

    @Override
    public Predicate like(Expression<String> x, String pattern, char escapeChar) {
        return null;
    }

    @Override
    public Predicate notLike(Expression<String> x, Expression<String> pattern) {
        return null;
    }

    @Override
    public Predicate notLike(Expression<String> x, Expression<String> pattern, Expression<Character> escapeChar) {
        return null;
    }

    @Override
    public Predicate notLike(Expression<String> x, Expression<String> pattern, char escapeChar) {
        return null;
    }

    @Override
    public Predicate notLike(Expression<String> x, String pattern) {
        return null;
    }

    @Override
    public Predicate notLike(Expression<String> x, String pattern, Expression<Character> escapeChar) {
        return null;
    }

    @Override
    public Predicate notLike(Expression<String> x, String pattern, char escapeChar) {
        return null;
    }

    @Override
    public Expression<String> concat(Expression<String> x, Expression<String> y) {
        return null;
    }

    @Override
    public Expression<String> concat(Expression<String> x, String y) {
        return null;
    }

    @Override
    public Expression<String> concat(String x, Expression<String> y) {
        return null;
    }

    @Override
    public Expression<String> substring(Expression<String> x, Expression<Integer> from) {
        return null;
    }

    @Override
    public Expression<String> substring(Expression<String> x, int from) {
        return null;
    }

    @Override
    public Expression<String> substring(Expression<String> x, Expression<Integer> from, Expression<Integer> len) {
        return null;
    }

    @Override
    public Expression<String> substring(Expression<String> x, int from, int len) {
        return null;
    }

    @Override
    public Expression<String> trim(Expression<String> x) {
        return null;
    }

    @Override
    public Expression<String> trim(QueryBuilder.Trimspec ts, Expression<String> x) {
        return null;
    }

    @Override
    public Expression<String> trim(Expression<Character> t, Expression<String> x) {
        return null;
    }

    @Override
    public Expression<String> trim(QueryBuilder.Trimspec ts, Expression<Character> t, Expression<String> x) {
        return null;
    }

    @Override
    public Expression<String> trim(char t, Expression<String> x) {
        return null;
    }

    @Override
    public Expression<String> trim(QueryBuilder.Trimspec ts, char t, Expression<String> x) {
        return null;
    }

    @Override
    public Expression<String> lower(Expression<String> x) {
        return null;
    }

    @Override
    public Expression<String> upper(Expression<String> x) {
        return null;
    }

    @Override
    public Expression<Integer> length(Expression<String> x) {
        return null;
    }

    @Override
    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern) {
        return null;
    }

    @Override
    public Expression<Integer> locate(Expression<String> x, Expression<String> pattern, Expression<Integer> from) {
        return null;
    }

    @Override
    public Expression<Integer> locate(Expression<String> x, String pattern) {
        return null;
    }

    @Override
    public Expression<Integer> locate(Expression<String> x, String pattern, int from) {
        return null;
    }

    @Override
    public Expression<Date> currentDate() {
        return null;
    }

    @Override
    public Expression<Timestamp> currentTimestamp() {
        return null;
    }

    @Override
    public Expression<Time> currentTime() {
        return null;
    }

    @Override
    public <T> QueryBuilder.In<T> in(Expression<? extends T> expression) {
        return null;
    }

    @Override
    public <Y> Expression<Y> coalesce(Expression<? extends Y> x, Expression<? extends Y> y) {
        return null;
    }

    @Override
    public <Y> Expression<Y> coalesce(Expression<? extends Y> x, Y y) {
        return null;
    }

    @Override
    public <Y> Expression<Y> nullif(Expression<Y> x, Expression<?> y) {
        return null;
    }

    @Override
    public <Y> Expression<Y> nullif(Expression<Y> x, Y y) {
        return null;
    }

    @Override
    public <T> QueryBuilder.Coalesce<T> coalesce() {
        return null;
    }

    @Override
    public <C, R> QueryBuilder.SimpleCase<C, R> selectCase(Expression<? extends C> expression) {
        return null;
    }

    @Override
    public <R> QueryBuilder.Case<R> selectCase() {
        return null;
    }

    @Override
    public <T> Expression<T> function(String name, Class<T> type, Expression<?> ... args) {
        return null;
    }
}

