/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.namespaces;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackUnmarshalNamespaceResolver
implements UnmarshalNamespaceResolver {
    private Map<String, Stack<String>> namespaceMap = new HashMap<String, Stack<String>>();
    private Map<String, Stack<String>> uriToPrefixMap = new HashMap<String, Stack<String>>();

    @Override
    public String getPrefix(String namespaceURI) {
        Stack<String> prefixStack;
        String prefix = null;
        if (null == prefix && (prefixStack = this.uriToPrefixMap.get(namespaceURI)) != null && prefixStack.size() > 0) {
            prefix = prefixStack.peek();
        }
        return prefix;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        Stack<String> uriStack;
        String namespaceURI = null;
        if (prefix == null) {
            prefix = "";
        }
        if ((uriStack = this.namespaceMap.get(prefix)) != null && uriStack.size() > 0) {
            namespaceURI = uriStack.peek();
        }
        return namespaceURI;
    }

    @Override
    public void pop(String prefix) {
        Stack<String> prefixStack;
        String uri;
        Stack<String> uriStack = this.namespaceMap.get(prefix);
        if (uriStack != null && uriStack.size() > 0 && (uri = uriStack.pop()) != null && (prefixStack = this.uriToPrefixMap.get(uri)) != null && prefixStack.size() > 0) {
            prefixStack.pop();
        }
    }

    @Override
    public void push(String prefix, String namespaceURI) {
        Stack<String> uriStack = this.namespaceMap.get(prefix);
        if (uriStack == null) {
            uriStack = new Stack();
            this.namespaceMap.put(prefix, uriStack);
        }
        uriStack.push(namespaceURI);
        Stack<String> prefixStack = this.uriToPrefixMap.get(namespaceURI);
        if (prefixStack == null) {
            prefixStack = new Stack();
            this.uriToPrefixMap.put(namespaceURI, prefixStack);
        }
        prefixStack.push(prefix);
    }

    @Override
    public Set<String> getPrefixes() {
        return this.namespaceMap.keySet();
    }
}

