/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.AttributeDetails;
import org.eclipse.persistence.internal.weaving.ClassDetails;
import org.eclipse.persistence.internal.weaving.ClassWeaver;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeaver;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;

public class TransformerFactory {
    public static final String WEAVER_DISABLE_CT_NOT_SUPPORTED = "weaver_change_tracking_disabled_not_supported";
    public static final String WEAVER_FOUND_USER_IMPL_CT = "weaver_user_impl_change_tracking";
    public static final String WEAVER_NULL_PROJECT = "weaver_null_project";
    public static final String WEAVER_DISABLE_BY_SYSPROP = "weaver_disable_by_system_property";
    public static final String WEAVER_CLASS_NOT_IN_PROJECT = "weaver_class_not_in_project";
    public static final String WEAVER_PROCESSING_CLASS = "weaver_processing_class";
    public static final String CANNOT_WEAVE_CHANGETRACKING = "cannot_weave_changetracking";
    protected Session session;
    protected Collection entityClasses;
    protected Map classDetailsMap;
    protected ClassLoader classLoader;
    protected boolean weaveChangeTracking;
    protected boolean weaveLazy;
    protected boolean weaveFetchGroups;
    protected boolean weaveInternal;

    public static PersistenceWeaver createTransformerAndModifyProject(Session session, Collection entityClasses, ClassLoader classLoader, boolean weaveLazy, boolean weaveChangeTracking, boolean weaveFetchGroups, boolean weaveInternal) {
        if (session == null) {
            throw new IllegalArgumentException("Weaver session cannot be null");
        }
        if (session.getProject() == null) {
            ((AbstractSession)session).log(7, "weaver", WEAVER_NULL_PROJECT, null);
            throw new IllegalArgumentException("Weaver session's project cannot be null");
        }
        TransformerFactory tf = new TransformerFactory(session, entityClasses, classLoader, weaveLazy, weaveChangeTracking, weaveFetchGroups, weaveInternal);
        tf.buildClassDetailsAndModifyProject();
        return tf.buildPersistenceWeaver();
    }

    public TransformerFactory(Session session, Collection entityClasses, ClassLoader classLoader, boolean weaveLazy, boolean weaveChangeTracking, boolean weaveFetchGroups, boolean weaveInternal) {
        this.session = session;
        this.entityClasses = entityClasses;
        this.classLoader = classLoader;
        this.classDetailsMap = new HashMap();
        this.weaveLazy = weaveLazy;
        this.weaveChangeTracking = weaveChangeTracking;
        this.weaveFetchGroups = weaveFetchGroups;
        this.weaveInternal = weaveInternal;
    }

    public void addClassDetailsForMappedSuperClasses(Class clz, ClassDescriptor initialDescriptor, ClassDetails classDetails, Map classDetailsMap, List unMappedAttributes, boolean weaveChangeTracking) {
        if (initialDescriptor.getInheritancePolicyOrNull() != null && initialDescriptor.getInheritancePolicyOrNull().getParentClass() != null) {
            return;
        }
        if (unMappedAttributes.isEmpty()) {
            return;
        }
        Class superClz = clz.getSuperclass();
        if (superClz == null || superClz == Object.class) {
            return;
        }
        boolean weaveValueHolders = this.canWeaveValueHolders(superClz, unMappedAttributes);
        List stillUnMappedMappings = null;
        ClassDetails superClassDetails = this.createClassDetails(superClz, weaveValueHolders, weaveChangeTracking, this.weaveFetchGroups, this.weaveInternal);
        superClassDetails.setIsMappedSuperClass(true);
        if (!classDetailsMap.containsKey(superClassDetails.getClassName())) {
            stillUnMappedMappings = this.storeAttributeMappings(superClz, superClassDetails, unMappedAttributes, weaveValueHolders);
            classDetailsMap.put(superClassDetails.getClassName(), superClassDetails);
        }
        if (stillUnMappedMappings != null && stillUnMappedMappings.size() > 0) {
            this.addClassDetailsForMappedSuperClasses(superClz, initialDescriptor, classDetails, classDetailsMap, stillUnMappedMappings, weaveChangeTracking);
        }
    }

    public PersistenceWeaver buildPersistenceWeaver() {
        return new PersistenceWeaver(this.session, this.classDetailsMap);
    }

    public void buildClassDetailsAndModifyProject() {
        if (this.entityClasses != null && this.entityClasses.size() > 0) {
            for (Class clz : this.entityClasses) {
                ClassDescriptor descriptor = this.findDescriptor(this.session.getProject(), clz.getName());
                if (descriptor == null) {
                    this.log(2, WEAVER_CLASS_NOT_IN_PROJECT, new Object[]{clz.getName()});
                    continue;
                }
                this.log(2, WEAVER_PROCESSING_CLASS, new Object[]{clz.getName()});
                boolean weaveValueHoldersForClass = this.weaveLazy && this.canWeaveValueHolders(clz, descriptor.getMappings());
                boolean weaveChangeTrackingForClass = this.canChangeTrackingBeEnabled(descriptor, clz, this.weaveChangeTracking);
                ClassDetails classDetails = this.createClassDetails(clz, weaveValueHoldersForClass, weaveChangeTrackingForClass, this.weaveFetchGroups, this.weaveInternal);
                if (descriptor.isAggregateDescriptor()) {
                    classDetails.setIsEmbedable(true);
                    classDetails.setShouldWeaveFetchGroups(false);
                }
                List unMappedAttributes = this.storeAttributeMappings(clz, classDetails, descriptor.getMappings(), weaveValueHoldersForClass);
                this.classDetailsMap.put(classDetails.getClassName(), classDetails);
                if (!unMappedAttributes.isEmpty()) {
                    this.addClassDetailsForMappedSuperClasses(clz, descriptor, classDetails, this.classDetailsMap, unMappedAttributes, this.weaveChangeTracking);
                }
                if (classDetails.getLazyMappings() == null) continue;
                for (ForeignReferenceMapping foreignReferenceMapping : classDetails.getLazyMappings()) {
                    foreignReferenceMapping.setGetMethodName(ClassWeaver.getWeavedValueHolderGetMethodName(foreignReferenceMapping.getAttributeName()));
                    foreignReferenceMapping.setSetMethodName(ClassWeaver.getWeavedValueHolderSetMethodName(foreignReferenceMapping.getAttributeName()));
                }
            }
            for (ClassDetails classDetails : this.classDetailsMap.values()) {
                ClassDescriptor descriptor;
                ClassDetails superClassDetails = (ClassDetails)this.classDetailsMap.get(classDetails.getSuperClassName());
                if (superClassDetails == null && (descriptor = this.findDescriptor(this.session.getProject(), classDetails.getClassName())) != null && descriptor.hasInheritance()) {
                    superClassDetails = (ClassDetails)this.classDetailsMap.get(descriptor.getInheritancePolicy().getParentClassName());
                }
                if (superClassDetails == null) continue;
                classDetails.setSuperClassDetails(superClassDetails);
            }
            for (ClassDetails classDetails : this.classDetailsMap.values()) {
                classDetails.setShouldWeaveChangeTracking(classDetails.canWeaveChangeTracking());
            }
        }
    }

    protected boolean canChangeTrackingBeEnabled(ClassDescriptor descriptor, Class clz, boolean globalWeaveChangeTracking) {
        boolean canWeaveChangeTracking;
        if (!globalWeaveChangeTracking) {
            return false;
        }
        if (descriptor.getObjectChangePolicyInternal() != null) {
            if (descriptor.getObjectChangePolicyInternal().isDeferredChangeDetectionPolicy()) {
                return false;
            }
            if (descriptor.getObjectChangePolicyInternal().isObjectChangeTrackingPolicy()) {
                return true;
            }
        }
        if (!(canWeaveChangeTracking = descriptor.supportsChangeTracking(this.session.getProject()))) {
            this.log(4, CANNOT_WEAVE_CHANGETRACKING, new Object[]{descriptor.getJavaClassName()});
        }
        return canWeaveChangeTracking;
    }

    protected boolean wasChangeTrackingAlreadyWeaved(Class clz) {
        Class<?>[] interfaces = clz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> c = interfaces[i];
            if (!c.getName().equals(PersistenceWeavedChangeTracking.class.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean canWeaveValueHolders(Class clz, List mappings) {
        boolean weaveValueHolders = false;
        for (DatabaseMapping mapping : mappings) {
            String attributeName = mapping.getAttributeName();
            if (!mapping.isForeignReferenceMapping()) continue;
            ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)mapping;
            Class typeClass = this.getAttributeTypeFromClass(clz, attributeName, foreignReferenceMapping, true);
            if (!(foreignReferenceMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy) || typeClass == null || ValueHolderInterface.class.isAssignableFrom(typeClass)) continue;
            weaveValueHolders = true;
        }
        return weaveValueHolders;
    }

    private ClassDetails createClassDetails(Class clz, boolean weaveValueHolders, boolean weaveChangeTracking, boolean weaveFetchGroups, boolean weaveInternal) {
        String className = Helper.toSlashedClassName(clz.getName());
        String superClassName = Helper.toSlashedClassName(clz.getSuperclass().getName());
        ClassDetails classDetails = new ClassDetails();
        classDetails.setDescribedClass(clz);
        classDetails.setClassName(className);
        classDetails.setSuperClassName(superClassName);
        classDetails.setShouldWeaveValueHolders(weaveValueHolders);
        classDetails.setShouldWeaveChangeTracking(weaveChangeTracking);
        classDetails.setShouldWeaveFetchGroups(weaveFetchGroups);
        classDetails.setShouldWeaveInternal(weaveInternal);
        Method method = null;
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(clz, "clone", null));
                }
                catch (PrivilegedActionException exception) {}
            } else {
                method = PrivilegedAccessHelper.getDeclaredMethod(clz, "clone", null);
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        classDetails.setImplementsCloneMethod(method != null);
        return classDetails;
    }

    protected ClassDescriptor findDescriptor(Project project, String className) {
        for (ClassDescriptor descriptor : project.getOrderedDescriptors()) {
            if (!descriptor.getJavaClassName().equals(className)) continue;
            return descriptor;
        }
        return null;
    }

    protected boolean hasFieldInClass(Class clz, String attributeName) {
        try {
            Field field = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clz, attributeName, false));
                }
                catch (PrivilegedActionException ignore) {}
            } else {
                field = PrivilegedAccessHelper.getField(clz, attributeName, false);
            }
            return field != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Class getAttributeDeclaringClass(Class theClass, String attributeName) {
        try {
            Field field = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    field = (Field)AccessController.doPrivileged(new PrivilegedGetField(theClass, attributeName, false));
                }
                catch (PrivilegedActionException exception) {}
            } else {
                field = PrivilegedAccessHelper.getField(theClass, attributeName, false);
            }
            return field.getDeclaringClass();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Class getAttributeTypeFromClass(Class clz, String attributeName, DatabaseMapping mapping, boolean checkSuperclass) {
        String getterMethod = mapping.getGetMethodName();
        if (mapping != null && getterMethod != null) {
            try {
                Method method = null;
                if (checkSuperclass) {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            method = AccessController.doPrivileged(new PrivilegedGetMethod(clz, getterMethod, null, false));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        method = PrivilegedAccessHelper.getMethod(clz, getterMethod, null, false);
                    }
                } else {
                    method = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            method = (Method)AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(clz, getterMethod, null));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        method = PrivilegedAccessHelper.getDeclaredMethod(clz, getterMethod, null);
                    }
                }
                if (method != null) {
                    return method.getReturnType();
                }
            }
            catch (Exception e) {}
        } else {
            try {
                Class<?> typeClz = null;
                if (checkSuperclass) {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetField(clz, attributeName, false));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        field = PrivilegedAccessHelper.getField(clz, attributeName, false);
                    }
                    typeClz = field.getType();
                } else {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetDeclaredField(clz, attributeName, false));
                        }
                        catch (PrivilegedActionException exception) {}
                    } else {
                        field = PrivilegedAccessHelper.getDeclaredField(clz, attributeName, false);
                    }
                    typeClz = field.getType();
                }
                if (typeClz != null) {
                    return typeClz;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    protected List storeAttributeMappings(Class clz, ClassDetails classDetails, List mappings, boolean weaveValueHolders) {
        ArrayList<DatabaseMapping> unMappedAttributes = new ArrayList<DatabaseMapping>();
        HashMap<String, AttributeDetails> attributesMap = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> settersMap = new HashMap<String, AttributeDetails>();
        HashMap<String, AttributeDetails> gettersMap = new HashMap<String, AttributeDetails>();
        ArrayList<DatabaseMapping> lazyMappings = new ArrayList<DatabaseMapping>();
        for (DatabaseMapping mapping : mappings) {
            String attribute = mapping.getAttributeName();
            AttributeDetails attributeDetails = new AttributeDetails(attribute, mapping);
            Class typeClass = this.getAttributeTypeFromClass(clz, attribute, mapping, false);
            if (typeClass == null) {
                attributeDetails.setAttributeOnSuperClass(true);
                unMappedAttributes.add(mapping);
            }
            if (mapping.getGetMethodName() != null) {
                gettersMap.put(mapping.getGetMethodName(), attributeDetails);
                attributeDetails.setGetterMethodName(mapping.getGetMethodName());
                if (mapping.getSetMethodName() != null) {
                    settersMap.put(mapping.getSetMethodName(), attributeDetails);
                    attributeDetails.setSetterMethodName(mapping.getSetMethodName());
                }
                if (mapping.isForeignReferenceMapping() && ((ForeignReferenceMapping)mapping).requiresTransientWeavedFields()) {
                    attributeDetails.setWeaveTransientFieldValueHolders();
                }
                if (this.weaveInternal) {
                    attributeDetails.setHasField(this.hasFieldInClass(clz, attribute));
                }
            } else {
                attributeDetails.setHasField(true);
            }
            if (attributeDetails.hasField()) {
                attributeDetails.setDeclaringType(Type.getType(this.getAttributeDeclaringClass(clz, attribute)));
            }
            if (mapping.isForeignReferenceMapping()) {
                ForeignReferenceMapping foreignReferenceMapping = (ForeignReferenceMapping)mapping;
                attributeDetails.setReferenceClassName(foreignReferenceMapping.getReferenceClassName());
                Class referenceClass = null;
                if (attributeDetails.getReferenceClassName() != null) {
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                referenceClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(attributeDetails.getReferenceClassName(), true, this.classLoader));
                            }
                            catch (PrivilegedActionException exception) {}
                        } else {
                            referenceClass = PrivilegedAccessHelper.getClassForName(attributeDetails.getReferenceClassName(), true, this.classLoader);
                        }
                    }
                    catch (ClassNotFoundException exception) {
                        // empty catch block
                    }
                    attributeDetails.setReferenceClassType(Type.getType(referenceClass));
                }
                if (typeClass == null) {
                    typeClass = this.getAttributeTypeFromClass(clz, attribute, foreignReferenceMapping, true);
                }
                if (weaveValueHolders && foreignReferenceMapping.getIndirectionPolicy() instanceof BasicIndirectionPolicy && typeClass != null && !ValueHolderInterface.class.isAssignableFrom(typeClass)) {
                    lazyMappings.add(foreignReferenceMapping);
                    attributeDetails.weaveVH(weaveValueHolders, foreignReferenceMapping);
                }
            }
            if (attributeDetails.getReferenceClassType() == null && typeClass == null) {
                typeClass = this.getAttributeTypeFromClass(clz, attribute, mapping, true);
            }
            if (typeClass != null) {
                attributeDetails.setReferenceClassName(typeClass.getName());
                attributeDetails.setReferenceClassType(Type.getType(typeClass));
            }
            attributesMap.put(attribute, attributeDetails);
        }
        classDetails.setAttributesMap(attributesMap);
        classDetails.setGetterMethodToAttributeDetails(gettersMap);
        classDetails.setSetterMethodToAttributeDetails(settersMap);
        classDetails.setLazyMappings(lazyMappings);
        return unMappedAttributes;
    }

    protected void log(int level, String msg, Object[] params) {
        ((AbstractSession)this.session).log(level, "weaver", msg, params);
    }
}

