/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver
implements XMLNamespaceResolver {
    private static final String BASE_PREFIX = "ns";
    private String defaultNamespaceURI;
    private Map<String, String> prefixesToNamespaces = new HashMap<String, String>();
    int prefixCounter;
    private Node dom;

    public void setDOM(Node dom) {
        this.dom = dom;
    }

    public String resolveNamespacePrefix(String prefix) {
        if (null == prefix) {
            return this.defaultNamespaceURI;
        }
        String uri = this.prefixesToNamespaces.get(prefix);
        if (null != uri) {
            return uri;
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    public String resolveNamespaceURI(String uri) {
        if (null == uri) {
            return null;
        }
        for (Map.Entry<String, String> entry : this.prefixesToNamespaces.entrySet()) {
            if (!uri.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri.equalsIgnoreCase("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        return this.resolveNamespaceURI(this.dom, uri);
    }

    private String resolveNamespaceURI(Node node, String uri) {
        if (null == node) {
            return null;
        }
        if (uri.equals(node.getNamespaceURI())) {
            return node.getPrefix();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (null != namedNodeMap) {
            int namedNodeMapSize = namedNodeMap.getLength();
            for (int x = 0; x < namedNodeMapSize; ++x) {
                Node attr = namedNodeMap.item(x);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) || !uri.equals(attr.getNodeValue())) continue;
                return attr.getLocalName();
            }
        }
        return this.resolveNamespaceURI(node.getParentNode(), uri);
    }

    public void put(String prefix, String namespaceURI) {
        this.prefixesToNamespaces.put(prefix, namespaceURI.intern());
    }

    public Enumeration getPrefixes() {
        return new IteratorEnumeration(this.prefixesToNamespaces.keySet().iterator());
    }

    public Vector getNamespaces() {
        Vector<Namespace> names = new Vector<Namespace>(this.prefixesToNamespaces.size());
        for (Map.Entry<String, String> entry : this.prefixesToNamespaces.entrySet()) {
            Namespace namespace = new Namespace(entry.getKey(), entry.getValue());
            names.addElement(namespace);
        }
        return names;
    }

    public void setNamespaces(Vector names) {
        this.prefixesToNamespaces = new HashMap<String, String>(names.size());
        for (Namespace namespace : names) {
            if (namespace.getPrefix() == null || namespace.getNamespaceURI() == null) continue;
            this.prefixesToNamespaces.put(namespace.getPrefix(), namespace.getNamespaceURI());
        }
    }

    public String generatePrefix() {
        return this.generatePrefix(this.getNextPrefix());
    }

    private String getNextPrefix() {
        return BASE_PREFIX + this.prefixCounter++;
    }

    public String generatePrefix(String defaultPrefix) {
        String lookup = this.resolveNamespacePrefix(defaultPrefix);
        while (lookup != null) {
            defaultPrefix = this.getNextPrefix();
            lookup = this.resolveNamespacePrefix(defaultPrefix);
        }
        return defaultPrefix;
    }

    public void removeNamespace(String prefix) {
        this.prefixesToNamespaces.remove(prefix);
    }

    public void setDefaultNamespaceURI(String namespaceUri) {
        this.defaultNamespaceURI = namespaceUri;
    }

    public String getDefaultNamespaceURI() {
        return this.defaultNamespaceURI;
    }

    private static class IteratorEnumeration
    implements Enumeration {
        private Iterator iterator;

        public IteratorEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }
}

