/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.QueryBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractQueryImpl<T>
implements AbstractQuery<T> {
    protected Metamodel metamodel;
    protected Set<Root<?>> roots = new HashSet();
    protected Expression<Boolean> where;
    protected ResultType queryResult;
    protected QueryBuilderImpl queryBuilder;
    protected boolean distinct;
    protected List<Expression<?>> stupidImplicitDanglingJoins;
    protected Class queryType;
    protected ExpressionImpl havingClause;
    protected ExpressionImpl groupBy;

    public AbstractQueryImpl(Metamodel metamodel, ResultType queryResult, QueryBuilderImpl queryBuilder, Class<T> resultType) {
        this.metamodel = metamodel;
        this.queryResult = queryResult;
        this.queryBuilder = queryBuilder;
        this.queryType = resultType;
    }

    public <X> Root<X> from(EntityType<X> entity) {
        RootImpl root = new RootImpl((ManagedType)entity, this.metamodel, entity.getBindableJavaType(), (org.eclipse.persistence.expressions.Expression)new ExpressionBuilder(entity.getBindableJavaType()), (Bindable)entity);
        this.roots.add(root);
        return root;
    }

    public <X> Root<X> from(Class<X> entityClass) {
        EntityType entity = this.metamodel.entity(entityClass);
        return this.from(entity);
    }

    public Class<T> getResultType() {
        return this.queryType;
    }

    public Set<Root<?>> getRoots() {
        return this.roots;
    }

    public AbstractQuery<T> where(Expression<Boolean> restriction) {
        this.validateRoot(restriction);
        this.where = restriction;
        return this;
    }

    public AbstractQuery<T> where(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.where = null;
        }
        Predicate predicate = this.queryBuilder.and(restrictions);
        this.validateRoot((Expression<?>)predicate);
        this.where = predicate;
        return this;
    }

    public AbstractQuery<T> groupBy(List<Expression<?>> grouping) {
        throw new UnsupportedOperationException();
    }

    public AbstractQuery<T> groupBy(Expression<?> ... grouping) {
        throw new UnsupportedOperationException();
    }

    public AbstractQuery<T> having(Expression<Boolean> restriction) {
        throw new UnsupportedOperationException();
    }

    public AbstractQuery<T> having(Predicate ... restrictions) {
        throw new UnsupportedOperationException();
    }

    public AbstractQuery<T> distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public Selection<T> getSelection() {
        throw new UnsupportedOperationException();
    }

    public List<Expression<?>> getGroupList() {
        throw new UnsupportedOperationException();
    }

    public Predicate getRestriction() {
        throw new UnsupportedOperationException();
    }

    public Predicate getGroupRestriction() {
        throw new UnsupportedOperationException();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        return new SubQueryImpl(this.metamodel, type, this.queryBuilder, this);
    }

    protected void validateRoot(Expression<?> predicate) {
        HashSet newRoots = new HashSet();
        ((InternalSelection)predicate).findRoot(newRoots);
        for (Root root : newRoots) {
            if (this.roots.contains(root)) continue;
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"EXPRESSION_USES_UNKOWN_ROOT_TODO"));
        }
    }

    protected void validateRoot(Selection<?> selection) {
        if (selection.isCompoundSelection()) {
            for (Selection subSelection : selection.getCompoundSelectionItems()) {
                this.validateRoot(subSelection);
            }
        } else {
            this.validateRoot((Expression)selection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ResultType {
        OBJECT_ARRAY,
        PARTIAL,
        TUPLE,
        ENTITY,
        CONSTRUCTOR,
        OTHER;

    }
}

