/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.SetJoin;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.BasicCollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicMapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.BasicSetJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromImpl<Z, X>
extends PathImpl<X>
implements From<Z, X> {
    protected ManagedType managedType;
    protected Set<Join<X, ?>> joins;
    protected Set<Fetch<X, ?>> fetches;

    public <T> FromImpl(Path<Z> parentPath, ManagedType managedType, Metamodel metamodel, Class<X> javaClass, Expression expressionNode, Bindable<T> modelArtifact) {
        super(parentPath, metamodel, javaClass, expressionNode, modelArtifact);
        this.managedType = managedType;
        this.joins = new HashSet();
        this.fetches = new HashSet();
    }

    public Set<Fetch<X, ?>> getFetches() {
        return this.fetches;
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    public <Y> Fetch<X, Y> fetch(SingularAttribute<? super X, Y> assoc, JoinType jt) {
        if (assoc.getType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC)) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"CAN_NOT_JOIN_TO_BASIC"));
        }
        Class clazz = assoc.getBindableJavaType();
        JoinImpl join = null;
        if (jt.equals((Object)JoinType.LEFT)) {
            join = new JoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, this.currentNode.getAllowingNull(assoc.getName()), assoc, jt);
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
            }
            join = new JoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, this.currentNode.get(assoc.getName()), assoc, jt);
        }
        this.fetches.add(join);
        return join;
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc) {
        return this.fetch(assoc, JoinType.INNER);
    }

    public <Y> Fetch<X, Y> fetch(PluralAttribute<? super X, ?, Y> assoc, JoinType jt) {
        Expression node;
        if (jt.equals((Object)JoinType.LEFT)) {
            node = this.currentNode.anyOfAllowingNone(assoc.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOf(assoc.getName());
        }
        JoinImpl fetch = assoc.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new BasicCollectionJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new BasicListJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new BasicSetJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc) : new BasicMapJoinImpl(this, this.metamodel, assoc.getBindableJavaType(), node, assoc)))) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new CollectionJoinImpl(this, this.metamodel.type(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new ListJoinImpl(this, this.metamodel.type(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc) : (assoc.getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new SetJoinImpl(this, this.metamodel.type(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc) : new MapJoinImpl(this, this.metamodel.type(assoc.getBindableJavaType()), this.metamodel, assoc.getBindableJavaType(), node, assoc))));
        this.fetches.add(fetch);
        return fetch;
    }

    public <X, Y> Fetch<X, Y> fetch(String assocName) {
        return this.fetch(assocName, JoinType.INNER);
    }

    public <X, Y> Fetch<X, Y> fetch(String assocName, JoinType jt) {
        Attribute attribute = this.managedType.getAttribute(assocName);
        if (attribute.isCollection()) {
            return this.fetch((PluralAttribute)attribute, jt);
        }
        return this.fetch((SingularAttribute)attribute, jt);
    }

    public Set<Join<X, ?>> getJoins() {
        return this.joins;
    }

    @Override
    public <Y> Path<Y> get(SingularAttribute<? super X, Y> att) {
        if (att.getPersistentAttributeType().equals((Object)Attribute.PersistentAttributeType.BASIC)) {
            return new PathImpl(this, this.metamodel, att.getBindableJavaType(), this.currentNode.get(att.getName()), (Bindable)att);
        }
        Class clazz = att.getBindableJavaType();
        JoinImpl join = new JoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, this.currentNode.get(att.getName()), att);
        this.joins.add(join);
        return join;
    }

    @Override
    public <E, C extends Collection<E>> javax.persistence.criteria.Expression<C> get(PluralAttribute<X, C, E> collection) {
        return new ExpressionImpl(this.metamodel, ClassConstants.Collection_Class, this.currentNode.anyOf(collection.getName()));
    }

    @Override
    public <K, V, M extends Map<K, V>> javax.persistence.criteria.Expression<M> get(MapAttribute<X, K, V> map) {
        return new ExpressionImpl(this.metamodel, ClassConstants.Map_Class, this.currentNode.anyOf(map.getName()));
    }

    @Override
    public javax.persistence.criteria.Expression<Class<? extends X>> type() {
        return new ExpressionImpl<Class<? extends X>>(this.metamodel, ClassConstants.CLASS, this.currentNode.type());
    }

    @Override
    public <Y> Path<Y> get(String attName) {
        JoinImpl join;
        Attribute attribute = this.managedType.getAttribute(attName);
        if (attribute.isCollection()) {
            join = !((PluralAttribute)attribute).getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new CollectionJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new ListJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new SetJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : new MapJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute)))) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new BasicCollectionJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new BasicListJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new BasicSetJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute) : new BasicMapJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), this.currentNode.anyOf(attribute.getName()), (Bindable)attribute))));
        } else {
            Class clazz = ((SingularAttribute)attribute).getBindableJavaType();
            if (((SingularAttribute)attribute).getType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC)) {
                return new PathImpl(this, this.metamodel, clazz, this.currentNode.get(attribute.getName()), (Bindable)attribute);
            }
            join = new JoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, this.currentNode.get(attribute.getName()), (Bindable)attribute);
        }
        this.joins.add(join);
        return join;
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    public <Y> Join<X, Y> join(SingularAttribute<? super X, Y> attribute, JoinType jt) {
        if (attribute.getType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC)) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"CAN_NOT_JOIN_TO_BASIC"));
        }
        Class clazz = attribute.getBindableJavaType();
        JoinImpl join = null;
        if (jt.equals((Object)JoinType.LEFT)) {
            join = new JoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, this.currentNode.getAllowingNull(attribute.getName()), attribute, jt);
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
            }
            join = new JoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, this.currentNode.get(attribute.getName()), attribute, jt);
        }
        this.joins.add(join);
        return join;
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection) {
        return this.join(collection, JoinType.INNER);
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set) {
        return this.join(set, JoinType.INNER);
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list) {
        return this.join(list, JoinType.INNER);
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map) {
        return this.join(map, JoinType.INNER);
    }

    public <Y> CollectionJoin<X, Y> join(CollectionAttribute<? super X, Y> collection, JoinType jt) {
        Expression node;
        Class clazz = collection.getBindableJavaType();
        CollectionJoinImpl join = null;
        if (jt.equals((Object)JoinType.LEFT)) {
            node = this.currentNode.anyOf(collection.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(collection.getName());
        }
        join = collection.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicCollectionJoinImpl(this, this.metamodel, clazz, node, collection) : new CollectionJoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, node, collection);
        this.joins.add(join);
        return join;
    }

    public <Y> SetJoin<X, Y> join(SetAttribute<? super X, Y> set, JoinType jt) {
        Expression node;
        Class clazz = set.getBindableJavaType();
        SetJoinImpl join = null;
        if (jt.equals((Object)JoinType.LEFT)) {
            node = this.currentNode.anyOf(set.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(set.getName());
        }
        join = set.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicSetJoinImpl(this, this.metamodel, clazz, node, set) : new SetJoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, node, set);
        this.joins.add(join);
        return join;
    }

    public <Y> ListJoin<X, Y> join(ListAttribute<? super X, Y> list, JoinType jt) {
        Expression node;
        Class clazz = list.getBindableJavaType();
        ListJoinImpl join = null;
        if (jt.equals((Object)JoinType.LEFT)) {
            node = this.currentNode.anyOf(list.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(list.getName());
        }
        join = list.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicListJoinImpl(this, this.metamodel, clazz, node, list) : new ListJoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, node, list);
        this.joins.add(join);
        return join;
    }

    public <K, V> MapJoin<X, K, V> join(MapAttribute<? super X, K, V> map, JoinType jt) {
        Expression node;
        Class clazz = map.getBindableJavaType();
        MapJoinImpl join = null;
        if (jt.equals((Object)JoinType.LEFT)) {
            node = this.currentNode.anyOf(map.getName());
        } else {
            if (jt.equals((Object)JoinType.RIGHT)) {
                throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
            }
            node = this.currentNode.anyOfAllowingNone(map.getName());
        }
        join = map.getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? new BasicMapJoinImpl(this, this.metamodel, clazz, node, map) : new MapJoinImpl(this, this.metamodel.type(clazz), this.metamodel, clazz, node, map);
        this.joins.add(join);
        return join;
    }

    public <X, Y> Join<X, Y> join(String attributeName) {
        return this.join(attributeName, JoinType.INNER);
    }

    public <X, Y> Join<X, Y> join(String attributeName, JoinType jt) {
        Attribute attribute = this.managedType.getAttribute(attributeName);
        if (attribute.isCollection()) {
            Expression node;
            if (jt.equals((Object)JoinType.LEFT)) {
                node = this.currentNode.anyOf(((PluralAttribute)attribute).getName());
            } else {
                if (jt.equals((Object)JoinType.RIGHT)) {
                    throw new UnsupportedOperationException(ExceptionLocalization.buildMessage((String)"RIGHT_JOIN_NOT_SUPPORTED"));
                }
                node = this.currentNode.anyOfAllowingNone(((PluralAttribute)attribute).getName());
            }
            JoinImpl join = ((PluralAttribute)attribute).getElementType().getPersistenceType().equals((Object)Type.PersistenceType.BASIC) ? (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new BasicCollectionJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new BasicListJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new BasicSetJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute) : new BasicMapJoinImpl(this, this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute)))) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.COLLECTION) ? new CollectionJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.LIST) ? new ListJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute) : (((PluralAttribute)attribute).getCollectionType().equals((Object)PluralAttribute.CollectionType.SET) ? new SetJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute) : new MapJoinImpl(this, this.metamodel.type(((PluralAttribute)attribute).getBindableJavaType()), this.metamodel, ((PluralAttribute)attribute).getBindableJavaType(), node, (Bindable)attribute))));
            this.joins.add(join);
            return join;
        }
        return this.join((SingularAttribute)attribute, jt);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attributeName) {
        return this.joinCollection(attributeName, JoinType.INNER);
    }

    public <X, Y> CollectionJoin<X, Y> joinCollection(String attributeName, JoinType jt) {
        try {
            return (CollectionJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_attribute_not_collection", (Object[])new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }

    public <X, Y> ListJoin<X, Y> joinList(String attributeName) {
        return this.joinList(attributeName, JoinType.INNER);
    }

    public <X, Y> ListJoin<X, Y> joinList(String attributeName, JoinType jt) {
        try {
            return (ListJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_attribute_not_list", (Object[])new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }

    public <X, K, Y> MapJoin<X, K, Y> joinMap(String attributeName) {
        return this.joinMap(attributeName, JoinType.INNER);
    }

    public <X, K, Y> MapJoin<X, K, Y> joinMap(String attributeName, JoinType jt) {
        try {
            return (MapJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_attribute_not_map", (Object[])new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attributeName) {
        return this.joinSet(attributeName, JoinType.INNER);
    }

    public <X, Y> SetJoin<X, Y> joinSet(String attributeName, JoinType jt) {
        try {
            return (SetJoin)this.join(attributeName, jt);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"metamodel_attribute_not_set", (Object[])new Object[]{attributeName, this.managedType.getJavaType().getName()}), ex);
        }
    }
}

