/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.SubSelectExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.querydef.AbstractQueryImpl;
import org.eclipse.persistence.internal.jpa.querydef.CollectionJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.CompoundExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.JoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.ListJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.MapJoinImpl;
import org.eclipse.persistence.internal.jpa.querydef.PathImpl;
import org.eclipse.persistence.internal.jpa.querydef.QueryBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SetJoinImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.queries.ReportQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubQueryImpl<T>
extends AbstractQueryImpl<T>
implements Subquery<T>,
InternalExpression,
InternalSelection {
    protected SelectionImpl<?> selection;
    protected SubSelectExpression currentNode;
    protected String alias;
    protected ReportQuery subQuery = new ReportQuery();
    protected Set<Join<?, ?>> correlatedJoins = new HashSet();
    protected AbstractQuery parent;

    public SubQueryImpl(Metamodel metamodel, Class result, QueryBuilderImpl queryBuilder, AbstractQuery parent) {
        super(metamodel, AbstractQueryImpl.ResultType.OTHER, queryBuilder, result);
        this.currentNode = new SubSelectExpression(this.subQuery, (Expression)new ExpressionBuilder());
        this.parent = parent;
    }

    public Subquery<T> select(javax.persistence.criteria.Expression<T> selection) {
        this.validateRoot(selection);
        this.selection = (SelectionImpl)selection;
        this.queryType = selection.getJavaType();
        if (selection.isCompoundSelection()) {
            int count = 0;
            for (Selection select : selection.getCompoundSelectionItems()) {
                this.subQuery.addItem(String.valueOf(count), ((InternalSelection)select).getCurrentNode());
            }
        } else {
            ManagedType type = this.metamodel.type(this.queryType);
            if (type != null && type.getPersistenceType().equals((Object)Type.PersistenceType.ENTITY)) {
                if (!((EntityType)type).hasSingleIdAttribute()) {
                    this.selection = (SelectionImpl)((Path)this.selection).get(((EntityType)type).getId(Object.class));
                    this.subQuery.addItem(selection.getAlias() + "ID", this.selection.getCurrentNode());
                } else {
                    javax.persistence.criteria.Expression[] expressions = new javax.persistence.criteria.Expression[((EntityType)type).getIdClassAttributes().size()];
                    int index = 0;
                    for (SingularAttribute attr : ((EntityType)type).getIdClassAttributes()) {
                        PathImpl path = (PathImpl)((Path)selection).get(attr);
                        expressions[index] = path;
                        this.subQuery.addItem(selection.getAlias() + "ID" + ++index, path.getCurrentNode());
                    }
                    this.selection = (SelectionImpl)this.queryBuilder.construct(ClassConstants.AOBJECT, (Selection<?>[])expressions);
                }
            } else {
                this.subQuery.addItem(selection.getAlias(), ((InternalSelection)selection).getCurrentNode());
            }
        }
        this.queryResult = AbstractQueryImpl.ResultType.OTHER;
        return this;
    }

    @Override
    public Subquery<T> where(javax.persistence.criteria.Expression<Boolean> restriction) {
        super.where(restriction);
        this.subQuery.setSelectionCriteria(((InternalSelection)this.where).getCurrentNode());
        return this;
    }

    @Override
    public Subquery<T> where(Predicate ... restrictions) {
        super.where(restrictions);
        this.subQuery.setSelectionCriteria(((InternalSelection)this.where).getCurrentNode());
        return this;
    }

    @Override
    public Subquery<T> groupBy(javax.persistence.criteria.Expression<?> ... grouping) {
        super.groupBy(grouping);
        for (javax.persistence.criteria.Expression<?> groupby : grouping) {
            this.subQuery.addGrouping(((InternalSelection)groupby).getCurrentNode());
        }
        return this;
    }

    @Override
    public Subquery<T> groupBy(List<javax.persistence.criteria.Expression<?>> grouping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Subquery<T> having(javax.persistence.criteria.Expression<Boolean> restriction) {
        super.having(restriction);
        this.subQuery.setHavingExpression(((InternalSelection)restriction).getCurrentNode());
        return this;
    }

    @Override
    public Subquery<T> having(Predicate ... restrictions) {
        super.having(restrictions);
        this.subQuery.setHavingExpression(this.havingClause.getCurrentNode());
        return this;
    }

    public <Y> Root<Y> correlate(Root<Y> parentRoot) {
        return this.from(parentRoot.getModel());
    }

    public <X, Y> Join<X, Y> correlate(Join<X, Y> parentJoin) {
        this.correlatedJoins.add(parentJoin);
        return new JoinImpl(parentJoin.getParentPath(), this.metamodel.type(parentJoin.getModel().getBindableJavaType()), this.metamodel, parentJoin.getJavaType(), ((InternalSelection)parentJoin).getCurrentNode(), parentJoin.getModel(), parentJoin.getJoinType());
    }

    public <X, Y> CollectionJoin<X, Y> correlate(CollectionJoin<X, Y> parentCollection) {
        this.correlatedJoins.add((Join<?, ?>)parentCollection);
        return new CollectionJoinImpl(parentCollection.getParentPath(), this.metamodel.type(parentCollection.getModel().getBindableJavaType()), this.metamodel, parentCollection.getJavaType(), ((InternalSelection)parentCollection).getCurrentNode(), parentCollection.getModel(), parentCollection.getJoinType());
    }

    public <X, Y> SetJoin<X, Y> correlate(SetJoin<X, Y> parentCollection) {
        this.correlatedJoins.add((Join<?, ?>)parentCollection);
        return new SetJoinImpl(parentCollection.getParentPath(), this.metamodel.type(parentCollection.getModel().getBindableJavaType()), this.metamodel, parentCollection.getJavaType(), ((InternalSelection)parentCollection).getCurrentNode(), parentCollection.getModel(), parentCollection.getJoinType());
    }

    public <X, Y> ListJoin<X, Y> correlate(ListJoin<X, Y> parentCollection) {
        this.correlatedJoins.add((Join<?, ?>)parentCollection);
        return new ListJoinImpl(parentCollection.getParentPath(), this.metamodel.type(parentCollection.getModel().getBindableJavaType()), this.metamodel, parentCollection.getJavaType(), ((InternalSelection)parentCollection).getCurrentNode(), parentCollection.getModel(), parentCollection.getJoinType());
    }

    public <X, K, V> MapJoin<X, K, V> correlate(MapJoin<X, K, V> parentCollection) {
        this.correlatedJoins.add((Join<?, ?>)parentCollection);
        return new MapJoinImpl(parentCollection.getParentPath(), this.metamodel.type(parentCollection.getModel().getBindableJavaType()), this.metamodel, parentCollection.getJavaType(), ((InternalSelection)parentCollection).getCurrentNode(), parentCollection.getModel(), parentCollection.getJoinType());
    }

    public AbstractQuery<?> getParent() {
        return this.parent;
    }

    @Override
    public Subquery<T> distinct(boolean distinct) {
        super.distinct(distinct);
        return this;
    }

    @Override
    public Expression getCurrentNode() {
        return this.currentNode;
    }

    @Override
    public javax.persistence.criteria.Expression<T> getSelection() {
        return (javax.persistence.criteria.Expression)this.selection;
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        return this.correlatedJoins;
    }

    public <X> javax.persistence.criteria.Expression<X> as(Class<X> type) {
        return this;
    }

    public Predicate in(Object ... values) {
        ArrayList list = new ArrayList();
        list.add((javax.persistence.criteria.Expression<?>)this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(values), list, "in");
    }

    public Predicate in(javax.persistence.criteria.Expression<?> ... values) {
        ArrayList list = new ArrayList();
        list.add((javax.persistence.criteria.Expression<?>)this);
        for (javax.persistence.criteria.Expression<?> exp : values) {
            if (((InternalExpression)exp).isLiteral()) continue;
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage((String)"CRITERIA_NON_LITERAL_PASSED_TO_IN_TODO"));
        }
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in((Object[])values), list, "in");
    }

    public Predicate in(Collection<?> values) {
        ArrayList list = new ArrayList();
        list.add((javax.persistence.criteria.Expression<?>)this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(values), list, "in");
    }

    public Predicate in(javax.persistence.criteria.Expression<Collection<?>> values) {
        ArrayList list = new ArrayList();
        list.add((javax.persistence.criteria.Expression<?>)this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.in(((InternalSelection)values).getCurrentNode()), list, "in");
    }

    public Predicate isNotNull() {
        ArrayList list = new ArrayList();
        list.add((javax.persistence.criteria.Expression<?>)this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.notNull(), list, "not null");
    }

    public Predicate isNull() {
        ArrayList list = new ArrayList();
        list.add((javax.persistence.criteria.Expression<?>)this);
        return new CompoundExpressionImpl(this.metamodel, this.currentNode.isNull(), list, "is null");
    }

    public Selection<T> alias(String name) {
        this.alias = name;
        return this;
    }

    @Override
    public <X> Root<X> from(EntityType<X> entity) {
        if (this.roots.isEmpty()) {
            this.subQuery.setExpressionBuilder(new ExpressionBuilder(entity.getJavaType()));
        }
        return super.from(entity);
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<T> getJavaType() {
        return this.queryType;
    }

    public List<Selection<?>> getCompoundSelectionItems() {
        throw new IllegalStateException(ExceptionLocalization.buildMessage((String)"CRITERIA_NOT_A_COMPOUND_SELECTION"));
    }

    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public boolean isPredicate() {
        return false;
    }

    @Override
    public boolean isCompoundExpression() {
        return false;
    }

    @Override
    public boolean isExpression() {
        return true;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public void findRoot(Set<Root<?>> roots) {
        for (Join<?, ?> join : this.correlatedJoins) {
            ((JoinImpl)join).findRoot(roots);
        }
    }
}

