/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.FieldTransformerNodeValue;
import org.eclipse.persistence.internal.oxm.InheritanceNodeValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.TypeNodeValue;
import org.eclipse.persistence.internal.oxm.XMLAnyAttributeMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLAnyCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLAnyObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingMarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceCollectionMappingUnmarshalNodeValue;
import org.eclipse.persistence.internal.oxm.XMLChoiceObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCollectionReferenceMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeDirectCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLCompositeObjectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLDirectMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLFragmentCollectionMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLFragmentMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLObjectReferenceMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.SequencedMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.record.NodeRecord;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.sequenced.SequencedObject;
import org.w3c.dom.Node;

public class TreeObjectBuilder
extends XMLObjectBuilder {
    private XPathNode rootXPathNode = new XPathNode();
    private List transformationMappings;
    private List containerValues;
    private List nullCapableValues;

    public TreeObjectBuilder(ClassDescriptor descriptor) {
        super(descriptor);
    }

    public XPathNode getRootXPathNode() {
        return this.rootXPathNode;
    }

    public void addTransformationMapping(AbstractTransformationMapping transformationMapping) {
        if (null == this.getTransformationMappings()) {
            this.transformationMappings = new ArrayList();
        }
        this.transformationMappings.add(transformationMapping);
    }

    public List getTransformationMappings() {
        return this.transformationMappings;
    }

    public List getContainerValues() {
        return this.containerValues;
    }

    public void addContainerValue(ContainerValue containerValue) {
        if (null == this.getContainerValues()) {
            this.containerValues = new ArrayList();
        }
        this.containerValues.add(containerValue);
    }

    public List getNullCapableValues() {
        return this.nullCapableValues;
    }

    public void addNullCapableValue(NullCapableValue nullCapableValue) {
        if (null == this.getNullCapableValues()) {
            this.nullCapableValues = new ArrayList();
        }
        this.nullCapableValues.add(nullCapableValue);
    }

    public void initialize(AbstractSession session) {
        InheritancePolicy inheritancePolicy;
        super.initialize(session);
        XMLDescriptor xmlDescriptor = (XMLDescriptor)this.getDescriptor();
        Iterator<DatabaseMapping> mappingIterator = xmlDescriptor.getMappings().iterator();
        NodeValue mappingNodeValue = null;
        while (mappingIterator.hasNext()) {
            DatabaseMapping xmlMapping = mappingIterator.next();
            XMLField xmlField = (XMLField)xmlMapping.getField();
            if (xmlMapping.isTransformationMapping()) {
                AbstractTransformationMapping transformationMapping = (AbstractTransformationMapping)xmlMapping;
                this.addTransformationMapping(transformationMapping);
                Iterator fieldTransformerIterator = transformationMapping.getFieldToTransformers().iterator();
                while (fieldTransformerIterator.hasNext()) {
                    FieldTransformerNodeValue fieldTransformerNodeValue = new FieldTransformerNodeValue();
                    Object[] nextFieldToTransformer = (Object[])fieldTransformerIterator.next();
                    xmlField = (XMLField)nextFieldToTransformer[0];
                    fieldTransformerNodeValue.setXMLField(xmlField);
                    fieldTransformerNodeValue.setFieldTransformer((FieldTransformer)nextFieldToTransformer[1]);
                    this.addChild(xmlField.getXPathFragment(), fieldTransformerNodeValue, xmlDescriptor.getNamespaceResolver());
                }
                continue;
            }
            if (xmlMapping.isAbstractDirectMapping()) {
                mappingNodeValue = new XMLDirectMappingNodeValue((XMLDirectMapping)xmlMapping);
            } else if (xmlMapping.isAbstractCompositeObjectMapping()) {
                mappingNodeValue = new XMLCompositeObjectMappingNodeValue((XMLCompositeObjectMapping)xmlMapping);
            } else if (xmlMapping.isAbstractCompositeDirectCollectionMapping()) {
                mappingNodeValue = new XMLCompositeDirectCollectionMappingNodeValue((XMLCompositeDirectCollectionMapping)xmlMapping);
            } else if (xmlMapping.isAbstractCompositeCollectionMapping()) {
                mappingNodeValue = new XMLCompositeCollectionMappingNodeValue((XMLCompositeCollectionMapping)xmlMapping);
            } else if (xmlMapping instanceof XMLAnyObjectMapping) {
                mappingNodeValue = new XMLAnyObjectMappingNodeValue((XMLAnyObjectMapping)xmlMapping);
            } else if (xmlMapping instanceof XMLAnyCollectionMapping) {
                mappingNodeValue = new XMLAnyCollectionMappingNodeValue((XMLAnyCollectionMapping)xmlMapping);
            } else if (xmlMapping instanceof XMLAnyAttributeMapping) {
                mappingNodeValue = new XMLAnyAttributeMappingNodeValue((XMLAnyAttributeMapping)xmlMapping);
            } else if (xmlMapping instanceof XMLBinaryDataMapping) {
                mappingNodeValue = new XMLBinaryDataMappingNodeValue((XMLBinaryDataMapping)xmlMapping);
            } else if (xmlMapping instanceof XMLBinaryDataCollectionMapping) {
                mappingNodeValue = new XMLBinaryDataCollectionMappingNodeValue((XMLBinaryDataCollectionMapping)xmlMapping);
            } else if (xmlMapping instanceof XMLFragmentMapping) {
                mappingNodeValue = new XMLFragmentMappingNodeValue((XMLFragmentMapping)xmlMapping);
            } else if (xmlMapping instanceof XMLFragmentCollectionMapping) {
                mappingNodeValue = new XMLFragmentCollectionMappingNodeValue((XMLFragmentCollectionMapping)xmlMapping);
            } else {
                XMLField firstField;
                Iterator<XMLField> fields;
                DatabaseMapping xmlChoiceMapping;
                if (xmlMapping instanceof XMLCollectionReferenceMapping) {
                    XMLCollectionReferenceMapping xmlColMapping = (XMLCollectionReferenceMapping)xmlMapping;
                    for (XMLField xmlFld : xmlColMapping.getFields()) {
                        mappingNodeValue = new XMLCollectionReferenceMappingNodeValue(xmlColMapping, xmlFld);
                        if (mappingNodeValue.isContainerValue()) {
                            this.addContainerValue((ContainerValue)((Object)mappingNodeValue));
                        }
                        if (mappingNodeValue.isNullCapableValue()) {
                            this.addNullCapableValue((NullCapableValue)((Object)mappingNodeValue));
                        }
                        this.addChild(xmlFld.getXPathFragment(), mappingNodeValue, xmlDescriptor.getNamespaceResolver());
                    }
                    continue;
                }
                if (xmlMapping instanceof XMLObjectReferenceMapping) {
                    XMLObjectReferenceMapping xmlORMapping = (XMLObjectReferenceMapping)xmlMapping;
                    for (XMLField xmlFld : xmlORMapping.getFields()) {
                        mappingNodeValue = new XMLObjectReferenceMappingNodeValue(xmlORMapping, xmlFld);
                        if (mappingNodeValue.isContainerValue()) {
                            this.addContainerValue((ContainerValue)((Object)mappingNodeValue));
                        }
                        if (mappingNodeValue.isNullCapableValue()) {
                            this.addNullCapableValue((NullCapableValue)((Object)mappingNodeValue));
                        }
                        this.addChild(xmlFld.getXPathFragment(), mappingNodeValue, xmlDescriptor.getNamespaceResolver());
                    }
                    continue;
                }
                if (xmlMapping instanceof XMLChoiceObjectMapping) {
                    xmlChoiceMapping = (XMLChoiceObjectMapping)xmlMapping;
                    fields = ((XMLChoiceObjectMapping)xmlChoiceMapping).getChoiceElementMappings().keySet().iterator();
                    firstField = fields.next();
                    XMLChoiceObjectMappingNodeValue firstNodeValue = new XMLChoiceObjectMappingNodeValue((XMLChoiceObjectMapping)xmlChoiceMapping, firstField);
                    firstNodeValue.setNullCapableNodeValue(firstNodeValue);
                    this.addNullCapableValue(firstNodeValue);
                    this.addChild(firstField.getXPathFragment(), firstNodeValue, xmlDescriptor.getNamespaceResolver());
                    while (fields.hasNext()) {
                        XMLField next = fields.next();
                        XMLChoiceObjectMappingNodeValue nodeValue = new XMLChoiceObjectMappingNodeValue((XMLChoiceObjectMapping)xmlChoiceMapping, next);
                        nodeValue.setNullCapableNodeValue(firstNodeValue);
                        this.addChild(next.getXPathFragment(), nodeValue, xmlDescriptor.getNamespaceResolver());
                    }
                    continue;
                }
                if (xmlMapping instanceof XMLChoiceCollectionMapping) {
                    xmlChoiceMapping = (XMLChoiceCollectionMapping)xmlMapping;
                    fields = ((XMLChoiceCollectionMapping)xmlChoiceMapping).getChoiceElementMappings().keySet().iterator();
                    firstField = fields.next();
                    XMLChoiceCollectionMappingUnmarshalNodeValue unmarshalValue = new XMLChoiceCollectionMappingUnmarshalNodeValue((XMLChoiceCollectionMapping)xmlChoiceMapping, firstField);
                    XMLChoiceCollectionMappingMarshalNodeValue marshalValue = new XMLChoiceCollectionMappingMarshalNodeValue((XMLChoiceCollectionMapping)xmlChoiceMapping, firstField);
                    HashMap<XMLField, NodeValue> fieldToNodeValues = new HashMap<XMLField, NodeValue>();
                    unmarshalValue.setContainerNodeValue(unmarshalValue);
                    marshalValue.setFieldToNodeValues(fieldToNodeValues);
                    this.addContainerValue(unmarshalValue);
                    fieldToNodeValues.put(firstField, unmarshalValue);
                    this.addChild(firstField.getXPathFragment(), unmarshalValue, xmlDescriptor.getNamespaceResolver());
                    this.addChild(firstField.getXPathFragment(), marshalValue, xmlDescriptor.getNamespaceResolver());
                    while (fields.hasNext()) {
                        XMLField next = fields.next();
                        XMLChoiceCollectionMappingUnmarshalNodeValue nodeValue = new XMLChoiceCollectionMappingUnmarshalNodeValue((XMLChoiceCollectionMapping)xmlChoiceMapping, next);
                        nodeValue.setContainerNodeValue(unmarshalValue);
                        this.addChild(next.getXPathFragment(), nodeValue, xmlDescriptor.getNamespaceResolver());
                        fieldToNodeValues.put(next, nodeValue);
                    }
                    continue;
                }
            }
            if (mappingNodeValue.isContainerValue()) {
                this.addContainerValue((ContainerValue)((Object)mappingNodeValue));
            }
            if (mappingNodeValue.isNullCapableValue()) {
                this.addNullCapableValue((NullCapableValue)((Object)mappingNodeValue));
            }
            if (xmlField != null) {
                this.addChild(xmlField.getXPathFragment(), mappingNodeValue, xmlDescriptor.getNamespaceResolver());
            } else {
                this.addChild(null, mappingNodeValue, xmlDescriptor.getNamespaceResolver());
            }
            if (!xmlMapping.isAbstractDirectMapping() || !xmlField.isTypedTextField()) continue;
            XPathFragment nextFragment = xmlField.getXPathFragment();
            String typeXPath = "";
            while (nextFragment.getNextFragment() != null) {
                typeXPath = typeXPath + nextFragment.getXPath();
                nextFragment = nextFragment.getNextFragment();
            }
            XMLField typeField = new XMLField();
            if (typeXPath.length() > 0) {
                typeXPath = typeXPath + "/";
            }
            typeField.setXPath(typeXPath + XMLConstants.ATTRIBUTE + xmlDescriptor.getNonNullNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance") + ':' + "type");
            TypeNodeValue typeNodeValue = new TypeNodeValue();
            typeNodeValue.setDirectMapping((AbstractDirectMapping)xmlMapping);
            this.addChild(typeField.getXPathFragment(), typeNodeValue, xmlDescriptor.getNamespaceResolver());
        }
        if (xmlDescriptor.hasInheritance() && !(inheritancePolicy = xmlDescriptor.getInheritancePolicy()).hasClassExtractor()) {
            XMLField classIndicatorField = new XMLField(inheritancePolicy.getClassIndicatorFieldName());
            classIndicatorField.setNamespaceResolver(xmlDescriptor.getNamespaceResolver());
            InheritanceNodeValue inheritanceNodeValue = new InheritanceNodeValue();
            inheritanceNodeValue.setInheritancePolicy(inheritancePolicy);
            this.addChild(classIndicatorField.getXPathFragment(), inheritanceNodeValue, xmlDescriptor.getNamespaceResolver());
        }
    }

    public void addChild(XPathFragment xPathFragment, NodeValue nodeValue, NamespaceResolver namespaceResolver) {
        this.getRootXPathNode().addChild(xPathFragment, nodeValue, namespaceResolver);
    }

    public AbstractRecord buildRow(AbstractRecord record, Object object, AbstractSession session) {
        return this.buildRow(record, object, session, null);
    }

    public AbstractRecord buildRow(AbstractRecord record, Object object, AbstractSession session, XMLMarshaller marshaller) {
        if (null == this.getRootXPathNode().getNonAttributeChildren()) {
            return record;
        }
        XMLDescriptor xmlDescriptor = (XMLDescriptor)this.getDescriptor();
        NamespaceResolver namespaceResolver = xmlDescriptor.getNamespaceResolver();
        MarshalContext marshalContext = null;
        if (xmlDescriptor.isSequencedObject()) {
            SequencedObject sequencedObject = (SequencedObject)object;
            marshalContext = new SequencedMarshalContext(sequencedObject.getSettings());
        } else {
            marshalContext = ObjectMarshalContext.getInstance();
        }
        int size = marshalContext.getNonAttributeChildrenSize(this.getRootXPathNode());
        for (int x = 0; x < size; ++x) {
            XPathNode xPathNode = (XPathNode)marshalContext.getNonAttributeChild(x, this.getRootXPathNode());
            xPathNode.marshal((MarshalRecord)record, object, session, namespaceResolver, marshaller, marshalContext.getMarshalContext(x));
        }
        return record;
    }

    public boolean marshalAttributes(MarshalRecord marshalRecord, Object object, AbstractSession session) {
        List selfChildren;
        boolean hasValue = false;
        NamespaceResolver namespaceResolver = ((XMLDescriptor)this.getDescriptor()).getNamespaceResolver();
        List attributeChildren = this.rootXPathNode.getAttributeChildren();
        if (null != attributeChildren) {
            int attributeChildrenSize = attributeChildren.size();
            for (int x = 0; x < attributeChildrenSize; ++x) {
                XPathNode attributeNode = (XPathNode)this.rootXPathNode.getAttributeChildren().get(x);
                hasValue = attributeNode.marshal(marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance()) || hasValue;
            }
        }
        if (this.rootXPathNode.getAnyAttributeNode() != null) {
            boolean bl = hasValue = this.rootXPathNode.getAnyAttributeNode().marshal(marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance()) || hasValue;
        }
        if (null != (selfChildren = this.rootXPathNode.getSelfChildren())) {
            int selfChildrenSize = selfChildren.size();
            for (int x = 0; x < selfChildrenSize; ++x) {
                XPathNode childNode = (XPathNode)selfChildren.get(x);
                childNode.marshalSelfAttributes(marshalRecord, object, session, namespaceResolver, marshalRecord.getMarshaller());
            }
        }
        return hasValue;
    }

    public AbstractRecord createRecord(AbstractSession session) {
        UnmarshalRecord uRec = new UnmarshalRecord(this);
        uRec.setSession(session);
        return uRec;
    }

    public AbstractRecord createRecord(String rootName, AbstractSession session) {
        NodeRecord nRec = new NodeRecord(rootName, this.getNamespaceResolver());
        nRec.setSession(session);
        return nRec;
    }

    public AbstractRecord createRecord(String rootName, Node parent, AbstractSession session) {
        NodeRecord nRec = new NodeRecord(rootName, this.getNamespaceResolver(), parent);
        nRec.setSession(session);
        return nRec;
    }

    public AbstractRecord createRecord(int size, AbstractSession session) {
        return this.createRecord(session);
    }
}

