/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLStreamReaderInputSource;
import org.eclipse.persistence.internal.oxm.record.namespaces.UnmarshalNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;

public class XMLStreamReaderReader
extends XMLReader {
    private ContentHandler contentHandler;
    private LexicalHandler lexicalHandler;
    private ErrorHandler errorHandler;
    private int depth = 0;

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler aContentHandler) {
        this.contentHandler = aContentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler anErrorHandler) {
        this.errorHandler = anErrorHandler;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            this.lexicalHandler = (LexicalHandler)value;
        }
    }

    public void parse(InputSource input) throws SAXException {
        if (input instanceof XMLStreamReaderInputSource) {
            XMLStreamReader xmlStreamReader = ((XMLStreamReaderInputSource)input).getXmlStreamReader();
            this.parse(xmlStreamReader);
        }
    }

    public void parse(InputSource input, SAXUnmarshallerHandler saxUnmarshallerHandler) throws SAXException {
        if (input instanceof XMLStreamReaderInputSource) {
            XMLStreamReader xmlStreamReader = ((XMLStreamReaderInputSource)input).getXmlStreamReader();
            saxUnmarshallerHandler.setUnmarshalNamespaceResolver(new UnmarshalNamespaceContext(xmlStreamReader));
            this.parse(xmlStreamReader);
        }
    }

    public void parse(String systemId) throws SAXException {
    }

    private void parse(XMLStreamReader xmlStreamReader) throws SAXException {
        try {
            this.getContentHandler().startDocument();
            this.parseEvent(xmlStreamReader);
            while (this.depth > 0 && xmlStreamReader.hasNext()) {
                xmlStreamReader.next();
                this.parseEvent(xmlStreamReader);
            }
            this.getContentHandler().endDocument();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void parseEvent(XMLStreamReader xmlStreamReader) throws SAXException {
        if (null == this.getContentHandler()) {
            return;
        }
        switch (xmlStreamReader.getEventType()) {
            case 10: {
                break;
            }
            case 12: {
                if (null == this.lexicalHandler) {
                    this.getContentHandler().characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                    break;
                }
                this.lexicalHandler.startCDATA();
                this.getContentHandler().characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                this.lexicalHandler.endCDATA();
                break;
            }
            case 4: {
                this.getContentHandler().characters(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 5: {
                if (null == this.lexicalHandler) break;
                this.lexicalHandler.comment(xmlStreamReader.getTextCharacters(), xmlStreamReader.getTextStart(), xmlStreamReader.getTextLength());
                break;
            }
            case 11: {
                break;
            }
            case 8: {
                --this.depth;
                return;
            }
            case 2: {
                --this.depth;
                String prefix = xmlStreamReader.getPrefix();
                if (null == prefix || prefix.length() == 0) {
                    this.getContentHandler().endElement(xmlStreamReader.getNamespaceURI(), xmlStreamReader.getLocalName(), xmlStreamReader.getLocalName());
                    break;
                }
                this.getContentHandler().endElement(xmlStreamReader.getNamespaceURI(), xmlStreamReader.getLocalName(), prefix + ':' + xmlStreamReader.getLocalName());
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 3: {
                this.getContentHandler().processingInstruction(xmlStreamReader.getPITarget(), xmlStreamReader.getPIData());
                break;
            }
            case 6: {
                char[] characters = xmlStreamReader.getTextCharacters();
                this.getContentHandler().characters(characters, 0, characters.length);
                break;
            }
            case 7: {
                ++this.depth;
                break;
            }
            case 1: {
                ++this.depth;
                String prefix = xmlStreamReader.getPrefix();
                if (null == prefix || prefix.length() == 0) {
                    this.getContentHandler().startElement(xmlStreamReader.getNamespaceURI(), xmlStreamReader.getLocalName(), xmlStreamReader.getLocalName(), new IndexedAttributeList(xmlStreamReader));
                    break;
                }
                this.getContentHandler().startElement(xmlStreamReader.getNamespaceURI(), xmlStreamReader.getLocalName(), prefix + ':' + xmlStreamReader.getLocalName(), new IndexedAttributeList(xmlStreamReader));
                break;
            }
        }
    }

    private static class Attribute {
        private QName qName;
        private String name;
        private String value;

        public Attribute(String uri, String localName, String name, String value) {
            this.qName = new QName(uri, localName);
            this.name = name;
            this.value = value;
        }

        public QName getQName() {
            return this.qName;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static class IndexedAttributeList
    implements Attributes {
        private List<Attribute> attributes;

        public IndexedAttributeList(XMLStreamReader xmlStreamReader) {
            String localName;
            String uri;
            int x;
            int namespaceCount = xmlStreamReader.getNamespaceCount();
            int attributeCount = xmlStreamReader.getAttributeCount();
            this.attributes = new ArrayList<Attribute>(attributeCount + namespaceCount);
            for (x = 0; x < namespaceCount; ++x) {
                String qName;
                uri = "http://www.w3.org/2000/xmlns/";
                localName = xmlStreamReader.getNamespacePrefix(x);
                if (null == localName || localName.length() == 0) {
                    localName = "xmlns";
                    qName = "xmlns";
                } else {
                    qName = "xmlns:" + localName;
                }
                String value = xmlStreamReader.getNamespaceURI(x);
                this.attributes.add(new Attribute(uri, localName, qName, value));
            }
            for (x = 0; x < attributeCount; ++x) {
                uri = xmlStreamReader.getAttributeNamespace(x);
                localName = xmlStreamReader.getAttributeLocalName(x);
                String prefix = xmlStreamReader.getAttributePrefix(x);
                String qName = null == prefix || prefix.length() == 0 ? localName : prefix + ':' + localName;
                String value = xmlStreamReader.getAttributeValue(x);
                this.attributes.add(new Attribute(uri, localName, qName, value));
            }
        }

        public int getIndex(String qName) {
            if (null == qName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes) {
                if (qName.equals(attribute.getName())) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public int getIndex(String uri, String localName) {
            if (null == localName) {
                return -1;
            }
            int index = 0;
            for (Attribute attribute : this.attributes) {
                QName testQName = new QName(uri, localName);
                if (attribute.getQName().equals(testQName)) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        public int getLength() {
            return this.attributes.size();
        }

        public String getLocalName(int index) {
            return this.attributes.get(index).getQName().getLocalPart();
        }

        public String getQName(int index) {
            return this.attributes.get(index).getName();
        }

        public String getType(int index) {
            return "CDATA";
        }

        public String getType(String name) {
            return "CDATA";
        }

        public String getType(String uri, String localName) {
            return "CDATA";
        }

        public String getURI(int index) {
            return this.attributes.get(index).getQName().getNamespaceURI();
        }

        public String getValue(int index) {
            return this.attributes.get(index).getValue();
        }

        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (-1 == index) {
                return null;
            }
            return this.attributes.get(index).getValue();
        }

        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (-1 == index) {
                return null;
            }
            return this.attributes.get(index).getValue();
        }
    }
}

