/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.platform.database.DerbyPlatform;
import org.eclipse.persistence.platform.database.MySQLPlatform;
import org.eclipse.persistence.platform.database.PostgreSQLPlatform;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbColumn;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.jdbc.DbTable;

public class JDBCHelper {
    public static final int TABLESINFO_CATALOG = 1;
    public static final int TABLESINFO_SCHEMA = 2;
    public static final int TABLESINFO_NAME = 3;
    public static final int TABLESINFO_TYPE = 4;
    public static final int COLUMNSINFO_COLUMN_NAME = 4;
    public static final int COLUMNSINFO_DATA_TYPE = 5;
    public static final int COLUMNSINFO_TYPE_NAME = 6;
    public static final int COLUMNSINFO_COLUMN_SIZE = 7;
    public static final int COLUMNSINFO_DECIMAL_DIGITS = 9;
    public static final int COLUMNSINFO_NULLABLE = 11;
    public static final int COLUMNSINFO_ORDINAL_POSITION = 17;
    public static final int PKSINFO_KEY_SEQ = 5;
    public static final int PKSINFO_PK_NAME = 6;
    public static final int INDEXINFO_NON_UNIQUE = 4;
    public static final int INDEXINFO_TYPE = 7;
    public static final int INDEXINFO_ORDINAL_POSITION = 8;
    public static final int PROCS_INFO_CATALOG = 1;
    public static final int PROCS_INFO_SCHEMA = 2;
    public static final int PROCS_INFO_NAME = 3;
    public static final int PROCS_INFO_TYPE = 8;
    public static final int PROC_COLS_INFO_CATALOG = 1;
    public static final int PROC_COLS_INFO_SCHEMA = 2;
    public static final int PROC_COLS_INFO_NAME = 3;
    public static final int PROC_COLS_INFO_COLNAME = 4;
    public static final int PROC_COLS_INFO_TYPE = 5;
    public static final int PROC_COLS_INFO_DATA_TYPE = 6;
    public static final int PROC_COLS_INFO_TYPE_NAME = 7;
    public static final int PROC_COLS_INFO_PRECISION = 8;
    public static final int PROC_COLS_INFO_LENGTH = 9;
    public static final int PROC_COLS_INFO_SCALE = 10;
    public static final int PROC_COLS_INFO_RADIX = 11;
    public static final int PROC_COLS_INFO_NULLABLE = 12;
    public static final int PROC_COLS_INFO_ORA_SEQUENCE = 14;
    public static final int PROC_COLS_INFO_ORA_OVERLOAD = 15;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<DbTable> buildDbTable(Connection var0, DatabasePlatform var1_1, String var2_2, String var3_3, String var4_4) {
        var5_5 = null;
        var6_6 = var1_1.getClass().getName().contains("Oracle") != false;
        var7_7 = JDBCHelper.trimPunctuation(var3_3, var6_6);
        var8_8 = JDBCHelper.trimPunctuation(var4_4, var6_6);
        var9_9 = JDBCHelper.getDatabaseMetaData(var0);
        var10_10 = true;
        try {
            var10_10 = var9_9.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException var11_11) {
            // empty catch block
        }
        var11_12 = JDBCHelper.trimPunctuation(var10_10 != false ? var2_2 : "", var6_6);
        var12_13 = null;
        try {
            var12_13 = var9_9.getTables(var11_12, var7_7, var8_8, null);
        }
        catch (SQLException var13_14) {
            throw new IllegalStateException("failure retrieving JDBC table metadata", var13_14);
        }
        if (var12_13 == null) return var5_5;
        var5_5 = new ArrayList<DbTable>();
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                if (!var12_13.next()) {
                    var12_13.close();
                    return var5_5;
                }
                var13_15 = null;
                try {
                    var13_15 = var12_13.getString(1);
                }
                catch (SQLException var14_18) {
                    // empty catch block
                }
                if (var13_15 != null && var13_15.length() == 0 && var6_6) {
                    var13_15 = null;
                }
                var14_17 = null;
                try {
                    var14_17 = var12_13.getString(2);
                }
                catch (SQLException var15_20) {
                    // empty catch block
                }
                if (var14_17 != null && var14_17.length() == 0 && var6_6) {
                    var14_17 = null;
                }
                var15_19 = var12_13.getString(3);
                var16_21 = null;
                try {
                    var16_21 = var12_13.getString(4);
                }
                catch (SQLException var17_23) {
                    // empty catch block
                }
                var17_22 = new DbTable();
                var17_22.setCatalog(var13_15);
                var17_22.setSchema(var14_17);
                var17_22.setName(var15_19);
                if (var16_21 != null) {
                    var17_22.setType(var16_21);
                }
                var5_5.add(var17_22);
                var18_24 = var9_9.getColumns(var13_15, var14_17, var15_19, "%");
                while (var18_24.next()) {
                    var19_25 = new DbColumn();
                    var19_25.setName(var18_24.getString(4));
                    var19_25.setOrdinalPosition(var18_24.getInt(17));
                    try {
                        var19_25.setPrecision(var18_24.getInt(7));
                    }
                    catch (NumberFormatException var20_27) {
                        var19_25.setPrecision(-1);
                    }
                    var19_25.setScale(var18_24.getInt(9));
                    var19_25.setNullable(var18_24.getInt(11) == 1);
                    var19_25.setJDBCType(var18_24.getInt(5));
                    var19_25.setJDBCTypeName(var18_24.getString(6));
                    var17_22.getColumns().add(var19_25.getOrdinalPosition() - 1, (DbColumn)var19_25);
                }
                var18_24.close();
                var19_25 = var9_9.getPrimaryKeys(var13_15, var14_17, var15_19);
                if (var19_25 != null) {
                    while (var19_25.next()) {
                        var20_28 = var19_25.getShort(5);
                        var21_30 = var19_25.getString(6);
                        var22_32 = var17_22.getColumns().get(var20_28 - 1);
                        var22_32.setPK(true);
                        var22_32.setPkConstraintName(var21_30);
                    }
                }
                var19_25.close();
                try {
                    var20_26 = var9_9.getIndexInfo(var13_15, var14_17, var15_19, true, false);
                    if (var20_26 != null) {
                        while (var20_26.next()) {
                            var21_31 = var20_26.getBoolean(4);
                            if (var21_31 || (var22_33 = var20_26.getShort(7)) == 0) continue;
                            var23_34 = var20_26.getShort(8);
                            var24_35 = var17_22.getColumns().get(var23_34 - 1);
                            if (var24_35.isPK()) continue;
                            var24_35.setUnique(true);
                        }
                    }
                    var20_26.close();
                }
                catch (SQLException var20_29) {
                    continue;
                }
                break;
            }
        }
        catch (SQLException var13_16) {
            throw new IllegalStateException("failure retrieving JDBC table metadata", var13_16);
        }
        ** GOTO lbl-1000
    }

    public static List<DbStoredProcedure> buildStoredProcedure(Connection connection, DatabasePlatform databasePlatform, String string, String string2, String string3) {
        ArrayList<Object> arrayList = null;
        boolean bl = false;
        if (databasePlatform instanceof MySQLPlatform || databasePlatform instanceof DerbyPlatform || databasePlatform instanceof PostgreSQLPlatform) {
            bl = true;
        }
        boolean bl2 = databasePlatform.getClass().getName().matches("Oracle*Platform");
        String string4 = JDBCHelper.trimPunctuation(string, bl2);
        String string5 = JDBCHelper.trimPunctuation(string2, bl2);
        String string6 = JDBCHelper.trimPunctuation(string3, bl2);
        ResultSet resultSet = null;
        try {
            DatabaseMetaData databaseMetaData = JDBCHelper.getDatabaseMetaData(connection);
            resultSet = databaseMetaData.getProcedures(string4, string5, string6);
            if (resultSet != null) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                ArrayList<DbStoredProcedure> arrayList2 = new ArrayList<DbStoredProcedure>();
                while (resultSet.next()) {
                    String string7 = resultSet.getString(1);
                    object5 = resultSet.getString(2);
                    object4 = resultSet.getString(3);
                    short s = resultSet.getShort(8);
                    object3 = s == 2 ? new DbStoredFunction((String)object4) : new DbStoredProcedure((String)object4);
                    if (string7 != null && string7.length() > 0) {
                        ((DbStoredProcedure)object3).setCatalog(string7);
                    }
                    if (object5 != null && ((String)object5).length() > 0) {
                        ((DbStoredProcedure)object3).setSchema((String)object5);
                    }
                    arrayList2.add((DbStoredProcedure)object3);
                }
                resultSet.close();
                int n = arrayList2.size();
                arrayList = new ArrayList<Object>(n);
                object5 = new ArrayList();
                object4 = null;
                object4 = databaseMetaData.getProcedureColumns(string4, string5, string6, "%");
                while (object4.next()) {
                    Object object62;
                    Object object7;
                    short s;
                    String string8 = object4.getString(1);
                    object3 = object4.getString(2);
                    object2 = object4.getString(3);
                    String string9 = object4.getString(4);
                    object = new DbStoredArgument(string9);
                    short s2 = object4.getShort(5);
                    if (s2 == 2) {
                        ((DbStoredArgument)object).setInOut(Util.InOut.INOUT);
                    } else if (s2 == 4) {
                        ((DbStoredArgument)object).setInOut(Util.InOut.OUT);
                    } else if (s2 == 5) {
                        ((DbStoredArgument)object).setInOut(Util.InOut.RETURN);
                    }
                    ((DbStoredArgument)object).setJdbcType(object4.getInt(6));
                    ((DbStoredArgument)object).setJdbcTypeName(object4.getString(7));
                    ((DbStoredArgument)object).setPrecision(object4.getInt(8));
                    ((DbStoredArgument)object).setScale(object4.getInt(10));
                    ((DbStoredArgument)object).setRadix(object4.getShort(11));
                    ((DbStoredArgument)object).setNullable(object4.getShort(12) == 1);
                    if (bl2) {
                        ((DbStoredArgument)object).setSeq(object4.getShort(14));
                    }
                    short s3 = s = bl2 ? object4.getShort(15) : (short)0;
                    if (s == 0) {
                        object7 = null;
                        for (int i = 0; i < arrayList2.size(); ++i) {
                            object62 = (DbStoredProcedure)arrayList2.get(i);
                            if (!((DbStoredProcedure)object62).matches(string8, (String)object3, (String)object2, bl2, bl)) continue;
                            object7 = object62;
                            arrayList.add(object7);
                            break;
                        }
                        if (object7 == null) {
                            for (Object object62 : arrayList) {
                                if (!((DbStoredProcedure)object62).matches(string8, (String)object3, (String)object2, bl2, bl)) continue;
                                object7 = object62;
                                break;
                            }
                        }
                        if (object7 == null) continue;
                        if (((DbStoredProcedure)object7).isFunction() && (bl2 ? ((DbStoredArgument)object).getName() == null : ((DbStoredArgument)object).getName().equalsIgnoreCase("")) && ((DbStoredArgument)object).getSeq() == (bl2 ? 1 : 0)) {
                            ((DbStoredFunction)object7).setReturnArg((DbStoredArgument)object);
                        } else {
                            ((DbStoredProcedure)object7).getArguments().add((DbStoredArgument)object);
                        }
                        arrayList2.remove(object7);
                        continue;
                    }
                    object7 = null;
                    Iterator iterator = object5.iterator();
                    while (iterator.hasNext()) {
                        object62 = (OverloadHolder)iterator.next();
                        if (((OverloadHolder)object62).overload != s || !((OverloadHolder)object62).packageName.equals(string8) || !((OverloadHolder)object62).procedureSchema.equals(object3) || !((OverloadHolder)object62).procedureName.equals(object2)) continue;
                        object7 = object62;
                        break;
                    }
                    if (object7 == null) {
                        object7 = new OverloadHolder(string8, (String)object3, (String)object2, s);
                        object5.add(object7);
                    }
                    ((OverloadHolder)object7).getArgs().add((DbStoredArgument)object);
                }
                object4.close();
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    object3 = (OverloadHolder)iterator.next();
                    Collections.sort(((OverloadHolder)object3).getArgs(), new Comparator<DbStoredArgument>(){

                        @Override
                        public int compare(DbStoredArgument dbStoredArgument, DbStoredArgument dbStoredArgument2) {
                            return dbStoredArgument.getSeq() - dbStoredArgument2.getSeq();
                        }
                    });
                    object2 = null;
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        object = (DbStoredProcedure)arrayList2.get(i);
                        if (!((DbStoredProcedure)object).matches(((OverloadHolder)object3).packageName, ((OverloadHolder)object3).procedureSchema, ((OverloadHolder)object3).procedureName, true, false)) continue;
                        DbStoredArgument dbStoredArgument = ((OverloadHolder)object3).getArgs().get(0);
                        if (dbStoredArgument.getName() == null && dbStoredArgument.getSeq() == 1) {
                            if (!((DbStoredProcedure)object).isFunction()) continue;
                            object2 = (DbStoredProcedure)arrayList2.remove(i);
                            break;
                        }
                        object2 = (DbStoredProcedure)arrayList2.remove(i);
                        break;
                    }
                    if (object2 == null) continue;
                    if (((DbStoredProcedure)object2).isFunction()) {
                        DbStoredArgument dbStoredArgument = ((OverloadHolder)object3).getArgs().remove(0);
                        ((DbStoredFunction)object2).setReturnArg(dbStoredArgument);
                    }
                    ((DbStoredProcedure)object2).setOverload(((OverloadHolder)object3).overload);
                    ((DbStoredProcedure)object2).getArguments().addAll(((OverloadHolder)object3).getArgs());
                    arrayList.add(object2);
                }
                if (!arrayList2.isEmpty()) {
                    arrayList.addAll(arrayList2);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("failure retrieving Stored Procedure metadata", sQLException);
        }
        if (arrayList != null && !arrayList.isEmpty()) {
            Collections.sort(arrayList, new Comparator<DbStoredProcedure>(){

                @Override
                public int compare(DbStoredProcedure dbStoredProcedure, DbStoredProcedure dbStoredProcedure2) {
                    String string;
                    String string2 = dbStoredProcedure.getName();
                    if (!string2.equals(string = dbStoredProcedure2.getName())) {
                        return string2.compareTo(string);
                    }
                    return dbStoredProcedure.getOverload() - dbStoredProcedure2.getOverload();
                }
            });
        }
        return arrayList;
    }

    public static DatabaseMetaData getDatabaseMetaData(Connection connection) {
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("failure retrieving JDBC metadata", sQLException);
        }
        return databaseMetaData;
    }

    public static String trimPunctuation(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            if (bl) {
                return null;
            }
            return string;
        }
        String string2 = null;
        String string3 = string.trim();
        String string4 = string3.replaceAll("[\\p{Punct}&&[^\\._%]]", " ");
        String string5 = string4.trim();
        if (string5.length() != string3.length()) {
            throw new IllegalArgumentException(string + " contains illegal characters");
        }
        string2 = bl ? string5.toUpperCase() : string5;
        return string2;
    }

    public static class OverloadHolder {
        String packageName;
        String procedureSchema;
        String procedureName;
        short overload;
        List<DbStoredArgument> overloadedArgs;

        public OverloadHolder(String string, String string2, String string3, short s) {
            this.packageName = string;
            this.procedureSchema = string2;
            this.procedureName = string3;
            this.overload = s;
            this.overloadedArgs = new ArrayList<DbStoredArgument>();
        }

        public List<DbStoredArgument> getArgs() {
            return this.overloadedArgs;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.overload);
            stringBuilder.append(' ');
            stringBuilder.append(this.packageName);
            stringBuilder.append('-');
            stringBuilder.append(this.procedureSchema);
            stringBuilder.append('-');
            stringBuilder.append(this.procedureName);
            stringBuilder.append(' ');
            stringBuilder.append(this.overloadedArgs);
            return stringBuilder.toString();
        }
    }
}

