/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.InParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.localization.WarningLocalization;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class DatasourceCall
implements Call {
    protected DatabaseQuery query;
    protected transient Vector parameters;
    protected transient Vector parameterTypes;
    public static final Integer LITERAL = new Integer(1);
    public static final Integer MODIFY = new Integer(2);
    public static final Integer TRANSLATION = new Integer(3);
    public static final Integer CUSTOM_MODIFY = new Integer(4);
    public static final Integer OUT = new Integer(5);
    public static final Integer INOUT = new Integer(6);
    public static final Integer IN = new Integer(7);
    public static final Integer OUT_CURSOR = new Integer(8);
    protected boolean isPrepared = false;
    protected boolean isNativeConnectionRequired;
    protected boolean shouldProcessTokenInQuotes = true;
    protected int returnType = 3;
    protected static final int NO_RETURN = 1;
    protected static final int RETURN_ONE_ROW = 2;
    protected static final int RETURN_MANY_ROWS = 3;
    protected static final int RETURN_CURSOR = 4;

    public Vector getParameters() {
        if (this.parameters == null) {
            this.parameters = NonSynchronizedVector.newInstance();
        }
        return this.parameters;
    }

    public Vector getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = NonSynchronizedVector.newInstance();
        }
        return this.parameterTypes;
    }

    public void setParameters(Vector vector) {
        this.parameters = vector;
    }

    public void setParameterTypes(Vector vector) {
        this.parameterTypes = vector;
    }

    public boolean hasParameters() {
        return this.parameters != null && !this.getParameters().isEmpty();
    }

    public boolean areManyRowsReturned() {
        return this.getReturnType() == 3;
    }

    public boolean isOutputParameterType(Integer n) {
        return n == OUT || n == INOUT || n == OUT_CURSOR;
    }

    protected boolean isPrepared() {
        return this.isPrepared;
    }

    protected void setIsPrepared(boolean bl) {
        this.isPrepared = bl;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery databaseQuery) {
        return new DatasourceCallQueryMechanism(databaseQuery, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery databaseQuery, DatabaseQueryMechanism databaseQueryMechanism) {
        if (databaseQueryMechanism.isCallQueryMechanism() && databaseQueryMechanism instanceof DatasourceCallQueryMechanism) {
            DatasourceCallQueryMechanism datasourceCallQueryMechanism = (DatasourceCallQueryMechanism)databaseQueryMechanism;
            if (!datasourceCallQueryMechanism.hasMultipleCalls()) {
                datasourceCallQueryMechanism.addCall(datasourceCallQueryMechanism.getCall());
                datasourceCallQueryMechanism.setCall(null);
            }
            datasourceCallQueryMechanism.addCall(this);
            return databaseQueryMechanism;
        }
        return this.buildNewQueryMechanism(databaseQuery);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public abstract String getLogString(Accessor var1);

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public int getReturnType() {
        return this.returnType;
    }

    public boolean isCursorReturned() {
        return this.getReturnType() == 4;
    }

    public boolean isFinished() {
        return !this.isCursorReturned();
    }

    public boolean isNothingReturned() {
        return this.getReturnType() == 1;
    }

    public boolean isOneRowReturned() {
        return this.getReturnType() == 2;
    }

    public boolean isSQLCall() {
        return false;
    }

    public boolean isStoredFunctionCall() {
        return false;
    }

    public boolean isStoredProcedureCall() {
        return false;
    }

    public boolean isJPQLCall() {
        return false;
    }

    public boolean isEISInteraction() {
        return false;
    }

    public boolean isQueryStringCall() {
        return false;
    }

    public void prepare(AbstractSession abstractSession) {
        this.setIsPrepared(true);
    }

    public void returnCursor() {
        this.setReturnType(4);
    }

    public void returnManyRows() {
        this.setReturnType(3);
    }

    public void returnNothing() {
        this.setReturnType(1);
    }

    public void returnOneRow() {
        this.setReturnType(2);
    }

    public void setQuery(DatabaseQuery databaseQuery) {
        this.query = databaseQuery;
    }

    public void setReturnType(int n) {
        this.returnType = n;
    }

    public void translate(AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
    }

    public String getQueryString() {
        return "";
    }

    public void setQueryString(String string) {
    }

    public void translateCustomQuery() {
        if (this.shouldProcessTokenInQuotes) {
            if (this.getQueryString().indexOf("#") == -1) {
                if (this.getQuery().shouldBindAllParameters() && this.getQueryString().indexOf("?") == -1) {
                    return;
                }
                this.translatePureSQLCustomQuery();
                return;
            }
        } else if (!this.hasArgumentMark(this.getQueryString(), '#')) {
            if (this.getQuery().shouldBindAllParameters() && !this.hasArgumentMark(this.getQueryString(), '?')) {
                return;
            }
            this.translatePureSQLCustomQuery();
            return;
        }
        int n = 0;
        String string = this.getQueryString();
        CharArrayWriter charArrayWriter = new CharArrayWriter(string.length() + 50);
        try {
            while (n != -1) {
                DatabaseField databaseField;
                String string2;
                int n2;
                String string3;
                int n3 = string.indexOf(35, n);
                if (n3 == -1) {
                    string3 = string.substring(n, string.length());
                    n = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    string3 = string.substring(n, n3);
                } else {
                    n2 = 1;
                    int n4 = n3;
                    while ((n4 = string.lastIndexOf(39, n4 - 1)) != -1 && n4 > n) {
                        n2 = n2 == 0 ? 1 : 0;
                    }
                    int n5 = -1;
                    if (n2 == 0) {
                        n5 = string.indexOf(39, n3 + 1);
                    }
                    if (n5 != -1) {
                        string3 = string.substring(n, n5 + 1);
                        n3 = -1;
                        n = n5 + 1;
                    } else {
                        string3 = string.substring(n, n3);
                        n = n3 + 1;
                    }
                }
                charArrayWriter.write(string3);
                if (n3 == -1) continue;
                for (n2 = n3 + 1; n2 < string.length() && this.whitespace().indexOf(string.charAt(n2)) == -1; ++n2) {
                }
                if (string.charAt(n3 + 1) == '#') {
                    if (string.charAt(n3 + 2) == '#') {
                        if (string.charAt(n3 + 3) == '#') {
                            string2 = string.substring(n3 + 4, n2);
                            databaseField = this.createField(string2);
                            this.appendInOut(charArrayWriter, databaseField);
                        } else {
                            string2 = string.substring(n3 + 3, n2);
                            databaseField = this.createField(string2);
                            this.appendOut(charArrayWriter, databaseField);
                        }
                    } else {
                        string2 = string.substring(n3 + 2, n2);
                        databaseField = this.createField(string2);
                        this.appendModify(charArrayWriter, databaseField);
                    }
                } else {
                    string2 = string.substring(n3 + 1, n2);
                    databaseField = this.createField(string2);
                    this.appendIn(charArrayWriter, databaseField);
                }
                n = n2;
            }
            this.setQueryString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void translatePureSQLCustomQuery() {
        int n = 0;
        String string = this.getQueryString();
        int n2 = 1;
        CharArrayWriter charArrayWriter = new CharArrayWriter(string.length() + 50);
        try {
            while (n != -1) {
                int n3;
                String string2;
                int n4 = string.indexOf(63, n);
                if (n4 == -1) {
                    string2 = string.substring(n, string.length());
                    n = -1;
                } else if (this.shouldProcessTokenInQuotes) {
                    string2 = string.substring(n, n4);
                    n = n4 + 1;
                } else {
                    n3 = 1;
                    int n5 = n4;
                    while ((n5 = string.lastIndexOf(39, n5 - 1)) != -1 && n5 > n) {
                        n3 = n3 == 0 ? 1 : 0;
                    }
                    int n6 = -1;
                    if (n3 == 0) {
                        n6 = string.indexOf(39, n4 + 1);
                    }
                    if (n6 != -1) {
                        string2 = string.substring(n, n6 + 1);
                        n4 = -1;
                        n = n6 + 1;
                    } else {
                        string2 = string.substring(n, n4);
                        n = n4 + 1;
                    }
                }
                charArrayWriter.write(string2);
                if (n4 == -1) continue;
                for (n3 = n4 + 1; n3 < string.length() && this.whitespace().indexOf(string.charAt(n3)) == -1; ++n3) {
                }
                if (n3 > n4 + 1) {
                    String string3 = string.substring(n4 + 1, n3);
                    DatabaseField databaseField = this.createField(string3);
                    this.appendIn(charArrayWriter, databaseField);
                    n = n3;
                    continue;
                }
                DatabaseField databaseField = this.createField(String.valueOf(n2));
                ++n2;
                this.appendIn(charArrayWriter, databaseField);
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.setQueryString(((Object)charArrayWriter).toString());
    }

    protected DatabaseField createField(String string) {
        return new DatabaseField(string);
    }

    public void appendLiteral(Writer writer, Object object) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(object);
        this.getParameterTypes().addElement(LITERAL);
    }

    public void appendTranslation(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(TRANSLATION);
    }

    public void appendModify(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(MODIFY);
    }

    public void appendIn(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(IN);
    }

    public void appendInOut(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        Object[] objectArray = new Object[]{databaseField, databaseField};
        this.getParameters().addElement(objectArray);
        this.getParameterTypes().addElement(INOUT);
    }

    public void appendOut(Writer writer, DatabaseField databaseField) {
        try {
            writer.write(this.argumentMarker());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        this.getParameters().addElement(databaseField);
        this.getParameterTypes().addElement(OUT);
    }

    public void appendParameter(Writer writer, Object object, AbstractSession abstractSession) {
        abstractSession.getDatasourcePlatform().appendParameter(this, writer, object);
    }

    protected char argumentMarker() {
        return '?';
    }

    protected String whitespace() {
        return ",); \n\t:";
    }

    public void translateQueryString(AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
        if (this.parameters == null || this.getParameters().isEmpty()) {
            return;
        }
        if (this.getQueryString().indexOf(this.argumentMarker()) == -1) {
            return;
        }
        int n = 0;
        int n2 = 0;
        String string = this.getQueryString();
        CharArrayWriter charArrayWriter = new CharArrayWriter(string.length() + 50);
        try {
            Vector vector = this.getParameters();
            Vector vector2 = this.getParameterTypes();
            this.setParameters(NonSynchronizedVector.newInstance(vector.size()));
            while (n != -1) {
                Object object;
                DatabaseField databaseField;
                String string2;
                int n3 = string.indexOf(this.argumentMarker(), n);
                if (n3 == -1) {
                    string2 = string.substring(n, string.length());
                    n = -1;
                } else {
                    string2 = string.substring(n, n3);
                }
                charArrayWriter.write(string2);
                if (n3 == -1) continue;
                Integer n4 = (Integer)vector2.get(n2);
                if (n4 == MODIFY) {
                    databaseField = (DatabaseField)vector.get(n2);
                    object = abstractRecord2.get(databaseField);
                    this.appendParameter(charArrayWriter, object, abstractSession);
                } else if (n4 == CUSTOM_MODIFY) {
                    databaseField = (DatabaseField)vector.get(n2);
                    object = abstractRecord2.get(databaseField);
                    if (object != null && (object = abstractSession.getDatasourcePlatform().getCustomModifyValueForCall(this, object, databaseField, false)) instanceof BindCallCustomParameter && ((BindCallCustomParameter)object).shouldUseUnwrappedConnection()) {
                        this.isNativeConnectionRequired = true;
                    }
                    this.appendParameter(charArrayWriter, object, abstractSession);
                } else if (n4 == TRANSLATION) {
                    databaseField = vector.get(n2);
                    object = null;
                    if (databaseField instanceof ParameterExpression) {
                        object = ((ParameterExpression)((Object)databaseField)).getValue(abstractRecord, abstractSession);
                    } else {
                        DatabaseField databaseField2 = databaseField;
                        object = abstractRecord.get(databaseField2);
                        if (object == null && abstractRecord2 != null) {
                            object = abstractRecord2.get(databaseField2);
                        }
                    }
                    this.appendParameter(charArrayWriter, object, abstractSession);
                } else if (n4 == LITERAL) {
                    databaseField = vector.get(n2);
                    if (databaseField instanceof DatabaseField) {
                        databaseField = null;
                    }
                    this.appendParameter(charArrayWriter, databaseField, abstractSession);
                } else if (n4 == IN) {
                    databaseField = vector.get(n2);
                    object = this.getValueForInParameter(databaseField, abstractRecord, abstractRecord2, abstractSession, false);
                    this.appendParameter(charArrayWriter, object, abstractSession);
                } else if (n4 == INOUT) {
                    databaseField = vector.get(n2);
                    object = this.getValueForInOutParameter(databaseField, abstractRecord, abstractRecord2, abstractSession);
                    this.appendParameter(charArrayWriter, object, abstractSession);
                }
                n = n3 + 1;
                ++n2;
            }
            this.setQueryString(((Object)charArrayWriter).toString());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected Object getValueForInParameter(Object object, AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession, boolean bl) {
        Object object2 = object;
        if (object instanceof ParameterExpression) {
            object2 = ((ParameterExpression)object).getValue(abstractRecord, abstractSession);
        } else if (object instanceof DatabaseField) {
            DatabaseField databaseField;
            DatabaseField databaseField2 = (DatabaseField)object;
            object2 = abstractRecord.get(databaseField2);
            if (abstractRecord2 != null) {
                if (object2 == null) {
                    object2 = abstractRecord2.get(databaseField2);
                }
                if (object2 != null && (databaseField = abstractRecord2.getField(databaseField2)) != null && abstractSession.getDatasourcePlatform().shouldUseCustomModifyForCall(databaseField)) {
                    object2 = abstractSession.getDatasourcePlatform().getCustomModifyValueForCall(this, object2, databaseField, bl);
                }
            }
            if (object2 == null && bl) {
                if (databaseField2.getType() != null || databaseField2.getSqlType() != -1) {
                    object2 = databaseField2;
                } else if (abstractRecord2 != null && (databaseField = abstractRecord2.getField(databaseField2)) != null && databaseField.getType() != null) {
                    object2 = databaseField;
                }
                if (object2 == null) {
                    databaseField = abstractRecord.getField(databaseField2);
                    if (databaseField == null) {
                        abstractSession.log(6, "sql", WarningLocalization.buildMessage("named_argument_not_found_in_query_parameters", new Object[]{databaseField2}));
                    }
                    if (databaseField != null && databaseField.getType() != null) {
                        object2 = databaseField;
                    }
                }
            } else if (object instanceof ObjectRelationalDatabaseField) {
                object2 = new InParameterForCallableStatement(object2, (DatabaseField)object);
            }
        }
        return object2;
    }

    protected Object getValueForInOutParameter(Object object, AbstractRecord abstractRecord, AbstractRecord abstractRecord2, AbstractSession abstractSession) {
        Object object2 = ((Object[])object)[0];
        Object object3 = this.getValueForInParameter(object2, abstractRecord, abstractRecord2, abstractSession, true);
        Object object4 = ((Object[])object)[1];
        return this.createInOutParameter(object3, object4, abstractSession);
    }

    protected Object createInOutParameter(Object object, Object object2, AbstractSession abstractSession) {
        Object[] objectArray = new Object[]{object, object2};
        return objectArray;
    }

    private boolean hasArgumentMark(String string, char c) {
        int n;
        int n2 = -1;
        int n3 = -1;
        do {
            if ((n = string.indexOf(c, n3 + 1)) == -1) {
                return false;
            }
            n2 = string.lastIndexOf(39, n);
            if (n2 == -1) {
                return true;
            }
            boolean bl = false;
            while (n2 != -1 && n2 >= n3) {
                if ((n2 = string.lastIndexOf(39, n2 - 1)) == -1) continue;
                bl = !bl;
            }
            if (!bl) continue;
            return true;
        } while ((n3 = string.indexOf(39, n + 1)) != -1);
        return true;
    }

    public void setIsNativeConnectionRequired(boolean bl) {
        this.isNativeConnectionRequired = bl;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }
}

