/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.dbws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.internal.dbws.DBWSAdapter;
import org.eclipse.persistence.internal.dbws.SOAPAttachmentHandler;
import org.eclipse.persistence.internal.dbws.SOAPResponse;
import org.eclipse.persistence.internal.dbws.SOAPResponseClassLoader;
import org.eclipse.persistence.internal.descriptors.Namespace;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.Operation;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractCompositeCollectionMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.mappings.XMLAnyObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.w3c.dom.Node;

public class SOAPResponseWriter {
    protected DBWSAdapter dbwsAdapter;
    protected Map<String, XMLDescriptor> resultDescriptors = new HashMap<String, XMLDescriptor>();
    protected MessageFactory messageFactory;

    public SOAPResponseWriter(DBWSAdapter dBWSAdapter) {
        this.dbwsAdapter = dBWSAdapter;
        try {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException);
        }
    }

    public void initialize() {
        SOAPResponseClassLoader sOAPResponseClassLoader = new SOAPResponseClassLoader(Thread.currentThread().getContextClassLoader());
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        namespaceResolver.put("srvc", this.dbwsAdapter.getExtendedSchema().getTargetNamespace());
        for (Operation operation : this.dbwsAdapter.getOperationsList()) {
            String string = operation.getName() + "_Response";
            Class<?> clazz = sOAPResponseClassLoader.buildClass(string);
            XMLDescriptor xMLDescriptor = new XMLDescriptor();
            xMLDescriptor.setNamespaceResolver(namespaceResolver);
            xMLDescriptor.setJavaClass(clazz);
            xMLDescriptor.setDefaultRootElement("srvc:" + operation.getName() + "Response");
            if (operation instanceof QueryOperation) {
                Object object;
                Object object2;
                QueryOperation queryOperation = (QueryOperation)operation;
                if (queryOperation.isSimpleXMLFormat()) {
                    object2 = new XMLAnyObjectMapping();
                    ((XMLAnyObjectMapping)object2).setUseXMLRoot(true);
                    ((DatabaseMapping)object2).setAttributeName("result");
                    ((XMLAnyObjectMapping)object2).setXPath("srvc:result");
                    xMLDescriptor.addMapping((DatabaseMapping)object2);
                    ((XMLAnyObjectMapping)object2).initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                } else if (queryOperation.isAttachment()) {
                    object2 = queryOperation.getResult().getAttachment();
                    object = new XMLBinaryDataMapping();
                    ((DatabaseMapping)object).setAttributeName("result");
                    ((XMLBinaryDataMapping)object).setXPath("srvc:result");
                    ((XMLBinaryDataMapping)object).setSwaRef(true);
                    ((XMLBinaryDataMapping)object).setShouldInlineBinaryData(false);
                    ((XMLBinaryDataMapping)object).setMimeType(((Attachment)object2).getMimeType());
                    xMLDescriptor.addMapping((DatabaseMapping)object);
                } else {
                    Map.Entry entry;
                    object2 = queryOperation.getResult().getType();
                    object = null;
                    if (((QName)object2).getPrefix() != null && ((QName)object2).getPrefix().length() > 0) {
                        object = ((QName)object2).getPrefix() + ":";
                    }
                    String string2 = ((QName)object2).getLocalPart();
                    Set set = this.dbwsAdapter.getSchema().getTopLevelComplexTypes().entrySet();
                    Object object3 = set.iterator();
                    while (object3.hasNext()) {
                        entry = object3.next();
                        if (!((ComplexType)entry.getValue()).getName().equals(((QName)object2).getLocalPart())) continue;
                        string2 = (String)entry.getKey();
                        break;
                    }
                    if ((object3 = this.dbwsAdapter.getDescriptorsByQName().get(object2)) != null) {
                        if (queryOperation.isCollection()) {
                            entry = new XMLCompositeCollectionMapping();
                            ((DatabaseMapping)((Object)entry)).setAttributeName("result");
                            ((AggregateMapping)((Object)entry)).setReferenceClass(((ClassDescriptor)object3).getJavaClass());
                            ((AbstractCompositeCollectionMapping)((Object)entry)).useCollectionClass(Vector.class);
                            ((XMLCompositeCollectionMapping)((Object)entry)).setXPath("srvc:result/" + (object == null ? string2 : (String)object + string2));
                            xMLDescriptor.addMapping((DatabaseMapping)((Object)entry));
                            ((XMLCompositeCollectionMapping)((Object)entry)).initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        } else {
                            entry = new XMLCompositeObjectMapping();
                            ((DatabaseMapping)((Object)entry)).setAttributeName("result");
                            ((AggregateMapping)((Object)entry)).setReferenceClass(((ClassDescriptor)object3).getJavaClass());
                            ((XMLCompositeObjectMapping)((Object)entry)).setXPath("srvc:result/" + (object == null ? string2 : (String)object + string2));
                            xMLDescriptor.addMapping((DatabaseMapping)((Object)entry));
                            ((XMLCompositeObjectMapping)((Object)entry)).initialize((AbstractSession)this.dbwsAdapter.getOXSession());
                        }
                        entry = ((XMLDescriptor)object3).getNamespaceResolver().getNamespaces();
                        Iterator iterator = entry.iterator();
                        while (iterator.hasNext()) {
                            Namespace namespace = (Namespace)iterator.next();
                            xMLDescriptor.getNamespaceResolver().put(namespace.getPrefix(), namespace.getNamespaceURI());
                        }
                    } else if (((QName)object2).equals(new QName("http://www.w3.org/2001/XMLSchema", "any"))) {
                        entry = new XMLAnyObjectMapping();
                        ((DatabaseMapping)((Object)entry)).setAttributeName("result");
                        ((XMLAnyObjectMapping)((Object)entry)).setXPath("srvc:result");
                        xMLDescriptor.addMapping((DatabaseMapping)((Object)entry));
                    } else if (((QName)object2).equals(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"))) {
                        entry = new XMLBinaryDataMapping();
                        ((DatabaseMapping)((Object)entry)).setAttributeName("result");
                        ((XMLBinaryDataMapping)((Object)entry)).setXPath("srvc:result");
                        ((XMLBinaryDataMapping)((Object)entry)).setShouldInlineBinaryData(true);
                        ((XMLField)((AbstractDirectMapping)((Object)entry)).getField()).setSchemaType((QName)object2);
                        xMLDescriptor.addMapping((DatabaseMapping)((Object)entry));
                    } else {
                        entry = new XMLDirectMapping();
                        ((DatabaseMapping)((Object)entry)).setAttributeName("result");
                        ((XMLDirectMapping)((Object)entry)).setXPath("srvc:result/text()");
                        xMLDescriptor.addMapping((DatabaseMapping)((Object)entry));
                    }
                }
            }
            this.dbwsAdapter.getOXSession().getProject().addDescriptor(xMLDescriptor);
            ((DatabaseSessionImpl)this.dbwsAdapter.getOXSession()).initializeDescriptorIfSessionAlive(xMLDescriptor);
            this.dbwsAdapter.getXMLContext().storeXMLDescriptorByQName(xMLDescriptor);
            this.resultDescriptors.put(operation.getName(), xMLDescriptor);
        }
    }

    public SOAPMessage generateResponse(Operation operation, EclipseLinkException eclipseLinkException) throws SOAPException {
        SOAPMessage sOAPMessage = this.messageFactory.createMessage();
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        sOAPBody.addFault(new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server"), operation.getName() + " failed: " + eclipseLinkException.getMessage());
        return sOAPMessage;
    }

    public SOAPMessage generateResponse(Operation operation, Object object) throws SOAPException {
        SOAPMessage sOAPMessage = this.messageFactory.createMessage();
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        XMLDescriptor xMLDescriptor = this.resultDescriptors.get(operation.getName());
        SOAPResponse sOAPResponse = null;
        try {
            sOAPResponse = (SOAPResponse)xMLDescriptor.getJavaClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new SOAPException((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SOAPException((Throwable)illegalAccessException);
        }
        sOAPResponse.setResult(object);
        SOAPAttachmentHandler sOAPAttachmentHandler = new SOAPAttachmentHandler();
        XMLMarshaller xMLMarshaller = this.dbwsAdapter.getXMLContext().createMarshaller();
        xMLMarshaller.setAttachmentMarshaller(sOAPAttachmentHandler);
        xMLMarshaller.marshal((Object)sOAPResponse, (Node)sOAPBody);
        if (sOAPAttachmentHandler.hasAttachments()) {
            for (String string : sOAPAttachmentHandler.getAttachments().keySet()) {
                DataHandler dataHandler = sOAPAttachmentHandler.getAttachments().get(string);
                AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart(dataHandler);
                attachmentPart.setContentType(dataHandler.getContentType());
                String string2 = "<" + string.substring(4) + ">";
                attachmentPart.setContentId(string2);
                attachmentPart.setMimeHeader("Content-Transfer-Encoding", "binary");
                sOAPMessage.addAttachmentPart(attachmentPart);
            }
        }
        return sOAPMessage;
    }
}

