/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.descriptors.changetracking;

import java.beans.PropertyChangeEvent;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;

public class AttributeChangeListener
extends ObjectChangeListener {
    protected transient ClassDescriptor descriptor;
    protected transient UnitOfWorkImpl uow;
    protected ObjectChangeSet objectChangeSet;
    protected Object owner;

    public AttributeChangeListener(ClassDescriptor classDescriptor, UnitOfWorkImpl unitOfWorkImpl, Object object) {
        this.descriptor = classDescriptor;
        this.uow = unitOfWorkImpl;
        this.owner = object;
    }

    public ObjectChangeSet getObjectChangeSet() {
        return this.objectChangeSet;
    }

    public void setObjectChangeSet(ObjectChangeSet objectChangeSet) {
        this.objectChangeSet = objectChangeSet;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public UnitOfWorkImpl getUnitOfWork() {
        return this.uow;
    }

    public void setUnitOfWork(UnitOfWorkImpl unitOfWorkImpl) {
        this.uow = unitOfWorkImpl;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.ignoreEvents) {
            return;
        }
        this.internalPropertyChange(propertyChangeEvent);
    }

    public void internalPropertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() == propertyChangeEvent.getOldValue()) {
            return;
        }
        DatabaseMapping databaseMapping = this.descriptor.getObjectBuilder().getMappingForAttributeName(propertyChangeEvent.getPropertyName());
        if (databaseMapping == null) {
            throw ValidationException.wrongPropertyNameInChangeEvent(this.owner.getClass(), propertyChangeEvent.getPropertyName());
        }
        if ((databaseMapping instanceof AbstractDirectMapping || databaseMapping instanceof AbstractTransformationMapping) && (propertyChangeEvent.getNewValue() == null && propertyChangeEvent.getOldValue() == null || propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue().equals(propertyChangeEvent.getOldValue()))) {
            return;
        }
        super.internalPropertyChange(propertyChangeEvent);
        if (this.uow.getUnitOfWorkChangeSet() == null) {
            this.uow.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet(this.uow));
        }
        if (this.objectChangeSet == null) {
            this.uow.addToChangeTrackedHardList(this.owner);
            this.objectChangeSet = this.getDescriptor().getObjectBuilder().createObjectChangeSet(this.owner, (UnitOfWorkChangeSet)this.uow.getUnitOfWorkChangeSet(), false, this.uow);
        }
        if (propertyChangeEvent.getClass().equals(ClassConstants.PropertyChangeEvent_Class)) {
            databaseMapping.updateChangeRecord(propertyChangeEvent.getSource(), propertyChangeEvent.getNewValue(), propertyChangeEvent.getOldValue(), this.objectChangeSet, this.getUnitOfWork());
        } else if (propertyChangeEvent.getClass().equals(ClassConstants.CollectionChangeEvent_Class) || propertyChangeEvent.getClass().equals(ClassConstants.MapChangeEvent_Class)) {
            databaseMapping.updateCollectionChangeRecord((CollectionChangeEvent)propertyChangeEvent, this.objectChangeSet, this.getUnitOfWork());
        } else {
            throw ValidationException.wrongChangeEvent(propertyChangeEvent.getClass());
        }
    }

    public void clearChanges() {
        super.clearChanges();
        this.objectChangeSet = null;
    }
}

