/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakCacheKey;

public class WeakIdentityMap
extends FullIdentityMap {
    protected volatile int cleanupCount = 0;
    protected volatile int cleanupSize;

    public WeakIdentityMap(int n, ClassDescriptor classDescriptor) {
        super(n, classDescriptor);
        this.cleanupSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupDeadCacheKeys() {
        Iterator<CacheKey> iterator = this.getCacheKeys().values().iterator();
        while (iterator.hasNext()) {
            CacheKey cacheKey = iterator.next();
            if (cacheKey.getObject() != null || !cacheKey.acquireIfUnownedNoWait()) continue;
            try {
                if (cacheKey.getObject() != null) continue;
                iterator.remove();
            }
            finally {
                cacheKey.release();
            }
        }
    }

    public CacheKey createCacheKey(Vector vector, Object object, Object object2, long l) {
        return new WeakCacheKey(vector, object, object2, l);
    }

    protected CacheKey getCacheKeyIfAbsentPut(CacheKey cacheKey) {
        CacheKey cacheKey2 = super.getCacheKeyIfAbsentPut(cacheKey);
        if (cacheKey2 == null) {
            this.checkCleanup();
        }
        return cacheKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCleanup() {
        if (this.cleanupCount > this.cleanupSize) {
            WeakIdentityMap weakIdentityMap = this;
            synchronized (weakIdentityMap) {
                if (this.cleanupCount > this.cleanupSize) {
                    this.cleanupDeadCacheKeys();
                    this.cleanupCount = 0;
                    int n = this.getSize();
                    if (n > this.cleanupSize) {
                        this.cleanupSize = n;
                    }
                }
            }
        }
        ++this.cleanupCount;
    }
}

