/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetField;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;
import org.eclipse.persistence.internal.security.PrivilegedGetValueFromField;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedSetValueInField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class CMP3Policy
extends CMPPolicy {
    protected CMPPolicy.KeyElementAccessor[] keyClassFields;
    protected HashMap<DatabaseField, CMPPolicy.KeyElementAccessor> fieldToAccessorMap;
    protected String pkClassName;
    protected Class pkClass;

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.getPKClassName() != null) {
            try {
                Class clazz = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getPKClassName(), true, classLoader));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("pk_class_not_found", new Object[]{this.pkClassName}), privilegedActionException.getException());
                    }
                } else {
                    clazz = PrivilegedAccessHelper.getClassForName(this.getPKClassName(), true, classLoader);
                }
                this.setPKClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("pk_class_not_found", new Object[]{this.pkClassName}), classNotFoundException);
            }
        }
    }

    public boolean isCMP3Policy() {
        return true;
    }

    public void setPrimaryKeyClassName(String string) {
        this.pkClassName = string;
    }

    public Class getPKClass() {
        if (this.pkClass == null && this.getPKClassName() == null) {
            this.getKeyClassFields(null);
        }
        return this.pkClass;
    }

    public void setPKClass(Class clazz) {
        this.pkClass = clazz;
    }

    public String getPKClassName() {
        return this.pkClassName;
    }

    public Object getPKClassInstance() {
        try {
            return this.getPKClass().newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Vector createPkVectorFromKey(Object object, AbstractSession abstractSession) {
        CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(object.getClass());
        NonSynchronizedVector nonSynchronizedVector = new NonSynchronizedVector(keyElementAccessorArray.length);
        for (int i = 0; i < keyElementAccessorArray.length; ++i) {
            DatabaseMapping databaseMapping = keyElementAccessorArray[i].getMapping();
            Object object2 = null;
            if (databaseMapping.isDirectToFieldMapping()) {
                object2 = ((AbstractDirectMapping)databaseMapping).getFieldValue(keyElementAccessorArray[i].getValue(object, abstractSession), abstractSession);
            } else {
                object2 = keyElementAccessorArray[i].getValue(object, abstractSession);
                if (object2 != null && this.pkClass != null && databaseMapping.isOneToOneMapping()) {
                    OneToOneMapping oneToOneMapping = (OneToOneMapping)databaseMapping;
                    DatabaseField databaseField = oneToOneMapping.getSourceToTargetKeyFields().get(keyElementAccessorArray[i].getDatabaseField());
                    CMPPolicy cMPPolicy = oneToOneMapping.getReferenceDescriptor().getCMPPolicy();
                    if (cMPPolicy.isCMP3Policy()) {
                        Class clazz = cMPPolicy.getPKClass();
                        if (clazz != null && clazz != object2.getClass() && !clazz.isAssignableFrom(object2.getClass())) {
                            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{clazz, object2.getClass()}));
                        }
                        object2 = ((CMP3Policy)cMPPolicy).getPkValueFromKeyForField(object2, databaseField, abstractSession);
                    }
                }
            }
            ((Vector)nonSynchronizedVector).add(object2);
        }
        return nonSynchronizedVector;
    }

    public Object createBeanUsingKey(Object object, AbstractSession abstractSession) {
        try {
            Object object2 = this.getDescriptor().getInstantiationPolicy().buildNewInstance();
            CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = this.getKeyClassFields(object.getClass());
            for (int i = 0; i < keyElementAccessorArray.length; ++i) {
                Object object3 = object2;
                Object object4 = keyElementAccessorArray[i].getValue(object, abstractSession);
                DatabaseField databaseField = keyElementAccessorArray[i].getDatabaseField();
                DatabaseMapping databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessorArray[i].getAttributeName());
                if (databaseMapping == null) {
                    databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(databaseField);
                }
                while (databaseMapping.isAggregateObjectMapping()) {
                    Object object5 = databaseMapping.getRealAttributeValueFromObject(object3, abstractSession);
                    if (object5 == null) {
                        object5 = databaseMapping.getReferenceDescriptor().getJavaClass().newInstance();
                        databaseMapping.setRealAttributeValueInObject(object3, object5);
                    }
                    if ((databaseMapping = databaseMapping.getReferenceDescriptor().getObjectBuilder().getMappingForAttributeName(keyElementAccessorArray[i].getAttributeName())) == null) {
                        databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField(databaseField);
                    }
                    object3 = object5;
                }
                databaseMapping.setRealAttributeValueInObject(object3, object4);
            }
            return object2;
        }
        catch (Exception exception) {
            throw DescriptorException.errorUsingPrimaryKey(object, this.getDescriptor(), exception);
        }
    }

    protected CMPPolicy.KeyElementAccessor[] initializePrimaryKeyFields(Class clazz) {
        CMPPolicy.KeyElementAccessor[] keyElementAccessorArray = null;
        ClassDescriptor classDescriptor = this.getDescriptor();
        this.fieldToAccessorMap = new HashMap();
        int n = classDescriptor.getPrimaryKeyFields().size();
        keyElementAccessorArray = new CMPPolicy.KeyElementAccessor[n];
        Iterator<DatabaseField> iterator = classDescriptor.getPrimaryKeyFields().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            DatabaseField databaseField = iterator.next();
            List<DatabaseMapping> list = classDescriptor.getObjectBuilder().getReadOnlyMappingsForField(databaseField);
            if (list == null) {
                list = new Vector<DatabaseMapping>(1);
            }
            list.add(classDescriptor.getObjectBuilder().getMappingForField(databaseField));
            DatabaseMapping databaseMapping = null;
            NoSuchMethodException noSuchMethodException = null;
            for (int i = list.size() - 1; i >= 0; --i) {
                Serializable serializable;
                List<DatabaseMapping> list2;
                Object object;
                databaseMapping = list.get(i);
                if (classDescriptor.isIDSpecified() && !databaseMapping.isIDMapping() || databaseMapping.isForeignReferenceMapping() && !databaseMapping.isOneToOneMapping()) continue;
                if (databaseMapping.isAggregateMapping()) {
                    object = databaseMapping.getReferenceDescriptor().getObjectBuilder();
                    list2 = ((ObjectBuilder)object).getReadOnlyMappingsForField(databaseField);
                    if (list2 != null && !list2.isEmpty()) {
                        list.addAll(list2);
                    }
                    if ((serializable = ((ObjectBuilder)object).getMappingForField(databaseField)) != null) {
                        list.add((DatabaseMapping)serializable);
                    }
                    list.remove(databaseMapping);
                    i = list.size();
                    continue;
                }
                object = databaseMapping.getAttributeName();
                if (clazz == null) {
                    keyElementAccessorArray[n2] = new CMPPolicy.KeyIsElementAccessor((String)object, databaseField, databaseMapping);
                    if (databaseMapping.isDirectToFieldMapping()) {
                        this.setPKClass(ConversionManager.getObjectClass(databaseMapping.getAttributeClassification()));
                    } else if (databaseMapping.isOneToOneMapping()) {
                        list2 = databaseMapping.getReferenceDescriptor().getCMPPolicy();
                        this.setPKClass(((CMPPolicy)((Object)list2)).getPKClass());
                    }
                    this.fieldToAccessorMap.put(databaseField, keyElementAccessorArray[n2]);
                    noSuchMethodException = null;
                } else {
                    try {
                        list2 = null;
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                list2 = (Field)AccessController.doPrivileged(new PrivilegedGetField(clazz, (String)object, true));
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                throw (NoSuchFieldException)privilegedActionException.getException();
                            }
                        } else {
                            list2 = PrivilegedAccessHelper.getField(clazz, (String)object, true);
                        }
                        keyElementAccessorArray[n2] = new FieldAccessor((Field)((Object)list2), (String)object, databaseField, databaseMapping);
                        this.fieldToAccessorMap.put(databaseField, keyElementAccessorArray[n2]);
                        noSuchMethodException = null;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        serializable = new StringBuffer();
                        ((StringBuffer)serializable).append("get");
                        ((StringBuffer)serializable).append(((String)object).substring(0, 1).toUpperCase());
                        ((StringBuffer)serializable).append(((String)object).substring(1));
                        try {
                            Method method = null;
                            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                try {
                                    method = AccessController.doPrivileged(new PrivilegedGetMethod(clazz, ((StringBuffer)serializable).toString(), new Class[0], true));
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throw (NoSuchMethodException)privilegedActionException.getException();
                                }
                            } else {
                                method = PrivilegedAccessHelper.getMethod(clazz, ((StringBuffer)serializable).toString(), new Class[0], true);
                            }
                            keyElementAccessorArray[n2] = new PropertyAccessor(method, (String)object, databaseField, databaseMapping);
                            this.fieldToAccessorMap.put(databaseField, keyElementAccessorArray[n2]);
                            noSuchMethodException = null;
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            noSuchMethodException = noSuchMethodException2;
                        }
                    }
                }
                if (databaseMapping.isIDMapping() || noSuchMethodException == null) break;
            }
            if (noSuchMethodException != null) {
                throw DescriptorException.errorUsingPrimaryKey(clazz, this.getDescriptor(), noSuchMethodException);
            }
            ++n2;
        }
        return keyElementAccessorArray;
    }

    protected CMPPolicy.KeyElementAccessor[] getKeyClassFields(Class clazz) {
        if (this.keyClassFields == null) {
            this.keyClassFields = this.initializePrimaryKeyFields(this.pkClass);
        }
        return this.keyClassFields;
    }

    public Object getPkValueFromKeyForField(Object object, DatabaseField databaseField, AbstractSession abstractSession) {
        Object object2 = null;
        this.getKeyClassFields(object.getClass());
        CMPPolicy.KeyElementAccessor keyElementAccessor = this.fieldToAccessorMap.get(databaseField);
        DatabaseMapping databaseMapping = keyElementAccessor.getMapping();
        if (databaseMapping.isDirectToFieldMapping()) {
            object2 = ((AbstractDirectMapping)databaseMapping).getFieldValue(keyElementAccessor.getValue(object, abstractSession), abstractSession);
        } else {
            object2 = keyElementAccessor.getValue(object, abstractSession);
            if (databaseMapping.isOneToOneMapping()) {
                OneToOneMapping oneToOneMapping = (OneToOneMapping)databaseMapping;
                DatabaseField databaseField2 = oneToOneMapping.getSourceToTargetKeyFields().get(databaseField);
                CMPPolicy cMPPolicy = oneToOneMapping.getReferenceDescriptor().getCMPPolicy();
                if (cMPPolicy.isCMP3Policy()) {
                    Class clazz = cMPPolicy.getPKClass();
                    if (clazz != null && clazz != object2.getClass() && !clazz.isAssignableFrom(object2.getClass())) {
                        throw new IllegalArgumentException(ExceptionLocalization.buildMessage("invalid_pk_class", new Object[]{cMPPolicy.getPKClass(), object2.getClass()}));
                    }
                    object2 = ((CMP3Policy)cMPPolicy).getPkValueFromKeyForField(object2, databaseField2, abstractSession);
                }
            }
        }
        return object2;
    }

    private class FieldAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Field field;
        protected String attributeName;
        protected DatabaseField databaseField;
        protected DatabaseMapping mapping;

        public FieldAccessor(Field field, String string, DatabaseField databaseField, DatabaseMapping databaseMapping) {
            this.field = field;
            this.attributeName = string;
            this.databaseField = databaseField;
            this.mapping = databaseMapping;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public Object getValue(Object object, AbstractSession abstractSession) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedGetValueFromField(this.field, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), privilegedActionException.getException());
                    }
                }
                return PrivilegedAccessHelper.getValueFromField(this.field, object);
            }
            catch (Exception exception) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), exception);
            }
        }

        public void setValue(Object object, Object object2) {
            block5: {
                try {
                    Field field = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            field = (Field)AccessController.doPrivileged(new PrivilegedGetField(object.getClass(), this.field.getName(), true));
                            AccessController.doPrivileged(new PrivilegedSetValueInField(field, object, object2));
                            break block5;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), privilegedActionException.getException());
                        }
                    }
                    field = PrivilegedAccessHelper.getField(object.getClass(), this.field.getName(), true);
                    PrivilegedAccessHelper.setValueInField(field, object, object2);
                }
                catch (Exception exception) {
                    throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), exception);
                }
            }
        }
    }

    private class PropertyAccessor
    implements CMPPolicy.KeyElementAccessor {
        protected Method method;
        protected String attributeName;
        protected DatabaseField databaseField;
        protected DatabaseMapping mapping;

        public PropertyAccessor(Method method, String string, DatabaseField databaseField, DatabaseMapping databaseMapping) {
            this.method = method;
            this.attributeName = string;
            this.databaseField = databaseField;
            this.mapping = databaseMapping;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public DatabaseField getDatabaseField() {
            return this.databaseField;
        }

        public DatabaseMapping getMapping() {
            return this.mapping;
        }

        public Object getValue(Object object, AbstractSession abstractSession) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(this.method, object, new Object[0]));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw (IllegalAccessException)exception;
                        }
                        throw (InvocationTargetException)exception;
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(this.method, object, new Object[0]);
            }
            catch (Exception exception) {
                throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), exception);
            }
        }

        public void setValue(Object object, Object object2) {
            block6: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(new MetadataMethod(this.method, object.getClass()).getSetMethod(), object, new Object[]{object2}));
                            break block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            if (exception instanceof IllegalAccessException) {
                                throw (IllegalAccessException)exception;
                            }
                            throw (InvocationTargetException)exception;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(new MetadataMethod(this.method, object.getClass()).getSetMethod(), object, new Object[]{object2});
                }
                catch (Exception exception) {
                    throw DescriptorException.errorUsingPrimaryKey(object, CMP3Policy.this.getDescriptor(), exception);
                }
            }
        }
    }
}

