/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import java.util.Map;
import java.util.Set;
import javax.persistence.Cache;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.FlushModeType;
import javax.persistence.PersistenceException;
import javax.persistence.QueryBuilder;
import org.eclipse.persistence.internal.jpa.CacheImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerSetupImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.sessions.PropertiesHandler;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.server.ServerSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerFactoryImpl
implements EntityManagerFactory {
    protected Cache myCache;
    protected volatile ServerSession serverSession;
    protected EntityManagerSetupImpl setupImpl;
    protected boolean isOpen = true;
    protected Map properties;
    protected boolean beginEarlyTransaction;
    protected FlushModeType flushMode = FlushModeType.AUTO;
    protected ReferenceMode referenceMode = ReferenceMode.HARD;
    protected boolean closeOnCommit;
    protected boolean persistOnCommit = true;
    protected String flushClearCache = "DropInvalidate";
    protected boolean shouldValidateExistence;

    public EntityManagerFactoryImpl(ServerSession serverSession) {
        this.serverSession = serverSession;
        this.processProperties(serverSession.getProperties());
    }

    public EntityManagerFactoryImpl(EntityManagerSetupImpl entityManagerSetupImpl, Map map) {
        this.setupImpl = entityManagerSetupImpl;
        this.properties = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerSession getServerSession() {
        if (this.serverSession == null) {
            EntityManagerFactoryImpl entityManagerFactoryImpl = this;
            synchronized (entityManagerFactoryImpl) {
                if (this.serverSession == null) {
                    ClassLoader classLoader = this.setupImpl.getPersistenceUnitInfo().getClassLoader();
                    ServerSession serverSession = this.setupImpl.deploy(classLoader, this.properties);
                    this.processProperties(serverSession.getProperties());
                    this.serverSession = serverSession;
                }
            }
        }
        return this.serverSession;
    }

    public synchronized void close() {
        this.verifyOpen();
        this.isOpen = false;
        if (this.setupImpl != null) {
            this.setupImpl.undeploy();
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public EntityManager createEntityManager() {
        return this.createEntityManagerImpl(null);
    }

    public EntityManager createEntityManager(Map map) {
        return this.createEntityManagerImpl(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerImpl createEntityManagerImpl(Map map) {
        this.verifyOpen();
        ServerSession serverSession = this.getServerSession();
        if (!serverSession.isLoggedIn()) {
            ServerSession serverSession2 = serverSession;
            synchronized (serverSession2) {
                if (!serverSession.isLoggedIn()) {
                    serverSession.login();
                }
            }
        }
        return new EntityManagerImpl(this, map);
    }

    protected void verifyOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException(ExceptionLocalization.buildMessage("operation_on_closed_entity_manager_factory"));
        }
    }

    protected void finalize() throws Throwable {
        if (this.isOpen()) {
            this.close();
        }
    }

    public Object getProperty(String string) {
        if (string == null) {
            return null;
        }
        return this.getServerSession().getProperty(string);
    }

    protected void processProperties(Map map) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.transaction.join-existing", map, this.serverSession, true);
        if (string7 != null) {
            this.beginEarlyTransaction = "true".equalsIgnoreCase(string7);
        }
        if ((string6 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.reference-mode", map, this.serverSession, true)) != null) {
            this.referenceMode = ReferenceMode.valueOf(string6);
        }
        if ((string5 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.flush-mode", map, this.serverSession, true)) != null) {
            this.flushMode = FlushModeType.valueOf((String)string5);
        }
        if ((string4 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.close-on-commit", map, this.serverSession, true)) != null) {
            this.closeOnCommit = "true".equalsIgnoreCase(string4);
        }
        if ((string3 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.persistence-context.persist-on-commit", map, this.serverSession, true)) != null) {
            this.persistOnCommit = "true".equalsIgnoreCase(string3);
        }
        if ((string2 = PropertiesHandler.getPropertyValueLogDebug("eclipselink.validate-existence", map, this.serverSession, true)) != null) {
            this.shouldValidateExistence = "true".equalsIgnoreCase(string2);
        }
        if ((string = PropertiesHandler.getPropertyValueLogDebug("eclipselink.flush-clear.cache", map, this.serverSession, true)) != null) {
            this.flushClearCache = string;
        }
    }

    public boolean getBeginEarlyTransaction() {
        return this.beginEarlyTransaction;
    }

    public void setBeginEarlyTransaction(boolean bl) {
        this.beginEarlyTransaction = bl;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.flushMode = flushModeType;
    }

    public ReferenceMode getReferenceMode() {
        return this.referenceMode;
    }

    public void setReferenceMode(ReferenceMode referenceMode) {
        this.referenceMode = referenceMode;
    }

    public boolean getCloseOnCommit() {
        return this.closeOnCommit;
    }

    public void setCloseOnCommit(boolean bl) {
        this.closeOnCommit = bl;
    }

    public boolean getPersistOnCommit() {
        return this.persistOnCommit;
    }

    public void setPersistOnCommit(boolean bl) {
        this.persistOnCommit = bl;
    }

    public String getFlushClearCache() {
        return this.flushClearCache;
    }

    public void setFlushClearCache(String string) {
        this.flushClearCache = string;
    }

    public boolean shouldValidateExistence() {
        return this.shouldValidateExistence;
    }

    public void setShouldValidateExistence(boolean bl) {
        this.shouldValidateExistence = bl;
    }

    public Cache getCache() {
        this.verifyOpen();
        if (this.myCache == null) {
            ServerSession serverSession = this.getServerSession();
            this.myCache = new CacheImpl(this, serverSession.getIdentityMapAccessor());
        }
        return this.myCache;
    }

    public Map getProperties() {
        throw new PersistenceException("Not Yet Implemented");
    }

    public QueryBuilder getQueryBuilder() {
        throw new PersistenceException("Not Yet Implemented");
    }

    public Set<String> getSupportedProperties() {
        throw new PersistenceException("Not Yet Implemented");
    }
}

