/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.converters.Converter;

public abstract class DirectCollectionAccessor
extends DirectAccessor {
    private Enum m_joinFetch;
    private boolean m_keyContextProcessing;

    protected DirectCollectionAccessor(String string) {
        super(string);
    }

    protected DirectCollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object t;
        if (annotation != null) {
            this.setFetch((Enum)MetadataHelper.invokeMethod("fetch", annotation));
        }
        if ((t = this.getAnnotation(JoinFetch.class)) != null) {
            this.m_joinFetch = (Enum)MetadataHelper.invokeMethod("value", t);
        }
    }

    protected String getDefaultCollectionTableName() {
        return this.getDescriptor().getAlias() + "_" + this.getUpperCaseAttributeName();
    }

    public FetchType getDefaultFetchType() {
        return FetchType.LAZY;
    }

    public Enum getJoinFetch() {
        return this.m_joinFetch;
    }

    public String getPrivateOwned() {
        return null;
    }

    public Class getReferenceClass() {
        Class clazz = this.getReferenceClassFromGeneric();
        return clazz == null ? Void.TYPE : clazz;
    }

    protected abstract String getKeyConverter();

    protected String getValueConverter() {
        return this.getConvert();
    }

    public boolean isDirectCollection() {
        return true;
    }

    protected boolean isKeyContextProcessing() {
        return this.m_keyContextProcessing;
    }

    protected boolean isValidDirectCollectionType() {
        return this.getAccessibleObject().isSupportedDirectCollectionClass(this.getDescriptor());
    }

    protected boolean isValidDirectMapType() {
        return this.getAccessibleObject().isSupportedDirectMapClass(this.getDescriptor());
    }

    protected void process(CollectionMapping collectionMapping) {
        collectionMapping.setAttributeName(this.getAttributeName());
        this.setAccessorMethods(collectionMapping);
        collectionMapping.setJoinFetch(this.getMappingJoinFetchType(this.m_joinFetch));
        this.processCollectionTable(collectionMapping);
        this.processReturnInsertAndUpdate();
        this.addMapping(collectionMapping);
    }

    protected abstract void processCollectionTable(CollectionMapping var1);

    public void processConvert() {
        DatabaseMapping databaseMapping = this.getMapping();
        if (databaseMapping.isDirectMapMapping()) {
            this.m_keyContextProcessing = true;
            this.processConvert(databaseMapping, this.getKeyConverter());
        }
        this.m_keyContextProcessing = false;
        this.processConvert(databaseMapping, this.getValueConverter());
    }

    protected void processDirectCollectionMapping() {
        DirectCollectionMapping directCollectionMapping = new DirectCollectionMapping();
        this.process(directCollectionMapping);
        this.setIndirectionPolicy(directCollectionMapping, null, this.usesIndirection());
        directCollectionMapping.setDirectField(this.getDatabaseField(directCollectionMapping.getReferenceTable(), "metadata_default_value_column"));
        this.processMappingConverter(directCollectionMapping, this.getValueConverter());
    }

    protected void processDirectMapMapping() {
        DirectMapMapping directMapMapping = new DirectMapMapping();
        this.process(directMapMapping);
        this.setIndirectionPolicy(directMapMapping, null, this.usesIndirection());
        directMapMapping.setDirectKeyField(this.getDatabaseField(directMapMapping.getReferenceTable(), "metadata_default_key_column"));
        this.processMappingConverter(directMapMapping, this.getKeyConverter());
        directMapMapping.setDirectField(this.getDatabaseField(directMapMapping.getReferenceTable(), "metadata_default_value_column"));
        this.processMappingConverter(directMapMapping, this.getValueConverter());
    }

    public void setConverter(DatabaseMapping databaseMapping, Converter converter) {
        if (databaseMapping.isDirectMapMapping() && this.isKeyContextProcessing()) {
            ((DirectMapMapping)databaseMapping).setKeyConverter(converter);
        } else {
            ((DirectCollectionMapping)databaseMapping).setValueConverter(converter);
        }
    }

    public void setConverterClassName(DatabaseMapping databaseMapping, String string) {
        if (databaseMapping.isDirectMapMapping() && this.isKeyContextProcessing()) {
            ((DirectMapMapping)databaseMapping).setKeyConverterClassName(string);
        } else {
            ((DirectCollectionMapping)databaseMapping).setValueConverterClassName(string);
        }
    }

    public void setFieldClassification(DatabaseMapping databaseMapping, Class clazz) {
        if (databaseMapping.isDirectMapMapping() && this.isKeyContextProcessing()) {
            ((DirectMapMapping)databaseMapping).setDirectKeyFieldClassification(clazz);
        } else {
            ((DirectCollectionMapping)databaseMapping).setDirectFieldClassification(clazz);
        }
    }

    public void setJoinFetch(Enum enum_) {
        this.m_joinFetch = enum_;
    }
}

