/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;

public class EmbeddedIdAccessor
extends EmbeddedAccessor {
    protected HashMap<String, DatabaseField> m_idFields = new HashMap();

    public EmbeddedIdAccessor() {
        super("<embedded-id>");
    }

    public EmbeddedIdAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
    }

    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String string, DatabaseField databaseField, DatabaseMapping databaseMapping) {
        super.addFieldNameTranslation(embeddableMapping, string, databaseField, databaseMapping);
        this.m_idFields.put(databaseMapping.getAttributeName(), databaseField);
    }

    public boolean isEmbeddedId() {
        return true;
    }

    public void process() {
        if (this.getOwningDescriptor().hasEmbeddedIdAttribute()) {
            throw ValidationException.multipleEmbeddedIdAnnotationsFound(this.getJavaClass(), this.getAttributeName(), this.getOwningDescriptor().getEmbeddedIdAttributeName());
        }
        if (this.getOwningDescriptor().hasPrimaryKeyFields()) {
            throw ValidationException.embeddedIdAndIdAnnotationFound(this.getJavaClass(), this.getAttributeName(), this.getOwningDescriptor().getIdAttributeName());
        }
        super.process();
        this.getOwningDescriptor().setPKClass(this.getReferenceClass());
        this.getOwningDescriptor().setEmbeddedIdAttributeName(this.getAttributeName());
        if (this.getReferenceDescriptor().getMappings().isEmpty()) {
            throw ValidationException.embeddedIdHasNoAttributes(this.getDescriptor().getJavaClass(), this.getReferenceDescriptor().getJavaClass(), this.getReferenceDescriptor().getClassAccessor().getAccess());
        }
        for (DatabaseMapping cloneable : this.getReferenceDescriptor().getMappings()) {
            if (cloneable.isDirectToFieldMapping()) {
                cloneable.setIsIDMapping(true);
                if (this.m_idFields.containsKey(cloneable.getAttributeName())) continue;
                this.m_idFields.put(cloneable.getAttributeName(), cloneable.getField());
                continue;
            }
            throw ValidationException.invalidMappingForEmbeddedId(this.getAttributeName(), this.getJavaClass(), cloneable.getAttributeName(), this.getReferenceDescriptor().getJavaClass());
        }
        for (DatabaseField databaseField : this.m_idFields.values()) {
            if (this.getOwningDescriptor().getPrimaryKeyFieldNames().contains(databaseField.getName())) continue;
            DatabaseField databaseField2 = (DatabaseField)databaseField.clone();
            if (databaseField2.getTableName().equals("")) {
                databaseField2.setTable(this.getOwningDescriptor().getPrimaryTable());
            }
            this.getOwningDescriptor().addPrimaryKeyField(databaseField2);
        }
    }
}

