/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.Column;
import javax.persistence.FetchType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.ReturnInsert;
import org.eclipse.persistence.annotations.ReturnUpdate;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.AccessMethodsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MappingAccessor
extends MetadataAccessor {
    private AccessMethodsMetadata m_accessMethods;
    private ClassAccessor m_classAccessor;
    private DatabaseMapping m_mapping;
    private Map<String, PropertyMetadata> m_properties = new HashMap<String, PropertyMetadata>();

    protected MappingAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor.getDescriptor(), classAccessor.getProject());
        this.m_classAccessor = classAccessor;
    }

    protected MappingAccessor(String string) {
        super(string);
    }

    protected void addMapping(DatabaseMapping databaseMapping) {
        this.processProperties(databaseMapping);
        this.getDescriptor().getClassDescriptor().addMapping(databaseMapping);
        this.m_mapping = databaseMapping;
    }

    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String string, DatabaseField databaseField, DatabaseMapping databaseMapping) {
        DatabaseField databaseField2 = databaseMapping.getField();
        if (this.getOwningDescriptor().isPrimaryKeyField(databaseField2)) {
            this.getOwningDescriptor().removePrimaryKeyField(databaseField2);
            this.getOwningDescriptor().addPrimaryKeyField(databaseField);
        }
        if (string.indexOf(".") > -1) {
            embeddableMapping.addNestedFieldNameTranslation(string, databaseField.getQualifiedName(), databaseField2.getName());
        } else {
            embeddableMapping.addFieldNameTranslation(databaseField.getQualifiedName(), databaseField2.getName());
        }
    }

    public AccessMethodsMetadata getAccessMethods() {
        return this.m_accessMethods;
    }

    public ClassAccessor getClassAccessor() {
        return this.m_classAccessor;
    }

    protected Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    protected String getGetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getGetMethodName() != null) {
            return this.m_accessMethods.getGetMethodName();
        }
        return this.getAccessibleObjectName();
    }

    public DatabaseMapping getMapping() {
        return this.m_mapping;
    }

    protected int getMappingJoinFetchType(Enum enum_) {
        if (enum_ == null) {
            return 0;
        }
        if (enum_.name().equals(JoinFetchType.INNER.name())) {
            return 1;
        }
        return 2;
    }

    public Class getRawClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClass() {
        return this.getAccessibleObject().getRawClass(this.getDescriptor());
    }

    public Class getReferenceClassFromGeneric() {
        return this.getAccessibleObject().getReferenceClassFromGeneric(this.getDescriptor());
    }

    public String getReferenceClassName() {
        return this.getReferenceClass().getName();
    }

    public MetadataDescriptor getReferenceDescriptor() {
        return this.getReferenceDescriptor(this.getReferenceClassName());
    }

    public MetadataDescriptor getReferenceDescriptor(String string) {
        ClassAccessor classAccessor = this.getProject().getAccessor(string);
        if (classAccessor == null) {
            throw ValidationException.classNotListedInPersistenceUnit(string);
        }
        return classAccessor.getDescriptor();
    }

    protected String getSetMethodName() {
        if (this.m_accessMethods != null && this.m_accessMethods.getSetMethodName() != null) {
            return this.m_accessMethods.getSetMethodName();
        }
        return ((MetadataMethod)this.getAccessibleObject()).getSetMethodName();
    }

    protected boolean hasColumn() {
        return this.isAnnotationPresent(Column.class);
    }

    protected boolean hasConvert() {
        return this.isAnnotationPresent(Convert.class);
    }

    protected boolean hasReturnInsert() {
        return this.isAnnotationPresent(ReturnInsert.class);
    }

    protected boolean hasReturnUpdate() {
        return this.isAnnotationPresent(ReturnUpdate.class);
    }

    public void initXMLMappingAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
        this.initXMLAccessor(classAccessor.getDescriptor(), classAccessor.getProject());
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_accessMethods, metadataAccessibleObject);
    }

    public boolean isBasicCollection() {
        return false;
    }

    public boolean isDerivedId() {
        return false;
    }

    public boolean isDirectCollection() {
        return false;
    }

    public boolean isDirectEmbeddableCollection() {
        return false;
    }

    public boolean isCollectionAccessor() {
        return false;
    }

    public boolean isEmbedded() {
        return false;
    }

    public boolean isId() {
        return false;
    }

    public boolean isEmbeddedId() {
        return false;
    }

    public boolean isManyToMany() {
        return false;
    }

    public boolean isManyToOne() {
        return false;
    }

    public boolean isOneToMany() {
        return false;
    }

    public boolean isOneToOne() {
        return false;
    }

    @Override
    public boolean isProcessed() {
        return this.m_mapping != null;
    }

    public boolean isRelationship() {
        return this.isManyToOne() || this.isManyToMany() || this.isOneToMany() || this.isOneToOne() || this.isVariableOneToOne();
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isVariableOneToOne() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAssociationOverride(AssociationOverrideMetadata associationOverrideMetadata, EmbeddableMapping embeddableMapping, DatabaseMapping databaseMapping, DatabaseTable databaseTable, MetadataDescriptor metadataDescriptor) {
        String string = associationOverrideMetadata.getName();
        if (databaseMapping == null || !databaseMapping.isOneToOneMapping()) throw ValidationException.embeddableAssociationOverrideNotFound(this.getReferenceDescriptor().getJavaClass(), string, this.getJavaClass(), this.getAttributeName());
        MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(databaseMapping.getAttributeName());
        MetadataDescriptor metadataDescriptor2 = mappingAccessor.getReferenceDescriptor();
        if (!associationOverrideMetadata.hasJoinColumns()) throw new RuntimeException("Join table from association override not supported yet");
        for (JoinColumnMetadata joinColumnMetadata : this.processJoinColumns(associationOverrideMetadata.getJoinColumns(), metadataDescriptor2)) {
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setTable(metadataDescriptor2.getPrimaryKeyTable());
            DatabaseField databaseField2 = ((OneToOneMapping)databaseMapping).getTargetToSourceKeyFields().get(databaseField);
            if (databaseField2 == null) continue;
            DatabaseField databaseField3 = joinColumnMetadata.getForeignKeyField();
            if (!databaseField3.hasTableName()) {
                databaseField3.setTable(databaseTable);
            }
            embeddableMapping.addFieldNameTranslation(databaseField3.getQualifiedName(), databaseField2.getName());
        }
    }

    protected Map<String, AssociationOverrideMetadata> processAssociationOverrides(List<AssociationOverrideMetadata> list) {
        String string;
        HashMap<String, AssociationOverrideMetadata> hashMap = new HashMap<String, AssociationOverrideMetadata>();
        for (AssociationOverrideMetadata associationOverrideMetadata : list) {
            string = associationOverrideMetadata.getName();
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName() + "." + string)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logWarningMessage("metadata_warning_ignore_association_override", string, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                hashMap.put(string, this.getDescriptor().getAssociationOverrideFor(string));
                continue;
            }
            hashMap.put(string, associationOverrideMetadata);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AssociationOverrideMetadata associationOverrideMetadata : this.getDescriptor().getAssociationOverrides()) {
                String string2 = string = associationOverrideMetadata.getName();
                String string3 = string;
                int n = string.indexOf(".");
                if (n > -1) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                if (!string2.equals(this.getAttributeName()) || hashMap.containsKey(string2)) continue;
                hashMap.put(string3, associationOverrideMetadata);
            }
        }
        return hashMap;
    }

    protected Map<String, AttributeOverrideMetadata> processAttributeOverrides(List<AttributeOverrideMetadata> list) {
        String string;
        HashMap<String, AttributeOverrideMetadata> hashMap = new HashMap<String, AttributeOverrideMetadata>();
        for (AttributeOverrideMetadata attributeOverrideMetadata : list) {
            string = attributeOverrideMetadata.getName();
            if (this.getClassAccessor().isMappedSuperclass() && this.getDescriptor().hasAttributeOverrideFor(this.getAttributeName() + "." + string)) {
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logWarningMessage("metadata_warning_ignore_attribute_override", string, this.getAttributeName(), this.getClassAccessor().getJavaClassName(), this.getJavaClassName());
                hashMap.put(string, this.getDescriptor().getAttributeOverrideFor(string));
                continue;
            }
            hashMap.put(string, attributeOverrideMetadata);
        }
        if (this.getClassAccessor().isMappedSuperclass()) {
            for (AttributeOverrideMetadata attributeOverrideMetadata : this.getDescriptor().getAttributeOverrides()) {
                String string2 = string = attributeOverrideMetadata.getName();
                String string3 = string;
                int n = string.indexOf(".");
                if (n > -1) {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
                if (!string2.equals(this.getAttributeName()) || hashMap.containsKey(string2)) continue;
                hashMap.put(string3, attributeOverrideMetadata);
            }
        }
        return hashMap;
    }

    protected List<JoinColumnMetadata> processJoinColumns(List<JoinColumnMetadata> list) {
        if (this.getDescriptor().hasAssociationOverrideFor(this.getAttributeName())) {
            return this.processJoinColumns(this.getDescriptor().getAssociationOverrideFor(this.getAttributeName()).getJoinColumns(), this.getReferenceDescriptor());
        }
        return this.processJoinColumns(list, this.getReferenceDescriptor());
    }

    protected List<JoinColumnMetadata> processJoinColumns(List<JoinColumnMetadata> list, MetadataDescriptor metadataDescriptor) {
        if (list.isEmpty()) {
            if (metadataDescriptor.hasCompositePrimaryKey()) {
                for (String object : metadataDescriptor.getPrimaryKeyFieldNames()) {
                    JoinColumnMetadata joinColumnMetadata = new JoinColumnMetadata();
                    joinColumnMetadata.setReferencedColumnName(object);
                    joinColumnMetadata.setName(object);
                    list.add(joinColumnMetadata);
                }
            } else {
                list.add(new JoinColumnMetadata());
            }
        } else {
            for (JoinColumnMetadata joinColumnMetadata : list) {
                joinColumnMetadata.setReferencedColumnName(metadataDescriptor.getPrimaryKeyJoinColumnAssociation(joinColumnMetadata.getReferencedColumnName()));
            }
        }
        if (metadataDescriptor.hasCompositePrimaryKey()) {
            if (list.size() != metadataDescriptor.getPrimaryKeyFields().size()) {
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
            for (JoinColumnMetadata joinColumnMetadata : list) {
                if (!joinColumnMetadata.isPrimaryKeyFieldNotSpecified() && !joinColumnMetadata.isForeignKeyFieldNotSpecified()) continue;
                throw ValidationException.incompleteJoinColumnsSpecified(this.getAnnotatedElement(), this.getJavaClass());
            }
        }
        return list;
    }

    protected void processProperties(DatabaseMapping databaseMapping) {
        if (this.loadedFromXML()) {
            for (PropertyMetadata propertyMetadata : this.getProperties()) {
                this.processProperty(databaseMapping, propertyMetadata);
            }
        } else {
            Object object;
            Object t = this.getAnnotation(Properties.class);
            if (t != null) {
                object = (Annotation[])MetadataHelper.invokeMethod("value", t);
                int n = ((T)object).length;
                for (int i = 0; i < n; ++i) {
                    Object t2 = object[i];
                    this.processProperty(databaseMapping, new PropertyMetadata((Annotation)t2, this.getAccessibleObject()));
                }
            }
            if ((object = this.getAnnotation(Property.class)) != null) {
                this.processProperty(databaseMapping, new PropertyMetadata((Annotation)object, this.getAccessibleObject()));
            }
        }
    }

    protected void processProperty(DatabaseMapping databaseMapping, PropertyMetadata propertyMetadata) {
        if (propertyMetadata.shouldOverride(this.m_properties.get(propertyMetadata.getName()))) {
            this.m_properties.put(propertyMetadata.getName(), propertyMetadata);
            databaseMapping.getProperties().put(propertyMetadata.getName(), propertyMetadata.getConvertedValue());
        }
    }

    protected void processReturnInsert() {
        if (this.hasReturnInsert()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_insert", this.getAnnotatedElement());
        }
    }

    protected void processReturnInsertAndUpdate() {
        this.processReturnInsert();
        this.processReturnUpdate();
    }

    protected void processReturnUpdate() {
        if (this.hasReturnUpdate()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_return_update", this.getAnnotatedElement());
        }
    }

    public void setAccessMethods(AccessMethodsMetadata accessMethodsMetadata) {
        this.m_accessMethods = accessMethodsMetadata;
    }

    protected void setAccessorMethods(DatabaseMapping databaseMapping) {
        if (this.usesPropertyAccess(this.getDescriptor())) {
            databaseMapping.setGetMethodName(this.getGetMethodName());
            databaseMapping.setSetMethodName(this.getSetMethodName());
        }
    }

    public void setClassAccessor(ClassAccessor classAccessor) {
        this.m_classAccessor = classAccessor;
    }

    public void setIndirectionPolicy(CollectionMapping collectionMapping, String string, boolean bl) {
        Class clazz = this.getRawClass();
        if (bl) {
            if (clazz == Map.class) {
                if (collectionMapping.isDirectMapMapping()) {
                    ((DirectMapMapping)collectionMapping).useTransparentMap();
                } else {
                    collectionMapping.useTransparentMap(string);
                }
            } else if (clazz == List.class) {
                collectionMapping.useTransparentList();
            } else if (clazz == Collection.class) {
                collectionMapping.useTransparentCollection();
                collectionMapping.setContainerPolicy(new CollectionContainerPolicy(ClassConstants.IndirectList_Class));
            } else if (clazz == Set.class) {
                collectionMapping.useTransparentSet();
            } else {
                this.getLogger().logWarningMessage("non_jpa_allowed_type_used_for_collection_using_lazy_access", this.getJavaClass(), this.getAnnotatedElement(), clazz);
            }
        } else {
            collectionMapping.dontUseIndirection();
            if (clazz == Map.class) {
                if (collectionMapping.isDirectMapMapping()) {
                    ((DirectMapMapping)collectionMapping).useMapClass(Hashtable.class);
                } else {
                    collectionMapping.useMapClass(Hashtable.class, string);
                }
            } else if (clazz == Set.class) {
                collectionMapping.useCollectionClass(HashSet.class);
            } else if (clazz == List.class) {
                collectionMapping.useCollectionClass(Vector.class);
            } else if (clazz == Collection.class) {
                collectionMapping.setContainerPolicy(new CollectionContainerPolicy(Vector.class));
            } else if (string == null || string.equals("")) {
                collectionMapping.useCollectionClass(clazz);
            } else {
                collectionMapping.useMapClass(clazz, string);
            }
        }
    }

    public boolean usesPropertyAccess(MetadataDescriptor metadataDescriptor) {
        if (this.hasAccess()) {
            return this.hasPropertyAccess();
        }
        return this.m_accessMethods == null ? this.m_classAccessor.usesPropertyAccess() : true;
    }
}

