/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.CollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;

public class OneToManyAccessor
extends CollectionAccessor {
    public OneToManyAccessor() {
        super("<one-to-many>");
    }

    public OneToManyAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    public boolean isOneToMany() {
        return true;
    }

    public void process() {
        super.process();
        if (this.getMappedBy() == null || this.getMappedBy().equals("")) {
            if (this.getJoinColumns().isEmpty()) {
                this.processManyToManyMapping();
            } else {
                this.processUnidirectionalOneToManyMapping();
            }
        } else {
            this.processOneToManyMapping();
        }
    }

    protected void processManyToManyMapping() {
        ManyToManyMapping manyToManyMapping = new ManyToManyMapping();
        this.process(manyToManyMapping);
        this.processJoinTable(manyToManyMapping);
    }

    protected void processOneToManyMapping() {
        OneToManyMapping oneToManyMapping = new OneToManyMapping();
        this.process(oneToManyMapping);
        OneToOneMapping oneToOneMapping = null;
        if (!this.getOwningMapping(this.getMappedBy()).isOneToOneMapping()) {
            throw ValidationException.invalidMapping(this.getJavaClass(), this.getReferenceClass());
        }
        oneToOneMapping = (OneToOneMapping)this.getOwningMapping(this.getMappedBy());
        Map<DatabaseField, DatabaseField> map = oneToOneMapping.getSourceToTargetKeyFields();
        for (DatabaseField databaseField : map.keySet()) {
            DatabaseField databaseField2 = map.get(databaseField);
            if (this.getDescriptor().usesTablePerClassInheritanceStrategy() && !databaseField2.getTable().equals(this.getDescriptor().getPrimaryTable())) {
                databaseField2 = (DatabaseField)databaseField2.clone();
                databaseField2.setTable(this.getDescriptor().getPrimaryTable());
            }
            oneToManyMapping.addTargetForeignKeyField(databaseField, databaseField2);
        }
    }

    protected void processUnidirectionalOneToManyMapping() {
        UnidirectionalOneToManyMapping unidirectionalOneToManyMapping = new UnidirectionalOneToManyMapping();
        this.process(unidirectionalOneToManyMapping);
        this.processUnidirectionalOneToManyTargetForeignKeyRelationship(unidirectionalOneToManyMapping);
    }

    protected void processUnidirectionalOneToManyTargetForeignKeyRelationship(UnidirectionalOneToManyMapping unidirectionalOneToManyMapping) {
        String string = this.getDescriptor().getPrimaryKeyFieldName();
        String string2 = this.getUpperCaseAttributeName() + "_" + string;
        for (JoinColumnMetadata joinColumnMetadata : this.processJoinColumns()) {
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, string, "metadata_default_pk_column"));
            databaseField.setTable(this.getDescriptor().getPrimaryKeyTable());
            DatabaseField databaseField2 = joinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, string2, "metadata_default_fk_column"));
            if (databaseField2.getTableName().equals("")) {
                databaseField2.setTable(this.getReferenceDescriptor().getPrimaryTable());
            }
            unidirectionalOneToManyMapping.addTargetForeignKeyField(databaseField2, databaseField);
            if (!databaseField2.isReadOnly()) continue;
            unidirectionalOneToManyMapping.setIsReadOnly(true);
        }
    }
}

