/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class MetadataField
extends MetadataAnnotatedElement {
    public MetadataField(Field field, MetadataLogger metadataLogger) {
        super((AnnotatedElement)field, metadataLogger);
        this.setName(field.getName());
        this.setAttributeName(field.getName());
        this.setRelationType(field.getGenericType());
    }

    public MetadataField(Field field, XMLEntityMappings xMLEntityMappings) {
        super((AnnotatedElement)field, xMLEntityMappings);
        this.setName(field.getName());
        this.setAttributeName(field.getName());
        this.setRelationType(field.getGenericType());
    }

    protected Field getField() {
        return (Field)this.getAnnotatedElement();
    }

    public boolean isValidPersistenceField(boolean bl, MetadataDescriptor metadataDescriptor) {
        if (this.isValidPersistenceElement(bl, "FIELD", metadataDescriptor)) {
            return this.isValidPersistenceField(metadataDescriptor, this.hasDeclaredAnnotations(metadataDescriptor));
        }
        return false;
    }

    public boolean isValidPersistenceField(MetadataDescriptor metadataDescriptor, boolean bl) {
        if (!this.isValidPersistenceElement(this.getField().getModifiers())) {
            if (bl) {
                throw ValidationException.mappingMetadataAppliedToInvalidAttribute(this.getField(), metadataDescriptor.getJavaClass());
            }
            return false;
        }
        return true;
    }
}

