/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.NodeFactory;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class ParseTreeContext {
    private Map variableDecls = new HashMap();
    private String baseVariable;
    private int currentScope = 0;
    private Set outerScopeVariables;
    private Map fetchJoins = new HashMap();
    private TypeHelper typeHelper = null;
    private Map parameterTypes = new HashMap();
    private List parameterNames = new ArrayList();
    private NodeFactory nodeFactory;
    private String queryInfo;

    public ParseTreeContext(NodeFactory nodeFactory, String string) {
        this.nodeFactory = nodeFactory;
        this.queryInfo = string;
    }

    public void registerSchema(String string, String string2, int n, int n2) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        if (variableDecl != null) {
            String string3 = variableDecl.isRangeVariable ? variableDecl.schema : variableDecl.path.getAsString();
            throw JPQLException.multipleVariableDeclaration(this.getQueryInfo(), n, n2, string, string3);
        }
        variableDecl = new VariableDecl(string, string2);
        this.variableDecls.put(string, variableDecl);
    }

    public void registerJoinVariable(String string, Node node, int n, int n2) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        if (variableDecl != null) {
            String string2 = variableDecl.isRangeVariable ? variableDecl.schema : variableDecl.path.getAsString();
            throw JPQLException.multipleVariableDeclaration(this.getQueryInfo(), n, n2, string, string2);
        }
        variableDecl = new VariableDecl(string, node);
        this.variableDecls.put(string, variableDecl);
    }

    public void unregisterVariable(String string) {
        this.variableDecls.remove(string);
    }

    public boolean isVariable(String string) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        return variableDecl != null;
    }

    public boolean isRangeVariable(String string) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        return variableDecl != null && variableDecl.isRangeVariable;
    }

    public String schemaForVariable(String string) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        return variableDecl != null ? variableDecl.schema : null;
    }

    public Class classForSchemaName(String string, GenerationContext generationContext) {
        ClassDescriptor classDescriptor = generationContext.getSession().getDescriptorForAlias(string);
        if (classDescriptor == null) {
            throw JPQLException.unknownAbstractSchemaType(this.getQueryInfo(), string);
        }
        Class clazz = classDescriptor.getJavaClass();
        if (clazz == null) {
            throw JPQLException.resolutionClassNotFoundException(this.getQueryInfo(), string);
        }
        return clazz;
    }

    public String getVariableNameForClass(Class clazz, GenerationContext generationContext) {
        for (Map.Entry entry : this.variableDecls.entrySet()) {
            String string = (String)entry.getKey();
            VariableDecl variableDecl = (VariableDecl)entry.getValue();
            if (variableDecl.schema == null || clazz != this.classForSchemaName(variableDecl.schema, generationContext)) continue;
            return string;
        }
        return null;
    }

    public Node pathForVariable(String string) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        return variableDecl != null ? variableDecl.path : null;
    }

    public String getBaseVariable() {
        return this.baseVariable;
    }

    public void setBaseVariable(String string) {
        this.baseVariable = string;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public String getQueryInfo() {
        return this.queryInfo;
    }

    public boolean isDeclaredInOuterScope(String string) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        return variableDecl != null ? variableDecl.scope < this.currentScope : false;
    }

    public void setScopeOfVariable(String string) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        if (variableDecl != null) {
            variableDecl.scope = this.currentScope;
        }
    }

    public void enterScope() {
        ++this.currentScope;
        this.resetOuterScopeVariables();
    }

    public void leaveScope() {
        --this.currentScope;
    }

    public void registerOuterScopeVariable(String string) {
        this.outerScopeVariables.add(string);
    }

    public Set getOuterScopeVariables() {
        return this.outerScopeVariables;
    }

    public void resetOuterScopeVariables() {
        this.outerScopeVariables = new HashSet();
    }

    public void resetOuterScopeVariables(Set set) {
        this.outerScopeVariables = set;
    }

    public void registerFetchJoin(String string, Node node) {
        ArrayList<Node> arrayList = (ArrayList<Node>)this.fetchJoins.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Node>();
            this.fetchJoins.put(string, arrayList);
        }
        arrayList.add(node);
    }

    public List getFetchJoins(String string) {
        return (List)this.fetchJoins.get(string);
    }

    public void usedVariable(String string) {
        VariableDecl variableDecl = (VariableDecl)this.variableDecls.get(string);
        if (variableDecl != null && variableDecl.scope == this.currentScope) {
            variableDecl.used = true;
        }
    }

    public Set getUnusedVariables() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry entry : this.variableDecls.entrySet()) {
            String string = (String)entry.getKey();
            VariableDecl variableDecl = (VariableDecl)entry.getValue();
            if (variableDecl.scope != this.currentScope || variableDecl.used) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public boolean hasMoreThanOneVariablePerType() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        for (Map.Entry entry : this.variableDecls.entrySet()) {
            String string = (String)entry.getKey();
            VariableDecl variableDecl = (VariableDecl)entry.getValue();
            if (!variableDecl.isRangeVariable) continue;
            ++n;
            hashMap.put(variableDecl.schema, string);
        }
        return hashMap.size() != n;
    }

    public boolean hasMoreThanOneAliasInFrom() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry entry : this.variableDecls.entrySet()) {
            String string = (String)entry.getKey();
            VariableDecl variableDecl = (VariableDecl)entry.getValue();
            if (!variableDecl.isRangeVariable) continue;
            hashMap.put(variableDecl.schema, string);
        }
        return hashMap.size() > 1;
    }

    public TypeHelper getTypeHelper() {
        return this.typeHelper;
    }

    public void setTypeHelper(TypeHelper typeHelper) {
        this.typeHelper = typeHelper;
    }

    public void addParameter(String string) {
        if (!this.parameterNames.contains(string)) {
            this.parameterNames.add(string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineParameterType(String string, Object object, int n, int n2) {
        if (this.parameterTypes.containsKey(string)) {
            Object v = this.parameterTypes.get(string);
            if (this.typeHelper.isAssignableFrom(v, object)) return;
            if (!this.typeHelper.isAssignableFrom(object, v)) throw JPQLException.invalidMultipleUseOfSameParameter(this.getQueryInfo(), n, n2, string, this.typeHelper.getTypeName(v), this.typeHelper.getTypeName(object));
            this.parameterTypes.put(string, object);
            return;
        } else {
            this.parameterTypes.put(string, object);
        }
    }

    public boolean hasParameters() {
        return !this.parameterNames.isEmpty();
    }

    public Object getParameterType(String string) {
        return this.parameterTypes.get(string);
    }

    public List getParameterNames() {
        return this.parameterNames;
    }

    static class VariableDecl {
        public final String variable;
        public final boolean isRangeVariable;
        public final String schema;
        public final Node path;
        public int scope;
        public boolean used;

        public VariableDecl(String string, String string2) {
            this.variable = string;
            this.isRangeVariable = true;
            this.schema = string2;
            this.path = null;
            this.used = false;
        }

        public VariableDecl(String string, Node node) {
            this.variable = string;
            this.isRangeVariable = false;
            this.schema = null;
            this.path = node;
            this.used = false;
        }
    }
}

