/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.platform.database.oracle;

import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.ZONEIDMAP;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPLTZWrapper;
import org.eclipse.persistence.internal.platform.database.oracle.TIMESTAMPTZWrapper;

public class TIMESTAMPHelper {
    public static TIMESTAMPTZ buildTIMESTAMPTZ(Calendar calendar, Connection connection, boolean bl) throws SQLException {
        if (bl) {
            return new TIMESTAMPTZ(connection, Helper.printCalendar(calendar, false), calendar);
        }
        return new TIMESTAMPTZ(connection, new Timestamp(calendar.getTimeInMillis()), calendar);
    }

    public static Calendar buildCalendar(TIMESTAMPTZWrapper tIMESTAMPTZWrapper) throws SQLException {
        Calendar calendar;
        Timestamp timestamp = tIMESTAMPTZWrapper.getTimestamp();
        TimeZone timeZone = tIMESTAMPTZWrapper.getTimeZone();
        if (tIMESTAMPTZWrapper.isTimestampInGmt()) {
            calendar = Calendar.getInstance(timeZone);
            calendar.setTime(timestamp);
        } else {
            calendar = Calendar.getInstance();
            calendar.setTime(timestamp);
            calendar.getTimeZone().setID(timeZone.getID());
            calendar.getTimeZone().setRawOffset(timeZone.getRawOffset());
        }
        return calendar;
    }

    public static Calendar buildCalendar(TIMESTAMPLTZWrapper tIMESTAMPLTZWrapper) throws SQLException {
        Calendar calendar = tIMESTAMPLTZWrapper.getZoneId() != null ? Calendar.getInstance(TimeZone.getTimeZone(tIMESTAMPLTZWrapper.getZoneId())) : Calendar.getInstance();
        Calendar calendar2 = Helper.allocateCalendar();
        calendar2.setTime(tIMESTAMPLTZWrapper.getTimestamp());
        calendar.set(calendar2.get(1), calendar2.get(2), calendar2.get(5), calendar2.get(11), calendar2.get(12), calendar2.get(13));
        Helper.releaseCalendar(calendar2);
        calendar.set(14, tIMESTAMPLTZWrapper.getTimestamp().getNanos() / 1000000);
        return calendar;
    }

    public static String printCalendar(Calendar calendar) {
        if (calendar == null) {
            return "null";
        }
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.printCalendar(calendar, false));
        stringWriter.write(" ");
        stringWriter.write(calendar.getTimeZone().getID());
        if (TIMESTAMPHelper.shouldAppendDaylightTime(calendar)) {
            stringWriter.write(" ");
            stringWriter.write(calendar.getTimeZone().getDisplayName(true, 0));
        }
        return stringWriter.toString();
    }

    public static boolean shouldAppendDaylightTime(Calendar calendar) {
        if (calendar == null) {
            return false;
        }
        TimeZone timeZone = calendar.getTimeZone();
        return timeZone.useDaylightTime() && timeZone.inDaylightTime(calendar.getTime());
    }

    public static TimeZone extractTimeZone(byte[] byArray) {
        String string = null;
        if ((byArray[11] & 0xFFFFFF80) != 0) {
            int n = (byArray[11] & 0x7F) << 6;
            string = new String(ZONEIDMAP.getRegion((int)(n += (byArray[12] & 0xFC) >> 2)));
        } else {
            int n = byArray[11] - 20;
            int n2 = byArray[12] - 60;
            String string2 = Helper.buildZeroPrefix(n, 2) + ":" + Helper.buildZeroPrefixWithoutSign(n2, 2);
            string = "GMT" + string2;
        }
        return TimeZone.getTimeZone(string);
    }
}

