/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.coordination.jms;

import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.sessions.coordination.broadcast.BroadcastRemoteConnection;
import org.eclipse.persistence.sessions.coordination.Command;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;

public class JMSTopicRemoteConnection
extends BroadcastRemoteConnection
implements Runnable {
    protected TopicConnection topicConnection;
    protected Topic topic;
    protected TopicSession topicSession;
    protected TopicPublisher publisher;
    protected TopicSubscriber subscriber;
    protected boolean isLocal;
    public static long WAIT_ON_ERROR_RECEIVING_JMS_MESSAGE = 10000L;

    public JMSTopicRemoteConnection(RemoteCommandManager remoteCommandManager, TopicConnection topicConnection, Topic topic, boolean bl) throws JMSException {
        super(remoteCommandManager);
        this.topicConnection = topicConnection;
        this.topic = topic;
        this.isLocal = bl;
        remoteCommandManager.logDebug("creating_broadcast_connection", this.getInfo());
        try {
            this.topicSession = topicConnection.createTopicSession(false, 1);
            if (bl) {
                this.subscriber = this.topicSession.createSubscriber(topic);
                this.topicConnection.start();
                remoteCommandManager.logDebug("broadcast_connection_created", this.getInfo());
                remoteCommandManager.getServerPlatform().launchContainerRunnable(this);
            } else {
                this.publisher = this.topicSession.createPublisher(topic);
                remoteCommandManager.logDebug("broadcast_connection_created", this.getInfo());
            }
        }
        catch (JMSException jMSException) {
            remoteCommandManager.logDebug("failed_to_create_broadcast_connection", this.getInfo());
            this.close();
            throw jMSException;
        }
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    protected Object executeCommandInternal(Command command) throws Exception {
        ObjectMessage objectMessage = this.topicSession.createObjectMessage();
        objectMessage.setObject((Serializable)command);
        Object[] objectArray = null;
        if (this.rcm.shouldLogDebugMessage()) {
            objectArray = this.logDebugBeforePublish(null);
        }
        this.publisher.publish((Message)objectMessage);
        if (objectArray != null) {
            this.logDebugAfterPublish(objectArray, objectMessage.getJMSMessageID());
        }
        return null;
    }

    public void onMessage(Message message) {
        String string = null;
        String string2 = "";
        if (this.rcm.shouldLogDebugMessage()) {
            try {
                string2 = message.getJMSMessageID();
                this.logDebugOnReceiveMessage(string2);
                string = this.logDebugJMSTopic(message);
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        ObjectMessage objectMessage = null;
        if (!(message instanceof ObjectMessage)) {
            if (this.rcm.shouldLogWarningMessage() && string == null) {
                try {
                    string = ((Topic)message.getJMSDestination()).getTopicName();
                }
                catch (JMSException jMSException) {
                    string = "";
                }
                Object[] objectArray = new Object[]{message.getClass().getName(), string};
                this.rcm.logWarningWithoutLevelCheck("received_unexpected_message_type", objectArray);
            }
            return;
        }
        objectMessage = (ObjectMessage)message;
        Serializable serializable = null;
        try {
            serializable = objectMessage.getObject();
        }
        catch (Exception exception) {
            if (string2.length() == 0) {
                try {
                    string2 = message.getJMSMessageID();
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
            }
            this.failDeserializeMessage(string2, exception);
            return;
        }
        this.processReceivedObject(serializable, string2);
    }

    protected boolean areAllResourcesFreedOnClose() {
        return !this.isLocal();
    }

    protected void closeInternal() throws JMSException {
        if (this.areAllResourcesFreedOnClose()) {
            this.topicConnection.close();
        }
    }

    protected String logDebugJMSTopic(Message message) throws JMSException {
        String string = ((Topic)message.getJMSDestination()).getTopicName();
        Object[] objectArray = new Object[]{string};
        this.rcm.logDebugWithoutLevelCheck("retreived_remote_message_from_JMS_topic", objectArray);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object[] objectArray;
        JMSTopicTransportManager jMSTopicTransportManager = (JMSTopicTransportManager)this.rcm.getTransportManager();
        this.rcm.logDebug("broadcast_connection_start_listening", this.getInfo());
        boolean bl = false;
        RuntimeException runtimeException = null;
        while (this.isActive()) {
            try {
                Message message = this.subscriber.receive();
                if (!this.isActive()) continue;
                if (message == null) {
                    try {
                        this.rcm.handleException(RemoteCommandManagerException.errorJMSMessageIsNull());
                        continue;
                    }
                    catch (RuntimeException runtimeException2) {
                        runtimeException = runtimeException2;
                        throw new JMSException("");
                    }
                }
                this.rcm.getServerPlatform().launchContainerRunnable(new JMSOnMessageHelper(message));
            }
            catch (JMSException jMSException) {
                if (!this.isActive()) continue;
                if (runtimeException != null) {
                    objectArray = RemoteCommandManagerException.errorReceivingJMSMessage(runtimeException);
                    runtimeException = null;
                } else {
                    objectArray = RemoteCommandManagerException.errorReceivingJMSMessage((Exception)((Object)jMSException));
                }
                if (jMSTopicTransportManager.shouldRemoveConnectionOnError()) {
                    bl = true;
                    Object[] objectArray2 = new Object[]{this.getServiceId(), objectArray};
                    this.rcm.logWarning("drop_connection_on_error", objectArray2);
                    jMSTopicTransportManager.removeLocalConnection();
                    continue;
                }
                try {
                    this.rcm.handleException((RuntimeException)objectArray);
                }
                catch (RuntimeException runtimeException3) {
                    Object[] objectArray3 = new Object[]{this.toString(), objectArray, WAIT_ON_ERROR_RECEIVING_JMS_MESSAGE};
                    this.rcm.logWarning("broadcast_listening_sleep_on_error", objectArray3);
                    try {
                        Thread.sleep(WAIT_ON_ERROR_RECEIVING_JMS_MESSAGE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        this.rcm.logDebug("broadcast_connection_stop_listening", this.getInfo());
        if (this.isClosing()) {
            try {
                this.topicConnection.close();
            }
            catch (JMSException jMSException) {
                objectArray = new Object[]{this.displayString, jMSException};
                this.rcm.logWarning("broadcast_exception_thrown_when_attempting_to_close_connection", objectArray);
            }
            finally {
                this.rcm.logDebug("broadcast_connection_closed", this.getInfo());
                this.state = "CLOSED";
            }
        }
        if (bl && !jMSTopicTransportManager.getRemoteCommandManager().isStopped()) {
            try {
                jMSTopicTransportManager.createLocalConnection();
            }
            catch (RemoteCommandManagerException remoteCommandManagerException) {
                // empty catch block
            }
        }
    }

    protected void createDisplayString() {
        super.createDisplayString();
        this.displayString = (this.isLocal() ? "Local " : "External ") + this.displayString;
    }

    protected boolean shouldCheckServiceId() {
        return true;
    }

    class JMSOnMessageHelper
    implements Runnable {
        Message message = null;

        public JMSOnMessageHelper(Message message) {
            this.message = message;
        }

        public void run() {
            JMSTopicRemoteConnection.this.onMessage(this.message);
        }
    }
}

