/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.factories;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import org.eclipse.persistence.config.SessionCustomizer;
import org.eclipse.persistence.eis.EISConnectionSpec;
import org.eclipse.persistence.eis.EISLogin;
import org.eclipse.persistence.eis.adapters.xmlfile.XMLFileSequence;
import org.eclipse.persistence.exceptions.ExceptionHandler;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.event.SessionEventManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.DefaultSessionLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.JavaLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.log.ServerLogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.EISLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.StructConverterConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.XMLLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.CustomServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.PoolsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.ReadConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.pool.WriteConnectionPoolConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.property.PropertyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.RemoteCommandManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.rcm.command.CommandsConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.DefaultSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.NativeSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.TableSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.UnaryTableSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.XMLFileSequenceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.ServerSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionBrokerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.JMSTopicTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.Oc4jJGroupsTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.RMIIIOPTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.RMITransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.SunCORBATransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.TransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.UserDefinedTransportManagerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.discovery.DiscoveryConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.JNDINamingServiceConfig;
import org.eclipse.persistence.internal.sessions.factories.model.transport.naming.RMIRegistryNamingServiceConfig;
import org.eclipse.persistence.logging.DefaultSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.platform.database.converters.StructConverter;
import org.eclipse.persistence.platform.server.NoServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sequencing.DefaultSequence;
import org.eclipse.persistence.sequencing.NativeSequence;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sequencing.UnaryTableSequence;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.JNDIConnector;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.SessionEventListener;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.sessions.coordination.DiscoveryManager;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.TransportManager;
import org.eclipse.persistence.sessions.coordination.corba.sun.SunCORBATransportManager;
import org.eclipse.persistence.sessions.coordination.jms.JMSTopicTransportManager;
import org.eclipse.persistence.sessions.coordination.rmi.RMITransportManager;
import org.eclipse.persistence.sessions.factories.XMLProjectReader;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ReadConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.tools.profiler.PerformanceProfiler;

public class SessionsFactory {
    protected Map m_sessions;
    protected Map m_logLevels = new HashMap();
    protected ClassLoader m_classLoader;

    public SessionsFactory() {
        this.m_logLevels.put("off", new Integer(8));
        this.m_logLevels.put("severe", new Integer(7));
        this.m_logLevels.put("warning", new Integer(6));
        this.m_logLevels.put("info", new Integer(5));
        this.m_logLevels.put("config", new Integer(4));
        this.m_logLevels.put("fine", new Integer(3));
        this.m_logLevels.put("finer", new Integer(2));
        this.m_logLevels.put("finest", new Integer(1));
        this.m_logLevels.put("all", new Integer(1));
    }

    public Map buildSessionConfigs(SessionConfigs sessionConfigs, ClassLoader classLoader) {
        Object object;
        Object object2;
        this.m_sessions = new HashMap();
        this.m_classLoader = classLoader;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = sessionConfigs.getSessionConfigs().elements();
        while (enumeration.hasMoreElements()) {
            object2 = (SessionConfig)enumeration.nextElement();
            if (object2 instanceof SessionBrokerConfig) {
                vector.add(object2);
                continue;
            }
            object = this.buildSession((SessionConfig)object2);
            ((AbstractSession)object).getDatasourcePlatform().getConversionManager().setLoader(classLoader);
            this.processSessionCustomizer((SessionConfig)object2, (AbstractSession)object);
            this.m_sessions.put(((AbstractSession)object).getName(), object);
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (SessionBrokerConfig)object2.nextElement();
            SessionBroker sessionBroker = this.buildSessionBrokerConfig((SessionBrokerConfig)object);
            sessionBroker.getDatasourcePlatform().getConversionManager().setLoader(classLoader);
            this.processSessionCustomizer((SessionConfig)object, sessionBroker);
            this.m_sessions.put(sessionBroker.getName(), sessionBroker);
        }
        return this.m_sessions;
    }

    protected void processSessionCustomizer(SessionConfig sessionConfig, AbstractSession abstractSession) {
        String string = sessionConfig.getSessionCustomizerClass();
        if (string != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    ((SessionCustomizer)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz))).customize(abstractSession);
                } else {
                    ((SessionCustomizer)PrivilegedAccessHelper.newInstanceFromClass(clazz)).customize(abstractSession);
                }
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadTag("session-customizer-class", string, throwable);
            }
        }
    }

    protected AbstractSession buildSession(SessionConfig sessionConfig) {
        if (sessionConfig instanceof ServerSessionConfig) {
            return this.buildServerSessionConfig((ServerSessionConfig)sessionConfig);
        }
        return this.buildDatabaseSessionConfig((DatabaseSessionConfig)sessionConfig);
    }

    protected AbstractSession buildDatabaseSessionConfig(DatabaseSessionConfig databaseSessionConfig) {
        DatabaseSessionImpl databaseSessionImpl = this.createSession(databaseSessionConfig, null);
        Login login = this.buildLogin(databaseSessionConfig.getLoginConfig());
        if (login != null) {
            databaseSessionImpl.setLogin(login);
        }
        this.processDatabaseSessionConfig(databaseSessionConfig, databaseSessionImpl);
        this.processSessionConfig(databaseSessionConfig, databaseSessionImpl);
        return databaseSessionImpl;
    }

    protected void processDatabaseSessionConfig(DatabaseSessionConfig databaseSessionConfig, AbstractSession abstractSession) {
    }

    protected AbstractSession buildServerSessionConfig(ServerSessionConfig serverSessionConfig) {
        Login login = this.buildLogin(serverSessionConfig.getLoginConfig());
        ServerSession serverSession = (ServerSession)this.createSession(serverSessionConfig, login);
        this.processDatabaseSessionConfig(serverSessionConfig, serverSession);
        this.processPoolsConfig(serverSessionConfig.getPoolsConfig(), serverSession);
        this.processConnectionPolicyConfig(serverSessionConfig.getConnectionPolicyConfig(), serverSession);
        this.processSessionConfig(serverSessionConfig, serverSession);
        return serverSession;
    }

    protected DatabaseSessionImpl createSession(DatabaseSessionConfig databaseSessionConfig, Login login) {
        Project project = databaseSessionConfig.getPrimaryProject() != null ? this.loadProjectConfig(databaseSessionConfig.getPrimaryProject()) : new Project();
        this.prepareProjectLogin(project, login);
        DatabaseSessionImpl databaseSessionImpl = this.getSession(databaseSessionConfig, project);
        if (databaseSessionConfig.getAdditionalProjects() != null) {
            Enumeration enumeration = databaseSessionConfig.getAdditionalProjects().elements();
            while (enumeration.hasMoreElements()) {
                Project project2 = this.loadProjectConfig((ProjectConfig)enumeration.nextElement());
                project.addDescriptors(project2, databaseSessionImpl);
            }
        }
        return databaseSessionImpl;
    }

    protected void prepareProjectLogin(Project project, Login login) {
        if (login != null) {
            project.setLogin(login);
        } else if (project.getDatasourceLogin() == null) {
            project.setLogin(new DatabaseLogin());
        }
    }

    protected DatabaseSessionImpl getSession(SessionConfig sessionConfig, Project project) {
        if (sessionConfig instanceof ServerSessionConfig) {
            return (ServerSession)project.createServerSession();
        }
        return (DatabaseSessionImpl)project.createDatabaseSession();
    }

    protected Project loadProjectConfig(ProjectConfig projectConfig) {
        Project project = null;
        String string = projectConfig.getProjectString();
        if (projectConfig.isProjectClassConfig()) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    project = (Project)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.m_classLoader.loadClass(string)));
                }
                project = (Project)PrivilegedAccessHelper.newInstanceFromClass(this.m_classLoader.loadClass(string));
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadProjectClass(string, throwable);
            }
        } else {
            try {
                project = XMLProjectReader.read(string, this.m_classLoader);
            }
            catch (ValidationException validationException) {
                if (validationException.getErrorCode() == 7099) {
                    try {
                        project = XMLProjectReader.read(string);
                    }
                    catch (Exception exception) {
                        throw SessionLoaderException.failedToLoadProjectXml(string, validationException);
                    }
                }
                throw SessionLoaderException.failedToLoadProjectXml(string, validationException);
            }
        }
        return project;
    }

    protected Login buildLogin(LoginConfig loginConfig) {
        if (loginConfig instanceof EISLoginConfig) {
            return this.buildEISLoginConfig((EISLoginConfig)loginConfig);
        }
        if (loginConfig instanceof XMLLoginConfig) {
            return this.buildXMLLoginConfig((XMLLoginConfig)loginConfig);
        }
        if (loginConfig instanceof DatabaseLoginConfig) {
            return this.buildDatabaseLoginConfig((DatabaseLoginConfig)loginConfig);
        }
        return null;
    }

    protected Login buildEISLoginConfig(EISLoginConfig eISLoginConfig) {
        EISLogin eISLogin = new EISLogin();
        String string = eISLoginConfig.getConnectionSpecClass();
        if (string != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                EISConnectionSpec eISConnectionSpec = null;
                eISConnectionSpec = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (EISConnectionSpec)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)) : (EISConnectionSpec)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                eISLogin.setConnectionSpec(eISConnectionSpec);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("connection-spec-class", string, exception);
            }
        }
        eISLogin.setConnectionFactoryURL(eISLoginConfig.getConnectionFactoryURL());
        this.processLoginConfig(eISLoginConfig, eISLogin);
        return eISLogin;
    }

    protected Login buildXMLLoginConfig(XMLLoginConfig xMLLoginConfig) {
        XMLLogin xMLLogin = new XMLLogin();
        this.processLoginConfig(xMLLoginConfig, xMLLogin);
        return xMLLogin;
    }

    protected Login buildDatabaseLoginConfig(DatabaseLoginConfig databaseLoginConfig) {
        Serializable serializable;
        String string;
        Object object;
        DatabaseLogin databaseLogin = new DatabaseLogin();
        String string2 = databaseLoginConfig.getDriverClass();
        if (string2 != null) {
            try {
                object = this.m_classLoader.loadClass(string2);
                databaseLogin.setDriverClass((Class)object);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("driver-class", string2, exception);
            }
        }
        if ((object = databaseLoginConfig.getConnectionURL()) != null) {
            databaseLogin.setConnectionString((String)object);
        }
        if ((string = databaseLoginConfig.getDatasource()) != null) {
            try {
                serializable = new JNDIConnector(new InitialContext(), string);
                ((JNDIConnector)serializable).setLookupType(databaseLoginConfig.getLookupType());
                databaseLogin.setConnector((Connector)serializable);
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("datasource", string, exception);
            }
        }
        databaseLogin.setShouldBindAllParameters(databaseLoginConfig.getBindAllParameters());
        databaseLogin.setShouldCacheAllStatements(databaseLoginConfig.getCacheAllStatements());
        databaseLogin.setUsesByteArrayBinding(databaseLoginConfig.getByteArrayBinding());
        databaseLogin.setUsesStringBinding(databaseLoginConfig.getStringBinding());
        databaseLogin.setUsesStreamsForBinding(databaseLoginConfig.getStreamsForBinding());
        databaseLogin.setShouldForceFieldNamesToUpperCase(databaseLoginConfig.getForceFieldNamesToUppercase());
        databaseLogin.setShouldOptimizeDataConversion(databaseLoginConfig.getOptimizeDataConversion());
        databaseLogin.setShouldTrimStrings(databaseLoginConfig.getTrimStrings());
        databaseLogin.setUsesBatchWriting(databaseLoginConfig.getBatchWriting());
        databaseLogin.setUsesJDBCBatchWriting(databaseLoginConfig.getJdbcBatchWriting());
        serializable = databaseLoginConfig.getMaxBatchWritingSize();
        if (serializable != null) {
            databaseLogin.setMaxBatchWritingSize((Integer)serializable);
        }
        databaseLogin.setUsesNativeSQL(databaseLoginConfig.getNativeSQL());
        this.processLoginConfig(databaseLoginConfig, databaseLogin);
        this.processStructConverterConfig(databaseLoginConfig.getStructConverterConfig(), databaseLogin);
        if (databaseLoginConfig.isConnectionHealthValidatedOnError() != null) {
            databaseLogin.setConnectionHealthValidatedOnError(databaseLoginConfig.isConnectionHealthValidatedOnError());
        }
        if (databaseLoginConfig.getQueryRetryAttemptCount() != null) {
            databaseLogin.setQueryRetryAttemptCount(databaseLoginConfig.getQueryRetryAttemptCount());
        }
        if (databaseLoginConfig.getDelayBetweenConnectionAttempts() != null) {
            databaseLogin.setDelayBetweenConnectionAttempts(databaseLoginConfig.getDelayBetweenConnectionAttempts());
        }
        if (databaseLoginConfig.getPingSQL() != null) {
            databaseLogin.setPingSQL(databaseLoginConfig.getPingSQL());
        }
        return databaseLogin;
    }

    protected void processStructConverterConfig(StructConverterConfig structConverterConfig, DatabaseLogin databaseLogin) {
        Platform platform;
        if (structConverterConfig != null && (platform = databaseLogin.getDatasourcePlatform()) instanceof DatabasePlatform) {
            for (String string : structConverterConfig.getStructConverterClasses()) {
                try {
                    Class<?> clazz = this.m_classLoader.loadClass(string);
                    StructConverter structConverter = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            structConverter = (StructConverter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw (Exception)privilegedActionException.getCause();
                        }
                    } else {
                        structConverter = (StructConverter)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                    }
                    ((DatabasePlatform)platform).addStructConverter(structConverter);
                }
                catch (Exception exception) {
                    throw SessionLoaderException.failedToLoadTag("struct-converter", string, exception);
                }
            }
        }
    }

    protected void processLoginConfig(LoginConfig loginConfig, DatasourceLogin datasourceLogin) {
        Object object;
        Enumeration enumeration;
        Object object2;
        String string = loginConfig.getPlatformClass();
        if (string != null) {
            try {
                object2 = this.m_classLoader.loadClass(string);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    datasourceLogin.usePlatform((DatasourcePlatform)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass((Class)object2)));
                } else {
                    datasourceLogin.usePlatform((DatasourcePlatform)PrivilegedAccessHelper.newInstanceFromClass((Class)object2));
                }
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("platform-class", string, exception);
            }
        }
        if ((object2 = loginConfig.getTableQualifier()) != null) {
            datasourceLogin.setTableQualifier((String)object2);
        }
        datasourceLogin.setUserName(loginConfig.getUsername());
        datasourceLogin.setEncryptionClassName(loginConfig.getEncryptionClass());
        datasourceLogin.setEncryptedPassword(loginConfig.getEncryptedPassword());
        datasourceLogin.setUsesExternalConnectionPooling(loginConfig.getExternalConnectionPooling());
        datasourceLogin.setUsesExternalTransactionController(loginConfig.getExternalTransactionController());
        if (loginConfig.getSequencingConfig() != null) {
            if (loginConfig.getSequencingConfig().getDefaultSequenceConfig() != null) {
                enumeration = this.buildSequence(loginConfig.getSequencingConfig().getDefaultSequenceConfig());
                datasourceLogin.setDefaultSequence((Sequence)((Object)enumeration));
            }
            if (loginConfig.getSequencingConfig().getSequenceConfigs() != null && !loginConfig.getSequencingConfig().getSequenceConfigs().isEmpty()) {
                enumeration = loginConfig.getSequencingConfig().getSequenceConfigs().elements();
                while (enumeration.hasMoreElements()) {
                    object = this.buildSequence((SequenceConfig)enumeration.nextElement());
                    datasourceLogin.addSequence((Sequence)object);
                }
            }
        }
        if (loginConfig.getPropertyConfigs() != null) {
            enumeration = loginConfig.getPropertyConfigs().elements();
            while (enumeration.hasMoreElements()) {
                object = (PropertyConfig)enumeration.nextElement();
                datasourceLogin.getProperties().put(((PropertyConfig)object).getName(), ((PropertyConfig)object).getValue());
            }
        }
    }

    protected void processPoolsConfig(PoolsConfig poolsConfig, ServerSession serverSession) {
        if (poolsConfig != null) {
            ConnectionPoolConfig connectionPoolConfig;
            WriteConnectionPoolConfig writeConnectionPoolConfig;
            ReadConnectionPoolConfig readConnectionPoolConfig = poolsConfig.getReadConnectionPoolConfig();
            if (readConnectionPoolConfig != null) {
                serverSession.setReadConnectionPool(this.buildReadConnectionPoolConfig(readConnectionPoolConfig, serverSession));
            }
            if ((writeConnectionPoolConfig = poolsConfig.getWriteConnectionPoolConfig()) != null) {
                serverSession.addConnectionPool(this.buildConnectionPoolConfig(writeConnectionPoolConfig, serverSession));
            }
            if ((connectionPoolConfig = poolsConfig.getSequenceConnectionPoolConfig()) != null) {
                this.processSequenceConnectionPoolConfig(connectionPoolConfig, serverSession);
            }
            Enumeration enumeration = poolsConfig.getConnectionPoolConfigs().elements();
            while (enumeration.hasMoreElements()) {
                ConnectionPoolConfig connectionPoolConfig2 = (ConnectionPoolConfig)enumeration.nextElement();
                serverSession.addConnectionPool(this.buildConnectionPoolConfig(connectionPoolConfig2, serverSession));
            }
        }
    }

    protected void processSequenceConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig, ServerSession serverSession) {
        Integer n;
        serverSession.getSequencingControl().setShouldUseSeparateConnection(true);
        Integer n2 = connectionPoolConfig.getMaxConnections();
        if (n2 != null) {
            serverSession.getSequencingControl().setMaxPoolSize(n2);
        }
        if ((n = connectionPoolConfig.getMinConnections()) != null) {
            serverSession.getSequencingControl().setMinPoolSize(n);
        }
    }

    protected void processServerPlatformConfig(ServerPlatformConfig serverPlatformConfig, ServerPlatform serverPlatform) {
        if (!serverPlatformConfig.getEnableRuntimeServices()) {
            serverPlatform.disableRuntimeServices();
        }
        if (!serverPlatformConfig.getEnableJTA()) {
            serverPlatform.disableJTA();
        }
    }

    protected ConnectionPool buildConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig, ServerSession serverSession) {
        ConnectionPool connectionPool = new ConnectionPool();
        this.processConnectionPoolConfig(connectionPoolConfig, connectionPool, serverSession);
        return connectionPool;
    }

    protected ServerPlatform buildCustomServerPlatformConfig(CustomServerPlatformConfig customServerPlatformConfig, DatabaseSessionImpl databaseSessionImpl) {
        ServerPlatform serverPlatform;
        Object object;
        String string = customServerPlatformConfig.getServerClassName();
        try {
            Constructor constructor;
            object = this.m_classLoader.loadClass(string);
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor((Class)object, new Class[]{DatabaseSession.class}, false));
                serverPlatform = (ServerPlatform)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{databaseSessionImpl}));
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(object, new Class[]{DatabaseSession.class}, false);
                serverPlatform = (ServerPlatform)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{databaseSessionImpl});
            }
        }
        catch (Throwable throwable) {
            throw SessionLoaderException.failedToLoadTag("server-class", string, throwable);
        }
        object = customServerPlatformConfig.getExternalTransactionControllerClass();
        if (object != null) {
            try {
                serverPlatform.setExternalTransactionControllerClass(this.m_classLoader.loadClass((String)object));
            }
            catch (Exception exception) {
                throw SessionLoaderException.failedToLoadTag("external-transaction-controller-class", (String)object, exception);
            }
        }
        return serverPlatform;
    }

    protected ConnectionPool buildReadConnectionPoolConfig(ReadConnectionPoolConfig readConnectionPoolConfig, ServerSession serverSession) {
        ConnectionPool connectionPool = readConnectionPoolConfig.getExclusive() ? new ConnectionPool() : new ReadConnectionPool();
        this.processConnectionPoolConfig(readConnectionPoolConfig, connectionPool, serverSession);
        return connectionPool;
    }

    protected void processConnectionPolicyConfig(ConnectionPolicyConfig connectionPolicyConfig, ServerSession serverSession) {
        if (connectionPolicyConfig != null) {
            ConnectionPolicy connectionPolicy = serverSession.getDefaultConnectionPolicy();
            if (connectionPolicyConfig.getUseExclusiveConnection()) {
                connectionPolicy.setExclusiveMode(ConnectionPolicy.ExclusiveMode.Isolated);
            } else {
                connectionPolicy.setExclusiveMode(ConnectionPolicy.ExclusiveMode.Transactional);
            }
            connectionPolicy.setIsLazy(connectionPolicyConfig.getLazy());
        }
    }

    protected void processConnectionPoolConfig(ConnectionPoolConfig connectionPoolConfig, ConnectionPool connectionPool, AbstractSession abstractSession) {
        Integer n;
        Login login = this.buildLogin(connectionPoolConfig.getLoginConfig());
        if (login != null) {
            connectionPool.setLogin(login);
        } else {
            connectionPool.setLogin(abstractSession.getDatasourceLogin());
        }
        connectionPool.setName(connectionPoolConfig.getName());
        Integer n2 = connectionPoolConfig.getMaxConnections();
        if (n2 != null) {
            connectionPool.setMaxNumberOfConnections(n2);
        }
        if ((n = connectionPoolConfig.getMinConnections()) != null) {
            connectionPool.setMinNumberOfConnections(n);
        }
    }

    protected void processSessionConfig(SessionConfig sessionConfig, AbstractSession abstractSession) {
        String string;
        this.processSessionEventManagerConfig(sessionConfig.getSessionEventManagerConfig(), abstractSession);
        ((DatabaseSessionImpl)abstractSession).setServerPlatform(this.buildServerPlatformConfig(sessionConfig.getServerPlatformConfig(), (DatabaseSessionImpl)abstractSession));
        SessionLog sessionLog = this.buildSessionLog(sessionConfig.getLogConfig(), abstractSession);
        if (sessionLog != null) {
            abstractSession.setSessionLog(sessionLog);
        }
        this.buildRemoteCommandManagerConfig(sessionConfig.getRemoteCommandManagerConfig(), abstractSession);
        abstractSession.setName(sessionConfig.getName());
        if (sessionConfig.getProfiler() != null && sessionConfig.getProfiler().equals("toplink")) {
            abstractSession.setProfiler(new PerformanceProfiler());
        }
        if ((string = sessionConfig.getExceptionHandlerClass()) != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    abstractSession.setExceptionHandler((ExceptionHandler)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                } else {
                    abstractSession.setExceptionHandler((ExceptionHandler)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                }
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadTag("exception-handler-class", string, throwable);
            }
        }
    }

    protected ServerPlatform buildServerPlatformConfig(ServerPlatformConfig serverPlatformConfig, DatabaseSessionImpl databaseSessionImpl) {
        ServerPlatform serverPlatform;
        if (serverPlatformConfig == null) {
            return new NoServerPlatform(databaseSessionImpl);
        }
        if (serverPlatformConfig instanceof CustomServerPlatformConfig) {
            serverPlatform = this.buildCustomServerPlatformConfig((CustomServerPlatformConfig)serverPlatformConfig, databaseSessionImpl);
        } else {
            String string = serverPlatformConfig.getServerClassName();
            if (serverPlatformConfig.isSupported()) {
                try {
                    Class<?> clazz = this.m_classLoader.loadClass(string);
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(clazz, new Class[]{DatabaseSession.class}, false));
                        serverPlatform = (ServerPlatform)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{databaseSessionImpl}));
                    }
                    Constructor constructor = PrivilegedAccessHelper.getConstructorFor(clazz, new Class[]{DatabaseSession.class}, false);
                    serverPlatform = (ServerPlatform)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{databaseSessionImpl});
                }
                catch (Throwable throwable) {
                    throw SessionLoaderException.failedToParseXML("Server platform class is invalid: " + string, throwable);
                }
            } else {
                throw SessionLoaderException.serverPlatformNoLongerSupported(string);
            }
        }
        this.processServerPlatformConfig(serverPlatformConfig, serverPlatform);
        return serverPlatform;
    }

    protected void buildRemoteCommandManagerConfig(RemoteCommandManagerConfig remoteCommandManagerConfig, AbstractSession abstractSession) {
        if (remoteCommandManagerConfig != null) {
            RemoteCommandManager remoteCommandManager = new RemoteCommandManager(abstractSession);
            this.processCommandsConfig(remoteCommandManagerConfig.getCommandsConfig(), remoteCommandManager);
            this.buildTransportManager(remoteCommandManagerConfig.getTransportManagerConfig(), remoteCommandManager);
            remoteCommandManager.setChannel(remoteCommandManagerConfig.getChannel());
        }
    }

    protected void buildTransportManager(TransportManagerConfig transportManagerConfig, RemoteCommandManager remoteCommandManager) {
        if (transportManagerConfig instanceof RMITransportManagerConfig) {
            this.buildRMITransportManagerConfig((RMITransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof RMIIIOPTransportManagerConfig) {
            this.buildRMIIIOPTransportManagerConfig((RMIIIOPTransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof JMSTopicTransportManagerConfig) {
            this.buildJMSTopicTransportManagerConfig((JMSTopicTransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof Oc4jJGroupsTransportManagerConfig) {
            this.buildOc4jJGroupsTransportManagerConfig((Oc4jJGroupsTransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof SunCORBATransportManagerConfig) {
            this.buildSunCORBATransportManagerConfig((SunCORBATransportManagerConfig)transportManagerConfig, remoteCommandManager);
        } else if (transportManagerConfig instanceof UserDefinedTransportManagerConfig) {
            this.buildUserDefinedTransportManagerConfig((UserDefinedTransportManagerConfig)transportManagerConfig, remoteCommandManager);
        }
    }

    protected void buildRMITransportManagerConfig(RMITransportManagerConfig rMITransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        RMITransportManager rMITransportManager = new RMITransportManager(remoteCommandManager);
        remoteCommandManager.setTransportManager(rMITransportManager);
        DiscoveryConfig discoveryConfig = rMITransportManagerConfig.getDiscoveryConfig();
        if (discoveryConfig != null) {
            this.processDiscoveryConfig(discoveryConfig, remoteCommandManager.getDiscoveryManager());
        }
        if (rMITransportManagerConfig.getJNDINamingServiceConfig() != null) {
            rMITransportManager.setNamingServiceType(0);
            this.processJNDINamingServiceConfig(rMITransportManagerConfig.getJNDINamingServiceConfig(), rMITransportManager);
        } else if (rMITransportManagerConfig.getRMIRegistryNamingServiceConfig() != null) {
            rMITransportManager.setNamingServiceType(1);
            this.processRMIRegistryNamingServiceConfig(rMITransportManagerConfig.getRMIRegistryNamingServiceConfig(), rMITransportManager);
        }
        rMITransportManager.setIsRMIOverIIOP(rMITransportManagerConfig instanceof RMIIIOPTransportManagerConfig);
        remoteCommandManager.setShouldPropagateAsynchronously(rMITransportManagerConfig.getSendMode().equals("Asynchronous"));
        this.processTransportManagerConfig(rMITransportManagerConfig, rMITransportManager);
    }

    protected Sequence buildSequence(SequenceConfig sequenceConfig) {
        if (sequenceConfig == null) {
            return null;
        }
        String string = sequenceConfig.getName();
        int n = sequenceConfig.getPreallocationSize();
        if (sequenceConfig instanceof DefaultSequenceConfig) {
            return new DefaultSequence(string, n);
        }
        if (sequenceConfig instanceof NativeSequenceConfig) {
            return new NativeSequence(string, n);
        }
        if (sequenceConfig instanceof TableSequenceConfig) {
            TableSequenceConfig tableSequenceConfig = (TableSequenceConfig)sequenceConfig;
            return new TableSequence(string, n, tableSequenceConfig.getTable(), tableSequenceConfig.getNameField(), tableSequenceConfig.getCounterField());
        }
        if (sequenceConfig instanceof UnaryTableSequenceConfig) {
            UnaryTableSequenceConfig unaryTableSequenceConfig = (UnaryTableSequenceConfig)sequenceConfig;
            return new UnaryTableSequence(string, n, unaryTableSequenceConfig.getCounterField());
        }
        if (sequenceConfig instanceof XMLFileSequenceConfig) {
            return new XMLFileSequence(string, n);
        }
        return null;
    }

    protected void buildRMIIIOPTransportManagerConfig(RMIIIOPTransportManagerConfig rMIIIOPTransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        this.buildRMITransportManagerConfig(rMIIIOPTransportManagerConfig, remoteCommandManager);
    }

    protected void buildJMSTopicTransportManagerConfig(JMSTopicTransportManagerConfig jMSTopicTransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        String string;
        JMSTopicTransportManager jMSTopicTransportManager = new JMSTopicTransportManager(remoteCommandManager);
        remoteCommandManager.setTransportManager(jMSTopicTransportManager);
        if (jMSTopicTransportManagerConfig.getJNDINamingServiceConfig() != null) {
            jMSTopicTransportManager.setNamingServiceType(0);
            this.processJNDINamingServiceConfig(jMSTopicTransportManagerConfig.getJNDINamingServiceConfig(), jMSTopicTransportManager);
        }
        if ((string = jMSTopicTransportManagerConfig.getTopicHostURL()) != null) {
            jMSTopicTransportManager.setTopicHostUrl(string);
        }
        jMSTopicTransportManager.setTopicConnectionFactoryName(jMSTopicTransportManagerConfig.getTopicConnectionFactoryName());
        jMSTopicTransportManager.setTopicName(jMSTopicTransportManagerConfig.getTopicName());
        this.processTransportManagerConfig(jMSTopicTransportManagerConfig, jMSTopicTransportManager);
    }

    protected void buildOc4jJGroupsTransportManagerConfig(Oc4jJGroupsTransportManagerConfig oc4jJGroupsTransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        TransportManager transportManager = null;
        try {
            Class<?> clazz = this.m_classLoader.loadClass(oc4jJGroupsTransportManagerConfig.getTransportManagerClassName());
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(clazz, new Class[]{RemoteCommandManager.class, Boolean.TYPE, String.class}, false));
                transportManager = (TransportManager)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{remoteCommandManager, oc4jJGroupsTransportManagerConfig.useSingleThreadedNotification(), oc4jJGroupsTransportManagerConfig.getTopicName()}));
            } else {
                Constructor constructor = PrivilegedAccessHelper.getConstructorFor(clazz, new Class[]{RemoteCommandManager.class, Boolean.TYPE, String.class}, false);
                transportManager = (TransportManager)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{remoteCommandManager, oc4jJGroupsTransportManagerConfig.useSingleThreadedNotification(), oc4jJGroupsTransportManagerConfig.getTopicName()});
            }
        }
        catch (Throwable throwable) {
            throw SessionLoaderException.failedToParseXML("Oc4jJGroupsTransportManager class is invalid: " + oc4jJGroupsTransportManagerConfig.getTransportManagerClassName(), throwable);
        }
        remoteCommandManager.setTransportManager(transportManager);
        this.processTransportManagerConfig(oc4jJGroupsTransportManagerConfig, transportManager);
    }

    protected void buildUserDefinedTransportManagerConfig(UserDefinedTransportManagerConfig userDefinedTransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        TransportManager transportManager = null;
        String string = userDefinedTransportManagerConfig.getTransportClass();
        if (string != null) {
            try {
                Class<?> clazz = this.m_classLoader.loadClass(string);
                transportManager = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? (TransportManager)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)) : (TransportManager)PrivilegedAccessHelper.newInstanceFromClass(clazz);
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadTag("transport-class", string, throwable);
            }
            remoteCommandManager.setTransportManager(transportManager);
            this.processTransportManagerConfig(userDefinedTransportManagerConfig, transportManager);
        }
    }

    protected void processJNDINamingServiceConfig(JNDINamingServiceConfig jNDINamingServiceConfig, TransportManager transportManager) {
        String string = jNDINamingServiceConfig.getURL();
        if (string != null) {
            transportManager.getRemoteCommandManager().setUrl(string);
        }
        transportManager.setUserName(jNDINamingServiceConfig.getUsername());
        transportManager.setEncryptionClassName(jNDINamingServiceConfig.getEncryptionClass());
        transportManager.setEncryptedPassword(jNDINamingServiceConfig.getEncryptedPassword());
        transportManager.setInitialContextFactoryName(jNDINamingServiceConfig.getInitialContextFactoryName());
        Enumeration enumeration = jNDINamingServiceConfig.getPropertyConfigs().elements();
        while (enumeration.hasMoreElements()) {
            PropertyConfig propertyConfig = (PropertyConfig)enumeration.nextElement();
            transportManager.getRemoteContextProperties().put(propertyConfig.getName(), propertyConfig.getValue());
        }
    }

    protected void processRMIRegistryNamingServiceConfig(RMIRegistryNamingServiceConfig rMIRegistryNamingServiceConfig, TransportManager transportManager) {
        transportManager.getRemoteCommandManager().setUrl(rMIRegistryNamingServiceConfig.getURL());
    }

    protected void processDiscoveryConfig(DiscoveryConfig discoveryConfig, DiscoveryManager discoveryManager) {
        discoveryManager.setMulticastGroupAddress(discoveryConfig.getMulticastGroupAddress());
        discoveryManager.setMulticastPort(discoveryConfig.getMulticastPort());
        discoveryManager.setAnnouncementDelay(discoveryConfig.getAnnouncementDelay());
        discoveryManager.setPacketTimeToLive(discoveryConfig.getPacketTimeToLive());
    }

    protected void processTransportManagerConfig(TransportManagerConfig transportManagerConfig, TransportManager transportManager) {
        transportManager.setShouldRemoveConnectionOnError(transportManagerConfig.getOnConnectionError().equals("DiscardConnection"));
    }

    protected void processSessionEventManagerConfig(SessionEventManagerConfig sessionEventManagerConfig, AbstractSession abstractSession) {
        if (sessionEventManagerConfig != null) {
            Enumeration enumeration = sessionEventManagerConfig.getSessionEventListeners().elements();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                try {
                    Class<?> clazz = this.m_classLoader.loadClass(string);
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        abstractSession.getEventManager().addListener((SessionEventListener)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz)));
                    }
                    abstractSession.getEventManager().addListener((SessionEventListener)PrivilegedAccessHelper.newInstanceFromClass(clazz));
                }
                catch (Exception exception) {
                    throw SessionLoaderException.failedToLoadTag("event-listener-class", string, exception);
                }
            }
        }
    }

    protected SessionLog buildSessionLog(LogConfig logConfig, AbstractSession abstractSession) {
        if (logConfig instanceof JavaLogConfig) {
            return this.buildJavaLogConfig((JavaLogConfig)logConfig, abstractSession);
        }
        if (logConfig instanceof DefaultSessionLogConfig) {
            return this.buildDefaultSessionLogConfig((DefaultSessionLogConfig)logConfig);
        }
        if (logConfig instanceof ServerLogConfig) {
            return this.buildServerLogConfig((ServerLogConfig)logConfig, abstractSession);
        }
        return null;
    }

    protected SessionLog buildJavaLogConfig(JavaLogConfig javaLogConfig, AbstractSession abstractSession) {
        SessionLog sessionLog = null;
        try {
            sessionLog = (SessionLog)((Class)ConversionManager.getDefaultManager().convertObject("org.eclipse.persistence.logging.JavaLog", Class.class)).newInstance();
            sessionLog.setSession(abstractSession);
        }
        catch (Exception exception) {
            throw ValidationException.unableToLoadClass("org.eclipse.persistence.logging.JavaLog", exception);
        }
        this.processLogConfig(javaLogConfig, sessionLog);
        return sessionLog;
    }

    protected SessionLog buildDefaultSessionLogConfig(DefaultSessionLogConfig defaultSessionLogConfig) {
        DefaultSessionLog defaultSessionLog = new DefaultSessionLog();
        defaultSessionLog.setLevel((Integer)this.m_logLevels.get(defaultSessionLogConfig.getLogLevel()));
        defaultSessionLog.setWriter(defaultSessionLogConfig.getFilename());
        this.processLogConfig(defaultSessionLogConfig, defaultSessionLog);
        return defaultSessionLog;
    }

    protected SessionLog buildServerLogConfig(ServerLogConfig serverLogConfig, AbstractSession abstractSession) {
        SessionLog sessionLog = ((DatabaseSessionImpl)abstractSession).getServerPlatform().getServerLog();
        return sessionLog;
    }

    protected void processLogConfig(LogConfig logConfig, SessionLog sessionLog) {
        if (logConfig.getLoggingOptions() != null) {
            if (logConfig.getLoggingOptions().getShouldLogExceptionStackTrace() != null) {
                sessionLog.setShouldLogExceptionStackTrace(logConfig.getLoggingOptions().getShouldLogExceptionStackTrace());
            }
            if (logConfig.getLoggingOptions().getShouldPrintConnection() != null) {
                sessionLog.setShouldPrintConnection(logConfig.getLoggingOptions().getShouldPrintConnection());
            }
            if (logConfig.getLoggingOptions().getShouldPrintDate() != null) {
                sessionLog.setShouldPrintDate(logConfig.getLoggingOptions().getShouldPrintDate());
            }
            if (logConfig.getLoggingOptions().getShouldPrintSession() != null) {
                sessionLog.setShouldPrintSession(logConfig.getLoggingOptions().getShouldPrintSession());
            }
            if (logConfig.getLoggingOptions().getShouldPrintThread() != null) {
                sessionLog.setShouldPrintThread(logConfig.getLoggingOptions().getShouldPrintThread());
            }
        }
    }

    protected void buildSunCORBATransportManagerConfig(SunCORBATransportManagerConfig sunCORBATransportManagerConfig, RemoteCommandManager remoteCommandManager) {
        SunCORBATransportManager sunCORBATransportManager = new SunCORBATransportManager(remoteCommandManager);
        remoteCommandManager.setTransportManager(sunCORBATransportManager);
        this.processTransportManagerConfig(sunCORBATransportManagerConfig, sunCORBATransportManager);
    }

    protected void processCommandsConfig(CommandsConfig commandsConfig, RemoteCommandManager remoteCommandManager) {
        if (commandsConfig != null) {
            ((AbstractSession)remoteCommandManager.getCommandProcessor()).setShouldPropagateChanges(commandsConfig.getCacheSync());
        }
    }

    protected SessionBroker buildSessionBrokerConfig(SessionBrokerConfig sessionBrokerConfig) {
        SessionBroker sessionBroker = new SessionBroker();
        Enumeration enumeration = sessionBrokerConfig.getSessionNames().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            sessionBroker.registerSession(string, (AbstractSession)this.m_sessions.get(string));
        }
        this.processSessionConfig(sessionBrokerConfig, sessionBroker);
        return sessionBroker;
    }
}

