/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.EnumSet;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.Session;

public class JAXBEnumTypeConverter
extends ObjectTypeConverter {
    private Class m_enumClass;
    private String m_enumClassName;
    private boolean m_usesOrdinalValues;

    public JAXBEnumTypeConverter(DatabaseMapping databaseMapping, String string, boolean bl) {
        super(databaseMapping);
        this.m_enumClassName = string;
        this.m_usesOrdinalValues = bl;
    }

    public void convertClassNamesToClasses() {
        block5: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_enumClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.m_enumClassName));
                        break block5;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, privilegedActionException.getException());
                    }
                }
                this.m_enumClass = PrivilegedAccessHelper.getClassForName(this.m_enumClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, classNotFoundException);
            }
        }
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        this.convertClassNamesToClasses();
        for (Enum enum_ : EnumSet.allOf(this.m_enumClass)) {
            if (this.getAttributeToFieldValues().get(enum_) != null) continue;
            Object v = this.getAttributeToFieldValues().get(enum_.name());
            if (v != null) {
                this.getAttributeToFieldValues().remove(enum_.name());
                this.addConversionValue(v, enum_);
                continue;
            }
            if (this.m_usesOrdinalValues) {
                this.addConversionValue(enum_.ordinal(), enum_);
                continue;
            }
            this.addConversionValue(enum_.name(), enum_);
        }
        super.initialize(databaseMapping, session);
    }

    public boolean usesOrdinalValues() {
        return this.m_usesOrdinalValues;
    }
}

