/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.awt.Image;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.bind.annotation.XmlNs;
import javax.xml.bind.annotation.XmlNsForm;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSchemaTypes;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.MarshalCallback;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.compiler.UnmarshalCallback;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaPackage;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsProcessor {
    private static final String JAVAX_ACTIVATION_DATAHANDLER = "javax.activation.DataHandler";
    private static final String JAVAX_MAIL_INTERNET_MIMEMULTIPART = "javax.mail.internet.MimeMultipart";
    private ArrayList<JavaClass> typeInfoClasses;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, MarshalCallback> marshalCallbacks;
    private HashMap<String, QName> userDefinedSchemaTypes;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<String, UnmarshalCallback> unmarshalCallbacks;
    private HashMap<QName, ElementDeclaration> globalElements;
    private NamespaceResolver namespaceResolver;
    private Helper helper;

    public AnnotationsProcessor(Helper helper) {
        this.helper = helper;
    }

    public void processClassesAndProperties(JavaClass[] javaClassArray) {
        this.typeInfoClasses = new ArrayList();
        this.typeInfo = new HashMap();
        this.userDefinedSchemaTypes = new HashMap();
        this.packageToNamespaceMappings = new HashMap();
        this.namespaceResolver = new NamespaceResolver();
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (JavaClass javaClass2 : javaClassArray) {
            if (this.helper.isAnnotationPresent(javaClass2, XmlRegistry.class)) {
                this.processObjectFactory(javaClass2, arrayList);
                continue;
            }
            arrayList.add(javaClass2);
        }
        this.updateGlobalElements(arrayList);
        for (JavaClass javaClass : arrayList) {
            if (javaClass == null) continue;
            this.createTypeInfoFor(javaClass);
            for (JavaClass javaClass2 : javaClass.getDeclaredClasses()) {
                if (!this.shouldGenerateTypeInfo(javaClass2)) continue;
                this.createTypeInfoFor(javaClass2);
            }
            JavaClass javaClass3 = javaClass.getSuperclass();
            if (!this.shouldGenerateTypeInfo(javaClass3)) continue;
            this.createTypeInfoFor(javaClass3);
        }
        this.checkForCallbackMethods();
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        if (this.typeInfo == null) {
            this.typeInfoClasses = new ArrayList();
            this.typeInfo = new HashMap();
            this.userDefinedSchemaTypes = new HashMap();
            this.packageToNamespaceMappings = new HashMap();
            this.namespaceResolver = new NamespaceResolver();
        }
        TypeInfo typeInfo = this.createTypeInfoFor(javaClass);
        JavaPackage javaPackage = javaClass.getPackage();
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaPackage.getQualifiedName());
        SchemaTypeInfo schemaTypeInfo = new SchemaTypeInfo();
        schemaTypeInfo.setSchemaTypeName(new QName(typeInfo.getClassNamespace(), typeInfo.getSchemaTypeName()));
        if (this.helper.isAnnotationPresent(javaClass, XmlRootElement.class)) {
            int n;
            char c;
            XmlRootElement xmlRootElement = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
            String string = xmlRootElement.name();
            if ((string.equals("##default") || string.equals("")) && (string = javaClass.getName().indexOf("$") != -1 ? Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(javaClass.getName().substring(javaClass.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(c = string.charAt((n = string.length() - 1) - 1))) {
                char c2 = Character.toUpperCase(string.charAt(n));
                string = string.substring(0, n) + c2;
            }
            String string2 = xmlRootElement.namespace();
            QName qName = null;
            qName = string2.equals("##default") ? new QName(namespaceInfo.getNamespace(), string) : new QName(string2, string);
            schemaTypeInfo.getGlobalElementDeclarations().add(qName);
            ElementDeclaration elementDeclaration = new ElementDeclaration(qName, javaClass, javaClass.getRawName(), false);
            this.globalElements.put(qName, elementDeclaration);
        }
        return schemaTypeInfo;
    }

    /*
     * WARNING - void declaration
     */
    public TypeInfo createTypeInfoFor(JavaClass javaClass) {
        JavaClass javaClass2;
        Object object;
        JavaClass javaClass3;
        Object[] objectArray;
        Object object3;
        if (javaClass == null) {
            return null;
        }
        if (this.typeInfo.containsKey(javaClass.getQualifiedName())) {
            return this.typeInfo.get(javaClass.getQualifiedName());
        }
        TypeInfo typeInfo = null;
        typeInfo = javaClass.isEnum() ? new EnumTypeInfo(this.helper) : new TypeInfo(this.helper);
        JavaPackage javaPackage = javaClass.getPackage();
        if (this.helper.isAnnotationPresent(javaPackage, XmlJavaTypeAdapters.class)) {
            object3 = (XmlJavaTypeAdapters)this.helper.getAnnotation(javaPackage, XmlJavaTypeAdapters.class);
            objectArray = object3.value();
            for (XmlJavaTypeAdapter xmlJavaTypeAdapter : objectArray) {
                JavaClass javaClass4 = this.helper.getJavaClass(xmlJavaTypeAdapter.value());
                javaClass3 = this.helper.getJavaClass(xmlJavaTypeAdapter.type());
                if (javaClass3 == null) continue;
                typeInfo.addAdapterClass(javaClass4, javaClass3);
            }
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlJavaTypeAdapters.class)) {
            object3 = (XmlJavaTypeAdapters)this.helper.getAnnotation(javaClass, XmlJavaTypeAdapters.class);
            objectArray = object3.value();
            for (XmlSchemaType xmlSchemaType : objectArray) {
                JavaClass javaClass5 = this.helper.getJavaClass(xmlSchemaType.value());
                javaClass3 = this.helper.getJavaClass(xmlSchemaType.type());
                if (javaClass3 == null) continue;
                typeInfo.addAdapterClass(javaClass5, javaClass3);
            }
        }
        object3 = this.getNamespaceInfoForPackage(javaPackage);
        if (this.helper.isAnnotationPresent(javaPackage, XmlSchemaTypes.class)) {
            void var9_19;
            objectArray = (XmlSchemaType[])this.helper.getAnnotation(javaPackage, XmlSchemaTypes.class);
            object = objectArray.value();
            XmlSchemaType[] xmlSchemaTypeArray = object;
            int n = xmlSchemaTypeArray.length;
            boolean bl = false;
            while (var9_19 < n) {
                XmlSchemaType xmlSchemaType = xmlSchemaTypeArray[var9_19];
                this.processSchemaType(xmlSchemaType);
                ++var9_19;
            }
        } else if (this.helper.isAnnotationPresent(javaPackage, XmlSchemaType.class)) {
            this.processSchemaType((XmlSchemaType)this.helper.getAnnotation(javaPackage, XmlSchemaType.class));
        }
        objectArray = new String[]{""};
        object = "";
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType xmlType = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            object = xmlType.name();
            if (((String)object).equals("##default")) {
                object = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
            objectArray = xmlType.propOrder();
            if (!xmlType.namespace().equals("##default")) {
                typeInfo.setClassNamespace(xmlType.namespace());
            } else {
                typeInfo.setClassNamespace(((NamespaceInfo)object3).getNamespace());
            }
        } else {
            object = this.getSchemaTypeNameForClassName(javaClass.getName());
            typeInfo.setClassNamespace(((NamespaceInfo)object3).getNamespace());
        }
        typeInfo.setPropOrder((String[])objectArray);
        typeInfo.setSchemaTypeName((String)object);
        if (typeInfo.isEnumerationType()) {
            this.addEnumTypeInfo(javaClass, (EnumTypeInfo)typeInfo);
            return typeInfo;
        }
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), typeInfo);
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorType.class)) {
            XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(javaClass, XmlAccessorType.class);
            typeInfo.setAccessType(xmlAccessorType.value());
        } else {
            typeInfo.setAccessType(((NamespaceInfo)object3).getAccessType());
        }
        typeInfo.setProperties(this.getPropertiesForClass(javaClass, typeInfo));
        if (this.helper.isAnnotationPresent(javaClass, XmlAccessorOrder.class)) {
            XmlAccessorOrder xmlAccessorOrder = (XmlAccessorOrder)this.helper.getAnnotation(javaClass, XmlAccessorOrder.class);
            typeInfo.orderProperties(xmlAccessorOrder.value());
        }
        if (this.shouldGenerateTypeInfo(javaClass2 = javaClass.getSuperclass())) {
            this.createTypeInfoFor(javaClass2);
        }
        ArrayList<Property> arrayList = typeInfo.getPropertyList();
        for (Property property : arrayList) {
            JavaClass javaClass6;
            javaClass3 = property.getType();
            if (this.isCollectionType(property)) {
                javaClass6 = property.getGenericType();
                if (javaClass6 != null) {
                    if (javaClass6.hasActualTypeArguments()) {
                        javaClass3 = this.helper.getJavaClass(javaClass6.getRawName());
                    } else if (javaClass6 instanceof JavaClass) {
                        javaClass3 = javaClass6;
                    }
                }
            } else if (javaClass3.isArray()) {
                javaClass3 = javaClass3.getComponentType();
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class) && (javaClass6 = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).type() != XmlElement.DEFAULT.class) {
                javaClass3 = this.helper.getJavaClass(javaClass6.type());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlID.class)) {
                if (!this.areEquals(property.getType(), String.class)) {
                    // empty if block
                }
                if (typeInfo.isIDSet()) {
                    // empty if block
                }
                typeInfo.setIDProperty(property);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                property.setAdapterClass(((XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class)).value());
            }
            if (!this.shouldGenerateTypeInfo(javaClass3)) continue;
            this.createTypeInfoFor(javaClass3);
        }
        return typeInfo;
    }

    public boolean shouldGenerateTypeInfo(JavaClass javaClass) {
        if (javaClass == null || javaClass.isPrimitive() || javaClass.isAnnotation() || javaClass.isInterface() || javaClass.isArray()) {
            return false;
        }
        if (this.userDefinedSchemaTypes.get(javaClass.getQualifiedName()) != null) {
            return false;
        }
        return !this.helper.isBuiltInJavaType(javaClass);
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        if (typeInfo.getAccessType() == XmlAccessType.FIELD) {
            return this.getFieldPropertiesForClass(javaClass, typeInfo, false);
        }
        if (typeInfo.getAccessType() == XmlAccessType.PROPERTY) {
            return this.getPropertyPropertiesForClass(javaClass, typeInfo, false);
        }
        if (typeInfo.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            return this.getPublicMemberPropertiesForClass(javaClass, typeInfo);
        }
        return this.getNoAccessTypePropertiesForClass(javaClass, typeInfo);
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (javaClass == null) {
            return arrayList;
        }
        for (JavaField javaField : javaClass.getDeclaredFields()) {
            QName qName;
            String string;
            String string2;
            int n;
            XmlElementRef xmlElementRef;
            Object object2;
            int n2;
            if (this.helper.isAnnotationPresent(javaField, XmlTransient.class) || Modifier.isStatic(n2 = javaField.getModifiers()) || Modifier.isTransient(n2) || (!Modifier.isPublic(javaField.getModifiers()) || !bl) && bl) continue;
            Property property = null;
            if (this.helper.isAnnotationPresent(javaField, XmlElements.class)) {
                property = new ChoiceProperty(this.helper);
                property.setElement(javaField);
                object2 = (XmlElements)this.helper.getAnnotation(property.getElement(), XmlElements.class);
                xmlElementRef = object2.value();
                ArrayList<Property> arrayList2 = new ArrayList<Property>(((XmlElement[])xmlElementRef).length);
                for (n = 0; n < ((XmlElementRef)xmlElementRef).length; ++n) {
                    XmlElementRef xmlElementRef2 = xmlElementRef[n];
                    Property property2 = new Property();
                    string2 = xmlElementRef2.name();
                    string = xmlElementRef2.namespace();
                    qName = null;
                    qName = !string.equals("##default") ? new QName(string, string2) : new QName(string2);
                    property2.setPropertyName(property.getPropertyName());
                    property2.setType(this.helper.getJavaClass(xmlElementRef2.type()));
                    property2.setSchemaName(qName);
                    property2.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(xmlElementRef2.type())));
                    property2.setElement(property.getElement());
                    arrayList2.add(property2);
                }
                ((ChoiceProperty)property).setChoiceProperties(arrayList2);
            } else if (this.helper.isAnnotationPresent(javaField, XmlAnyElement.class)) {
                property = new AnyProperty(this.helper);
                property.setElement(javaField);
                object2 = (XmlAnyElement)this.helper.getAnnotation(javaField, XmlAnyElement.class);
                ((AnyProperty)property).setLax(object2.lax());
                ((AnyProperty)property).setDomHandlerClass(object2.value());
            } else if (this.helper.isAnnotationPresent(javaField, XmlElementRef.class) || this.helper.isAnnotationPresent(javaField, XmlElementRefs.class)) {
                property = new ReferenceProperty(this.helper);
                property.setElement(javaField);
                xmlElementRef = (XmlElementRef)this.helper.getAnnotation(javaField, XmlElementRef.class);
                if (xmlElementRef != null) {
                    object2 = new XmlElementRef[]{xmlElementRef};
                } else {
                    XmlElementRefs xmlElementRefs = (XmlElementRefs)this.helper.getAnnotation(javaField, XmlElementRefs.class);
                    object2 = xmlElementRefs.value();
                    typeInfo.setHasElementRefs(true);
                }
                XmlElementRef[] xmlElementRefArray = object2;
                n = xmlElementRefArray.length;
                for (int i = 0; i < n; ++i) {
                    ElementDeclaration elementDeclaration;
                    XmlElementRef xmlElementRef3 = xmlElementRefArray[i];
                    string2 = xmlElementRef3.name();
                    string = xmlElementRef3.namespace();
                    if (string.equals("##default")) {
                        string = "";
                    }
                    if ((elementDeclaration = this.globalElements.get(qName = new QName(string, string2))) == null) continue;
                    this.addReferencedElement((ReferenceProperty)property, elementDeclaration);
                }
            } else {
                property = new Property(this.helper);
                property.setElement(javaField);
            }
            object2 = javaField.getResolvedType();
            property.setType((JavaClass)object2);
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                xmlElementRef = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(xmlElementRef.value());
            } else if (typeInfo.getAdaptersByClass().get(object2) != null) {
                property.setAdapterClass(typeInfo.getAdapterClass((JavaClass)object2));
            }
            if (property.hasAdapterClass()) {
                object2 = property.getValueType();
            }
            property.setGenericType(this.helper.getGenericType(javaField));
            property.setPropertyName(javaField.getName());
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals((JavaClass)object2, JAVAX_ACTIVATION_DATAHANDLER)) {
                property.setIsSwaAttachmentRef(true);
                property.setSchemaType(XMLConstants.SWA_REF_QNAME);
            } else if (this.areEquals((JavaClass)object2, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals((JavaClass)object2, byte[].class) || this.areEquals((JavaClass)object2, Byte[].class) || this.areEquals((JavaClass)object2, Image.class) || this.areEquals((JavaClass)object2, Source.class) || this.areEquals((JavaClass)object2, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                property.setIsMtomAttachment(true);
                property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
                property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                xmlElementRef = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                QName qName2 = new QName(xmlElementRef.namespace(), xmlElementRef.name());
                property.setSchemaType(qName2);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                property.setIsAttribute(true);
                property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                property.setIsAttribute(true);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) {
                property.setIsRequired(((XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).required());
            }
            property.setSchemaName(this.getQNameForProperty(Introspector.decapitalize(javaField.getName()), javaField));
            arrayList.add(property);
        }
        return arrayList;
    }

    protected boolean areEquals(JavaClass javaClass, Class clazz) {
        if (javaClass == null || clazz == null) {
            return false;
        }
        return javaClass.getRawName().equals(clazz.getCanonicalName());
    }

    protected boolean areEquals(JavaClass javaClass, String string) {
        if (javaClass == null || string == null) {
            return false;
        }
        return javaClass.getRawName().equals(string);
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (javaClass == null) {
            return arrayList;
        }
        ArrayList<JavaMethod> arrayList2 = new ArrayList<JavaMethod>();
        for (JavaMethod javaMethod : new ArrayList(javaClass.getDeclaredMethods())) {
            int n;
            if ((!javaMethod.getName().startsWith("get") || javaMethod.getName().length() <= 3) && (!this.areEquals(javaMethod.getReturnType(), Boolean.class) && !this.areEquals(javaMethod.getReturnType(), Boolean.TYPE) || !javaMethod.getName().startsWith("is") || javaMethod.getName().length() <= 2) || Modifier.isStatic(n = javaMethod.getModifiers()) || Modifier.isTransient(n) || (!bl || !Modifier.isPublic(javaMethod.getModifiers())) && bl) continue;
            arrayList2.add(javaMethod);
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            QName qName;
            String string;
            String string2;
            XmlElementRef[] xmlElementRefArray;
            XmlElementRef xmlElementRef;
            XmlElementRef[] xmlElementRefArray2;
            JavaMethod javaMethod;
            javaMethod = (JavaMethod)arrayList2.get(i);
            String string3 = "";
            if (javaMethod.getName().startsWith("get")) {
                string3 = javaMethod.getName().substring(3);
            } else if (javaMethod.getName().startsWith("is")) {
                string3 = javaMethod.getName().substring(2);
            }
            string3 = Character.toLowerCase(string3.charAt(0)) + string3.substring(1);
            String string4 = "set" + Character.toUpperCase(string3.charAt(0)) + string3.substring(1);
            JavaClass[] javaClassArray = new JavaClass[]{javaMethod.getReturnType()};
            JavaMethod javaMethod2 = javaClass.getMethod(string4, javaClassArray);
            JavaMethod javaMethod3 = null;
            if (javaMethod2 != null && !javaMethod2.getAnnotations().isEmpty()) {
                if (!this.helper.isAnnotationPresent(javaMethod2, XmlTransient.class)) {
                    javaMethod3 = javaMethod2;
                }
            } else if (!this.helper.isAnnotationPresent(javaMethod, XmlTransient.class)) {
                javaMethod3 = javaMethod;
            }
            Property property = null;
            property = this.helper.isAnnotationPresent(javaMethod3, XmlElements.class) ? new ChoiceProperty(this.helper) : (this.helper.isAnnotationPresent(javaMethod3, XmlAnyElement.class) ? new AnyProperty(this.helper) : (this.helper.isAnnotationPresent(javaMethod3, XmlElementRef.class) || this.helper.isAnnotationPresent(javaMethod3, XmlElementRefs.class) ? new ReferenceProperty(this.helper) : new Property(this.helper)));
            property.setElement(javaMethod3);
            property.setSchemaName(this.getQNameForProperty(string3, javaMethod3));
            property.setPropertyName(string3);
            property.setType(javaMethod.getReturnType());
            property.setGenericType(this.helper.getGenericReturnType(javaMethod));
            property.setGetMethodName(javaMethod.getName());
            property.setSetMethodName(string4);
            property.setMethodProperty(true);
            JavaClass javaClass2 = property.getType();
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                xmlElementRefArray2 = (XmlElementRef[])this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(xmlElementRefArray2.value());
            } else if (typeInfo.getAdaptersByClass().get(javaClass2) != null) {
                property.setAdapterClass(typeInfo.getAdaptersByClass().get(javaClass2));
            }
            if (property.hasAdapterClass()) {
                javaClass2 = property.getValueType();
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlSchemaType.class)) {
                xmlElementRefArray2 = (XmlSchemaType)this.helper.getAnnotation(property.getElement(), XmlSchemaType.class);
                xmlElementRef = new QName(xmlElementRefArray2.namespace(), xmlElementRefArray2.name());
                property.setSchemaType((QName)xmlElementRef);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttachmentRef.class) && this.areEquals(javaClass2, JAVAX_ACTIVATION_DATAHANDLER)) {
                property.setIsSwaAttachmentRef(true);
                property.setSchemaType(XMLConstants.SWA_REF_QNAME);
            } else if (this.areEquals(javaClass2, JAVAX_ACTIVATION_DATAHANDLER) || this.areEquals(javaClass2, byte[].class) || this.areEquals(javaClass2, Byte[].class) || this.areEquals(javaClass2, Image.class) || this.areEquals(javaClass2, Source.class) || this.areEquals(javaClass2, JAVAX_MAIL_INTERNET_MIMEMULTIPART)) {
                property.setIsMtomAttachment(true);
                property.setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlMimeType.class)) {
                property.setMimeType(((XmlMimeType)this.helper.getAnnotation(property.getElement(), XmlMimeType.class)).value());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlJavaTypeAdapter.class)) {
                xmlElementRefArray2 = (XmlJavaTypeAdapter)this.helper.getAnnotation(property.getElement(), XmlJavaTypeAdapter.class);
                property.setAdapterClass(xmlElementRefArray2.value());
            } else if (typeInfo.getAdaptersByClass().get(javaClass2) != null) {
                property.setAdapterClass(typeInfo.getAdaptersByClass().get(javaClass2));
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
                property.setIsAttribute(true);
                property.setIsRequired(((XmlAttribute)this.helper.getAnnotation(property.getElement(), XmlAttribute.class)).required());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
                property.setIsAttribute(true);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElements.class)) {
                xmlElementRefArray2 = (XmlElements)this.helper.getAnnotation(property.getElement(), XmlElements.class);
                xmlElementRef = xmlElementRefArray2.value();
                xmlElementRefArray = new ArrayList(((XmlElement[])xmlElementRef).length);
                for (int j = 0; j < ((XmlElement[])xmlElementRef).length; ++j) {
                    XmlElementRef xmlElementRef2 = xmlElementRef[j];
                    Property property2 = new Property();
                    string2 = xmlElementRef2.name();
                    string = xmlElementRef2.namespace();
                    qName = null;
                    qName = !string.equals("##default") ? new QName(string, string2) : new QName(string2);
                    property2.setPropertyName(property.getPropertyName());
                    property2.setType(this.helper.getJavaClass(xmlElementRef2.type()));
                    property2.setSchemaName(qName);
                    property2.setSchemaType(this.getSchemaTypeFor(this.helper.getJavaClass(xmlElementRef2.type())));
                    property2.setElement(property.getElement());
                    xmlElementRefArray.add(property2);
                }
                ((ChoiceProperty)property).setChoiceProperties((Collection<Property>)xmlElementRefArray);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlAnyElement.class)) {
                xmlElementRefArray2 = (XmlAnyElement)this.helper.getAnnotation(property.getElement(), XmlAnyElement.class);
                ((AnyProperty)property).setDomHandlerClass(xmlElementRefArray2.value());
                ((AnyProperty)property).setLax(xmlElementRefArray2.lax());
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlElementRef.class) || this.helper.isAnnotationPresent(property.getElement(), XmlElementRefs.class)) {
                xmlElementRef = (XmlElementRef)this.helper.getAnnotation(property.getElement(), XmlElementRef.class);
                if (xmlElementRef != null) {
                    xmlElementRefArray2 = new XmlElementRef[]{xmlElementRef};
                } else {
                    xmlElementRefArray = (XmlElementRef[])this.helper.getAnnotation(property.getElement(), XmlElementRefs.class);
                    xmlElementRefArray2 = xmlElementRefArray.value();
                    typeInfo.setHasElementRefs(true);
                }
                for (XmlElementRef xmlElementRef2 : xmlElementRefArray2) {
                    ElementDeclaration elementDeclaration;
                    string2 = xmlElementRef2.name();
                    string = xmlElementRef2.namespace();
                    if (string.equals("##default")) {
                        string = "";
                    }
                    if ((elementDeclaration = this.globalElements.get(qName = new QName(string, string2))) == null) continue;
                    ((ReferenceProperty)property).addReferencedElement(elementDeclaration);
                }
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) {
                arrayList.add(property);
            }
            if (!this.helper.isAnnotationPresent(property.getElement(), XmlElement.class)) continue;
            property.setIsRequired(((XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).required());
        }
        return arrayList;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        ArrayList<Property> arrayList = this.getFieldPropertiesForClass(javaClass, typeInfo, false);
        ArrayList<Property> arrayList2 = this.getPropertyPropertiesForClass(javaClass, typeInfo, false);
        ArrayList<Property> arrayList3 = new ArrayList<Property>();
        ArrayList<Property> arrayList4 = new ArrayList<Property>();
        for (Property property : arrayList) {
            if (Modifier.isPublic(((JavaField)property.getElement()).getModifiers())) {
                arrayList3.add(property);
                continue;
            }
            if (!this.hasJAXBAnnotations(property.getElement())) continue;
            arrayList3.add(property);
        }
        for (Property property : arrayList2) {
            if (property.getElement() == null) continue;
            if (Modifier.isPublic(((JavaMethod)property.getElement()).getModifiers())) {
                arrayList4.add(property);
                continue;
            }
            if (!this.hasJAXBAnnotations(property.getElement())) continue;
            arrayList4.add(property);
        }
        if (arrayList3.size() >= 0 && arrayList4.size() == 0) {
            return arrayList3;
        }
        if (arrayList4.size() > 0 && arrayList3.size() == 0) {
            return arrayList4;
        }
        HashMap hashMap = this.getPropertyMapFromArrayList(arrayList3);
        for (int i = 0; i < arrayList4.size(); ++i) {
            Property property = (Property)arrayList4.get(i);
            if (hashMap.get(property.getPropertyName()) != null) continue;
            arrayList3.add(property);
        }
        return arrayList3;
    }

    public HashMap getPropertyMapFromArrayList(ArrayList<Property> arrayList) {
        HashMap<String, Property> hashMap = new HashMap<String, Property>(arrayList.size());
        for (Property property : arrayList) {
            hashMap.put(property.getPropertyName(), property);
        }
        return hashMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        JavaHasAnnotations javaHasAnnotations;
        Property property;
        int n;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        if (javaClass == null) {
            return arrayList;
        }
        ArrayList<Property> arrayList2 = this.getFieldPropertiesForClass(javaClass, typeInfo, false);
        ArrayList<Property> arrayList3 = this.getPropertyPropertiesForClass(javaClass, typeInfo, false);
        for (n = 0; n < arrayList2.size(); ++n) {
            property = arrayList2.get(n);
            javaHasAnnotations = property.getElement();
            if (!this.hasJAXBAnnotations(javaHasAnnotations)) continue;
            arrayList.add(property);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            property = arrayList3.get(n);
            javaHasAnnotations = property.getElement();
            if (!this.hasJAXBAnnotations(javaHasAnnotations)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public void processSchemaType(XmlSchemaType xmlSchemaType) {
        String string = xmlSchemaType.name();
        Class clazz = xmlSchemaType.type();
        if (clazz == null) {
            return;
        }
        JavaClass javaClass = this.helper.getJavaClass(clazz);
        if (javaClass == null) {
            return;
        }
        QName qName = new QName(xmlSchemaType.namespace(), string);
        this.userDefinedSchemaTypes.put(javaClass.getQualifiedName(), qName);
    }

    public void addEnumTypeInfo(JavaClass javaClass, EnumTypeInfo enumTypeInfo) {
        Object object;
        if (javaClass == null) {
            return;
        }
        enumTypeInfo.setClassName(javaClass.getQualifiedName());
        Class clazz = String.class;
        if (this.helper.isAnnotationPresent(javaClass, XmlEnum.class)) {
            object = (XmlEnum)this.helper.getAnnotation(javaClass, XmlEnum.class);
            clazz = object.value();
        }
        object = this.getSchemaTypeFor(this.helper.getJavaClass(clazz));
        enumTypeInfo.setRestrictionBase((QName)object);
        for (JavaField javaField : javaClass.getDeclaredFields()) {
            if (!javaField.isEnumConstant()) continue;
            String string = javaField.getName();
            if (this.helper.isAnnotationPresent(javaField, XmlEnumValue.class)) {
                XmlEnumValue xmlEnumValue = (XmlEnumValue)this.helper.getAnnotation(javaField, XmlEnumValue.class);
                string = xmlEnumValue.value();
            }
            enumTypeInfo.addObjectToFieldValuePair(javaField.getName(), string);
        }
        this.typeInfoClasses.add(javaClass);
        this.typeInfo.put(javaClass.getQualifiedName(), enumTypeInfo);
    }

    public String getSchemaTypeNameForClassName(String string) {
        String string2 = "";
        string2 = string.indexOf(36) != -1 ? Introspector.decapitalize(string.substring(string.lastIndexOf(36) + 1)) : Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1));
        return string2;
    }

    public QName getSchemaTypeFor(JavaClass javaClass) {
        if (javaClass == null) {
            return null;
        }
        QName qName = this.userDefinedSchemaTypes.get(javaClass.getQualifiedName());
        if (qName == null) {
            qName = (QName)this.helper.getXMLToJavaTypeMap().get(javaClass.getRawName());
        }
        if (qName == null) {
            return XMLConstants.ANY_SIMPLE_TYPE_QNAME;
        }
        return qName;
    }

    public boolean isCollectionType(Property property) {
        JavaClass javaClass = property.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(List.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(Set.class).isAssignableFrom(javaClass);
    }

    public NamespaceInfo processNamespaceInformation(XmlSchema xmlSchema) {
        NamespaceInfo namespaceInfo = new NamespaceInfo();
        namespaceInfo.setNamespaceResolver(new NamespaceResolver());
        String string = null;
        if (xmlSchema != null) {
            String string2 = xmlSchema.namespace();
            if (!string2.equals("") && !string2.equals("##default")) {
                string = string2;
            }
            namespaceInfo.setNamespace(string);
            XmlNs[] xmlNsArray = xmlSchema.xmlns();
            for (int i = 0; i < xmlNsArray.length; ++i) {
                XmlNs xmlNs = xmlNsArray[i];
                namespaceInfo.getNamespaceResolver().put(xmlNs.prefix(), xmlNs.namespaceURI());
            }
            namespaceInfo.setAttributeFormQualified(xmlSchema.attributeFormDefault() == XmlNsForm.QUALIFIED);
            namespaceInfo.setElementFormQualified(xmlSchema.elementFormDefault() == XmlNsForm.QUALIFIED);
        }
        return namespaceInfo;
    }

    public HashMap<String, TypeInfo> getTypeInfo() {
        return this.typeInfo;
    }

    public ArrayList<JavaClass> getTypeInfoClasses() {
        return this.typeInfoClasses;
    }

    public HashMap getUserDefinedSchemaTypes() {
        return this.userDefinedSchemaTypes;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public String getSchemaTypeNameFor(JavaClass javaClass, XmlType xmlType) {
        String string = "";
        if (javaClass == null) {
            return string;
        }
        if (this.helper.isAnnotationPresent(javaClass, XmlType.class)) {
            XmlType xmlType2 = (XmlType)this.helper.getAnnotation(javaClass, XmlType.class);
            string = xmlType2.name();
            if (string.equals("#default")) {
                string = this.getSchemaTypeNameForClassName(javaClass.getName());
            }
        } else {
            string = this.getSchemaTypeNameForClassName(javaClass.getName());
        }
        return string;
    }

    public QName getQNameForProperty(String string, JavaHasAnnotations javaHasAnnotations) {
        Object object;
        String string2 = "##default";
        String string3 = "##default";
        if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlAttribute.class)) {
            object = (XmlAttribute)this.helper.getAnnotation(javaHasAnnotations, XmlAttribute.class);
            string2 = object.name();
            string3 = object.namespace();
        } else if (this.helper.isAnnotationPresent(javaHasAnnotations, XmlElement.class)) {
            object = (XmlElement)this.helper.getAnnotation(javaHasAnnotations, XmlElement.class);
            string2 = object.name();
            string3 = object.namespace();
        }
        if (string2.equals("##default")) {
            string2 = string;
        }
        object = null;
        object = !string3.equals("##default") ? new QName(string3, string2) : new QName(string2);
        return object;
    }

    public HashMap<String, NamespaceInfo> getPackageToNamespaceMappings() {
        return this.packageToNamespaceMappings;
    }

    public NamespaceInfo getNamespaceInfoForPackage(JavaPackage javaPackage) {
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaPackage.getQualifiedName());
        if (namespaceInfo == null) {
            XmlSchema xmlSchema = (XmlSchema)this.helper.getAnnotation(javaPackage, XmlSchema.class);
            namespaceInfo = this.processNamespaceInformation(xmlSchema);
            if (namespaceInfo.getNamespace() == null) {
                namespaceInfo.setNamespace("");
            }
            if (this.helper.isAnnotationPresent(javaPackage, XmlAccessorType.class)) {
                XmlAccessorType xmlAccessorType = (XmlAccessorType)this.helper.getAnnotation(javaPackage, XmlAccessorType.class);
                namespaceInfo.setAccessType(xmlAccessorType.value());
            }
            this.packageToNamespaceMappings.put(javaPackage.getQualifiedName(), namespaceInfo);
        }
        return namespaceInfo;
    }

    private void checkForCallbackMethods() {
        for (JavaClass javaClass : this.typeInfoClasses) {
            if (javaClass == null) continue;
            JavaClass javaClass2 = this.helper.getJavaClass(Unmarshaller.class);
            JavaClass javaClass3 = this.helper.getJavaClass(Marshaller.class);
            JavaClass javaClass4 = this.helper.getJavaClass(Object.class);
            JavaClass[] javaClassArray = new JavaClass[]{javaClass2, javaClass4};
            JavaClass[] javaClassArray2 = new JavaClass[]{javaClass3};
            UnmarshalCallback unmarshalCallback = null;
            MarshalCallback marshalCallback = null;
            if (javaClass.getMethod("beforeUnmarshal", javaClassArray) != null) {
                unmarshalCallback = new UnmarshalCallback();
                unmarshalCallback.setDomainClassName(javaClass.getQualifiedName());
                unmarshalCallback.setHasBeforeUnmarshalCallback();
            }
            if (javaClass.getMethod("afterUnmarshal", javaClassArray) != null) {
                if (unmarshalCallback == null) {
                    unmarshalCallback = new UnmarshalCallback();
                    unmarshalCallback.setDomainClassName(javaClass.getQualifiedName());
                }
                unmarshalCallback.setHasAfterUnmarshalCallback();
            }
            if (unmarshalCallback != null) {
                if (this.unmarshalCallbacks == null) {
                    this.unmarshalCallbacks = new HashMap();
                }
                this.unmarshalCallbacks.put(javaClass.getQualifiedName(), unmarshalCallback);
            }
            if (javaClass.getMethod("beforeMarshal", javaClassArray2) != null) {
                marshalCallback = new MarshalCallback();
                marshalCallback.setDomainClassName(javaClass.getQualifiedName());
                marshalCallback.setHasBeforeMarshalCallback();
            }
            if (javaClass.getMethod("afterMarshal", javaClassArray2) != null) {
                if (marshalCallback == null) {
                    marshalCallback = new MarshalCallback();
                    marshalCallback.setDomainClassName(javaClass.getQualifiedName());
                }
                marshalCallback.setHasAfterMarshalCallback();
            }
            if (marshalCallback == null) continue;
            if (this.marshalCallbacks == null) {
                this.marshalCallbacks = new HashMap();
            }
            this.marshalCallbacks.put(javaClass.getQualifiedName(), marshalCallback);
        }
    }

    public HashMap<String, MarshalCallback> getMarshalCallbacks() {
        return this.marshalCallbacks;
    }

    public HashMap<String, UnmarshalCallback> getUnmarshalCallbacks() {
        return this.unmarshalCallbacks;
    }

    public JavaClass[] processObjectFactory(JavaClass javaClass, ArrayList<JavaClass> arrayList) {
        Collection collection = javaClass.getMethods();
        Iterator iterator = collection.iterator();
        NamespaceInfo namespaceInfo = this.getNamespaceInfoForPackage(javaClass.getPackage());
        while (iterator.hasNext()) {
            Object object;
            String string;
            JavaMethod javaMethod = (JavaMethod)iterator.next();
            if (!javaMethod.getName().startsWith("create")) continue;
            if (!javaMethod.getReturnType().getName().equals("javax.xml.bind.JAXBElement") && !arrayList.contains(javaMethod.getReturnType())) {
                arrayList.add(javaMethod.getReturnType());
                continue;
            }
            if (!this.helper.isAnnotationPresent(javaMethod, XmlElementDecl.class)) continue;
            XmlElementDecl xmlElementDecl = (XmlElementDecl)this.helper.getAnnotation(javaMethod, XmlElementDecl.class);
            String string2 = xmlElementDecl.namespace();
            if ("##default".equals(string2)) {
                string2 = namespaceInfo.getNamespace();
            }
            String string3 = xmlElementDecl.name();
            QName qName = new QName(string2, string3);
            if (this.globalElements == null) {
                this.globalElements = new HashMap();
            }
            boolean bl = false;
            JavaClass javaClass2 = (JavaClass)javaMethod.getReturnType().getActualTypeArguments().toArray()[0];
            if ("java.util.List".equals(javaClass2.getName())) {
                bl = true;
                if (javaClass2.hasActualTypeArguments()) {
                    javaClass2 = (JavaClass)javaClass2.getActualTypeArguments().toArray()[0];
                }
            }
            ElementDeclaration elementDeclaration = new ElementDeclaration(qName, javaClass2, javaClass2.getQualifiedName(), bl);
            if (!xmlElementDecl.substitutionHeadName().equals("")) {
                string = xmlElementDecl.substitutionHeadName();
                object = xmlElementDecl.substitutionHeadNamespace();
                if (((String)object).equals("##default")) {
                    object = namespaceInfo.getNamespace();
                }
                elementDeclaration.setSubstitutionHead(new QName((String)object, string));
            }
            if (this.helper.isAnnotationPresent(javaMethod, XmlJavaTypeAdapter.class)) {
                string = (XmlJavaTypeAdapter)this.helper.getAnnotation(javaMethod, XmlJavaTypeAdapter.class);
                object = string.value();
                elementDeclaration.setJavaTypeAdapterClass((Class)object);
                Method[] methodArray = ((Class)object).getMethods();
                Class<?> clazz = null;
                for (int i = 0; i < methodArray.length; ++i) {
                    Method method = methodArray[i];
                    if (!method.getName().equals("marshal")) continue;
                    clazz = method.getReturnType();
                    break;
                }
                elementDeclaration.setJavaType(this.helper.getJavaClass(clazz));
                elementDeclaration.setAdaptedJavaType(javaClass2);
            }
            this.globalElements.put(qName, elementDeclaration);
            if (this.helper.isBuiltInJavaType(javaClass2) || arrayList.contains(javaClass2)) continue;
            arrayList.add(javaClass2);
        }
        if (arrayList.size() > 0) {
            return arrayList.toArray(new JavaClass[arrayList.size()]);
        }
        return new JavaClass[0];
    }

    public HashMap<QName, ElementDeclaration> getGlobalElements() {
        return this.globalElements;
    }

    public void updateGlobalElements(ArrayList<JavaClass> arrayList) {
        Object object;
        Object object2;
        for (JavaClass object3 : arrayList) {
            int n;
            char c;
            if (!this.helper.isAnnotationPresent(object3, XmlRootElement.class)) continue;
            object2 = (XmlRootElement)this.helper.getAnnotation(object3, XmlRootElement.class);
            JavaPackage javaPackage = object3.getPackage();
            object = this.getNamespaceInfoForPackage(javaPackage);
            String string = object2.name();
            if ((string.equals("##default") || string.equals("")) && (string = object3.getName().indexOf("$") != -1 ? Introspector.decapitalize(object3.getName().substring(object3.getName().lastIndexOf(36) + 1)) : Introspector.decapitalize(object3.getName().substring(object3.getName().lastIndexOf(46) + 1))).length() >= 3 && Character.isDigit(c = string.charAt((n = string.length() - 1) - 1))) {
                char c2 = Character.toUpperCase(string.charAt(n));
                string = string.substring(0, n) + c2;
            }
            String string2 = object2.namespace();
            QName qName = null;
            qName = string2.equals("##default") ? (object == null ? new QName(string) : new QName(((NamespaceInfo)object).getNamespace(), string)) : new QName(string2, string);
            ElementDeclaration elementDeclaration = new ElementDeclaration(qName, object3, object3.getRawName(), false);
            elementDeclaration.setIsXmlRootElement(true);
            if (this.globalElements == null) {
                this.globalElements = new HashMap();
            }
            this.globalElements.put(qName, elementDeclaration);
        }
        if (this.globalElements == null) {
            return;
        }
        for (QName qName : this.globalElements.keySet()) {
            object2 = this.globalElements.get(qName);
            if (((ElementDeclaration)object2).getSubstitutionHead() == null) continue;
            object = this.globalElements.get(((ElementDeclaration)object2).getSubstitutionHead());
            ((ElementDeclaration)object).addSubstitutableElement((ElementDeclaration)object2);
        }
    }

    private void addReferencedElement(ReferenceProperty referenceProperty, ElementDeclaration elementDeclaration) {
        referenceProperty.addReferencedElement(elementDeclaration);
        if (elementDeclaration.getSubstitutableElements() != null && elementDeclaration.getSubstitutableElements().size() > 0) {
            for (ElementDeclaration elementDeclaration2 : elementDeclaration.getSubstitutableElements()) {
                this.addReferencedElement(referenceProperty, elementDeclaration2);
            }
        }
    }

    private boolean hasJAXBAnnotations(JavaHasAnnotations javaHasAnnotations) {
        return this.helper.isAnnotationPresent(javaHasAnnotations, XmlElement.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlAttribute.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyAttribute.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlValue.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElements.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRef.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlElementRefs.class) || this.helper.isAnnotationPresent(javaHasAnnotations, XmlID.class);
    }
}

